/* --- Copyright University of Sussex 1997. All rights reserved. ----------
 * File:	S.sun4/src/aprocess.s
 * Purpose:
 * Author:	John Gibson, Aug 19 1988 (see revisions)
 */


;;; -------- ROUTINES TO HANDLE PROCESS CALL STACK SWAPPING -----------------

#_<

#_INCLUDE 'asm.ph'
#_INCLUDE 'process.ph'

lconstant macro (
	_ID_VALOF		= @@ID_VALOF,
	_PD_EXIT		= @@PD_EXIT,
	_PD_FLAGS		= @@PD_FLAGS,
	_PD_NLOCALS		= @@PD_NLOCALS,
	_PD_NUM_STK_VARS	= @@PD_NUM_STK_VARS,
	_PD_REGMASK		= @@PD_REGMASK,
	_PD_TABLE		= @@PD_TABLE,
	_PS_CALLSTACK_LIM	= @@PS_CALLSTACK_LIM,
	_PS_CALLSTACK_PARTIAL	= @@PS_CALLSTACK_PARTIAL,
	_PS_FLAGS		= @@PS_FLAGS,
	_PS_PARTIAL_RETURN 	= @@PS_PARTIAL_RETURN,
	_PS_STATE		= @@PS_STATE,
	_SF_FP			= @@SF_FP,
	_SF_CALLER_RETURN	= @@SF_CALLER_RETURN,
	_SF_LOCALS		= @@SF_LOCALS,
	);

>_#

/********************* wrapping structures ***********************************/

ASM_TEXT_SECTION
	.word	Ltext_end-Ltext_start, C_LAB(Sys$-objmod_pad_key)
Ltext_start:
ASM_DATA_SECTION
	.word	Ldata_end-Ldata_start, C_LAB(Sys$-objmod_pad_key)
Ldata_start:

/**************************************************************************/

ASM_TEXT_SECTION

	;;; size of an I_BRANCH_std instruction, i.e. a "b,a"
BRANCH_std = 4


	;;; Swap out the callstack for a process
DEF_C_LAB (_swap_out_callstack)
	ld	[%us], %g1		;;; the process (use CHAIN_REG)
	inc	4, %us
	ld	[%g1+_PS_CALLSTACK_LIM], %o3	;;; end of saved callstack
	b	so_test
	ld	[%g1+_PS_STATE], %o4	;;; start of save callstack area

so_loop:
	;;; (procedure flags already loaded in %o0)
	sub	%o7, %pb, %o7		;;; make return address relative

	;;; test if procedure has dlocal expression code to run
	btst	_:M_PD_PROC_DLEXPR_CODE, %o0
	bnz,a	so_brk			;;; yes -- break out to run code
	ld	[%pb+_PD_EXIT], %o0 ;;; and load exit code base address

	;;; (continue here after break)
so_cont:
	sub	%sp, %fp, %o0		;;; -ve frame size of this procedure
	add	%o3, %o0, %o2		;;; start of frame in state record

	;;; save registers in state frame
	;;; (can't use "std" because [%o2] may not be doubleword aligned)
	st	%l0, [%o2+0]
	st	%l1, [%o2+4]
	st	%l2, [%o2+8]
	st	%l3, [%o2+12]
	st	%l4, [%o2+16]
	st	%l5, [%o2+20]
	st	%l6, [%o2+24]
	st	%l7, [%o2+28]
	st	%i0, [%o2+32]
	st	%i1, [%o2+36]
	st	%i2, [%o2+40]
	st	%i3, [%o2+44]
	st	%i4, [%o2+48]
	st	%pb, [%o2+_SF_OWNER]	;;; SF_OWNER=52
	st	%o0, [%o2+_SF_FP]	;;; save -ve frame size in SF_FP=56
	;;; save THIS pdr's relative return in SF_CALLER_RETURN
	st	%o7, [%o2+_SF_CALLER_RETURN]	;;; SF_CALLER_RETURN=60

	;;; swap any dlocal identifier values
	ldub	[%pb+_PD_NLOCALS], %o1
	subcc	%g0, %o1, %o1		;;; negate nlocals
	bz	2f			;;; br if none
	clr	%i3			;;; clear neg offset from frame top
	add	%pb, _PD_TABLE, %i2 	;;; ptr stepping thru ident table
	sll	%o1, 2, %o1		;;; convert -ve nlocals to byte offset

1:	dec	4, %i3			;;; step down frame
	ld	[%fp+%i3], %i0		;;; value saved in stack frame
	ld	[%i2], %i1		;;; next identifier from table
	inc	4, %i2			;;; step table ptr
	ld	[%i1+_ID_VALOF], %l0	;;; current idval
	st	%i0, [%i1+_ID_VALOF]	;;; replace with stack saved value
	cmp	%i3, %o1		;;; end of dlocals?
	bne	1b			;;; loop if not
	st	%l0, [%o3+%i3]		;;; save old idval in state frame

	;;; save on-stack lvars
2:	add	%o0, _SF_LOCALS, %o1	;;; -ve size of lvars + dlocals
	cmp	%i3, %o1
	be	4f			;;; br if no on-stack lvars
	mov	%o4, %i4		;;; start limit to o4 after restore

3:	dec	4, %i3			;;; step down frame
	ld	[%fp+%i3], %i0		;;; value in stack frame
	cmp	%i3, %o1
	bne	3b
	st	%i0, [%o3+%i3]		;;; store in state frame

	;;; unwind frame and switch frame base to next frame end in o3
4:	restore %o2, %g0, %o3

	;;; test reached start of state record
so_test:
	cmp	%o3, %o4
	bgu,a	so_loop			;;; next frame if not
	ldub	[%pb+_PD_FLAGS], %o0	;;; load procedure flags for loop

	;;; finished -- chain procedure on stack
	ld	[%us], %opb		;;; procedure to chain off stack
	st	%g0, [%g1+_PS_CALLSTACK_PARTIAL] ;;; ensure PARTIAL reset to NULL
	ld	[%opb], %o0		;;; procedure execute address
	sth	%g0, [%g1+_PS_FLAGS]	;;; 0 process flags = suspended
	jmp	%o0+8			;;; chain procedure
	inc	4, %us

	;;; come here to run dlocal expression code, by jumping into the
	;;; owner procedure.
	;;; relative return address is in o7, PD_EXIT in o0
	;;; (procedure expects process in CHAIN_REG = g1)
so_brk:
	st	%o7, [%g1+_PS_PARTIAL_RETURN]	;;; save relative return in PARTIAL_RETURN
	jmp	%o0-(BRANCH_std*2)		;;; go into pdr's suspend code
	st	%o3, [%g1+_PS_CALLSTACK_PARTIAL] ;;; save o3 in CALLSTACK_PARTIAL

	;;; then return from procedure's suspend code is to here
	;;; (process in CHAIN_REG = g1)
DEF_C_LAB (_swap_out_continue)
	ld	[%g1+_PS_PARTIAL_RETURN], %o7	;;; restore relative return
	ld	[%g1+_PS_STATE], %o4		;;; restore limit in o4
	b	so_cont				;;; continue swap-out
	ld	[%g1+_PS_CALLSTACK_PARTIAL], %o3 ;;; restore o3



	;;; swap in the callstack for a process
DEF_C_LAB (_swap_in_callstack)
	ld	[%us], %g1		;;; the process (use CHAIN_REG)
	inc	4, %us
	ld	[%g1+_PS_CALLSTACK_LIM], %o4	;;; limit of saved callstack
	b	si_test
	ld	[%g1+_PS_STATE], %o3	;;; start of saved callstack area

	;;; (-ve frame size already loaded in o0)
si_loop:
	save	%sp, %o0, %sp		;;; create new stack frame
	mov	%i4, %o4		;;; reset limit to o4
	ld	[%i3+_SF_OWNER], %pb	;;; restore pb from state
	sub	%i3, %i0, %o3		;;; end of state frame into o3

	;;; swap any dlocal identifier values
	ldub	[%pb+_PD_NLOCALS], %o1
	subcc	%g0, %o1, %o1		;;; negate nlocals
	bz	2f			;;; br if none
	clr	%o2			;;; clear neg offset from frame top
	add	%pb, _PD_TABLE, %i2 ;;; ptr stepping thru ident table
	sll	%o1, 2, %o1		;;; convert -ve nlocals to byte offset

1:	dec	4, %o2			;;; step down frame
	ld	[%o3+%o2], %o0		;;; value saved in state frame
	ld	[%i2], %i1		;;; next identifier from table
	inc	4, %i2			;;; step table ptr
	ld	[%i1+_ID_VALOF], %l0	;;; current idval
	st	%o0, [%i1+_ID_VALOF]	;;; replace with state saved value
	cmp	%o2, %o1		;;; end of dlocals?
	bne	1b			;;; loop if not
	st	%l0, [%fp+%o2]		;;; save old idval in stack frame

	;;; save on-stack lvars
2:	add	%i0, _SF_LOCALS, %o1	;;; -ve size of lvars + dlocals
	cmp	%o2, %o1
	be	4f			;;; br if no on-stack lvars
	ld	[%i3+_SF_CALLER_RETURN], %o7 ;;; restore pdr's rel return to o7

3:	dec	4, %o2			;;; step down frame
	ld	[%o3+%o2], %o0		;;; value in state frame
	cmp	%o2, %o1
	bne	3b
	st	%o0, [%fp+%o2]		;;; store in stack frame

	;;; restore remaining registers from state frame
	;;; (can't use "ldd" because [%i3] may not be doubleword aligned)
4:	ld	[%i3+0],  %l0
	ld	[%i3+4],  %l1
	ld	[%i3+8],  %l2
	ld	[%i3+12], %l3
	ld	[%i3+16], %l4
	ld	[%i3+20], %l5
	ld	[%i3+24], %l6
	ld	[%i3+28], %l7
	ld	[%i3+32], %i0
	ld	[%i3+36], %i1
	ld	[%i3+40], %i2
	ld	[%i3+48], %i4
	ldub	[%pb+_PD_FLAGS], %o0	;;; load procedure flags for test
	ld	[%i3+44], %i3		;;; make sure i3 is restored last!

	;;; test if has dlocal expression code to run
	btst	_:M_PD_PROC_DLEXPR_CODE, %o0
	bnz,a	si_brk			;;; yes -- break out to run code
	ld	[%pb+_PD_EXIT], %o0 ;;; loading exit code base address

	;;; (continue here after break)
si_cont:
	add	%o7, %pb, %o7		;;; make return address absolute

si_test:
	cmp	%o3, %o4		;;; reached state limit?
	blu,a	si_loop			;;; next frame if not
	ld	[%o3+_SF_FP], %o0	;;; loading -ve frame size of next pdr

	;;; finished
	ld	[%us], %opb		;;; procedure to call off stack
	inc	4, %us
	ld	[%opb], %o0		;;; procedure execute address
	jmp	%o0+8			;;; call procedure with existing return
	st	%g0, [%g1+_PS_CALLSTACK_PARTIAL] ;;; ensure PARTIAL reset to NULL


	;;; come here to run dlocal expression code, by jumping into the
	;;; owner procedure.
	;;; relative return address in o7, PD_EXIT in o0
	;;; (procedure expects process in CHAIN_REG = g1)
si_brk:
	st	%o7, [%g1+_PS_PARTIAL_RETURN]	;;; save relative return in PARTIAL_RETURN
	jmp	%o0-BRANCH_std			;;; go into pdr's resume code
	st	%o3, [%g1+_PS_CALLSTACK_PARTIAL] ;;; save o3 in CALLSTACK_PARTIAL

	;;; then return from procedure's resume code is to here
	;;; (process in CHAIN_REG = g1)
DEF_C_LAB (_swap_in_continue)
	ld	[%g1+_PS_PARTIAL_RETURN], %o7	;;; restore relative return
	ld	[%g1+_PS_CALLSTACK_LIM], %o4	;;; restore limit in o4
	b	si_cont
	ld	[%g1+_PS_CALLSTACK_PARTIAL], %o3 ;;; restore o3



;;; --- ROUTINES TO HANDLE USERSTACK SWAPPING --------------------------------

	;;; save and erase a given number of bytes at the end of the userstack
DEF_C_LAB (_ussave)
	mov	%o7, %g1		;;; save return address
	ld	[%r_svb+_SVB_OFFS(_userhi)], %o5 ;;; stack base _userhi in o5
	ld	[%us], %o2		;;; addr to store saved part in o2
	ld	[%us+4], %o0		;;; nbytes to save
	inc	8, %us
	sub	%o5, %o0, %o1		;;; where moving from
	call	movwords		;;; move stuff into save area
	mov	%o1, %o4		;;; save for after move

	;;; now reposition the rest above
	mov	%us, %o1		;;; stack top is move source
	sub	%o4, %o1, %o0		;;; size of rest to move
	sub	%o5, %o0, %us		;;; new stack top after move
	mov	%us, %o2		;;; stack top is move destination
	sethi	%hi(movwords), %o3
	jmp	%o3+%lo(movwords)	;;; do the move
	mov	%g1, %o7		;;; with return set to caller


	;;; restore a given number of bytes at the end of the userstack
DEF_C_LAB (_usrestore)
	mov	%o7, %g1		;;; save return address
	ld	[%r_svb+_SVB_OFFS(_userhi)], %o5 ;;; stack base _userhi in o5
	ld	[%us+4], %o4		;;; nbytes to restore
	sub	%o5, %us, %o0		;;; size of current stack to move
	mov	%us, %o1		;;; stack top is source
	sub	%us, %o4, %us		;;; will be new stack top
	call	movwords		;;; do the move
	mov	%us, %o2		;;; with new top as dest

	;;; move in the new part
	ld	[%us], %o1		;;; addr of part to restore
	inc	8, %us			;;; remove 2 args
	mov	%o4, %o0		;;; nbytes to restore
	sub	%o5, %o0, %o2		;;; sub size to get dest for move
	sethi	%hi(movwords), %o3
	jmp	%o3+%lo(movwords)	;;; do the move
	mov	%g1, %o7		;;; with return set to caller


	;;; erase a given number of bytes at the end of the userstack
DEF_C_LAB (_userasund)
	ld	[%r_svb+_SVB_OFFS(_userhi)], %o5 ;;; stack base _userhi in o5
	ld	[%us], %o3		;;; nbytes to erase
	add	%us, 4, %o1		;;; source for move
	add	%o1, %o3, %us		;;; where stack will start after
	sub	%o5, %us, %o0		;;; size to move
	sethi	%hi(movwords), %o3
	jmp	%o3+%lo(movwords)	;;; do the move (return to caller)
	mov	%us, %o2		;;; with new top as dest


/*************** end labels for wrapping structures **************************/

ASM_TEXT_SECTION
	.align	8
Ltext_end:
ASM_DATA_SECTION
	.align	8
Ldata_end:

/**************************************************************************/



/* --- Revision History ---------------------------------------------------
--- John Gibson, Oct  1 1997
	Now includes asm.ph
--- Robert John Duncan, Jun  1 1993
	Changed to use ASM_SECTION macros for changing section
--- John Gibson, Jun 15 1991
	Made _swap_in_callstack call a procedure off the stack when
	finished
--- John Gibson, Dec  6 1989
	Changes for new pop pointers (use explicit ID_VALOF offset)
--- John Gibson, Oct  5 1989
	_swap_out_callstack now clears the process' flags and chains the
	procedure on the stack when finished; the SWAP_BACK_IN flag is
	therefore unnecessary.
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- John Williams, Jul	4 1989
	Changed _M_PD_PROC_DLEXPR_CODE to _:M_PD_PROC_DLEXPR_CODE
--- John Gibson, Nov 14 1988
	Replaced uses of "swap" instruction in _swap_in_callstack and
	_swap_out_callstack (apparently, "swap" is not a hardware instruction
	but emulated in the SunOS kernel, and there appears to be bugs in it).
 */
