/* --- Copyright University of Sussex 1997. All rights reserved. ----------
 > File:            C.sparc/src/array_cons.p
 > Purpose:
 > Author:          Robert Smith, Aug 19 1988 (see revisions)
 > Related Files:   C.sparc/src/ass.p, C.all/src/arrays.p
 */

;;; ------------- CONSTRUCTING ARRAY PROCEDURES (SPARC) ----------------------

#_INCLUDE 'declare.ph'
#_INCLUDE 'drop_code.ph'

global constant
		procedure (Sys$-Vm$-Drop_hi, Sys$-Vm$-Drop_lo),
		_array_sub
	;


;;; ---------------------------------------------------------------------

section $-Sys$-Vm;

	/*	Construct a raw array procedure. _________tabsize is the word offset size of
		the array params starting at PD_ARRAY_TABLE.
	*/
define $-Sys$-Array$-Cons(_tabsize) -> _arrayp;
	lvars _tabsize, _arrayp, _drop_ptr, _size;

	;;; macro for dropping words
	lconstant macro W = [_drop_ptr!(w)++ -> _drop_ptr];

	;;; get procedure record -- 8 words of code
	@@PD_ARRAY_TABLE{_tabsize} _add @@(w)[_8] _sub @@POPBASE -> _size;
	Get_store(_size) -> _arrayp;

	;;; initialise some of procedure header
	##(w){_size} -> _arrayp!PD_LENGTH;
	_0		->> _arrayp!PD_REGMASK
			->> _arrayp!PD_NUM_STK_VARS
			->> _arrayp!PD_NUM_PSTK_VARS
			->> _arrayp!PD_NLOCALS
			->  _arrayp!PD_GC_SCAN_LEN;
	##SF_LOCALS -> _arrayp!PD_GC_OFFSET_LEN;
	##SF_LOCALS -> _arrayp!PD_FRAME_LEN;	;;; min frame size = 16 words


	;;; start of code
	_arrayp@PD_ARRAY_TABLE{_tabsize} ->> _drop_ptr -> _arrayp!PD_EXECUTE;

	_NOP_INST								-> W;	;;; nop
	_NOP_INST								-> W;	;;; nop
	_F3iA_INST(_OP_save, _:Rsp, _-64, _:Rsp) -> W;	;;; save %sp, -64, %sp

	;;; call the array subscript routine
	;;; (picks up parameters from pb+PD_ARRAY_TABLE, stacks computed
	;;; subscript and PD_ARRAY_VECTOR, and then chains PD_ARRAY_SUBSCR_PDR)
	_F2_INST(_OP_sethi, Drop_hi(_array_sub), _:Ro1)
											-> W;	;;; sethi %hi(n), %o1
	_F3iA_INST(_OP_jmpl, _:Ro1, Drop_lo(_array_sub), _:Ro7)
											-> W;	;;; jmpl %o1+%lo(n), %o7
	_NOP_INST								-> W;	;;; nop

	;;; remove stack frame and return
	_drop_ptr -> _arrayp!PD_EXIT;				;;; pointer to exit code
	_F3iA_INST(_OP_jmpl, _:Ri7, _8, _:Rg0)	-> W;	;;; ret
	_F3iA_INST(_OP_restore, _:Rg0, _0, _:Rg0) -> W;	;;; restore
enddefine;

endsection;			/* $-Sys$-Vm */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Oct  3 1997
		Changed instructions to use new _Fn... instruction macros
		from drop_code.ph, etc.
--- John Gibson, Aug 30 1994
		Simplified so that this machine-specific file now only has to
		construct a procedure with a stack frame and a call to _array_sub
		(_array_sub  picks up the parameters from PD_ARRAY_TABLE; these are
		planted by the machine-independent Get in arrays.p)
--- John Gibson, Apr 30 1989
		Put into section $-Sys$-Vm
--- John Gibson, Feb 13 1989
		Rewrote to use W macro
--- John Gibson, Feb  5 1989
		Initialisation of some procedure headrer fields moved to
		-newanyarray-
 */
