/* --- Copyright University of Sussex 1997. All rights reserved. -------
 * File:            S.sun4/src/asignals.s
 * Purpose:         Signal Handler for Sun 4
 * Author:          John Gibson & Roger Evans, Aug 19 1988 (see revisions)
 */

;;; --------------------- SIGNAL HANDLER -------------------------------

#_<

#_INCLUDE 'asm.ph'

section $-Sys;

constant
	procedure (Callstack_reset, Error_signal, Vfork_parent),
	;

vars
	Extern$- _saved_sp
	;

endsection;

lconstant macro (
	R_SVB		= [%"%"% r_svb],
	svb_SAVED_SP	= [R_SVB + _SVB_OFFS(Sys$-Extern$- _saved_sp)],
	);

>_#


/********************* wrapping structures *******************************/

ASM_TEXT_SECTION
	.word	Ltext_end-Ltext_start, C_LAB(Sys$-objmod_pad_key)
Ltext_start:
ASM_DATA_SECTION
	.word	Ldata_end-Ldata_start, C_LAB(Sys$-objmod_pad_key)
Ldata_start:

/**********************************************************************/

ASM_TEXT_SECTION

SYS_vfork	= 66


;;; --- ROUTINES TO CLEAN UP AND CALL A POP ERROR HANDLER ----------

reset_pop_environ:
	set	EXTERN_NAME(__pop_in_user_extern), %g1
	clr	[%g1]
	mov	%o7, %g1		;;; save return
	call	reset_pop_reg_environ	;;; ensure global regs set
	nop

	ld	[%r_svb+_SVB_OFFS(_userhi)], %us	;;; clear user stack

1:	ld	[svb_SAVED_SP], %o1
	tst	%o1			;;; in external calls?
	bz	2f			;;; nothing to do if not
	cmp	%sp, %o1		;;; current sp below that point?
	blu,a	1b			;;; loop if so
	restore				;;; and unwind 1 frame
	clr	[svb_SAVED_SP]		;;; else clear _saved_sp

2:	jmp	%g1+8			;;; return to caller
	nop


	;;; Error signals (e.g. SEGV) set return to this
.global EXTERN_NAME(__pop_errsig)
EXTERN_NAME(__pop_errsig):
	call	reset_pop_environ
	nop
	set 	XC_LAB(Sys$-Error_signal), %o0
	jmp	%o0
	nop



;;; --- VFORK ---------------------------------------------------------------

DEF_C_LAB (Sys$- _do_vfork)
	mov	SYS_vfork, %g1	;;; syscall number passed in g1
	ta	0		;;; vfork system call
	bgeu	1f		;;; br if forked OK
	nop
	;;; unable to fork -- error code in o0
	set	EXTERN_NAME(errno), %o1
	st	%o0, [%o1]	;;; error code into errno
	mov	-1, %o0
	st	%o0, [%us-4]	;;; return -1
	retl
	dec	4, %us

	;;; forked OK -- pid in o0, o1 nonzero if child
1:	tst	%o1		;;; the child?
	bz	2f		;;; br if not
	dec	4, %us
	retl
	clr	[%us]		;;; return 0 for child

	;;; parent
2:	clr	[svb_SAVED_SP]	;;; in case in extern calls in child
	st	%o0, [%us]	;;; (us already decremented)
	set	C_LAB(weakref Sys$-Vfork_parent), %o0
	st	%o0, [%us-4]
	set 	XC_LAB(Sys$-Callstack_reset), %o0
	jmp	%o0
	dec	4, %us


;;; --- SYSTEM CALLS --------------------------------------------------------

	;;; _call_sys(arg1, ..., argN, N, routine)
	;;; Make a system call, moving args from userstack to regs, etc
	;;; no arg conversion -- for internal use only (calls to this
	;;; are generated by the _extern syntax form).
	;;; (User external calls are done in aextern.s)

DEF_C_LAB (_call_sys)
	;;; save caller's stack frame ptr for exception conditions
	st	%sp, [svb_SAVED_SP]

	save	%sp, -256, %sp		;;; allow stack space for passing args

	inc	8, %us
	ld	[%us-4], %l0		;;; argument count
	sll	%l0, 2, %l0		;;; offset of args
	cmp	%l0, 6*4
	bgu	morethan6		;;; br if more than six args
	add	%l0, %us, %i0		;;; keep addr of after args in i0
	sethi	%hi(docall), %o0
	sub	%o0, %l0, %o0
	jmp	%o0+%lo(docall)
	ld	[%us-8], %i1		;;; address of routine to call

	ld	[%i0-24], %o5
	ld	[%i0-20], %o4
	ld	[%i0-16], %o3
	ld	[%i0-12], %o2
	ld	[%i0-8],  %o1
	ld	[%i0-4],  %o0
docall:
	mov	%r_false, %l2		;;; save r_false
	call	%i1			;;; call the routine ...
	mov	%r_svb, %l3		;;; ... saving r_svb

	mov	%l3, %r_svb		;;; recover r_svb   (g5)
	mov	%l2, %r_false		;;; recover r_false (g6)
	sub	%i0, 4, %us		;;; erase args (-1) from userstack
	st	%o0, [%us]		;;; return result on stack
	restore
	retl
	clr	[svb_SAVED_SP]		;;; says no longer in extern calls

morethan6:
	ld	[%i0-4],  %o0
	ld	[%i0-8],  %o1
	ld	[%i0-12], %o2
	ld	[%i0-16], %o3
	ld	[%i0-20], %o4
	ld	[%i0-24], %o5
	sub	%i0, 24, %l0
	add	%sp, 0x5c, %l1		;;; start sp offset for C args
1:	ld	[%l0-4], %l2
	dec	4, %l0
	st	%l2, [%l1]
	cmp	%l0, %us
	bne,a	1b
	inc	4, %l1
	b	docall
	ld	[%us-8], %i1		;;; address of routine to call


;;; -------------------------------------------------------------------------

ASM_DATA_SECTION
save_val:
	.word	0


/*************** end labels for wrapping structures **************************/

ASM_TEXT_SECTION
	.align	8
Ltext_end:
ASM_DATA_SECTION
	.align	8
Ldata_end:

/**************************************************************************/



/* --- Revision History ---------------------------------------------------
--- John Gibson, Oct  1 1997
	Now includes asm.ph
--- John Gibson, Mar 14 1995
	Removed _pop_m*alloc_exhausted (no longer needed)
--- John Gibson, Oct 24 1994
	Removed the C pointers to pop vars (now set up in initial.p)
--- John Gibson, May 24 1994
	errno now used directly for syscall error codes -- got rid of
	code transferring it to _sys*error.
--- Robert John Duncan, Jun  1 1993
	Changed to use ASM_SECTION macros for changing section
--- John Gibson, Apr 16 1993
	Made sure _call_sys saves r_svb, r_false and us around external call
--- Robert John Duncan, Jul 27 1992
	Changed to use -EXTERN_NAME-
--- John Gibson, Mar 14 1991
	Added __pop_in_X_call
--- John Gibson, Jan 19 1991
	Added clearing of ___pop_in_user_extern in reset_pop_environ
--- John Gibson, Dec 29 1990
	Actual signal handlers rewritten in C and moved to c_core.c (this
	file now contains only routines gone to on return from a signal).
--- John Gibson, Dec  3 1990
	Replaced _pop_a*dd_sig with _pop_add_ast taking ast type as 1st arg
--- Roger Evans, Nov 20 1990 added __pop_xt_dummy_fd
--- John Gibson, Nov 19 1990
	Grouped all C-accessible pointers and added
	__WEAK_pop_external_callback
--- John Gibson, Nov 15 1990
	Made parent in _do_vfork clear _SAVED_SP.
--- John Gibson, Nov 13 1990
	Replaced _m*alloc_use_external by _external_flags and
	_pop_m*alloc_use_external by pop_external_flags, etc.
--- John Gibson, Aug 21 1990
	Signal queue routines rewritten in C and put into malloc.c.
	These access the pop variable _trap via the constant pointer
	_pop_signals_pending.
--- John Gibson, Jun 23 1990
	Fixed SunOS 4.1 problem where protection violation on memory mapped
	with mmap or mprotect causes SIGBUS rather than SIGSEGV.
--- John Gibson, May 15 1990
	_remsig now sets _trap to 0 when signal queue is empty.
	_remsig also now returns signal on stack.
--- John Gibson, May 13 1990
	Added __pop_m*alloc_use_external to enable malloc to get at
	Sys$-_malloc_use_external.
	Changed name of routine called by malloc when internal dynamic
	memory exhausted to __pop_m*alloc_exhausted, and error pop procedure
	called to Sys$-M*alloc_exhausted.
--- John Gibson, Apr 28 1990
	Moved _call_sys to this file from aextern.s (so core routine
	_call_sys doesn't pull in 'optional' external stuff).
--- John Gibson, Apr 27 1990
	_saved_sp now in $-Sys$-Extern
--- John Gibson, Mar 23 1990
	Removed call of reset_pop_environ from do_vfork (mustn't be
	there now, because it resets the pop registers). Fixed WRONG
	correction to decrementing of -us-.
--- Ian Rogers, Jan 30 1990
	Made reset_pop_environ globally accessable. Added call to it
	in  _do_vfork. Fixed decrementing of -us- in _do_vfork
--- John Gibson, Jan 11 1990
	Correction to change dated Aug 14 1989.
--- John Gibson, Jan 10 1990
	Replaced _SIG_x with correct _:SIG_x.
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- John Gibson, Aug 14 1989
	Added code to -reset_pop_environ- to ensure global constants
	in registers (false and special_var_block) set correctly.
 */
