/* --- Copyright University of Sussex 1989. All rights reserved. ----------
 > File:            C.sparc/src/drop_code.p
 > Purpose:			SPARC run-time assembler routine for dropping code
 > Author:          Robert Smith, Aug 19 1988 (see revisions)
 */

#_INCLUDE 'declare.ph'

section $-Sys$-Vm;

vars
		_asm_drop_ptr, _asm_code_offset, _asm_pass
	;

endsection;


;;; --- CODE-DROPPING PROCEDURES ----------------------------------------------
;;; these are assumed to truncate their arguments to appropriate size

section $-Sys$-Vm;

;;; Put a (sysint) longword in the procedure record (on pass 2)
define Drop_l(_longword); /* sysint longword */
	lvars _longword;
	;;; just increment except on last pass
	unless _asm_pass then
		_longword -> _asm_drop_ptr!(w)++ -> _asm_drop_ptr;
	endunless;
	@@(w){_asm_code_offset}++ -> _asm_code_offset;
enddefine;

;;; Put a (sysint) word in the procedure record (on pass 2)
define Drop_w(_word); /* sysint word */
	lvars _word;
	;;; just increment except on last pass
	unless _asm_pass then
		_word -> _asm_drop_ptr!(s)++ -> _asm_drop_ptr;
	endunless;
	@@(s){_asm_code_offset}++ -> _asm_code_offset;
enddefine;

;;; Extract most significant 22 bits of longword
define Drop_hi(_long);
	lvars _long;
	(_shift(_long, _-10) _bimask _16:3FFFFF);
enddefine;

;;; Extract least significant 10 bits of longword
define Drop_lo(_long);
	lvars _long;
	(_long _bimask _16:3FF);
enddefine;


endsection;		/* $-Sys$-Vm */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Apr 30 1989
		Put into section $-Sys$-Vm
 */
