/* --- Copyright University of Sussex 1997. All rights reserved. ----------
 > File:            C.sparc/src/pdr_compose.p
 > Purpose:         Composing procedures (SPARC version)
 > Author:          Robert Smith, Aug 19 1988 (see revisions)
 > Documentation:	REF *PROCEDURE
 > Related Files:   C.sparc/src/ass.p
 */

#_INCLUDE 'declare.ph'
#_INCLUDE 'drop_code.ph'

;;; -------------------------------------------------------------------

section $-Sys$-Vm;

	/*	Construct a raw procedure for composition of two procedures
		-- used by <>
	*/
define $-Sys$-Cons_pcomposite() -> _comp;
	lvars _comp, _drop_ptr, _offs, _size;

	;;; macro for dropping words
	lconstant macro W = [_drop_ptr!(w)++ -> _drop_ptr];

	@@PD_COMPOSITE_TABLE[_13] _sub @@POPBASE -> _size;
	Get_store(_size) -> _comp;
	;;; initialise header
	##(w){_size} -> _comp!PD_LENGTH;
	_0		->> _comp!PD_REGMASK
			->> _comp!PD_NLOCALS
			->> _comp!PD_NUM_STK_VARS
			->> _comp!PD_NUM_PSTK_VARS
			-> _comp!PD_GC_SCAN_LEN;
	##SF_LOCALS -> _comp!PD_GC_OFFSET_LEN;
	##SF_LOCALS -> _comp!PD_FRAME_LEN;		;;; min frame size = 16 words

	;;; start of instructions
	_comp@PD_COMPOSITE_TABLE ->> _drop_ptr -> _comp!PD_EXECUTE;

	;;; stack frame
	_NOP_INST									-> W;	;;; nop
	_NOP_INST									-> W;	;;; nop
	_F3iA_INST(_OP_save, _:Rsp, _-64, _:Rsp) 	-> W;	;;; save %sp, -64, %sp
	;;; plant code to call first then second
	_0 -> _offs;
	repeat 2 times
		_F3iM_INST(_OP_ld, _:Rpb, @@PD_COMPOSITE_P1{_offs}, _:Ropb)
												-> W;	;;; ld [%pb+i], %o5
		_F3iM_INST(_OP_ld, _:Ropb, @@PD_EXECUTE, _:Ro0)
												-> W;	;;; ld [%o5], %o0
		_F3iA_INST(_OP_jmpl, _:Ro0, _8, _:Ro7)	-> W;	;;; jmpl [%o0+8], %o7
		_NOP_INST								-> W;	;;; nop
		@@(w)[_1] -> _offs
	endrepeat;
	_drop_ptr -> _comp!PD_EXIT;			;;; pointer to exit code
	_F3iA_INST(_OP_jmpl, _:Ri7, _8, _:Rg0)		-> W;	;;; ret
	_F3iA_INST(_OP_restore, _:Rg0, _0, _:Rg0)	-> W;	;;; restore
enddefine;

endsection;		/* $-Sys$-Vm */


/* --- Revision History ---------------------------------------------------
--- John Gibson, Oct  3 1997
		Changed instructions to use new _Fn... instruction macros
		from drop_code.ph, etc.
--- John Gibson, Apr 30 1989
		Put into section $-Sys$-Vm
--- John Gibson, Feb 13 1989
		Changed procedure name and moved common code to data_concat.p
		(Uses new struct definition for fields PD_COMPOSITE_P1, P2 etc)
		Rewrote to use W macro
 */
