/* --- Copyright University of Sussex 1997. All rights reserved. ----------
 > File:			S.sun3/src/syscomp/asmout.p
 > Purpose:
 > Author:			John Gibson (see revisions)
 */

/* -------------------------------------------------------------------------

				  OUTPUT CODE PROCEDURES MC68000/SPARC SYSTEMS
							(SUN BERKELEY UNIX)

--------------------------------------------------------------------------*/

#_INCLUDE 'common.ph'

section $-Popas;

vars	nextlabel;

define popint(n); lvars n; (n<<2) || 3 enddefine;

define mcint(n); lvars n; n >> 2 enddefine;

define nextlab();
	dlocal pop_pr_radix = 36;
	'L' >< nextlabel;
	nextlabel fi_+ 1 -> nextlabel
enddefine;

define lconstant asm_label(word, prefix_char);
	lvars n, len, string, q, r, prefix_char, word;
	lconstant SEP_CHAR = `.`;
	if isstring(word) then word else fast_word_string(word) endif -> string;
	datalength(string) -> len;
	cons_with consstring {%
		prefix_char, SEP_CHAR;
		fast_for n to len do
			go_on dup(fast_subscrs(n, string)) to
			;;; 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6
				c c c c c c c c c c c c c c c c		;;; Ctrl-A -- Ctrl-P
				c c c c c c c c c c c c c c c c		;;; Ctrl-Q -- SPACE
				s s s $ s s s s s s s s s s s d		;;;   !    --   0
				d d d d d d d d d s s s s s s s		;;;   1    --   @
				A A A A A A A A A A A A A A A A		;;;   A    --   P
				A A A A A A A A A A s s s s u s		;;;   Q    --   `
				a a a a a a a a a a a a a a a a		;;;   a    --   p
				a a a a a a a a a a s s s s c c		;;;   q    -- \(128)
			else c;

			A: a: d: u :		;;; alpha, digit, underscore
				nextloop;

			$ :
				if n /== len and fast_subscrs(n fi_+ 1, string) == `-`
				and (n /== 1 or len fi_> 2) then
					;;; replace section separator $- with SEP_CHAR
					-> ;			;;; erase $
					unless n == 1 then SEP_CHAR endunless;
					n fi_+ 1 -> n;	;;; skip -
					nextloop
				;;; else drop thru to "s"
				endif;

			s: c:				;;; other sign, control etc
				;;; represent as 3 decimal digits
				() fi_// 100 -> q -> r;
				q fi_+ `0`;
				r fi_// 10 -> q -> r;
				q fi_+ `0`, r fi_+ `0`;

		endfast_for
	%}
enddefine;

constant procedure (
	asm_symlabel	= asm_label(%`c`%),
	asm_identlabel	= asm_label(%`i`%),
	asm_wordlabel	= asm_label(%`w`%),
	asm_wordidlabel	= asm_label(%`z`%),
	asm_pdpropslabel= asm_label(%`p`%),
	asm_testdeflabel= asm_label(%`t`%),
	);


	;;; list of pop symbol prefixes for use by -Extern_make_base-
	;;; see unixextern.p
constant macro $- POP_SYMBOL_PREFIXES =
		[['c.' 'xc.' 'uc.' 'xuc.' 'i.' 'w.' 'z.' 'p.' 't.' '_end\^@']];


#_IF DEF SPARC

	;;; Since testdef labs have the value 0 or 1, can use
	;;; %lo(lab) to give better code
define asm_testdefval() with_nargs 1;
	lvars tlab;
	asm_testdeflabel() -> tlab;
	'%lo(' <> tlab <> ')'
enddefine;

constant macro (
	$- ASM_BYTE_STR	= '\t.byte\t',
	$- ASM_SHORT_STR= '\t.half\t',
	$- ASM_INT_STR	= '\t.word\t',
	);

#_IF DEFV SYSTEM_V >= 4.0

constant macro (
	$- ASM_TEXT_STR	= '\t.section ".text"',
	$- ASM_DATA_STR	= '\t.section ".data"',
	);

#_ELSE

constant macro (
	$- ASM_TEXT_STR	= '\t.seg "text"',
	$- ASM_DATA_STR	= '\t.seg "data"',
	);

#_ENDIF

;;; macros for changing section in hand-coded assembler files
identof("ASM_TEXT_STR") -> identof("ident $-ASM_TEXT_SECTION");
identof("ASM_DATA_STR") -> identof("ident $-ASM_DATA_SECTION");

#_ELSE

constant macro (
	$- ASM_TEXT_STR	= '\t.text',
	$- ASM_DATA_STR	= '\t.data',
	$- ASM_BYTE_STR	= '\t.byte\t',
	$- ASM_SHORT_STR= '\t.word\t',
	$- ASM_INT_STR	= '\t.long\t',
	);

#_ENDIF

constant macro $- ASM_WORD_STR = ASM_INT_STR;


#_IF DEF SPARC
constant procedure asm_startfile = erase;
#_ELSE
vars file_total_bytecount;
;;;
define asm_startfile(a_name);
	lvars a_name;
	0 -> file_total_bytecount
enddefine;
#_ENDIF

constant procedure (
	asm_endfile		= identfn,

	asm_startcode	= outcode(%'\n'<>ASM_TEXT_STR%),
	asm_startdata	= outcode(%'\n'<>ASM_DATA_STR%),
	);

define asm_outlab(lab);
	lvars lab;
	asmf_charout(lab), asmf_charout(`:`), asmf_charout(`\n`)
enddefine;

define asm_outglab(lab);
	lvars lab;
#_IF DEF SPARC
	asmf_charout('.global\s');
#_ELSE
	asmf_charout('.globl\s');
#_ENDIF
	asmf_charout(lab), asmf_charout(`\n`), asm_outlab(lab)
enddefine;

define asm_outlabset(lab, val);
	lvars lab, val;
	asmf_printf(val, lab, '%p = %p\n')
enddefine;

define asm_outglabset(lab, val);
	lvars lab, val;
#_IF DEF SPARC
	asmf_printf(val, lab, lab, '.global %p\n%p = %p\n')
#_ELSE
	asmf_printf(val, lab, lab, '.globl %p\n%p = %p\n')
#_ENDIF
enddefine;

define lconstant outdatum(n, string);
	lvars m, n, string;
	returnif(n == 0);
	asmf_charout(string);
	fast_for m from n by -1 to 2 do
		asmf_pr(subscr_stack(m)), asmf_charout(`,`)
	endfast_for;
	asmf_pr();
	erasenum(n-1);
	asmf_charout(`\n`)
enddefine;

constant procedure (
	asm_outbyte		= outdatum(% ASM_BYTE_STR %),
	asm_outshort	= outdatum(% ASM_SHORT_STR %),
	asm_outint		= outdatum(% ASM_INT_STR %),
	asm_outword		= outdatum(% ASM_WORD_STR %),
	);

	/*	-asm_addbits- is used to accumulate a sequence of bitfields into
		a (big)integer which -asm_outbits- is then called to output when the
		total number of bits accumulated occupies an exact number of bytes.
			-val- is the currently accumulated (big)integer, containing
		-nbits- bits so far; -new_val- is the field to be added, containing
		-new_nbits- bits.
			The value returned will be the -val- input for the next field
		(with -nbits- incremented by -new_nbits-), and so on. Other than
		initialising -val- to 0 at the start, nothing is assumed about how
		the fields are added to it, so it is the responsibility of this
		procedure and -asm_outbits- to output the bitfields correctly.
	*/
	;;; 68K ('big endian') version adds the fields at the bottom and
	;;; outputs the bytes from the top down
define asm_addbits(new_val, new_nbits, val, nbits);
	lvars new_val, new_nbits, val, nbits;
	(val << new_nbits) || new_val	;;; add the new field at the bottom
enddefine;

	/*	In this, -nbits- is a multiple of BYTE_BITS, and -val- has been
		produced by repeated calls of -asm_addbits-
	*/
define asm_outbits(val, nbits);
	lvars val, nbits, count = 0;
	lconstant BYTE_MASK = (1<<BYTE_BITS)-1;
	until nbits == 0 do
		nbits-BYTE_BITS -> nbits;
		(val >> nbits) && BYTE_MASK;	;;; output bytes from the top down
		;;; this just saves putting each byte on a separate line
		if (count+1 ->> count) == 12 then asm_outbyte(count), 0 -> count endif;
	enduntil;
	if count /== 0 then asm_outbyte(count) endif
enddefine;


#_IF DEF SPARC

constant procedure (
	;;; asm_align_double() -- output alignment for double (e.g. double float)
	asm_align_double = outcode(%'.align 8'%),
	;;; asm_out_dfloat(hi_part, lo_part) -- output double float
	asm_out_dfloat	= asm_outword(%2%),

	;;; asm_align_file() -- output end-of-file alignment
	;;; (don't define if no alignment necessary)
	asm_align_file	= asm_align_double,
	);

#_ELSE

constant procedure (
	;;; asm_align_double() -- output alignment for double (e.g. double float)
	asm_align_double = identfn,
	;;; asm_out_dfloat(hi_part, lo_part) -- output double float
	asm_out_dfloat	= asm_outword(%2%),

	;;; asm_align_file() -- output end-of-file alignment
	;;; (don't define if no alignment necessary)
;;;	asm_align_file	= identfn,
	);

#_ENDIF


	;;; optional procedure used (if present) by poplink
	;;; to do more compact generation of strings using ".ascii"
define asm_quick_genstring(string);
	lvars c, n, l = datalength(string), string;
	fast_for n to l do
		f_subs(n, string) -> c;
		if c fi_< `\s` or c fi_> `~` or c == `\\` or c == `"` then
			return(false)
		endif
	endfast_for;
	asmf_charout('\t.ascii "');
	asmf_charout(string);
	l && (WORD_BYTES-1) -> l;
	unless l == 0 then
		repeat WORD_BYTES-l times
			asmf_charout(`\\`), asmf_charout(`0`)
		endrepeat;
	endunless;
	asmf_charout(`"`), asmf_charout(`\n`);
	true
enddefine;

	;;; for closures generated by poplink for undef procedures, etc
define asm_gen_poplink_code(outlabs, nfroz, jmplab);
	lvars offs, outlabs, nfroz, jmplab;
	;;; plant exec labels
	outlabs();
#_IF DEF SPARC
	;;; get procedure label (poplink should really pass this as an argument)
	lvars lab = hd(frozval(1,outlabs));
	if isref(lab) then cont(lab) -> lab endif;
	asmf_printf(allbutfirst(1,lab), '\tset\t%p, %%o5\n');	;;; remove `x`
	;;; code to push _____nfroz frozvals
	0 -> offs;
	fast_repeat nfroz times
		asmf_printf(offs, '\tld [%%o5+20+%p], %%o1\n');	;;; 20 = PD_CLOS_FROZVALS
		offs+WORD_OFFS -> offs;
		asmf_printf(offs, '\tst %%o1, [%%g4-%p]\n')
	endrepeat;
	;;; jmp to ______jmplab and decrement stack
	asmf_printf(offs, jmplab, '\tset %p, %%o0; jmp %%o0; dec %p, %%g4\n');
	;;; return number of longwords of code planted
	nfroz*2 + 6
#_ELSE
	;;; code to push _____nfroz frozvals (last _____nfroz longwords planted)
	nfroz*4+2 -> offs;
	fast_repeat nfroz times
		;;; offs stays the same each time (+4 for next froz, -4 for instr)
		asmf_printf(offs, '\tmovl\tpc@(-%p),a6@-\n');	;;; 4 bytes each
	endrepeat;
	;;; jmp to ______jmplab
	asmf_printf(jmplab, '\tjmp\t%p\n');
	;;; align to longword boundary
	asmf_printf('\t.word\t0\n');
	;;; return number of longwords of code planted
	nfroz+2
#_ENDIF
enddefine;

/*
 *	Exfunc closure code -- jump to subroutine _exfunc_clos_action (aextern.s)
 *	with exfunc_closure record address in a reg, etc. This procedure is
 *	passed the label of _exfunc_clos_action. The code generated must be
 *	padded to exactly 4 words.
 */

define asm_gen_exfunc_clos_code(action_lab);
	lvars action_lab;
#_IF DEF SPARC
	;;; passes (exfunc_clos address)+4 in %g1, EFC_FUNC loaded in %g2
	asmf_printf(action_lab,
		'\tsethi\t%%hi(%p), %%g1\n');
	asmf_printf(action_lab,
		'\tjmpl\t%%g1+%%lo(%p), %%g1\n');	;;; addr of this instr in g1
	asmf_printf(
		'\tld\t[%%g1-12], %%g2\n');			;;; -8 for EFC_FUNC, -4 for sethi instr
	asmf_printf('\tnop\n');					;;; pad to 4 words
#_ELSE
	;;; passes (exfunc_clos address)+6 on stack
	asmf_printf(action_lab,
		'\tjsr\t%p:L\n');	;;; 6 bytes
	repeat 5 times asmf_printf('\t.word\t0\n') endrepeat;	;;; pad
#_ENDIF
enddefine;

/*
 *	extern_name_translate:
 *		translate an external symbol, using the same conventions as the
 *		C compiler and linker (e.g. add a leading '_', truncate to N
 *		characters, etc.)
 */

define extern_name_translate(lang, symbol, type) -> symbol;
	lvars lang, symbol, type;
	returnif(lang = 'ASM');
#_IF DEFV SUNOS < 5.0
	'_' <> symbol -> symbol;
#_ENDIF
	if lang = 'FORTRAN' then uppertolower(symbol) <> '_' -> symbol endif
enddefine;


	/*	String for first line of Unix "ld" command -- used in os_comms.p
		(Image name is in the environment variable "IM")
	*/
constant
	unix_ld_command_header =

#_IF DEFV SYSTEM_V >= 4.0
		;;; ld has been relocated; use dynamic linking as the default
		'/usr/ccs/bin/ld -o $IM -e _start \\\n'

#_ELSEIF DEF SHARED_LIBRARIES
		;;; dynamic linking under SunOS 4.x
		'/bin/ld -o $IM -e start -dc -dp \\\n'

#_ELSEIF DEFV SUNOS >= 4.0
		;;; -Bstatic needed because we can't handle shareable libraries.
		;;; can't use -x option because it corrupts the symbol table
		'/bin/ld -o $IM -e start -Bstatic \\\n'

#_ELSE
		;;; standard version (in so far as there is one!)
		'/bin/ld -x -o $IM -e start \\\n'

#_ENDIF
	;

#_IF DEFV SUNOS >= 5.0
	/*	Location of crt*.o files used by "ld"
	*/
define active unix_ld_crt_objects;

	define lconstant getlist();
		expandlist(pdtolist(sys_file_match((), nullstring, false, false)))
	enddefine;

	lvars l = getlist('/opt/SUNWspro/SC*/lib/crt1.o');
	if null(l) then
		getlist('/opt/SUNWspro/SC*/crt1.o') -> l;
		if null(l) then
			mishap(0, 'CANNOT FIND C RUNTIME STARTUP OBJECT FILES')
		endif;
	endif;
	sys_fname_path(last(l)) dir_>< 'crt[1in].o'
enddefine;
#_ENDIF

#_IF DEF SUN2 or DEF SUN3

	/*	Startup files and libraries for Sun-2/3 floating-point
	*/
define sunfp_poplink_flag(flag, link_other) -> link_other;
	lvars flag, link_other, c;
	[%	if not(flag) or flag = 'switch' then
			'switch' -> flag
		else
			if flag     = '68881' then
				'M'
			elseif flag = 'fpa' then
				'W'
			elseif flag = 'sky' then
				'S'
			elseif flag = 'soft' then
				'F'
			else
				mishap(flag, 1, 'UNKNOWN -sunfp OPTION')
			endif -> c;
			'/lib/' <> c <> 'crt1.o'
		endif;
		'-L/lib/f' <> flag
	%] nc_<> link_other -> link_other
enddefine;

#_ENDIF


endsection;		/* $-Popas */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Oct  1 1997
		Userstack reg now g4 instead of g*7
--- John Gibson, Aug 15 1996
		New version of extern_name_translate.
--- John Gibson, Apr  3 1995
		Added asm_outint
--- John Gibson, Feb 24 1995
		Fix to cure bug in last change ...
--- John Gibson, Feb  3 1995
		Owing to Solaris 2.4 assembler bug, changed SPARC version of
		asm_gen_poplink_code so it uses offsets off o5 to push frozvals
		instead of using "set" with location counter "." (better code
		anyway!)
--- John Gibson, Jun  6 1994
		Made unix_ld_crt_objects an active constant that finds the
		latest /opt/SUNWspro/SC* /lib directory etc
--- Robert John Duncan, Mar 22 1994
		Changed asm_gen_poplink_code to plant the execute labels
--- John Gibson, Sep  1 1993
		New definition of asm_startfile for 68K
--- Robert John Duncan, Jun 11 1993
		Added unix_ld_crt_objects for SunOS 5+ (used in "os_comms.p")
--- Robert John Duncan, Jun  7 1993
		Defined unix_ld_command_header for SVR4
--- Robert John Duncan, Jun  1 1993
		Changed ASM_{TEXT,DATA}_STR for SVR4; added equivalent macros
		ASM_{TEXT,DATA}_SECTION for selecting the correct versions in the
		hand-coded assembler files,
--- John Gibson, May 19 1993
		Added asm_gen_exfunc_clos_code
--- Simon Nichols, Jan 29 1993
		Changed name of conditional compilation flag SUNOS_DYNAMIC to
		SHARED_LIBRARIES.
--- Robert John Duncan, Jul 27 1992
		Added -extern_name_translate-
--- Robert John Duncan, Jul 24 1992
		ld command path and options have changed completely for SunOS 5.0.
		Also switched to dynamic linking by default.
--- Simon Nichols, Mar  3 1992
		Changes to support SunOS dynamic linking (temporarily flagged by
		SUNOS_DYNAMIC).
--- John Gibson, Jul 28 1990
		Fixed bug in SPARC -asm_gen_poplink_code-
--- John Gibson, Mar  8 1990
		Added -sunfp_poplink_flag-
--- John Gibson, Jul 17 1989
		OS command procedures commoned in C.unix/src/syscomp/os_comms.p
		(but this file still defines the "ld" command string since this
		is different for nearly every system).
--- John Gibson, Jun  7 1989
		Included common.ph
--- Rob Duncan, Apr  4 1989
		Replaced SUN_RELEASE with SUNOS
--- John Gibson, Mar 23 1989
		Added -asm_addbits- and -asm_outbits-
--- John Gibson, Feb  8 1989
		Removed fix for SunOS 4.0 of using special $popsrc/libc.olb
		(since normal libc.a is fixed in OS 4.0.1)
--- John Gibson, Feb  2 1989
		Changed -asm_gen_poplink_code- to allow any number of frozvals to
		be pushed.
--- John Gibson, Nov 16 1988
		Added procedure -unix_archive- (used by poplibr)
--- John Gibson, Jul 13 1988
		Added Sun-4 stuff
--- John Gibson, Jun 24 1988
		Added assembling and linking procedures.
--- John Gibson, Jan 21 1988
		Corrected bug in -asm_quick_genstring- (incremented loop counter
		-n- twice).
--- John Gibson, Jan 17 1988
		Revised label formats to cope with sections, etc, and
		added new label procedures -asm_wordidlabel-, -asm_pdpropslabel-
		-asm_testdeflabel-.
			Also new procedures -asm_align_double-, -asm_out_dfloat-,
		-asm_gen_poplink_code-.
--- John Gibson, Aug 16 1987
		Added missing lvars declaration for -pre- in -asm_label-
 */
