/* --- Copyright University of Sussex 1993. All rights reserved. ----------
 > File:            C.all/lib/proto/go/lib/go_mouse_sensitive.p
 > Purpose:         GO file
 > Author:          Ben Rabau, 1992-1993
 > Documentation:   HELP GO_CLASSES
 > Related Files:
 */
													   ;;; 21st June 1992
;;; File: go_mouse_sensitive.p
;;; Authors: B Rabau (based on original code of J L Cunningham)

compile_mode :pop11 +strict;

;;; This file should be used in conjunction with go_action.p ...

;;;------------------------------------------------------
;;; Definitions which where previously defined in sketch_basics.p

uses go_sensitive.p

;;;------------------------------------------------------
;;; SENSITIVE TO MOUSE CLICKS IN LIVE MODE

;;; INTRO: The MIXIN go_mouse_sensitive adds behaviour (actions) to the
;;; INTRO: Graphical Objects when mouse events occur over the object. These
;;; INTRO: actions only get called in "live" mode (see HELP * GO_LIVE).
;;; INTRO: The actions are devided in three categories: down, drag and up
;;; INTRO: which correspond to the state of a mouse button. By default the
;;; INTRO: code foresees a three button mouse, but any number of buttons can
;;; INTRO: be accomodated by extending the stored lists. Note that the number
;;; INTRO: of butons relates to the logical device; e.g. in X-windows vendors
;;; INTRO: with a physical two-button mouse often add a third logical button
;;; INTRO: in the form of combined pressing of both physical mouse-buttons.
;;; INTRO: See also LIB * GO_KEY_SENSITIVE for keyboard actions.

define no_action( event_data, dummy_object );
lvars event_data, dummy_object;
;;; REF: no_action( EVENT_DATA, OBJECT );
;;; REF: Dummy action in GO (default action on mouse-clicks): erase arguments.
enddefine;

define :mixin go_mouse_sensitive;
	slot stored_go_mouse_down_action = {^no_action ^no_action ^no_action};
;;; REF: A vector representing the actions attached to the down event of a
;;; REF: mouse-button. The vector needs to be as long as the maximum number
;;; REF: of mouse-buttons available. Default: 3 mouse-buttons with no_action()
	slot stored_go_mouse_drag_action = {^no_action ^no_action ^no_action};
;;; REF: A vector representing the actions attached to the drag event of a
;;; REF: mouse-button. The vector needs to be as long as the maximum number
;;; REF: of mouse-buttons available. Default: 3 mouse-buttons with no_action()
	slot stored_go_mouse_up_action   = {^no_action ^no_action ^no_action};
;;; REF: A vector representing the actions attached to the up event of a
;;; REF: mouse-button. The vector needs to be as long as the maximum number
;;; REF: of mouse-buttons available. Default: 3 mouse-buttons with no_action()

enddefine;


define :method go_accepts_events( type, raw_event_data, obj :go_mouse_sensitive ) -> accepts;
lvars type, raw_event_data, obj, accepts = false;
;;; REF: go_accepts_events( TYPE, RAW_EVENT_DATA, MOUSE_SENSITIVE ) -> BOOLEAN;
;;; REF: Returns whether or not this object accepts the event. In this
;;; REF: case whether the event is a mouse event.
;;; REF: TYPE is one of "mouse" or "keyboard".
;;; REF: RAW_EVENT_DATA is a vector (see REF * GO_XACTION/go_expand_event_data).
;;; REF: MOUSE_SENSITIVE is a go_mouse_sensitive object (LIB * GO_MOUSE_SENSITIVE).
	(type == "mouse") -> accepts;
	unless accepts then
		call_next_method( type, raw_event_data, obj ) -> accepts;
	endunless;
enddefine;


;;;------------------------------------------------------
;;; MOUSE BUTTON ACTIONS:
;;;------------------------------------------------------
define :method go_mouse_down_action( butt, obj :go_mouse_sensitive );
lvars butt, obj;
;;; REF: go_mouse_down_action( Button, MOUSE_SENSITIVE ) -> PROCEDURE;
;;; REF: Gets the action attached to the mouse sensitive object when the
;;; REF: indicated mouse-button is pushed down over the object.
;;; REF: These actions only get called in "live" mode (see HELP * GO_LIVE).
;;; REF: Button is a positive integer indicating the mouse-button, default [1..3]
;;; REF: MOUSE_SENSITIVE is a go_mouse_sensitive object (LIB * GO_MOUSE_SENSITIVE).
	stored_go_mouse_down_action(obj)(butt);
enddefine;

define :method updaterof go_mouse_down_action( proc, butt, obj :go_mouse_sensitive );
lvars proc, butt, obj;
;;; REF: PROCEDURE -> go_mouse_down_action( Button, MOUSE_SENSITIVE );
;;; REF: Attaches the action to the mouse sensitive object for when the
;;; REF: indicated mouse-button is pushed down over the object.
;;; REF: These actions only get called in "live" mode (see HELP * GO_LIVE).
;;; REF: Button is a positive integer indicating the mouse-button, default [1..3]
;;; REF: MOUSE_SENSITIVE is a go_mouse_sensitive object (LIB * GO_MOUSE_SENSITIVE).
	proc -> stored_go_mouse_down_action(obj)(butt);
enddefine;


define :method go_mouse_drag_action( butt, obj :go_mouse_sensitive );
lvars butt, obj;
;;; REF: go_mouse_drag_action( Button, MOUSE_SENSITIVE ) -> PROCEDURE;
;;; REF: Gets the action attached to the mouse sensitive object when the
;;; REF: indicated mouse-button is held down over the object and then moved.
;;; REF: These actions only get called in "live" mode (see HELP * GO_LIVE).
;;; REF: Button is a positive integer indicating the mouse-button, default [1..3]
;;; REF: MOUSE_SENSITIVE is a go_mouse_sensitive object (LIB * GO_MOUSE_SENSITIVE).
	stored_go_mouse_drag_action(obj)(butt);
enddefine;

define :method updaterof go_mouse_drag_action( proc, butt, obj :go_mouse_sensitive );
lvars proc, butt, obj;
;;; REF: PROCEDURE -> go_mouse_drag_action( Button, MOUSE_SENSITIVE );
;;; REF: Attaches the action to the mouse sensitive object for when the
;;; REF: indicated mouse-button is held down over the object and then moved.
;;; REF: These actions only get called in "live" mode (see HELP * GO_LIVE).
;;; REF: Button is a positive integer indicating the mouse-button, default [1..3]
;;; REF: MOUSE_SENSITIVE is a go_mouse_sensitive object (LIB * GO_MOUSE_SENSITIVE).
	proc -> stored_go_mouse_drag_action(obj)(butt);
enddefine;


define :method go_mouse_up_action( butt, obj :go_mouse_sensitive );
lvars butt, obj;
;;; REF: go_mouse_drag_action( Button, MOUSE_SENSITIVE ) -> PROCEDURE;
;;; REF: Gets the action attached to the mouse sensitive object when the
;;; REF: indicated mouse-button is released after being held down over the object.
;;; REF: These actions only get called in "live" mode (see HELP * GO_LIVE).
;;; REF: Button is a positive integer indicating the mouse-button, default [1..3]
;;; REF: MOUSE_SENSITIVE is a go_mouse_sensitive object (LIB * GO_MOUSE_SENSITIVE).
	stored_go_mouse_up_action(obj)(butt);
enddefine;

define :method updaterof go_mouse_up_action( proc, butt, obj :go_mouse_sensitive );
lvars proc, butt, obj;
;;; REF: PROCEDURE -> go_mouse_drag_action( Button, MOUSE_SENSITIVE );
;;; REF: Attaches the action to the mouse sensitive object for when the
;;; REF: indicated mouse-button is released after being held down over the object.
;;; REF: These actions only get called in "live" mode (see HELP * GO_LIVE).
;;; REF: Button is a positive integer indicating the mouse-button, default [1..3]
;;; REF: MOUSE_SENSITIVE is a go_mouse_sensitive object (LIB * GO_MOUSE_SENSITIVE).
	proc -> stored_go_mouse_up_action(obj)(butt);
enddefine;

;;;------------------------------------------------------
;;; MOUSE BUTTON ACTIONS: COMPATIBILITY WITH OLD RELEASES
;;;------------------------------------------------------
;;; Methods for saving and restoring procedural attributes
;;; All the methods below are triggerd when the mouse button is up,

;;; In live_mode the <Select> button (Left mouse button) can be user
;;; defined with the go_select_action() method
define :method go_select_action( obj :go_mouse_sensitive ) -> proc;
lvars obj;
;;; REF: go_select_action( MOUSE_SENSITIVE ) -> PROCEDURE;
;;; REF: Gets the argument-free procedure attached to the mouse sensitive object
;;; REF: when the left mouse-button is released after being held down over the
;;; REF: object. This method is obsolete and should be replaced by:
;;; REF:     go_mouse_up_action(MOUSE_SENSITIVE)(1) -> PROCEDURE;
;;; REF: These actions only get called in "live" mode (see HELP * GO_LIVE).
;;; REF: MOUSE_SENSITIVE is a go_mouse_sensitive object (LIB * GO_MOUSE_SENSITIVE).
lvars proc = stored_go_mouse_up_action(obj)(1);
	if ( ispcomposite(proc) ) then explode( proc ) -> (proc,); endif;
enddefine;

define :method updaterof go_select_action( newproc, obj :go_mouse_sensitive );
lvars newproc, obj;
;;; REF: PROCEDURE -> go_select_action( MOUSE_SENSITIVE );
;;; REF: Attaches the argument-free procedure to the mouse sensitive object
;;; REF: when the left mouse-button is released after being held down over the
;;; REF: object. This method is obsolete and should be replaced by:
;;; REF:     PROCEDURE -> go_mouse_up_action(MOUSE_SENSITIVE)(1);
;;; REF: These actions only get called in "live" mode (see HELP * GO_LIVE).
;;; REF: MOUSE_SENSITIVE is a go_mouse_sensitive object (LIB * GO_MOUSE_SENSITIVE).
	newproc <> no_action -> stored_go_mouse_up_action(obj)(1);
enddefine;

;;; In live_mode the dragiing of <Select> button (Left mouse button) can
;;; be user defined with the go_drag_action() method
;;;
define :method go_drag_action( obj :go_mouse_sensitive ) -> proc;
lvars obj;
;;; REF: go_select_action( MOUSE_SENSITIVE ) -> PROCEDURE;
;;; REF: Gets the argument-free procedure attached to the mouse sensitive object
;;; REF: when the left mouse-button is held down over the object and then moved.
;;; REF: This method is obsolete and should be replaced by
;;; REF:     go_mouse_drag_action(MOUSE_SENSITIVE)(1) -> PROCEDURE;
;;; REF: These actions only get called in "live" mode (see HELP * GO_LIVE).
;;; REF: MOUSE_SENSITIVE is a go_mouse_sensitive object (LIB * GO_MOUSE_SENSITIVE).
lvars proc = stored_go_mouse_drag_action(obj)(1);
	if ( ispcomposite(proc) ) then explode( proc ) -> (proc,); endif;
enddefine;

define :method updaterof go_drag_action( newproc, obj :go_mouse_sensitive );
lvars newproc, obj;
;;; REF: PROCEDURE -> go_select_action( MOUSE_SENSITIVE );
;;; REF: Attaches the argument-free procedure to the mouse sensitive object
;;; REF: when the left mouse-button is held down over the object and then moved.
;;; REF: This method is obsolete and should be replaced by
;;; REF:     PROCEDURE -> go_mouse_up_action(MOUSE_SENSITIVE)(1);
;;; REF: These actions only get called in "live" mode (see HELP * GO_LIVE).
;;; REF: MOUSE_SENSITIVE is a go_mouse_sensitive object (LIB * GO_MOUSE_SENSITIVE).
	newproc <> no_action -> stored_go_mouse_drag_action(obj)(1);
enddefine;

;;; In live_mode the <Adjust> button (Middle mouse button) can be user
;;; defined with the go_middle_action() method
;;;
define :method go_middle_action( obj :go_mouse_sensitive ) -> proc;
lvars obj;
;;; REF: go_select_action( MOUSE_SENSITIVE ) -> PROCEDURE;
;;; REF: Gets the argument-free procedure attached to the mouse sensitive object
;;; REF: when the middle (of 3) mouse-button is released after being held down
;;; REF: over the object. This method is obsolete and should be replaced by:
;;; REF:     go_mouse_up_action(MOUSE_SENSITIVE)(2) -> PROCEDURE;
;;; REF: These actions only get called in "live" mode (see HELP * GO_LIVE).
;;; REF: MOUSE_SENSITIVE is a go_mouse_sensitive object (LIB * GO_MOUSE_SENSITIVE).
lvars proc = stored_go_mouse_up_action(obj)(2);
	if ( ispcomposite(proc) ) then explode( proc ) -> (proc,); endif;
enddefine;

define :method updaterof go_middle_action( newproc, obj :go_mouse_sensitive );
lvars newproc, obj;
;;; REF: PROCEDURE -> go_select_action( MOUSE_SENSITIVE );
;;; REF: Attaches the argument-free procedure to the mouse sensitive object
;;; REF: when the middle (of 3) mouse-button is released after being held down
;;; REF: over the object. This method is obsolete and should be replaced by:
;;; REF:     PROCEDURE -> go_mouse_up_action(MOUSE_SENSITIVE)(2);
;;; REF: These actions only get called in "live" mode (see HELP * GO_LIVE).
;;; REF: MOUSE_SENSITIVE is a go_mouse_sensitive object (LIB * GO_MOUSE_SENSITIVE).
	newproc <> no_action -> stored_go_mouse_up_action(obj)(2);
enddefine;

;;; In live_mode the <Menu> button (Right mouse button) can be user
;;; defined with the go_right_action() method
;;;
define :method go_right_action( obj :go_mouse_sensitive ) -> proc;
lvars obj;
;;; REF: go_select_action( MOUSE_SENSITIVE ) -> PROCEDURE;
;;; REF: Gets the argument-free procedure attached to the mouse sensitive object
;;; REF: when the right mouse-button is released after being held down over the
;;; REF: object. This method is obsolete and should be replaced by:
;;; REF:     go_mouse_up_action(MOUSE_SENSITIVE)(1) -> PROCEDURE;
;;; REF: These actions only get called in "live" mode (see HELP * GO_LIVE).
;;; REF: MOUSE_SENSITIVE is a go_mouse_sensitive object (LIB * GO_MOUSE_SENSITIVE).
lvars proc = stored_go_mouse_up_action(obj)(3);
	if ( ispcomposite(proc) ) then explode( proc ) -> (proc,); endif;
enddefine;

define :method updaterof go_right_action( newproc, obj :go_mouse_sensitive );
lvars newproc, obj;
;;; REF: PROCEDURE -> go_select_action( MOUSE_SENSITIVE );
;;; REF: Attaches the argument-free procedure to the mouse sensitive object
;;; REF: when the right mouse-button is released after being held down over the
;;; REF: object. This method is obsolete and should be replaced by:
;;; REF:     PROCEDURE -> go_mouse_up_action(MOUSE_SENSITIVE)(1);
;;; REF: These actions only get called in "live" mode (see HELP * GO_LIVE).
;;; REF: MOUSE_SENSITIVE is a go_mouse_sensitive object (LIB * GO_MOUSE_SENSITIVE).
	newproc <> no_action -> stored_go_mouse_up_action(obj)(3);
enddefine;

;;;------------------------------------------------------
;;; Enter a string which needs to be compiled:

define :method go_select_action_string( obj :go_mouse_sensitive );
lvars obj;
;;; REF: go_select_action( MOUSE_SENSITIVE ) -> STRING;
;;; REF: Decompiles the procedure attached to the mouse sensitive object for
;;; REF: when the left mouse-button is held down over the object.
;;; REF: This method only works if the procedure was attached to the object
;;; REF: with the updater of go_select_action_string. This method is obsolete
;;; REF: and should be replaced by a correct use of:
;;; REF:     go_mouse_up_action(MOUSE_SENSITIVE)(1) -> PROCEDURE;
;;; REF: These actions only get called in "live" mode (see HELP * GO_LIVE).
;;; REF: MOUSE_SENSITIVE is a go_mouse_sensitive object (LIB * GO_MOUSE_SENSITIVE).
	go_action_string(obj.go_select_action);
enddefine;

define :method updaterof go_select_action_string(str, obj :go_mouse_sensitive );
lvars obj;
;;; REF: STRING -> go_select_action( MOUSE_SENSITIVE );
;;; REF: Compiles and attaches the string representing an argument-free
;;; REF: procedure to the mouse sensitive object for when the left mouse-button
;;; REF: is released after being held down over the object. This method is
;;; REF: obsolete and should be replaced by a correct use of:
;;; REF:     PROCEDURE -> go_mouse_up_action(MOUSE_SENSITIVE)(1);
;;; REF: These actions only get called in "live" mode (see HELP * GO_LIVE).
;;; REF: MOUSE_SENSITIVE is a go_mouse_sensitive object (LIB * GO_MOUSE_SENSITIVE).
	go_compile_action(str) -> obj.go_select_action;
enddefine;

define :method go_drag_action_string( obj :go_mouse_sensitive );
lvars obj;
;;; REF: go_drag_action_string( MOUSE_SENSITIVE ) -> STRING;
;;; REF: Decompiles the procedure attached to the mouse sensitive object for
;;; REF: when the left mouse-button is held down over the object and then moved.
;;; REF: This method only works if the procedure was attached to the object
;;; REF: with the updater of go_drag_action_string. This method is obsolete
;;; REF: and should be replaced by a correct use of:
;;; REF:     go_mouse_drag_action(MOUSE_SENSITIVE)(1) -> PROCEDURE;
;;; REF: These actions only get called in "live" mode (see HELP * GO_LIVE).
;;; REF: MOUSE_SENSITIVE is a go_mouse_sensitive object (LIB * GO_MOUSE_SENSITIVE).
	go_action_string(obj.go_drag_action);
enddefine;

define :method updaterof go_drag_action_string(str, obj :go_mouse_sensitive );
lvars obj;
;;; REF: STRING -> go_drag_action_string( MOUSE_SENSITIVE );
;;; REF: Compiles and attaches the string representing an argument-free
;;; REF: procedure to the mouse sensitive object for when the left mouse-button
;;; REF: is moved after being held down over the object. This method is
;;; REF: obsolete and should be replaced by a correct use of:
;;; REF:     PROCEDURE -> go_mouse_drag_action(MOUSE_SENSITIVE)(1);
;;; REF: These actions only get called in "live" mode (see HELP * GO_LIVE).
;;; REF: MOUSE_SENSITIVE is a go_mouse_sensitive object (LIB * GO_MOUSE_SENSITIVE).
	go_compile_action(str) -> obj.go_drag_action;
enddefine;

define :method go_middle_action_string( obj :go_mouse_sensitive );
lvars obj;
;;; REF: go_middle_action_string( MOUSE_SENSITIVE ) -> STRING;
;;; REF: Decompiles the procedure attached to the mouse sensitive object for
;;; REF: when the middle (of 3) mouse-button is held down over the object.
;;; REF: This method only works if the procedure was attached to the object
;;; REF: with the updater of go_middle_action_string. This method is obsolete
;;; REF: and should be replaced by a correct use of:
;;; REF:     go_mouse_up_action(MOUSE_SENSITIVE)(2) -> PROCEDURE;
;;; REF: These actions only get called in "live" mode (see HELP * GO_LIVE).
;;; REF: MOUSE_SENSITIVE is a go_mouse_sensitive object (LIB * GO_MOUSE_SENSITIVE).
	go_action_string(obj.go_middle_action);
enddefine;

define :method updaterof go_middle_action_string(str, obj :go_mouse_sensitive );
lvars obj;
;;; REF: STRING -> go_middle_action_string( MOUSE_SENSITIVE );
;;; REF: Compiles and attaches the string representing an argument-free
;;; REF: procedure to the mouse sensitive object for when the middle (of 3)
;;; REF: mouse-button is released after being held down over the object. This
;;; REF: method is obsolete and should be replaced by a correct use of:
;;; REF:     PROCEDURE -> go_mouse_up_action(MOUSE_SENSITIVE)(2);
;;; REF: These actions only get called in "live" mode (see HELP * GO_LIVE).
;;; REF: MOUSE_SENSITIVE is a go_mouse_sensitive object (LIB * GO_MOUSE_SENSITIVE).
	go_compile_action(str) -> obj.go_middle_action;
enddefine;

define :method go_right_action_string( obj :go_mouse_sensitive );
lvars obj;
;;; REF: go_right_action_string( MOUSE_SENSITIVE ) -> STRING;
;;; REF: Decompiles the procedure attached to the mouse sensitive object for
;;; REF: when the right (of 3) mouse-button is held down over the object.
;;; REF: This method only works if the procedure was attached to the object
;;; REF: with the updater of go_middle_action_string. This method is obsolete
;;; REF: and should be replaced by a correct use of:
;;; REF:     go_mouse_up_action(MOUSE_SENSITIVE)(3) -> PROCEDURE;
;;; REF: These actions only get called in "live" mode (see HELP * GO_LIVE).
;;; REF: MOUSE_SENSITIVE is a go_mouse_sensitive object (LIB * GO_MOUSE_SENSITIVE).
	go_action_string(obj.go_right_action);
enddefine;

define :method updaterof go_right_action_string(str, obj :go_mouse_sensitive );
lvars obj;
;;; REF: STRING -> go_right_action_string( MOUSE_SENSITIVE );
;;; REF: Compiles and attaches the string representing an argument-free
;;; REF: procedure to the mouse sensitive object for when the right (of 3)
;;; REF: mouse-button is released after being held down over the object. This
;;; REF: method is obsolete and should be replaced by a correct use of:
;;; REF:     PROCEDURE -> go_mouse_up_action(MOUSE_SENSITIVE)(3);
;;; REF: These actions only get called in "live" mode (see HELP * GO_LIVE).
;;; REF: MOUSE_SENSITIVE is a go_mouse_sensitive object (LIB * GO_MOUSE_SENSITIVE).
	go_compile_action(str) -> obj.go_right_action;
enddefine;


;;;----------------------------------------------------------------
;;; Variable for "uses"
vars go_mouse_sensitive = true;


/* --- Revision History --------------------------------------------
 * BR 21/06/93
 *     Added the go_accepts_events() method.
 * BR 04/05/93
 *     Split file go_sensitive.p into three parts:
 *         - go_sensitive.p       Common procedures for compilation aid
 *         - go_key_sensitive.p   The mixin for adding keyboard sensitivity
 *         - go_mouse_sensitive.p The mixin for adding mouse sensitivity
 *     Added go_ prefix to: compile_action() & action_string();
 *     Added comments.
 */
;;; eof
