/* --- Copyright University of Sussex 1997. All rights reserved. ----------
 * File:            S.sun4/src/alisp.s
 * Purpose:
 * Author:          John Williams & John Gibson, Aug 19 1988 (see revisions)
 */

;;; ---------------------- LISP ROUTINES ---------------------------------

#_<

#_INCLUDE 'asm.ph'

constant	_setstklen_diff
	;

>_#

/********************* wrapping structures ***********************************/

ASM_TEXT_SECTION
	.word	Ltext_end-Ltext_start, C_LAB(Sys$-objmod_pad_key)
Ltext_start:
ASM_DATA_SECTION
	.word	Ldata_end-Ldata_start, C_LAB(Sys$-objmod_pad_key)
Ldata_start:

/**************************************************************************/

ASM_TEXT_SECTION

DEF_C_LAB (_setstklen)
	ld	[%r_svb+_SVB_OFFS(_userhi)], %o0 ;;; _userhi
	ld	[%us], %o1		;;; nresults
	ld	[%us+4], %o2		;;; saved stklen
	inc	8, %us
	add	%o1, %o2, %o1		;;; saved stklen + nresults + 6
	dec	6, %o1			;;; desired stacklength (bytes)
	sub	%o0, %o1, %o0		;;; desired us in o0
	cmp	%o0, %us
	bne	C_LAB(_setstklen_diff)	;;; carry on if different
	nop
	retl				;;; return if same
	nop

DEF_C_LAB (_setstklen_diff)
	bgu	2f			;;; erase if o0 > us
	nop

	set	C_LAB(nil), %o1
1:	dec	4, %us
	cmp	%o0, %us
	bne	1b
	st	%o1, [%us]		;;; push nil

	retl
	nop

2:	retl
	mov	%o0, %us		;;; set us to desired stacklength


/*************** end labels for wrapping structures **************************/

ASM_TEXT_SECTION
	.align	8
Ltext_end:
ASM_DATA_SECTION
	.align	8
Ldata_end:

/**************************************************************************/

/* --- Revision History ---------------------------------------------------
--- John Gibson, Oct  1 1997
	Now includes asm.ph
--- Robert John Duncan, Jun  1 1993
	Changed to use ASM_SECTION macros for changing section
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- Robert Smith, Sep  8 1988 Added commas to macro definitions
 */
