/* --- Copyright University of Sussex 1997. All rights reserved. ----------
 * File:	    S.sun4/src/amisc.s
 * Purpose:
 * Author:          John Gibson, Aug 19 1988 (see revisions)
 */

;;; --------------- MISCELLANEOUS ASSEMBLER ROUTINES -----------------------

#_<

#_INCLUDE 'asm.ph'

vars
	_call_stack_lim, _plog_trail_sp, _plog_trail_lim
	;

section $-Sys;

constant
	procedure (Call_overflow, User_overflow, Callstack_reset,
	Conspair, Plog$-Area_overflow, Async_raise_signal)
	;

endsection;

lconstant macro (
	_K_APPLY	= @@K_APPLY,
	_RF_CONT	= @@RF_CONT,
	_PD_EXECUTE 	= @@PD_EXECUTE,
	_PD_EXIT	= @@PD_EXIT,
	_PD_FRAME_LEN	= @@PD_FRAME_LEN,
	_PD_UPDATER	= @@PD_UPDATER,
	_V_BYTES	= @@V_BYTES,

	;;; flush windows trap -- see <machine/trap.h>
	ST_FLUSH_WINDOWS = 3,
	);

>_#


/********************* wrapping structures ***********************************/

ASM_TEXT_SECTION
	.word	Ltext_end-Ltext_start, C_LAB(Sys$-objmod_pad_key)
Ltext_start:
ASM_DATA_SECTION
	.word	Ldata_end-Ldata_start, C_LAB(Sys$-objmod_pad_key)
Ldata_start:

/**************************************************************************/


ASM_TEXT_SECTION


;;; --- CHECKS DONE ON PROCEDURE ENTRY ---------------------------------

DEF_C_LAB (_checkplogall)
	ld	[%r_svb+_SVB_OFFS(_plog_trail_sp)], %o3		;;; trail sp
	ld	[%r_svb+_SVB_OFFS(_plog_trail_lim)], %o4	;;; trail lim
	ld	[%r_svb+_SVB_OFFS(_call_stack_lim)], %o1	;;; call stack limit
	cmp	%o3, %o4
	blu	checkall_cmp			;;; OK, trail sp < lim
	ld	[%r_svb+_SVB_OFFS(_userlim)], %o2		;;; userstack limit
	;;; chain Plog$-Area_overflow
	set	XC_LAB(weakref[prologvar_key] Sys$-Plog$-Area_overflow), %o0
	jmp	%o0
	nop

DEF_C_LAB (_checkall)
	ld	[%r_svb+_SVB_OFFS(_call_stack_lim)], %o1	;;; call stack limit
	ld	[%r_svb+_SVB_OFFS(_userlim)], %o2		;;; userstack limit
checkall_cmp:
	ld	[%r_svb+_SVB_OFFS(_trap)], %o3	;;; signals pending flag
	cmp	%sp, %o1
	bgeu	1f				;;; br if callstack OK
	cmp	%us, %o2			;;; compare userstack
	;;; callstack overflow
	set	XC_LAB(Sys$-Call_overflow), %o0
	b,a	4f

1:	bgeu	2f				;;; br if userstack OK
	tst	%o3				;;; test _trap
	;;; userstack overflow
	set	XC_LAB(Sys$-User_overflow), %o0
	b,a	4f

2:	bz	3f				;;; br if _trap clear
	sethi	%hi(I_LAB(_disable)), %o1
	;;; _trap nonzero, i.e. signals pending
	ld	[%o1+%lo(I_LAB(_disable))], %o1
	btst	1, %o1				;;; interrupts disabled?
	bnz	3f				;;; continue if so
	nop
	set	XC_LAB(Sys$-Async_raise_signal), %o0	;;; chain to handle sig
	jmp	%o0
	nop

3:	retl					;;; everything OK, return
	nop

	;;; call/user stack overflow
4:	sethi	%hi(I_LAB(_disable)), %o1
	ld	[%o1+%lo(I_LAB(_disable))], %o1
	btst	2, %o1				;;; stack checks disabled?
	bnz	2b				;;; continue if so
	tst	%o3				;;; testing _trap
	jmp	%o0				;;; else execute handler routine
	nop


DEF_C_LAB (_checkinterrupt)
	ld	[%r_svb+_SVB_OFFS(_trap)], %o0	;;; trap flag
	tst	%o0
	bz	1f				;;; br if clear
	nop
	b,a	C_LAB(_checkall)		;;; do all checks if trap set
1:	retl
	nop


;;; --- CHAINING ROUTINES ----------------------------------------------------

	;;; Unwind the current stack frame, by jumping into the procedure's
	;;; exit code. This subroutine is called immediately after executing
	;;; an M_UNWIND operation, so that the (unwanted) return address into
	;;; the procedure being unwound has been replaced in o7 by the return
	;;; address to the caller of this routine.
	;;;    The procedure's exit code finishes with 'ret; restore', and we
	;;; replace the return address into the NEXT caller with the return
	;;; from this subroutine, but saving the former in CHAIN_REG (= g1)
	;;; from whence it can be restored with an M_CALL_WITH_RETURN
	;;; operation.
DEF_C_LAB (_unwind_frame)
	ld	[%pb+_PD_EXIT], %o0	;;; address of procedure's exit code
	add	%i7, 8, %g1		;;; save caller's return in CHAIN_REG
	jmp	%o0			;;; go into exit code
	mov	%o7, %i7		;;; making return be to my caller


	;;; Routines to chain a procedure, either directly or out of the
	;;; current caller. These are executed as a result of displacing a
	;;; stack frame return address with their address-8 and then
	;;; returning with 'ret; restore'.
	;;;     In the case of _syschain and _sysncchain, the displaced
	;;; return is saved in CHAIN_REG.

DEF_C_LAB (_syschain_caller)
	call	C_LAB(_unwind_frame)	;;; pop frame for current procedure
	nop
DEF_C_LAB (_syschain)
	sub	%g1, 8, %o7	;;; reinstate return address from CHAIN_REG
	ld	[%us], %o0	;;; procedure to chain off stack
	b	C_LAB(_popenter)
	inc	4, %us

	;;; The same, but with no check for procedure
DEF_C_LAB (_sysncchain_caller)
	call	C_LAB(_unwind_frame)	;;; pop frame for current procedure
	nop
DEF_C_LAB (_sysncchain)
	ld	[%us], %opb	;;; procedure to chain off stack
	sub	%g1, 8, %o7	;;; reinstate return address from CHAIN_REG
	ld	[%opb], %o0	;;; execute address
	jmp	%o0+8		;;; run it
	inc	4, %us


	;;; erase 1 stack frame and chain Callstack_reset
	;;; (used by Callstack_reset in cleaning up)
DEF_C_LAB (_erase_sp_1)
	set	XC_LAB(Sys$-Callstack_reset), %o0
	jmp	%o0			;;; try again
	restore				;;; having erased one frame

	;;; Flush register windows into memory
	;;; (now uses "ta" and could be compiled in-line)
DEF_C_LAB(Sys$- _flush_regfile)
	retl
	ta	_:ST_FLUSH_WINDOWS	;;; flush windows trap



	;;; _cache_flush(______wptr, _______woffs)
	;;; Flush the instruction cache

DEF_C_LAB(Sys$- _cache_flush)
	ld	[%us], %o1	;;; _______woffs
	ld	[%us+4], %o0	;;; ______wptr
	tst	%o1
	ble	2f
	inc	8, %us

1:	deccc	4, %o1
	bnz	1b
	iflush	%o0+%o1

2:	retl; nop


;;; --- CALLING ARBITRARY OBJECTS ----------------------------------------

	;;; call an object in o0
DEF_C_LAB (_popenter)
	btst	1, %o0			;;; is simple?
	bnz	1f			;;; br if so
	sethi	%hi(C_LAB(procedure_key)), %o2
	ld	[%o0+_KEY], %o1		;;; get key
	or	%o2, %lo(C_LAB(procedure_key)), %o2
	cmp	%o1, %o2		;;; object has procedure key?
	bne	2f			;;; br if not
	ld	[%o0], %o2		;;; execute address
	jmp	%o2+8			;;; run it at after set or nops
	mov	%o0, %opb		;;; set for pb

	;;; applying a simple object. set appropriate key in o1
1:	set	C_LAB(integer_key), %o1
	btst	2, %o0			;;; is integer?
	bnz	2f			;;; br if so
	nop
	set	C_LAB(weakref decimal_key), %o1

	;;; applying non procedure -- run key apply proc (key in o1)
2:	ld	[%o1+_K_APPLY], %o1	;;; K_APPLY ref
	dec	4, %us
	ld	[%o1+_RF_CONT], %opb	;;; procedure in ref cont
	st	%o0, [%us]		;;; stack object
	ld	[%opb], %o0		;;; execute address
	jmp	%o0+8			;;; run it
	nop

	;;; call updater of object in o0 -- checking entry
DEF_C_LAB (_popuenter)
	btst	1, %o0			;;; is simple?
	bnz	2f			;;; br if so
	sethi	%hi(C_LAB(procedure_key)), %o2
	ld	[%o0+_KEY], %o1		;;; get key
	or	%o2, %lo(C_LAB(procedure_key)), %o2
	cmp	%o1, %o2		;;; object has procedure key?
	be,a	up_ex_opb		;;; br if so to execute updater in opb
	ld	[%o0+_PD_UPDATER], %opb	;;; get updater

	;;; applying non procedure as updater
	;;; -- run key apply proc updater (key in o1)
1:	ld	[%o1+_K_APPLY], %o1	;;; K_APPLY ref
	dec	4, %us
	ld	[%o1+_RF_CONT], %o1	;;; procedure in ref cont
	st	%o0, [%us]		;;; stack object
	ld	[%o1+_PD_UPDATER], %opb	;;; its updater
	cmp	%opb, %r_false		;;; test false
	be	up_err			;;; error if false
	ld	[%opb], %o2		;;; execute address
	jmp	%o2+8			;;; run it
	nop

	;;; applying a simple object as updater. set appropriate key in o1
2:	set	C_LAB(integer_key), %o1
	btst	2, %o0			;;; is integer?
	bnz	1b			;;; br if so
	nop
	set	C_LAB(weakref decimal_key), %o1
	b	1b
	nop

	;;; updater was false
up_err_stack:
	dec	4, %us
	st	%o0, [%us]		;;; stack object
up_err:
	set	XC_LAB(-> Sys$-Exec_nonpd), %o0
	jmp	%o0			;;; run exception procedure
	nop


	;;; call updater of object in o0 -- no-checking entry
DEF_C_LAB (_popuncenter)
	ld	[%o0+_PD_UPDATER], %opb	;;; get updater
up_ex_opb:
	cmp	%opb, %r_false		;;; is it false?
	be	up_err_stack
	ld	[%opb], %o2		;;; get updater's execute address
	jmp	%o2+8			;;; run it
	nop

;;; ----------------------------------------------------------------------


	;;; _nextframe(_sframe) -> _nextframe
	;;; get next stack frame
DEF_C_LAB (_nextframe)
	ld	[%us], %o0		;;; frame pointer
	ld	[%o0+_SF_OWNER], %o1	;;; owner procedure
	ldub	[%o1+_PD_FRAME_LEN], %o1 ;;; frame size in words
	sll	%o1, 2, %o1		;;; to bytes
	add	%o0, %o1, %o0		;;; add to frame pointer for next
	retl
	st	%o0, [%us]		;;; stack result


	;;; _subss(popint subscript, string) -> popint byte
DEF_C_LAB (_subss)
	ld	[%us+4], %o1	;;; popint subscript
	ld	[%us], %o0	;;; string
	srl	%o1, 2, %o1	;;; make subscript a sysint
	inc	_V_BYTES-1, %o1
	ldub	[%o0+%o1], %o0	;;; the byte
	inc	4, %us
	sll	%o0, 2, %o0
	bset	3, %o0		;;; make popint
	retl
	st	%o0, [%us]	;;; return it

	;;; popint byte -> _subss(popint subscript, string)
DEF_C_LAB(-> _subss)
DEF_C_LAB (_u_subss)
	ld	[%us], %o0	;;; string
	ld	[%us+4], %o1	;;; popint subscript
	ld	[%us+8], %o2	;;; popint byte
	inc	12, %us
	srl	%o2, 2, %o2	;;; make byte a sysint
	srl	%o1, 2, %o1	;;; make subscript a sysint
	inc	_V_BYTES-1, %o1
	retl
	stb	%o2, [%o0+%o1]	;;; store the byte


;;; --- PREDICATES -------------------------------------------------------

	;;; replace tos with true and return (o0 contains %hi(true) )
repl_true:
	bset	%lo(C_LAB(true)), %o0
	retl
	st	%o0, [%us]


DEF_C_LAB (_iscompound)
	ld	[%us], %o0
	btst	1, %o0
	bz,a	repl_true; sethi %hi(C_LAB(true)), %o0
	retl
	st	%r_false, [%us]

DEF_C_LAB (_issimple)
	ld	[%us], %o0
	btst	1, %o0
	bnz,a	repl_true; sethi %hi(C_LAB(true)), %o0
	retl
	st	%r_false, [%us]


DEF_C_LAB (_isinteger)
	ld	[%us], %o0
	btst	2, %o0		;;; bit 1 means popint
	bnz,a	repl_true; sethi %hi(C_LAB(true)), %o0
	retl
	st	%r_false, [%us]

	;;; _int1 _bitst _int2 -> bool   (bitwise AND)
DEF_C_LAB 4 (_bitst)
	ld	[%us], %o1	;;; _int2
	ld	[%us+4], %o0	;;; _int1
	inc	4, %us
	btst	%o0, %o1
	bnz,a	repl_true; sethi %hi(C_LAB(true)), %o0
	retl
	st	%r_false, [%us]


	;;; _int1 _gr _int2 -> bool   (unsigned greater than)
DEF_C_LAB 6 (_gr)
	ld	[%us], %o1	;;; _int2
	ld	[%us+4], %o0	;;; _int1
	inc	4, %us
	cmp	%o0, %o1
	bgu,a	repl_true; sethi %hi(C_LAB(true)), %o0
	retl
	st	%r_false, [%us]

	;;; _int1 _greq _int2 -> bool   (unsigned greater than or equal)
DEF_C_LAB 6 (_greq)
	ld	[%us], %o1	;;; _int2
	ld	[%us+4], %o0	;;; _int1
	inc	4, %us
	cmp	%o0, %o1
	bgeu,a	repl_true; sethi %hi(C_LAB(true)), %o0
	retl
	st	%r_false, [%us]


	;;; _int1 _lt _int2 -> bool   (unsigned less than)
DEF_C_LAB 6 (_lt)
	ld	[%us], %o1	;;; _int2
	ld	[%us+4], %o0	;;; _int1
	inc	4, %us
	cmp	%o0, %o1
	blu,a	repl_true; sethi %hi(C_LAB(true)), %o0
	retl
	st	%r_false, [%us]

	;;; _int1 _lteq _int2 -> bool   (unsigned less than or equal)
DEF_C_LAB 6 (_lteq)
	ld	[%us], %o1	;;; _int2
	ld	[%us+4], %o0	;;; _int1
	inc	4, %us
	cmp	%o0, %o1
	bleu,a	repl_true; sethi %hi(C_LAB(true)), %o0
	retl
	st	%r_false, [%us]

	;;; _int1 _sgr _int2 -> bool   (signed greater than)
DEF_C_LAB 6 (_sgr)
	ld	[%us], %o1	;;; _int2
	ld	[%us+4], %o0	;;; _int1
	inc	4, %us
	cmp	%o0, %o1
	bg,a	repl_true; sethi %hi(C_LAB(true)), %o0
	retl
	st	%r_false, [%us]

	;;; _int1 _sgreq _int2 -> bool   (signed greater than or equal)
DEF_C_LAB 6 (_sgreq)
	ld	[%us], %o1	;;; _int2
	ld	[%us+4], %o0	;;; _int1
	inc	4, %us
	cmp	%o0, %o1
	bge,a	repl_true; sethi %hi(C_LAB(true)), %o0
	retl
	st	%r_false, [%us]

	;;; _int1 _slt _int2 -> bool   (signed less than)
DEF_C_LAB 6 (_slt)
	ld	[%us], %o1	;;; _int2
	ld	[%us+4], %o0	;;; _int1
	inc	4, %us
	cmp	%o0, %o1
	bl,a	repl_true; sethi %hi(C_LAB(true)), %o0
	retl
	st	%r_false, [%us]

	;;; _int1 _slteq _int2 -> bool   (signed less than or equal)
DEF_C_LAB 6 (_slteq)
	ld	[%us], %o1	;;; _int2
	ld	[%us+4], %o0	;;; _int1
	inc	4, %us
	cmp	%o0, %o1
	ble,a	repl_true; sethi %hi(C_LAB(true)), %o0
	retl
	st	%r_false, [%us]

	;;; item1 _neq item2 -> bool
DEF_C_LAB 7 (_neq)
	ld	[%us], %o1	;;; item2
	ld	[%us+4], %o0	;;; item1
	inc	4, %us
	cmp	%o0, %o1
	bne,a	repl_true; sethi %hi(C_LAB(true)), %o0
	retl
	st	%r_false, [%us]

	;;; item1 _eq item2 -> bool
DEF_C_LAB 7 (_eq)
	ld	[%us], %o1	;;; item2
	ld	[%us+4], %o0	;;; item1
	inc	4, %us
	cmp	%o0, %o1
	be,a	repl_true; sethi %hi(C_LAB(true)), %o0
	retl
	st	%r_false, [%us]

	;;; _zero(_int) -> bool
DEF_C_LAB (_zero)
	ld	[%us], %o0
	tst	%o0
	bz,a	repl_true; sethi %hi(C_LAB(true)), %o0
	retl
	st	%r_false, [%us]

	;;; _neg(_int) -> bool
DEF_C_LAB (_neg)
	ld	[%us], %o0
	tst	%o0
	bneg,a	repl_true; sethi %hi(C_LAB(true)), %o0
	retl
	st	%r_false, [%us]

	;;; _not(item) -> bool
DEF_C_LAB (_not)
	ld	[%us], %o0
	cmp	%o0, %r_false
	be,a	repl_true; sethi %hi(C_LAB(true)), %o0
	retl
	st	%r_false, [%us]


	;;; _haskey(item, key) -> bool
DEF_C_LAB (_haskey)
	ld	[%us+4], %o1	;;; the item
	ld	[%us], %o0	;;; the key
	btst	1, %o1		;;; simple?
	bnz	1f		;;; br if so
	inc	4, %us
	ld	[%o1+_KEY], %o1
	cmp	%o1, %o0	;;; compare keys
	be,a	repl_true; sethi %hi(C_LAB(true)), %o0
1:	retl
	st	%r_false, [%us]

	;;; _datakey(item) -> key
DEF_C_LAB (_datakey)
	ld	[%us], %o0	;;; item
	btst	1, %o0		;;; simple?
	bnz,a	1f		;;; br if so
	btst	2, %o0		;;; and set test for integer
	ld	[%o0+_KEY], %o0	;;; key of compound item
	retl
	st	%o0, [%us]	;;; return key

1:	bz	2f		;;; br if bit1 not set (decimal)
	sethi	%hi(C_LAB(integer_key)), %o0
	or	%o0, %lo(C_LAB(integer_key)), %o0
	retl
	st	%o0, [%us]	;;; return integer key

2:	set	C_LAB(weakref decimal_key), %o0
	retl
	st	%o0, [%us]	;;; return decimal key


	;;; optimise subroutine for conspair
DEF_C_LAB (_conspair)
	ld	[%r_svb+_SVB_OFFS(Sys$- _free_pairs)], %o0 ;;; get free pair list
	ld	[%us], %o2		;;; back value into o2
	btst	1, %o0			;;; if simple then none left
	be,a	1f			;;; br if some left
	ld	[%o0+_P_BACK], %o4	;;; getting next back into o4

	;;; none left, chain to Conspair
	sethi	%hi(XC_LAB(Sys$-Conspair)), %o0
	jmp	%o0+%lo(XC_LAB(Sys$-Conspair))
	nop

1:	ld	[%us+4], %o3		;;; front value into o3
	inc	4, %us
	st	%o2, [%o0+_P_BACK]	;;; init back
	st	%o3, [%o0+_P_FRONT]	;;; init front
	st	%o4, [%r_svb+_SVB_OFFS(Sys$- _free_pairs)] ;;; move next back to _free_pairs
	retl
	st	%o0, [%us]		;;; return pair


;;; --- STRING AND CHARACTER SEARCH ROUTINES --------------------------

	;;; _locc(string, len, char) -> offs or -1
DEF_C_LAB (_locc)
	ld	[%us], %o2	;;; sysint char
	ld	[%us+4], %o1	;;; len
	ld	[%us+8], %o0	;;; string addr
	inc	8, %us
	add	%o0, 1, %o4	;;; save string+1 for end

	deccc	1, %o1		;;; decr length first time
1:	bneg	2f		;;; end of string
	inc	1, %o0		;;; step string
	ldub	[%o0-1], %o3	;;; string byte
	cmp	%o3, %o2	;;; compare with char
	bne,a	1b		;;; loop if not same
	deccc	1, %o1		;;; decrement length

	;;; found char at [%o0-1]
	sub	%o0, %o4, %o0	;;; offset to char
	retl
	st	%o0, [%us]	;;; return result

	;;; didn't find it -- return -1
2:	mov	-1, %o0
	retl
	st	%o0, [%us]	;;; return result


	;;; _skpc(string, len, char) -> offs or -1
DEF_C_LAB (_skpc)
	ld	[%us], %o2	;;; sysint char
	ld	[%us+4], %o1	;;; len
	ld	[%us+8], %o0	;;; string addr
	inc	8, %us
	add	%o0, 1, %o4	;;; save string+1 for end

	deccc	1, %o1		;;; decr length first time
1:	bneg	2f		;;; end of string
	inc	1, %o0		;;; step string
	ldub	[%o0-1], %o3	;;; string byte
	cmp	%o3, %o2	;;; compare with char
	be,a	1b		;;; loop if same
	deccc	1, %o1		;;; decrement length

	;;; found something at [%o0-1]
	sub	%o0, %o4, %o0	;;; offset to it
	retl
	st	%o0, [%us]	;;; return result

	;;; didn't find anything else -- return -1
2:	mov	-1, %o0
	retl
	st	%o0, [%us]	;;; return result


;;; --------------------------------------------------------------------------

	;;; move the user stack up or down
DEF_C_LAB (_move_userstack)
	ld	[%r_svb+_SVB_OFFS(_userhi)], %o3 ;;; stack base _userhi in o3
	ld	[%us], %o2		;;; amount to shift in bytes
	inc	4, %us
	sub	%o3, %us, %o0		;;; stacklength to move
	mov	%us, %o1		;;; current top is source for move
	add	%o3, %o2, %o3		;;; _userhi + shift = new _userhi
	st	%o3, [%r_svb+_SVB_OFFS(_userhi)] ;;; update _userhi
	add	%o2, %us, %o2		;;; dest for move
	sethi	%hi(movwords), %o3
	jmp	%o3+%lo(movwords)	;;; do the move (return to caller)
	mov	%o2, %us		;;; setting new stack top


;;; -------------------------------------------------------------------------

/***********************
 *
 * Must not modify g2 or g1, see reset_pop_environ
 *
 **********************/
.globl reset_pop_reg_environ
reset_pop_reg_environ:
	;;; set up global registers
	set	C_LAB(false), %r_false			;;; = g6
	set	C_LAB(_special_var_block), %r_svb	;;; = g5
	retl
	nop


/*************** end labels for wrapping structures **************************/

ASM_TEXT_SECTION
	.align	8
Ltext_end:
ASM_DATA_SECTION
	.align	8
Ldata_end:

/**************************************************************************/



/* --- Revision History ---------------------------------------------------
--- John Gibson, Oct  1 1997
	Now includes asm.ph
--- John Gibson, Feb 10 1997
	Removed _mt*chc routine.
--- John Gibson, Aug 10 1995
	Added _cache_flush
--- John Gibson, Oct 18 1994
	free*pairs -> _free_pairs
--- John Gibson, Nov  9 1993
	Renamed amisc.s and moved the main routine to amain.s
--- Robert John Duncan, Jun  1 1993
	Changed to use ASM_SECTION macros for changing section
--- John Gibson, Oct  2 1992
	Got rid of _c*mpc_order
--- Robert John Duncan, Jul 27 1992
	Changed to use -EXTERN_NAME-
--- John Gibson, Feb 18 1991
	_flush_regfile now uses "ta" to generate a flush windows trap.
--- John Gibson, May 15 1990
	Changed _checkall so that -Async_raise_signal- not called
	when _disable interrupt bit set (also now doesn't clear _trap
	if it is called).
--- John Gibson, Dec  7 1989
	Changes for new pop pointers (explicit offsets for RF_CONT,P_FRONT)
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- John Gibson, Apr 16 1989
	Fixed bug in _popenter (branching to the wrong label when applying
	an integer).
--- John Gibson, Jan 15 1989
	Replaced use of UC_LAB etc for updater with -> before pathname
 */
