/* --- Copyright University of Sussex 1997. All rights reserved. ----------
 * File:	S.sun4/src/aprolog.s
 * Purpose:
 * Author:	John Gibson, Aug 19 1988 (see revisions)
 */

;;; -------------------- ROUTINES FOR PROLOG -------------------------------

#_<

#_INCLUDE 'asm.ph'

constant
	procedure (Sys$-Plog$-Assign_pair, Sys$-Plog$-New_var),
	_checkplogall
	;

vars
	_plog_trail_sp, _plog_next_var, _plog_contn_sp, _plog_contn_top,
	_plog_save_contn_sp, _plog_trail_barrier, _plog_trail_lim,
	_call_stack_lim
	;

lconstant macro (
	_PGV_CONT	= @@PGV_CONT,
	_PGV_SIZE	= @@(struct PLOGVAR)++,
	_PGT_FUNCTOR	= @@PGT_FUNCTOR,
	_PGT_LENGTH	= @@PGT_LENGTH,

	r_plgsv_next_var	= 'i0',
	r_plgsv_contn_top	= 'i1',
	r_plgsv_trail_sp	= 'i2',

	R_SVB			= [%"%"% r_svb],
	svb_CALL_STACK_LIM	= [R_SVB + _SVB_OFFS(_call_stack_lim)],
	svb_PLOG_CONTN_SP	= [R_SVB + _SVB_OFFS(_plog_contn_sp)],
	svb_PLOG_CONTN_TOP	= [R_SVB + _SVB_OFFS(_plog_contn_top)],
	svb_PLOG_NEXT_VAR	= [R_SVB + _SVB_OFFS(_plog_next_var)],
	svb_PLOG_SAVE_CONTN_SP	= [R_SVB + _SVB_OFFS(_plog_save_contn_sp)],
	svb_PLOG_TRAIL_BARRIER	= [R_SVB + _SVB_OFFS(_plog_trail_barrier)],
	svb_PLOG_TRAIL_LIM	= [R_SVB + _SVB_OFFS(_plog_trail_lim)],
	svb_PLOG_TRAIL_SP	= [R_SVB + _SVB_OFFS(_plog_trail_sp)],
	svb_TRAP		= [R_SVB + _SVB_OFFS(_trap)],
	svb_USERLIM		= [R_SVB + _SVB_OFFS(_userlim)],
	);

>_#


/********************* wrapping structures ***********************************/

ASM_TEXT_SECTION
	.word	Ltext_end-Ltext_start, C_LAB(Sys$-objmod_pad_key)
Ltext_start:
ASM_DATA_SECTION
	.word	Ldata_end-Ldata_start, C_LAB(Sys$-objmod_pad_key)
Ldata_start:

/**************************************************************************/

ASM_TEXT_SECTION

	;;; Save the prolog continuation stack, trail and next free var
	;;; in the corresponding saved locations. Then do stack overflow and
	;;; interrupt checks.
DEF_C_LAB (_prolog_save_check)
	;;; save trail end pointer, relative to trail barrier
	ld	[svb_PLOG_TRAIL_SP], %o2		;;; also used later
	ld	[svb_PLOG_TRAIL_BARRIER], %o1
	ld	[svb_PLOG_NEXT_VAR], %r_plgsv_next_var	;;; save next var
	sub	%o2, %o1, %r_plgsv_trail_sp		;;; make relative

	;;; save continuation stack top and pointer
	;;; save_contn_sp is a dynamic local (see plogcore.p)
	ld	[svb_PLOG_CONTN_SP], %o1
	ld	[svb_PLOG_CONTN_TOP], %r_plgsv_contn_top
	st	%o1, [svb_PLOG_SAVE_CONTN_SP]

	;;; do checks
	ld	[svb_PLOG_TRAIL_LIM], %o1
	ld	[svb_CALL_STACK_LIM], %o3
	cmp	%o2, %o1		;;; compare _plog_trail_sp
	blu	1f			;;; br if no trail overflow
	ld	[svb_USERLIM], %o1
	b,a	5f

1:	cmp	%sp, %o3		;;; sys stack overflow?
	bgeu	2f			;;; br if not
	ld	[svb_TRAP], %o2
	b,a	5f

2:	cmp	%us, %o1		;;; user stack overflow?
	bgeu	3f			;;; br if not
	btst	1, %o2			;;; test _trap
	b,a	5f

3:	bz	4f			;;; return if trap clear
	nop
	b,a	5f

4:	retl				;;; return if all ok
	nop

5:	set	C_LAB(_checkplogall), %o0
	jmp	%o0			;;; redo checks
	nop



	;;; restore the contn stack and next free var from the current
	;;; saved values, and unwind the trail back to the saved position,
	;;; resetting vars to undef
DEF_C_LAB (_prolog_restore)
	;;; restore next var
	st	%r_plgsv_next_var, [svb_PLOG_NEXT_VAR]

	;;; restore contn top and pointer
	ld	[svb_PLOG_SAVE_CONTN_SP], %o1
	st	%r_plgsv_contn_top, [svb_PLOG_CONTN_TOP]
	st	%o1, [svb_PLOG_CONTN_SP]

	;;; restore trail end pointer, setting plogvars back to undef
	ld	[svb_PLOG_TRAIL_BARRIER], %o1
	ld	[svb_PLOG_TRAIL_SP], %o2	;;; current end
	add	%o1, %r_plgsv_trail_sp, %o1	;;; make absolute
	cmp	%o1, %o2			;;; = current end?
	bgeu	2f				;;; br if no vars to restore
	dec	4, %o2				;;; adjust lim
	st	%o1, [svb_PLOG_TRAIL_SP]	;;; set new end

1:	ld	[%o1], %o3		;;; the var
	cmp	%o1, %o2		;;; compare trail ptr with lim
	st	%o3, [%o3+_PGV_CONT]	;;; put var into its own PGV_CONT
	blu,a	1b			;;; loop if not reached end
	inc	4, %o1			;;; step on addr

2:	retl
	nop


	;;; Unify arg against atom. arg in %o0, atom in %o1
DEF_C_LAB (_prolog_unify_atom)
	set	C_LAB(prologvar_key), %o3	;;; get the key into a reg

1:	btst	1, %o0			;;; item simple?
	bz,a	2f			;;; br if not
	ld	[%o0+_KEY], %o2		;;; getting key
	retl				;;; else return
	cmp	%o0, %o1		;;; with flags set for eq/neq

2:	cmp	%o2, %o3		;;; = prologvar_key?
	be,a	3f			;;; br if so
	ld	[%o0+_PGV_CONT], %o2	;;; getting var cont
	retl				;;; else return
	cmp	%o0, %o1		;;; with flags set for eq/neq

3:	cmp	%o0, %o2		;;; cont = var (undef)?
	bne,a	1b			;;; not undef -- loop
	mov	%o2, %o0		;;; with cont as next item

	;;; undef var -- instantiate and push on trail
	ld	[svb_PLOG_TRAIL_SP], %o3	;;; get trail pointer
	st	%o1, [%o0+_PGV_CONT]	;;; assign atom to var's cont
	st	%o0, [%o3]		;;; put var on trail
	inc	4, %o3			;;; incr trail pointer
	retl				;;; return (flags already set equal)
	st	%o3, [svb_PLOG_TRAIL_SP] ;;; put back in _plog_trail_sp


	;;; Prolog pair switch -- arg is in %o0
DEF_C_LAB (_prolog_pair_switch)
	set	C_LAB(prologvar_key), %o2	;;; get the key into a reg

1:	btst	1, %o0			;;; item simple?
	bz,a	3f			;;; br if not
	ld	[%o0+_KEY], %o1		;;; getting key
2:	retl				;;; else return
	cmp	%g0, 1			;;; with flags set for less than

3:	cmp	%o1, %o2		;;; key = prologvar_key?
	be,a	4f			;;; br if so
	ld	[%o0+_PGV_CONT], %o1	;;; getting var cont

	;;; compound item
	set	C_LAB(pair_key), %o2
	cmp	%o1, %o2		;;; key = pair_key?
	bne	2b			;;; br if not
	nop
	;;; pair -- return flags set to equal (already are)
	retl; nop

	;;; prologvar
4:	cmp	%o0, %o1		;;; cont = var (undef)?
	bne,a	1b			;;; not undef -- loop
	mov	%o1, %o0		;;; with cont as next item
	;;; undef var - push on stack and return flags set to greater than
	dec	4, %us
	st	%o0, [%us]
	retl
	cmp	%g0, -1			;;; set flags greater than


	;;; Just like pair_switch but checks functor and length (== arity + 1)
	;;; arg is in %o0, functor in %o1, popint length in %o2
DEF_C_LAB (_prolog_term_switch)
	set	C_LAB(prologvar_key), %o4	;;; get the key into a reg

1:	btst	1, %o0			;;; item simple?
	bz,a	3f			;;; br if not
	ld	[%o0+_KEY], %o3		;;; getting key
2:	retl				;;; else return
	cmp	%g0, 1			;;; with flags set for less than

3:	cmp	%o3, %o4		;;; key = prologvar_key?
	be,a	4f			;;; br if so
	ld	[%o0+_PGV_CONT], %o3	;;; getting var cont

	;;; compound item
	set	C_LAB(prologterm_key), %o4
	cmp	%o3, %o4		;;; key = prologterm_key?
	bne	2b			;;; return if not
	srl	%o2, 2, %o2		;;; else make length a sysint
	ld	[%o0+_PGT_LENGTH], %o3	;;; get length
	ld	[%o0+_PGT_FUNCTOR], %o4 ;;; get functor
	cmp	%o3, %o2		;;; right length?
	bne	2b			;;; return if not
	cmp	%o4, %o1		;;; right functor?
	bne	2b			;;; return if not
	nop
	;;; correct term -- return flags set to equal (already are)
	retl; nop

	;;; prologvar
4:	cmp	%o0, %o3		;;; cont = var (undef)?
	bne,a	1b			;;; not undef -- loop
	mov	%o3, %o0		;;; with cont as next item
	;;; undef var - push on stack and return flags set to greater than
	dec	4, %us
	st	%o0, [%us]
	retl
	cmp	%g0, -1			;;; set flags greater than


	;;; Assign to a prolog variable
DEF_C_LAB (_prolog_assign)
	ld	[%us], %o0		;;; item into %o0
	b	plog_assign
	inc	4, %us

DEF_C_LAB (_prolog_assign_pair)
	ld	[%r_svb+_SVB_OFFS(Sys$- _free_pairs)], %o0	;;; get free pair list
	ld	[%us], %o2		;;; back value into o2
	btst	1, %o0			;;; if simple then none left
	be,a	1f			;;; br if some left
	ld	[%o0+_P_BACK], %o4	;;; getting next back into o4

	;;; none left, chain to Assign_pair
	sethi	%hi(XC_LAB(Sys$-Plog$-Assign_pair)), %o0
	jmp	%o0+%lo(XC_LAB(Sys$-Plog$-Assign_pair))
	nop

1:	ld	[%us+4], %o3		;;; front value into o3
	inc	8, %us
	st	%o2, [%o0+_P_BACK]	;;; init back
	st	%o3, [%o0+_P_FRONT]	;;; init front
	st	%o4, [%r_svb+_SVB_OFFS(Sys$- _free_pairs)] ;;; move next back to _free_pairs

	;;; Assign item in %o0 to var and push on trail
plog_assign:
	ld	[%us], %o1		;;; prolog var into %o1
	inc	4, %us
	ld	[svb_PLOG_TRAIL_SP], %o2 ;;; trail stack pointer
	st	%o0, [%o1+_PGV_CONT]	;;; assign item into var cont
	st	%o1, [%o2]		;;; put var on trail
	inc	4, %o2
	retl
	st	%o2, [svb_PLOG_TRAIL_SP] ;;; update trail pointer




;;; --- OPTIONAL ASSEMBLER CODE ---------------------------------------------
;;; optional assembler optimised stuff, for code normally in pop.
;;; see bottom of syscomp/sysdefs.p for when this is used
;;; and plogcore.p, plogterms.p for equivalent pop code


	;;; Dereference a chain of prolog variables
DEF_C_LAB (_prolog_deref)
	ld	[%us], %o0		;;; get item
	set	C_LAB(prologvar_key), %o2	;;; get the key into a reg

1:	btst	1, %o0			;;; item simple?
	be,a	2f			;;; br if not
	ld	[%o0+_KEY], %o1		;;; getting key
	retl
	st	%o0, [%us]		;;; return dereffed item

2:	cmp	%o1, %o2		;;; prologvar?
	be,a	3f			;;; br if so
	ld	[%o0+_PGV_CONT], %o1	;;; getting cont
	retl
	st	%o0, [%us]		;;; return dereffed item

3:	cmp	%o1, %o0		;;; cont = item (undef)?
	bne,a	1b			;;; loop if not
	mov	%o1, %o0		;;; with cont as next item
	retl
	st	%o0, [%us]		;;; return dereffed item


	;;; Return a new prolog variable from the free block, unless no
	;;; more space -- then use pop New_var, which allocates space.
DEF_C_LAB (_prolog_newvar)
	ld	[svb_PLOG_NEXT_VAR], %o1	;;; next var in block
	sethi	%hi(C_LAB(ref_key)), %o2
	ld	[%o1+_KEY], %o3
	bset	%lo(C_LAB(ref_key)), %o2
	cmp	%o3, %o2		;;; end-of-block ref?
	bne,a	1f			;;; branch if not
	st	%o1, [%o1+_PGV_CONT]	;;; make this var undef

	;;; call this for some more
	sethi	%hi(XC_LAB(Sys$-Plog$-New_var)), %o0
	jmp	%o0+%lo(XC_LAB(Sys$-Plog$-New_var))
	nop

1:	dec	4, %us
	st	%o1, [%us]		;;; return it
	inc	_PGV_SIZE, %o1		;;; address of next var
	retl
	st	%o1, [svb_PLOG_NEXT_VAR] ;;; update _plog_next_var



/*************** end labels for wrapping structures **************************/

ASM_TEXT_SECTION
	.align	8
Ltext_end:
ASM_DATA_SECTION
	.align	8
Ldata_end:

/**************************************************************************/

/* --- Revision History ---------------------------------------------------
--- John Gibson, Oct  1 1997
	Now includes asm.ph
--- John Gibson, Oct 18 1994
	free*pairs -> _free_pairs
--- Robert John Duncan, Jun  1 1993
	Changed to use ASM_SECTION macros for changing section
--- John Gibson, Dec  7 1989
	Changes for new pop pointers (explicit use of PGV_CONT)
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- John Gibson, Jul	5 1989
	Undid last change
--- John Williams, Jul	4 1989
	Changed lconstant '\%r_svb' to just 'r_svb' to avoid itemiser hassle
--- John Gibson, Apr	9 1989
	Prolog_newvar, Prolog_assign_pair renamed into section Sys$-Plog
 */
