/* --- Copyright University of Sussex 1997. All rights reserved. ----------
 > File:			C.sparc/src/drop_code.ph
 > Purpose:			Code-planting macros
 > Author:			John Gibson, Sep 30 1997
 */

lconstant macro (

	;;; Register numbers
	Ri7		= 31,		;;; Return address into caller
	Ri6		= 30,		;;; Frame pointer
	Ri5		= 29,		;;; Procedure base register
	Ri4		= 28,		;;; Non-pop lvars
	Ri3		= 27,		;;;	   "	  "
	Ri2		= 26,		;;;	   "	  "
	Ri1		= 25,		;;;	   "	  "
	Ri0		= 24,		;;;	   "	  "
	Rl7		= 23,		;;; Pop lvars
	Rl6		= 22,		;;;	 "	  "
	Rl5		= 21,		;;;	 "	  "
	Rl4		= 20,		;;;	 "	  "
	Rl3		= 19,		;;;	 "	  "
	Rl2		= 18,		;;;	 "	  "
	Rl1		= 17,		;;;	 "	  "
	Rl0		= 16,		;;;	 "	  "
	Ro7		= 15,		;;; Return address on call
	Ro6		= 14,		;;; Call stack pointer
	Ro5		= 13,		;;; Procedure base register on call
	Ro4		= 12,		;;; Temp
	Ro3		= 11,		;;; Temp
	Ro2		= 10,		;;; Temp, arg_reg_2
	Ro1		= 9,		;;; arg_reg_1
	Ro0		= 8,		;;; arg_reg_0
	Rg7		= 7,		;;; Unused (must not be used -- used by threads)
	Rg6		= 6,		;;; False
	Rg5		= 5,		;;; SVB base register
	Rg4		= 4,		;;; Userstack pointer
	Rg3		= 3,		;;;
	Rg2		= 2,		;;;
	Rg1		= 1,		;;; Chain_reg (corrupted by C calls)
	Rg0		= 0,		;;; Zero

	;;; Named registers
	Rusp		= Rg4,		;;; user stack pointer
	Rsvb		= Rg5,		;;;	special variable block base register
	Rfalse		= Rg6,		;;; false register
	Rpb			= Ri5,		;;; procedure base
	Ropb		= Ro5,		;;; procedure base before save
	Rsp			= Ro6,		;;; call stack pointer

	;;; Branch conditions
	_cond_ALL	= _16:8,	;;; Always
	_cond_EQ	= _16:1,	;;; Equal
	_cond_LE	= _16:2,	;;; Less Than or Equal
	_cond_LT	= _16:3,	;;; Less Than
	_cond_NE	= _16:9,	;;; Not Equal
	_cond_GT	= _16:A,	;;; Greater Than
	_cond_GE	= _16:B,	;;; Greater Than or Equal
	_cond_GTU	= _16:C,	;;; Greater Than Unsigned

	;;; Format 2 opcodes (3 bits)
	_OP_sethi	= _4,
	_OP_branch	= _2,

	;;; Format 3(M) opcodes (6 bits)
	_OP_stb		= _16:05,		;;; Store Byte
	_OP_sth		= _16:06,		;;; Store Halfword
	_OP_st		= _16:04,		;;; Store Word
	_OP_std		= _16:07,		;;; Store Doubleword
	_OP_ldsb	= _16:09,		;;; Load Signed Byte
	_OP_ldsh	= _16:0A,		;;; Load Signed Halfword
	_OP_ldub	= _16:01,		;;; Load Unsigned Byte
	_OP_lduh	= _16:02,		;;; Load Unsigned Halfword
	_OP_ld		= _16:00,		;;; Load Word
	_OP_ldd		= _16:03,		;;; Load Doubleword

	;;; Format 3(A) opcodes (6 bits)
	_OP_add		= _16:00,		;;; Add
	_OP_or		= _16:02,		;;; Inclusive Or
	_OP_sub		= _16:04,		;;; Subtract
	_OP_andcc	= _16:11,		;;; And and modify icc
	_OP_subcc	= _16:14,		;;; Subract and modify icc
	_OP_sll		= _16:25,		;;; Shift Left Logical
	_OP_sra		= _16:27,		;;; Shift Right Arithmetic

	_OP_jmpl	= _16:38,		;;; Jump and Link
	_OP_save	= _16:3C,		;;; Save Caller's Window
	_OP_restore	= _16:3D,		;;; Restore Caller's Window
);


define :inline lconstant _F2_INST(_Op, _Imm22, _Cond);
			_shift((_Cond) _bimask _:16:1F, _:25)
	_biset	_shift((_Op) _bimask _:16:7, _:22)
	_biset	((_Imm22) _bimask _:16:3FFFFF)
enddefine;

define :inline lconstant _F3r_INST(_Form, _Op, _Rs1, _Rs2, _Rd);
			_shift(_Form, _:30)
	_biset	_shift((_Rd) _bimask _:16:1F, _:25)
	_biset	_shift((_Op) _bimask _:16:3F, _:19)
	_biset	_shift((_Rs1) _bimask _:16:1F, _:14)
	_biset	((_Rs2) _bimask _:16:1F)
enddefine;

define :inline lconstant _F3i_INST(_Form, _Op, _Rs1, _Imm13, _Rd);
			_shift(_Form, _:30)
	_biset	_shift((_Rd) _bimask _:16:1F, _:25)
	_biset	_shift((_Op) _bimask _:16:3F, _:19)
	_biset	_shift((_Rs1) _bimask _:16:1F, _:14)
	_biset 	_shift(_:1, _:13)
	_biset	((_Imm13) _bimask _:16:1FFF)
enddefine;

define :inline lconstant _F3rM_INST(_Op, _Rs1, _Rs2, _Rd);
	_F3r_INST(_:2:11, _Op, _Rs1, _Rs2, _Rd)
enddefine;

define :inline lconstant _F3rA_INST(_Op, _Rs1, _Rs2, _Rd);
	_F3r_INST(_:2:10, _Op, _Rs1, _Rs2, _Rd)
enddefine;

define :inline lconstant _F3iM_INST(_Op, _Rs1, _Imm13, _Rd);
	_F3i_INST(_:2:11, _Op, _Rs1, _Imm13, _Rd)
enddefine;

define :inline lconstant _F3iA_INST(_Op, _Rs1, _Imm13, _Rd);
	_F3i_INST(_:2:10, _Op, _Rs1, _Imm13, _Rd)
enddefine;

lconstant macro (
	_NOP_INST	= _F2_INST(_OP_sethi, _0, _:Rg0),
);
