/* --- Copyright University of Sussex 1997. All rights reserved. ----------
 > File:            C.sparc/src/syscomp/genproc.p
 > Purpose:
 > Author:          John Gibson, Aug 19 1988 (see revisions)
 */

/* -------------------------------------------------------------------------

				GENERATE PROCEDURE CODE -- SPARC SYSTEMS
							(SUN-4)

--------------------------------------------------------------------------*/

#_INCLUDE 'common.ph'

section $-Popas$-M_trans;

constant
		procedure (auto_operand, reg_in_operand, immediate_operand,
		commute_test, negate_test, perm_const_opnd, cons_access_opnd)
	;

vars
		current_pdr_label, current_pdr_exec_label, false_immediate
	;

	/****************************************************************
	* This file is contained entirely in section Genproc, and must  *
	*   define all the exports to section M_trans listed below.     *
	****************************************************************/

section Genproc =>

		/*	M-opcode Procedures */
		M_ADD
		M_ASH
		M_BIC
		M_BIM
		M_BIS
		M_BIT
		M_BRANCH
		M_BRANCH_std
		M_BRANCH_ON
		M_BRANCH_ON_INT
		M_CALL
		M_CALL_WITH_RETURN
		M_CALLER_RETURN
		M_CALLSUB
		M_CHAIN
		M_CHAINSUB
		M_CLOSURE
		M_CMP
		M_CMPKEY
		M_CREATE_SF
		M_END
		M_ERASE
		M_LABEL
		M_LOGCOM
		M_MOVE
		M_MOVEbit
		M_MOVEsbit
		M_MULT
		M_NEG
		M_PADD
		M_PADD_TEST
		M_PCMP
		M_PLOG_IFNOT_ATOM
		M_PLOG_TERM_SWITCH
		M_PSUB
		M_PSUB_TEST
		M_PTR_ADD_OFFS
		M_PTR_CMP
		M_PTR_SUB
		M_PTR_SUB_OFFS
		M_RETURN
		M_SETSTKLEN
		M_SUB
		M_TEST
		M_UNWIND_SF
		M_UPDbit

		/*	Registers */
		SP
		USP
		USP_+
		-_USP
		i_USP
;;;		i_USP_+			;;; these two are optional
;;;		ii_USP
		WK_ADDR_REG_1
		WK_ADDR_REG_2
		WK_REG
		CHAIN_REG
		SPECIAL_VAR_BLOCK_REG

		/*	Register Lists */
		nonpop_registers
		pop_registers

		/*	Register Procedures */
		reglabel
		regnumber
		autoidreg

		/*	M-code Mapping of Subroutines */
		mc_inline_conditions_list
		mc_inline_procs_list

		/*	Procedures Needed by m_optimise */
		cvt_pop_subscript
		can_defer_opnd
		pdr_index_opnd

		/*	Procedure to Generate Code */
		mc_code_generator

		/* Boolean Switches */
		USE_NEW_M_OPERANDS
		BRANCH_ON_ALLOWS_BASE
	;


;;; --- REGISTERS ---------------------------------------------------------

/*---- Register Use --------------------------------------------------------

	r31 (i7)  |   return address into caller
	r30 (i6)  |       FP
	r29 (i5)  |   current procedure (PB)    SF_OWNER
	r28 (i4)  |     }
	r27 (i3)  |     }
	r26 (i2)  |     }  non-pop lvars (5)    SF_PLGSV_TRAIL_SP
	r25 (i1)  |     }                       SF_PLGSV_CONTN_TOP
	r24 (i0)  |     }                       SF_PLGSV_NEXT_VAR
	-----------------------
	r23 (l7)  |     }
	r22 (l6)  |     }
	r21 (l5)  |     }
	r20 (l4)  |     } pop lvars (8) (initialise ones used to 3)
	r19 (l3)  |     }
	r18 (l2)  |     }
	r17 (l1)  |     }
	r16 (l0)  |     }
	----------------------
	r15 (o7)  |     temp (but gets return address on CALL, etc)
	r14 (o6)  |      SP
	r13 (o5)  |     temp  opb
	r12 (o4)  |     temp
	r11 (o3)  |     temp
	r10 (o2)  |     temp  arg_reg_2
	r9  (o1)  |     temp  arg_reg_1
	r8  (o0)  |     temp  arg_reg_0
	---------------------
	r7  (g7)  |   unused (should not be used)    }
	r6  (g6)  |       false                      }
	r5  (g5)  |   address of _special_var_block  }  All liable to be
	r4  (g4)  |   userstack pointer              }  corrupted by C functions
	r3  (g3)  |    temp		                     }
	r2  (g2)  |    temp                          }
	r1  (g1)  |    temp and CHAIN_REG            }
	r0  (g0)  |
*/


constant
	rg0		= "g0",		;;;  0
	rg1		= "g1",		;;;  1
	rg2		= "g2",		;;;  2
	rg3		= "g3",		;;;  3
	rg4		= "g4",		;;;  4 = us
	rg5		= "g5",		;;;  5
	rg6		= "g6",		;;;  6 always contains <false>
	rg7		= "g7",		;;;  7

	ro0		= "o0",		;;;  8
	ro1		= "o1",		;;;  9
	ro2		= "o2",		;;; 10
	ro3		= "o3",		;;; 11
	ro4		= "o4",		;;; 12
	ro5		= "o5",		;;; 13
	ro6		= "o6",		;;; 14 = sp
	ro7		= "o7",		;;; 15

	rl0		= "l0",		;;; 16		}
	rl1		= "l1",		;;; 17		}
	rl2		= "l2",		;;; 18		}
	rl3		= "l3",		;;; 19		}  pop lvars
	rl4		= "l4",		;;; 20		}
	rl5		= "l5",		;;; 21		}
	rl6		= "l6",		;;; 22		}
	rl7		= "l7",		;;; 23		}

	ri0		= "i0",		;;; 24		}
	ri1		= "i1",		;;; 25		}
	ri2		= "i2",		;;; 26		}  non-pop lvars
	ri3		= "i3",		;;; 27		}
	ri4		= "i4",		;;; 28		}
	ri5		= "i5",		;;; 29 = pb
	ri6		= "i6",		;;; 30 = fp
	ri7		= "i7",		;;; 31

	SP		= "sp",				;;; = o6
	USP		= rg4,				;;; user stack pointer
	i_USP	= {^USP 0},			;;; top of user stack
	-_USP	= {^USP ^false},	;;; user stack autodecrement
	USP_+	= {^USP ^true},		;;; user stack autoincrement
	PB		= ri5,
	OPB		= ro5,
	FP		= "fp",
	R_RETN	= ri7,

	R_FALSE	= rg6,
	R_ZERO	= rg0,

		;


;;;-------- DEFINITIONS FOR TRANSLATING VM CODE TO MODEL ASSEMBLER --------

	/*	m_trans.p requires the definition of

			SP, USP, USP_+, -_USP and i_USP.

		(already defined)
	*/


	/*	WK_REG is used by m_optimise for eliminating stack pushes and pops
		between successive instructions
	*/
constant
	WK_REG = rg1;	;;; It's OK for this to be the same as CHAIN_REG


	/*	WK_ADDR_REG_1 and 2 are used by m_optimise for building field
		access operands (ie of the the form {^reg ^offset} ) when an existing
		operand cannot be deferred directly (can_defer_operand having
		returned false for it). 1 is used for source operands, 2 for
		destination operands
	*/
constant
	WK_ADDR_REG_1 = rg2,
	WK_ADDR_REG_2 = rg3;


	/*	CHAIN_REG is the register used to save procedure operands for in-line
		chaining, and must not be corrupted by M_UNWIND_SF (ideally it should
		be an address register). It is also used to save return addresses for
		out-of-line chaining thru the subroutines _syschain and _sysncchain.
	*/
constant
	CHAIN_REG	= rg1;


	/*	SPECIAL_VAR_BLOCK_REG is optional; if defined, it's assumed to
		hold the address of _special_var_block.
	*/
constant
	SPECIAL_VAR_BLOCK_REG = rg5;


	/*	m_optimise needs lists of pop and nonpop registers,
		in order of allocation; these lists start with a list of
		registers that should be local to every procedure.
		It also needs the properties regnumber and reglabel.
	*/
constant
	pop_registers		= [[] 16 17 18 19 20 21 22 23],	;;; l0 - l7
	nonpop_registers	= [[] 24 25 26 27 28];			;;; i0 - i4

define regnumber	= newassoc([]) enddefine;
define reglabel		= newassoc([]) enddefine;

	/* set up regnumber and reglabel properties */
procedure;
	lvars n, l;
	for n from 0 to 31 do
		consword(	if     n <  8 then `g`, n
					elseif n < 16 then `o`, n-8
					elseif n < 24 then `l`, n-16
					else			   `i`, n-24
					endif + `0`,
				2) -> l;

		n -> regnumber(l);
		l -> reglabel(n)
	endfor
endprocedure();
regnumber(ro6) -> regnumber(SP);
regnumber(ri6) -> regnumber(FP);


	/*	The procedure autoidreg is used by m_optimise in deciding
		whether a register can be used for autoincrement/decrement operands,
		ie of the form {^reg ^boolean}.
	*/
identof("regnumber") -> identof("autoidreg");


	/*	Setting this true means generate typed M-code vector operands for
		short and and byte memory access/updates (instead of the old
		M_MOVE(s)b/s and M_UPDb/s instructions). The operands have the form

			{____base ______offset ____type}

		where ____type is T_BYTE, T_SGN_BYTE, T_SHORT or T_SGN_SHORT (word access
		operands are always length 2). As well as a register, ____base may a
		string (i.e. absolute address), in which case any offset is
		concatenated onto the string and ______offset is 0.
	*/
constant macro USE_NEW_M_OPERANDS = true;

	/*	Setting this true means M_BRANCH_ON(_INT) instructions allow
		an optional extra element to specify the base integer (defaults to 1).
	*/
constant macro BRANCH_ON_ALLOWS_BASE = true;


	/*	can_defer_operand is used by m_optimise to create a field access
		operand from an existing operand, ie accessing/updating the datum
		of type _______acctype at offset ____offs from the pointer held in the operand.
		(Takes 4 args with USE_NEW_M_OPERANDS true.)
	*/
define can_defer_opnd(opnd, offs, acctype, upd);
	lvars opnd, acctype, offs, upd;
	if isref(opnd) then
		;;; immediate label
		fast_cont(opnd) -> opnd
	elseunless regnumber(opnd) then
		return(false)
	endif;
	chain(opnd, offs, acctype, cons_access_opnd)
enddefine;



define lconstant wof = nonop fi_*(% WORD_OFFS %) enddefine;

	/*	pdr_index_opnd is used by m_trans.p for creating operands to
		push/call values from procedure headers (not used in closures).
	*/
define pdr_index_opnd(fld_index);
	lvars fld_index;
	{% PB, fld_index.wof %}
enddefine;



;;; --- M-CODE TRANSLATION PROCEDURES ----------------------------------------

lconstant procedure
	test_opcode = newassoc([
		[EQ  [be]]		[NEQ  [bne]]
		[LT  [bg]]  	[LEQ  [bge]] 	[GT  [bl]]	[GEQ  [ble]]
		[ULT [bgu]]		[ULEQ [bgeu]]	[UGT [blu]]	[UGEQ [bleu]]
		[NEG [bneg]]	[POS  [bpos]]
		[OVF [bvs]]		[NOVF [bvc]]
		]);


lvars
		m_codelist, m_instr, last_ipair, instr_list,
	;


	;;; registers to cache literals
lconstant
	Lreg_A	= ro2,
	Lreg_B	= ro3,
	Lreg_C	= ro4,
	;

lvars
	;;; values currently in those registers (false if none)
	Lreg_A_val,
	Lreg_B_val,
	Lreg_C_val,

	;;; queue of Lregs in order of most recent use
	;;; (i.e. Lreg_1 = most recently used, etc)
	Lreg_1,
	Lreg_2,
	Lreg_3,

	;;; running userstack difference
	curr_stack_diff,

	condbr_code_pairs,
	;

lconstant
	OP_LABEL		= consref("label"),
	OP_NOP			= consref("nop"),
	OP_NOP_CONDBR	= consref("nop"),
	OP_WORD			= consref("\.word"),
	OP_B_ANNUL		= [b\,a],
	OP_CALL			= [call],
	OP_JMP			= [jmp],

	NOP_INSTR		= {^OP_NOP},
	NOP_CONDBR_INSTR= {^OP_NOP_CONDBR},

	procedure lab_code_pair = newproperty([], 64, false, false),
	;


define lconstant placei() with_nargs 1;
	() :: [] ->> f_tl(last_ipair) -> last_ipair
enddefine;

	;;; for non-nil instruction list
define lconstant placel(list);
	lvars list;
	list -> f_tl(last_ipair);
	until f_tl(list) == [] do f_tl(list) -> list enduntil;
	list -> last_ipair
enddefine;

define lconstant place2();
	placei(consvector(2))
enddefine;

define lconstant place3();
	placei(consvector(3))
enddefine;

define lconstant place4();
	placei(consvector(4))
enddefine;

define lconstant place_acb(dst_reg, n);
	lvars dst_reg, i, n;
	consvector(dst_reg, n) -> i;
	if f_subv(1, f_hd(last_ipair)) == OP_NOP_CONDBR
	and (fast_subscrw(1, dst_reg) == `o`
		 or dst_reg == R_ZERO or dst_reg == WK_REG)
	then
		;;; OK to replace condbr nop with this instruction since
		;;; it only alters a working reg (which can't carry a value
		;;; across a branch).
		consref(f_subv(1, i)) -> f_subv(1, i);	;;; mark as delay
		i -> f_hd(last_ipair)
	else
		placei(i)
	endif
enddefine;

define lconstant stack_adjust(delay);
	lvars delay;
	if curr_stack_diff /== 0 then
		place3(if delay then #_< consref("inc") >_# else "inc" endif,
													curr_stack_diff, USP);
		0 -> curr_stack_diff
	elseif delay then
		placei(if delay == "condbr" then NOP_CONDBR_INSTR
			   else NOP_INSTR
			   endif)
	endif
enddefine;

define lconstant place_label(lab);
	lvars lab;
	place2(OP_LABEL, lab)
enddefine;

lconstant procedure (
	isreg		= isword,
	isaccess	= isvector,
	abs_lo_part = newproperty([], 32, false, false),
	);

define lconstant access_type(opnd);
	lvars opnd;
	if isstring(opnd) or datalength(opnd) == 2 then
		T_WORD
	else
		f_subv(3, opnd)
	endif
enddefine;

define lconstant lab_lo_hi(lab);
	lvars lab = lab <> ')';
	consref('%hi(' <> lab), '%lo(' <> lab
enddefine;

define lconstant isabs(opnd);
	lvars opnd, hi, lo;
	lconstant abs_hi_part = newproperty([], 32, false, false);
	returnunless(isstring(opnd)
			or isaccess(opnd) and isstring(f_subv(1,opnd) ->> opnd)) (false);
	unless abs_hi_part(opnd) ->> hi then
		lab_lo_hi(opnd) -> lo ->> hi -> abs_hi_part(opnd);
		lo -> abs_lo_part(hi)
	endunless;
	hi
enddefine;

define lconstant isimm(opnd);
	lvars opnd;
	isintegral(opnd) or isref(opnd)
enddefine;

define lconstant normalise_int(i) -> i;
	lvars i, ilen = integer_length(i);
	if ilen >= WORD_BITS then
		if ilen == WORD_BITS and i > 0 then
			;;; allow 'unsigned' WORD_BITS value as -ve
			i || #_< -1<<WORD_BITS >_# -> i
		else
			mishap(i, 1, 'INTEGER OPERAND TOO LARGE')
		endif
	endif
enddefine;

define lconstant place_set(src, dst_reg, hi_already);
	lvars src, dst_reg, hi, lo, hi_already;
	if hi_already then
		src -> hi, false -> lo
	elseif isintegral(src) then
		normalise_int(src) -> src;
		if isinteger(src) and -4096 fi_<= src and src fi_<= 4095 then
			place_acb("mov", src, dst_reg, 3);
			return
		else
			lab_lo_hi(src >< nullstring) -> lo -> hi;
			if src &&=_0 16:3FF then false -> lo endif
		endif
	else
		lab_lo_hi(cont(src)) -> lo -> hi
	endif;
	place_acb("sethi", hi, dst_reg, 3);
	if lo then place3("bset", consref(lo), dst_reg) endif
enddefine;

define lconstant clear_lit_reg();
	false ->> Lreg_A_val ->> Lreg_B_val -> Lreg_C_val;
	Lreg_A -> Lreg_1, Lreg_B -> Lreg_2, Lreg_C -> Lreg_3
enddefine;

	;;; Get a register to cache a literal in
define lconstant get_lit_reg(lit, alloc) -> reg;
	lvars lit, reg, alloc;
	if 	   Lreg_A_val = lit then
		Lreg_A -> reg
	elseif Lreg_B_val = lit then
		Lreg_B -> reg
	elseif Lreg_C_val = lit then
		Lreg_C -> reg
	elseunless alloc then
		return(false -> reg)
	else
		;;; alloc to least recently used one
		Lreg_3 -> reg;
		;;; set and record value
		lit ->	if reg == Lreg_A then
					Lreg_A_val
				elseif reg == Lreg_B then
					Lreg_B_val
				else
					Lreg_C_val
				endif;
		place_set(lit, reg, alloc == "hi")
	endif;

	;;; promote reg used to head of queue
	if reg == Lreg_3 then
		Lreg_2 -> Lreg_3, Lreg_1 -> Lreg_2, reg -> Lreg_1
	elseif reg == Lreg_2 then
		Lreg_1 -> Lreg_2, reg -> Lreg_1
	endif
enddefine;

	;;; get an already-cached operand (absolute or immediate)
define lconstant get_cached_opnd(opnd) -> opnd;
	lvars opnd, reg, hi;
	if isabs(opnd) ->> hi then
		if get_lit_reg(hi, false) ->> reg then
			cons_access_opnd(reg, abs_lo_part(hi), access_type(opnd)) -> opnd
		endif
	elseif isimm(opnd) and (get_lit_reg(opnd, false) ->> reg) then
		reg -> opnd
	endif
enddefine;

define lconstant get_us_opnd(opnd) -> opnd;
	lvars offs, opnd;
	lconstant prop = newproperty([], 8, false, false);
	unless f_subv(2, opnd) ->> offs then
		;;; false = -_USP
		curr_stack_diff fi_- 4 ->> offs -> curr_stack_diff
	elseif offs == true then
		;;; true = USP_+
		curr_stack_diff -> offs;
		offs fi_+ 4 -> curr_stack_diff
	else
		curr_stack_diff fi_+ offs -> offs
	endunless;
	unless prop(offs) ->> opnd then
		consvector(USP, offs, 2) ->> opnd -> prop(offs)
	endunless
enddefine;

define lconstant get_annul_delay_instr(bri) -> delayi;
	lvars i, pair, op, bri, lab = f_subv(2, bri), delayi = false;
	returnunless(lab_code_pair(lab) ->> pair);
	repeat
		f_tl(pair) -> pair;
		f_hd(pair) -> i;
		quitif((f_subv(1, i) ->> op) /== OP_LABEL)
	endrepeat;
	if ispair(op) then
		;;; control instr
		returnunless(f_hd(op) == "b");
		;;; unconditional br followed by delay
		f_hd(f_tl(pair)) -> delayi;
		f_subv(2, i) -> lab
	else
		copy(i) -> delayi;
		consref(op) -> f_subv(1, delayi);
		f_hd(f_tl(pair)) -> i;
		if f_subv(1, i) == OP_LABEL then
			f_subv(2, i) -> lab
		else
			lab <> '_nxt' -> lab;
			0 -> islabel(lab);
			{^OP_LABEL ^lab} :: f_tl(pair) -> f_tl(pair)
		endif
	endif;

	lab -> f_subv(2, bri);
	(f_hd(f_subv(1, bri)) <> "\,a") :: [] -> f_subv(1, bri)
enddefine;

define lconstant place_test(test, lab);
	lvars test, lab, i, delayi = false;
	consvector(test_opcode(test), lab, 2) -> i;
	if curr_stack_diff == 0 then
		get_annul_delay_instr(i) -> delayi
	endif;
	placei(i);
	if delayi then
		placei(delayi)
	else
		if curr_stack_diff == 0 then
			last_ipair :: condbr_code_pairs -> condbr_code_pairs
		endif;
		stack_adjust("condbr")
	endif
enddefine;

define lconstant get_last_ndelay() -> lasti;
	lvars lasti, lastop;
	f_hd(last_ipair) -> lasti;
	f_subv(1, lasti) -> lastop;
	if isref(lastop) or ispair(lastop) then
		false -> lasti
	else
		copy(lasti) -> lasti;
		consref(lastop) -> f_subv(1, lasti)		;;; make delay
	endif
enddefine;


;;; --- LOAD AND STORE OPERANDS -------------------------------------------

define lconstant type_opcode = newassoc([
	[^T_BYTE		{ldub stb}]
	[^T_SGN_BYTE	{ldsb stb}]
	[^T_SHORT		{lduh sth}]
	[^T_SGN_SHORT	{ldsh sth}]
	[^T_WORD		{ld   st}]
	])
enddefine;

define lconstant load_src(opnd, wk_reg, int_imm);
	lvars opnd, reg, wk_reg, tmp, int_imm, type, op;

	if isreg(opnd) then
		if opnd == USP then stack_adjust(false) endif;
		return(opnd)
	elseif isintegral(opnd) then
		normalise_int(opnd) -> opnd;
		if opnd == 0 then
			return(R_ZERO)
		elseif int_imm and -4096 fi_<= opnd and opnd fi_<= 4095 then
			return(opnd)
		;;; else drop thru for default case
		endif
	elseif isref(opnd) then
		if int_imm and isstartstring('%lo(', fast_cont(opnd)) then
			return(opnd)
		elseif opnd = false_immediate then
			return(R_FALSE)
		;;; else drop thru for default case
		endif
	elseif isabs(opnd) ->> tmp then
		;;; absolute address (tmp is the hi part)
		get_lit_reg(tmp, "hi") -> reg;
		place3(f_subv(1,type_opcode(access_type(opnd))),
					consvector(reg, abs_lo_part(tmp), 2), wk_reg);
		return(wk_reg)
	elseif isaccess(opnd) then
		access_type(opnd) -> type;
		f_subv(1,type_opcode(type)) -> op;
		if (f_subv(1, opnd) ->> reg) == USP then
			;;; userstack access
			get_us_opnd(opnd) -> opnd
		elseif isboolean(f_subv(2, opnd)) then
			;;; predecr/postincr
			t_offset(type, false) -> tmp;		;;; data size
			consvector(reg, if f_subv(2,opnd) then 0 else -tmp ->> tmp endif,
																2) -> opnd;
			place3(op, opnd, wk_reg);
			place3("inc", tmp, reg);
			return(wk_reg)
		elseif datalength(opnd) == 3 then
			consvector(explode(opnd)->, 2) -> opnd
		endif;
		place3(op, opnd, wk_reg);
		return(wk_reg)
	else
		mishap(opnd, 1, 'UNKNOWN SOURCE OPERAND IN M-INSTRUCTION')
	endif;

	;;; drop thru to here for default immediate case
	if int_imm /== wk_reg then
		get_lit_reg(opnd, true)		;;; return reg
	elseif get_lit_reg(opnd, false) ->> reg then
		reg
	else
		place_set(opnd, wk_reg, false);
		wk_reg
	endif
enddefine;

define lconstant store_dst(src_reg, opnd);
	lvars opnd, reg, src_reg, tmp, int_imm, type, op;
	if isreg(opnd) then
		if opnd == USP then 0 -> curr_stack_diff endif;
		false, opnd
	elseif isabs(opnd) ->> tmp then
		;;; absolute address (tmp is the hi part)
		get_lit_reg(tmp, "hi") -> reg;
		consvector(f_subv(2,type_opcode(access_type(opnd))), src_reg,
						consvector(reg, abs_lo_part(tmp), 2), 3) :: [],
		src_reg
	elseif isaccess(opnd) then
		access_type(opnd) -> type;
		f_subv(2,type_opcode(type)) -> op;
		[%
		if (f_subv(1, opnd) ->> reg) == USP then
			;;; userstack access
			get_us_opnd(opnd) -> opnd
		elseif isboolean(f_subv(2, opnd)) then
			;;; predecr/postincr
			t_offset(type, false) -> tmp;		;;; data size
			consvector(reg, -tmp,
				unless f_subv(2,opnd) then -> tmp, 0 endunless, 2) -> opnd;
			consvector("inc", tmp, reg, 3),
		elseif datalength(opnd) == 3 then
			consvector(explode(opnd)->, 2) -> opnd
		endif;
		consvector(op, src_reg, opnd, 3)
		%], src_reg
	else
		mishap(opnd, 1, 'UNKNOWN/INVALID DESTINATION OPERAND IN M-INSTRUCTION')
	endif
enddefine;


;;; --- MOVE INSTRUCTIONS --------------------------------------------------

define lconstant do_move(src, dst);
	lvars src, reg, dst;
	returnif(src = dst or (src == USP_+ and dst == -_USP));
	if isreg(dst) then
		load_src(src, dst, dst) -> reg;
		if reg /== dst then place_acb("mov", reg, dst, 3) endif;
		if dst == USP then 0 -> curr_stack_diff endif
	else
		unless isreg(src) then
			get_cached_opnd(dst) -> dst;
			load_src(src, ro0, false) -> src
		endunless;
		placel(store_dst(src, dst) ->)
	endif
enddefine;

define M_MOVE();
	do_move(f_subv(2, m_instr), f_subv(3, m_instr))
enddefine;


define lconstant call_sr_delay(lab);
	lvars lasti, calli = consvector(OP_CALL, lab, 2), lab;
	if get_last_ndelay() ->> lasti then
		calli -> f_hd(last_ipair)
	else
		placei(calli);
		NOP_INSTR -> lasti
	endif;
	placei(lasti);
	clear_lit_reg()
enddefine;

define lconstant exclude_o2();
	termin -> Lreg_A_val;		;;; = ro2
	get_lit_reg(termin, false) ->
enddefine;

	;;; {M_MOVE(s)bit <fieldsize> <bitoffs> <ptr> <dst>}
define lconstant get_bitfield(routine);
	lvars fieldsize, dst, ptr, bitoffs, routine;
	explode(m_instr) -> dst -> ptr -> bitoffs -> fieldsize -> ;
	do_move(fieldsize, ro2);
	exclude_o2();
	do_move(bitoffs, ro1);
	do_move(ptr, ro0);
	call_sr_delay(symlabel(routine));
	do_move(ro0, dst)
enddefine;

define M_MOVEbit	= get_bitfield(%"\^_bfield"%)  enddefine;
define M_MOVEsbit	= get_bitfield(%"\^_sbfield"%) enddefine;

	;;; {M_UPDbit <fieldsize> <bitoffs> <ptr> <src>}
define M_UPDbit();
	lvars fieldsize, src, ptr, bitoffs;
	explode(m_instr) -> src -> ptr -> bitoffs -> fieldsize -> ;
	do_move(fieldsize, ro2);
	exclude_o2();
	do_move(bitoffs, ro1);
	if src /== USP_+ then do_move(src, -_USP) endif;
	exclude_o2();
	do_move(ptr, ro0);
	stack_adjust(false);
	call_sr_delay(symlabel("\^_ubfield"))
enddefine;

define M_ERASE();
	lvars src = f_subv(2, m_instr);
	if auto_operand(src) then do_move(src, R_ZERO) endif
enddefine;


;;; --- ARITH INSTRUCTIONS ---------------------------------------------

define lconstant do_arith3(src2, src1, dst, op);
	lvars src2, src1, dst, storel, op;

	;;; first replace any cached operands (absolute or immediate) in src1
	;;; and dst so they're not overwritten by loading src2, etc
	get_cached_opnd(src1) -> src1;
	get_cached_opnd(dst) -> dst;

	;;; load src operands into registers
	load_src(src2, ro1, true) -> src2;
	load_src(src1, ro0, false) -> src1;

	;;; get destination reg and possible store instruction
	store_dst(ro0, dst) -> dst -> storel;

	;;; place operation
	if isprocedure(op) then
		op(src1, src2, dst)
	else
		;;; op is opcode
		place_acb(op, src1, src2, dst, 4)
	endif;

	;;; and store if necesary
	if storel then placel(storel) endif
enddefine;

define lconstant arith3_instr(opcode);
	lvars opcode;
	do_arith3(explode(m_instr), opcode) ->	/*m_instr pdr*/
enddefine;

define M_ADD	= arith3_instr(%"add"%)  enddefine;
define M_SUB	= arith3_instr(%"sub"%)  enddefine;
define M_BIS	= arith3_instr(%"or"%)   enddefine;
define M_BIM	= arith3_instr(%"and"%)  enddefine;
define M_BIC	= arith3_instr(%"andn"%) enddefine;

define M_NEG();
	lvars src, dst;
	explode(m_instr) -> dst -> src -> ;
	do_arith3(src, R_ZERO, dst, "sub")
enddefine;

define M_LOGCOM();
	lvars src, dst;
	explode(m_instr) -> dst -> src -> ;
	do_arith3(R_ZERO, src, dst, "xnor")
enddefine;

define lconstant ptr_arith_instr(opcode);
	lvars opcode;
	do_arith3(explode(m_instr), opcode) -> /*type*/ -> /*m_instr pdr*/
enddefine;

define M_PTR_ADD_OFFS	= ptr_arith_instr(%"add"%) enddefine;
define M_PTR_SUB_OFFS 	= ptr_arith_instr(%"sub"%) enddefine;
define M_PTR_SUB		= ptr_arith_instr(%"sub"%) enddefine;


define M_ASH();
	lvars shift, src, dst, op;

	define lconstant varshift(src, shift_src, dst);
		lvars shift = ro1, shift_src, src, dst, lab = genlab();
		place_acb("orcc", R_ZERO, shift_src, shift, 4);	;;; tst into shift
		place2([bpos\,a], lab);
		place4("sll", src, shift, dst);
		place2("neg", shift);
		place4("sra", src, shift, dst);
		place_label(lab)
	enddefine;

	explode(m_instr) -> dst -> src -> shift ->;
	if isinteger(shift) then
		"sll" -> op;
		if shift fi_< 0 then "sra" -> op, -shift -> shift endif
	else
		varshift -> op
	endif;
	do_arith3(shift, src, dst, op)
enddefine;

define M_MULT();
	lvars src2, src1, dst;
	explode(m_instr) -> dst -> src1 -> src2 ->;
	get_cached_opnd(src1) -> src1;
	do_move(src2, ro1);
	do_move(src1, ro0);
	call_sr_delay('pop.Mul');
	do_move(ro0, dst)
enddefine;


;;; --- POP ARITHMETIC ------------------------------------------------

define lconstant do_parith3(src2, src1, dst, opcode);
	lvars n, src2, src1, dst, opcode, op = opcode;

	define lconstant parith(src1, src2, dst);
		lvars src1, src2, dst;
		place_acb("andn", src2, 3, ro1, 4);
		place4(opcode, src1, ro1, dst)
	enddefine;

	if isintegral(src2) then
		src2 - 3 -> src2
	elseif isintegral(src1) then
		if opcode == "sub" or opcode == "subcc" then
			;;; subtracting
			src1 + 3 -> n;
			if src1 > 0 and integer_length(n) fi_> 31 then
				;;; adding 3 to it overflows
				parith -> op
			else
				n -> src1
			endif
		else
			;;; adding
			src1 - 3 -> src1
		endif
	else
		parith -> op
	endif;
	do_arith3(src2, src1, dst, op)
enddefine;

define lconstant parith3_instr(opcode);
	lvars opcode;
	do_parith3(explode(m_instr), opcode) -> /*m_instr pdr*/
enddefine;

define M_PADD	= parith3_instr(%"add"%) enddefine;
define M_PSUB	= parith3_instr(%"sub"%) enddefine;

define lconstant parith_test_instr(opcode);
	lvars test, lab, opcode;
	do_parith3(explode(m_instr) -> lab -> test, -_USP, opcode) -> ; /*m_instr pdr*/
	place_test(test, lab)
enddefine;

define M_PADD_TEST	= parith_test_instr(%"addcc"%) enddefine;
define M_PSUB_TEST	= parith_test_instr(%"subcc"%) enddefine;


;;; --- COMPARE INSTRUCTIONS --------------------------------------------

define lconstant do_arith_test(test, lab, opcode);
	lvars lab, test, opcode;
	do_arith3((), R_ZERO, opcode);
	place_test(test, lab)
enddefine;

define lconstant arith_test_instr(opcode);
	lvars opcode;
	do_arith_test(explode(m_instr), opcode) -> /*m_instr pdr*/
enddefine;

define M_CMP 	= arith_test_instr(%"subcc"%) enddefine;
define M_PCMP	= M_CMP enddefine;		;;; compare popints is the same

define lconstant do_bit_test(src2, src1, test, lab);
	lvars src2, src1, test, lab, type, n, offs;
	if isintegral(src2)
	and (isstring(src1) or isaccess(src1) and isintegral(f_subv(2,src1))) then
		T_BYTE -> type;
		if     src2 &&=_0 16:FFFFFF00 then
			1
		elseif src2 &&=_0 16:FFFF00FF then
			2
		elseif src2 &&=_0 16:FF00FFFF then
			3
		elseif src2 &&=_0 16:00FFFFFF then
			4
		elseif src2 &&=_0 16:0000FFFF then
			T_SHORT -> type;
			4
		else
			100
		endif -> n;
		t_offset(access_type(src1), false) - n -> offs;
		if offs >= 0 then
			src2 >> ((n-t_offset(type,false)) * 8) -> src2;
			if isaccess(src1) then
				f_subv(2,src1)+offs -> offs;
				f_subv(1,src1) -> src1
			endif;
			cons_access_opnd(src1, offs, type) -> src1
		endif
	endif;
	do_arith_test(src2, src1, test, lab, "andcc")
enddefine;

define M_BIT();
	do_bit_test(explode(m_instr)) -> /*m_instr pdr*/
enddefine;

	;;; compare pointers -- same as integers for all types
define M_PTR_CMP();
	M_CMP() -> /* m_instr pdr, type already erased */
enddefine;

define M_TEST();
	lvars src, lab, test;
	explode(m_instr) -> (/*m_instr pdr*/, src, test, lab);
	do_arith_test(src, R_ZERO, test, lab, "orcc")
enddefine;

define M_CMPKEY();
	lvars src, test, lab, tlab, key, key_opnd;
	explode(m_instr) -> (, key, src, test, lab);
	if test == "EQ" then genlab() else lab endif -> tlab;
	unless isintegral(key) then get_cached_opnd(key) -> key endunless;
	load_src(src, ro0, false) -> src;
	do_arith_test(1, src, "NEQ", tlab, "andcc");
	{% src, field_##("KEY").wof %} -> key_opnd;
	if isintegral(key) then
		;;; testing flag(s) nonzero in K_FLAGS field
		load_src(key_opnd, ro0, false) -> src;
		do_bit_test(key, {% src, field_##("K_FLAGS").wof %},
											negate_test(test), lab)
	else
		;;; test for specific key
		do_arith_test(key, key_opnd, test, lab, "subcc")
	endif;
	if test == "EQ" then place_label(tlab) endif
enddefine;


;;; --- OTHER BRANCH INSTRUCTIONS -------------------------------------

define M_BRANCH();
	lvars lab = f_subv(2, m_instr), lasti;
	if curr_stack_diff /== 0 then
		place2([b], lab);
		stack_adjust(true)
	elseif get_last_ndelay() ->> lasti then
		;;; last instruction not a delay or a label
		{[b] ^lab} -> f_hd(last_ipair);
		placei(lasti)
	else
		place2(OP_B_ANNUL, lab)				;;; b,a
	endif
enddefine;

	;;; Branch instruction of standard size (annulled branch always -- 4 bytes).
define M_BRANCH_std();
	place2(OP_B_ANNUL, f_subv(2, m_instr))
enddefine;

define lconstant do_branch_on(isint);
	lvars	src, lab, afterlab1 = genlab(), tablab = genlab(), tablab_lo,
			base, lablist = f_subv(3,m_instr), afterlab2 = false, sdiff,
			base_subscr, org_src, isint;

	load_src(f_subv(2,m_instr), ro0, false) ->> src -> org_src;
	tablab -> lab;
	unless isint then lab label_- popint(0) -> lab endunless;
	place_set(lab_lo_hi(lab) -> tablab_lo, ro7, true);
	if isint then
		place_acb("sll", src, 2, ro1 ->> src, 4);
		4
	else
		5
	endif -> base_subscr;
	if datalength(m_instr) == base_subscr then
		f_subv(base_subscr,m_instr)
	else
		1
	endif -> base;
	unless 0 <= base and base <= 4 then
		do_arith3(base<<2, src, ro1 ->> src, "sub");
		0 -> base
	endunless;
	curr_stack_diff -> sdiff;

	place3("cmp", src, popint(listlength(lablist)+base-1));
	place2([bgu], afterlab1);
	place4("add", ro7, src, ro7);
	place2(OP_JMP, {^ro7 ^tablab_lo});
	stack_adjust(true);

	place_label(tablab);
	;;; first the branches for trapping arg values < base
	false -> lab;
	until base == 0 do
		unless lab then
			if sdiff /== 0 then genlab() ->> afterlab2 else afterlab1 endif
							-> lab
		endunless;
		place2(OP_B_ANNUL, lab);
		base-1 -> base
	enduntil;
	;;; now the ones for the allowable values
	for lab in lablist do place2(OP_B_ANNUL, lab) endfor;

	place_label(afterlab1);
	if sdiff /== 0 then
		sdiff -> curr_stack_diff;
		stack_adjust(false)
	endif;
	if afterlab2 then place_label(afterlab2) endif;

	unless isint or f_subv(4,m_instr) then
		;;; if no "else" label, push arg back onto stack
		;;; (as argument to error procedure)
		do_move(org_src, -_USP)
	endunless
enddefine;

define M_BRANCH_ON		= do_branch_on(%false%) enddefine;
define M_BRANCH_ON_INT	= do_branch_on(%true%) enddefine;


;;; --- CALL INSTRUCTIONS ------------------------------------------------

define lconstant call_or_chain_lab(lab, call);
	lvars lab, lo, call, delayi, i;

	define lconstant get_delay(reg, not_call);
		lvars n, i, reg, not_call;
		if curr_stack_diff == 0 and (get_last_ndelay() ->> i)
		and (not_call
			or (fast_cont(f_subv(1, i)) ->> n) /== "restore" and n /== "save")
		then
			fast_for n from 2 to datalength(i) do
				returnif(reg_in_operand(f_subv(n, i)) == reg) (false)
			endfast_for;
			i
		else
			false
		endif
	enddefine;

	if call then
		get_delay(ro7, false),
		consvector(OP_CALL, lab, 2)
	else
		get_delay(ro0, true),
		consvector("sethi", lab_lo_hi(lab) -> lo, ro0, 3)
	endif -> i -> delayi;
	if delayi then
		i -> f_hd(last_ipair)
	else
		placei(i)
	endif;
	unless call then
		place2(OP_JMP, {^ro0 ^lo})
	endunless;
	if delayi then
		placei(delayi)
	else
		stack_adjust(true)
	endif;
	clear_lit_reg()
enddefine;

define lconstant pop_call_or_chain(call);
	lvars src = f_subv(2, m_instr), call, delayi;
	if isref(src) then
		;;; constant
		call_or_chain_lab(execlabof(fast_cont(src), true), call)
	else
		false -> delayi;
		if isreg(src) then
			do_move({^src 0}, ro0);
			if curr_stack_diff == 0 then
				consvector(consref("mov"), src, OPB, 3) -> delayi
			else
				do_move(src, OPB)
			endif
		else
			do_move(src, OPB);
			do_move(#_< {^OPB 0} >_#, ro0)
		endif;
		;;; call/jmp at PD_EXECUTE+8
		place2(if call then OP_CALL else OP_JMP endif, #_< {^ro0 8} >_#);
		if delayi then
			placei(delayi)
		else
			stack_adjust(true)
		endif;
		clear_lit_reg()
	endif
enddefine;

define M_CALL	= pop_call_or_chain(% true %)  enddefine;
define M_CHAIN	= pop_call_or_chain(% false %) enddefine;

	;;; {M_CALL_WITH_RETURN <pdr_opnd> <return addr>}
define M_CALL_WITH_RETURN();
	do_arith3(8, f_subv(3, m_instr), ro7, "sub"); ;;; set return address in o7
	M_CHAIN()									;;; chain to procedure
enddefine;

define lconstant subr_call_or_chain(call);
	lvars src = f_subv(2, m_instr), call;
	if isref(src) then
		;;; constant
		call_or_chain_lab(fast_cont(src), call)
	else
		load_src(src, ro0, false) -> src;
		place2(if call then OP_CALL else OP_JMP endif, {^src 0});
		stack_adjust(true);
		clear_lit_reg()
	endif
enddefine;

	;;; {M_CALLSUB <subroutine_opnd> <upto 3 args to go in regs>}
	;;; (subroutine is always a constant when reg args present)
define M_CALLSUB();
	lvars l = datalength(m_instr);
	if l == 5 then
		do_move(f_subv(3,  m_instr), ro2);						;;; arg_reg_2
		exclude_o2();
	endif;
	if l fi_>= 4 then do_move(f_subv(l-1,m_instr), ro1) endif;	;;; arg_reg_1
	if l fi_>= 3 then do_move(f_subv(l,  m_instr), ro0) endif;	;;; arg_reg_0
	subr_call_or_chain(true)
enddefine;

define M_CHAINSUB = subr_call_or_chain(% false %) enddefine;

	;;; {M_CALLER_RETURN <bool> <operand>}
	;;; <bool> true if updating caller return, false if getting
define M_CALLER_RETURN();
	lvars opnd, upd;
	explode(m_instr) -> opnd -> upd -> ;
	if upd then
		;;; setting
		if isref(opnd) then
			do_move(consref(fast_cont(opnd)<>'-8'), R_RETN)
		else
			do_arith3(8, opnd, R_RETN, "sub")
		endif
	else
		;;; getting
		do_arith3(8, ri7, opnd, "add")
	endif
enddefine;

define M_LABEL();
	stack_adjust(false);
	clear_lit_reg();
	OP_LABEL -> f_subv(1, m_instr);
	placei(m_instr);
	last_ipair -> lab_code_pair(f_subv(2, m_instr))
enddefine;


;;; --- SPECIAL INSTRUCTIONS --------------------------------------------

	;;; {M_CLOSURE <frozvals> <pdpart opnd>}
define M_CLOSURE();
	lvars	f, l, offs, (, frozvals, pdpart_opnd) = explode(m_instr),
			nfroz = listlength(frozvals);

	;;; M-code to push frozvals and call pdpart.
	;;; If closure is non-writeable, pdpart_opnd
	;;; is an immediate operand for the pdpart procedure.
	[%	if nfroz fi_> 16 then
			;;; just give clos to Exec_closure
			{% M_MOVE, OPB, -_USP %};
			{% M_CHAIN, perm_const_opnd([Sys Exec_closure]) %}
		elseif pdpart_opnd then
			;;; closure non-writeable, can bypass stored frozvals
			fast_for f in frozvals do
				unless isintegral(f) then consref(f) -> f endunless;
				{% M_MOVE, f, -_USP %}
			endfor;
			{% M_CHAIN, pdpart_opnd %}
		else
			;;; must use stored frozvals
			field_##("PD_CLOS_FROZVALS").wof -> offs;
			fast_repeat nfroz times
				{% M_MOVE, {^OPB ^offs}, -_USP %};
				offs fi_+ 4 -> offs
			endrepeat;
			{% M_CHAIN, {%OPB, field_##("PD_CLOS_PDPART").wof%} %}
		endif
	%] -> l;
	f_hd(l) ->> m_instr -> f_hd(m_codelist);
	f_tl(l) nc_<> f_tl(m_codelist) -> f_tl(m_codelist);
	chain(f_subv(1, m_instr))
enddefine;

	;;; {M_SETSTKLEN <offset of stack increase> <popint saved stklen opnd>}
	;;; offset is always a constant integer
define M_SETSTKLEN();
	lvars sl_opnd, offs, lab;
	explode(m_instr) -> sl_opnd -> offs -> ;
	;;; userhi - popint stklen -> o0
	do_arith3(sl_opnd, identlabel("\^_userhi"), ro0, "sub");
	;;; o0 - (offs-3) -> o0 = desired value of USP
	;;; (-3 accounts for the popint bits in sl_opnd)
	do_arith3(offs-3, ro0, ro0, "sub");
	do_arith_test(USP, ro0, "EQ", genlab()->>lab, "subcc");
	call_or_chain_lab(perm_const_lab([\^_setstklen_diff]), true);
	place_label(lab)
enddefine;


;;; --- PROLOG INSTRUCTIONS ----------------------------------------------

	;;; {M_PLOG_IFNOT_ATOM <ifnot_lab>}
	;;; (follows a call of _prolog_unify_atom)
define M_PLOG_IFNOT_ATOM();
	place_test("NEQ", f_subv(2,m_instr))
enddefine;

	;;; {M_PLOG_TERM_SWITCH <fail_lab> <var_lab> <dst for drop thru case>}
	;;; (follows a call of _prolog_pair_switch/_prolog_term_switch)
define M_PLOG_TERM_SWITCH();
	place_test("LT", f_subv(3,m_instr));	;;; var_lab if greater than
	place_test("GT", f_subv(2,m_instr));	;;; fail_lab if less than
	;;; else deref'ed pair/term in arg_reg_0 (o0)
	do_move(ro0, f_subv(4,m_instr))
enddefine;


;;; --- ENTRY/EXIT CODE --------------------------------------------------

lblock

lvars	dlocal_labs,
	;

	;;; {M_CREATE_SF <reg_locals> <Npopreg> <Nstkvars> <Npopstkvars>
	;;;								<dlocal_labs> <ident reg_spec> }
	;;; Generate code to construct stack frame -- this sets up values
	;;; to be used by later M_UNWIND_SF.
define M_CREATE_SF();
	lvars	i, l, lab1, lab2, offs, pinit, dloc_offs, reg_locals, reg_spec_id,
			maxpopreg, Ndlocals, Npopregs, Nstkvars, Npopstkvars;

	explode(m_instr) -> reg_spec_id -> dlocal_labs
					-> Npopstkvars -> Nstkvars -> Npopregs -> reg_locals -> ;

	listlength(dlocal_labs) -> Ndlocals;

	;;; Reg spec in PD_REGMASK is unused -- returned in idval(reg_spec_id)
	0 -> idval(reg_spec_id);

	;;; new register window
	(field_##("SF_LOCALS") fi_+ Nstkvars) fi_<< 2 -> dloc_offs;
	place4("save", SP, negate(dloc_offs fi_+ (Ndlocals fi_<< 2)), SP);

	;;; get code to initialise pop registers to popint(0)
	Npopregs fi_+ 15 -> maxpopreg;
	[% fast_for i from 16 to maxpopreg do
		consvector("mov", 3, reglabel(i), 3)
	endfast_for %] -> pinit;

	;;; save dlocal identifiers (2 at a time where possible, and
	;;; interspersed with pop reg inits)
	0 -> offs;
	dlocal_labs -> l;
	until l == [] do
		f_dest(l) -> l -> lab1;
		if l == [] then
			offs fi_- 4 -> offs;
			load_src(lab1, ro0, false) -> ;
			"st"
		else
			f_dest(l) -> l -> lab2;
			offs fi_- 8 -> offs;
			load_src(lab1, ro1, false) -> ;
			load_src(lab2, ro0, false) -> ;
			"std"
		endif;
		if pinit /== [] then placei(f_dest(pinit) -> pinit) endif;
		place3((), ro0, {^FP ^offs})
	enduntil;

	;;; remaining pop reg inits
	fast_for i in pinit do placei(i) endfast_for;

	;;; initialise pop onstack lvars (use 1st/2nd pop lvars for this)
	Npopstkvars -> i;
	dloc_offs -> offs;
	while i /== 0 do
		if maxpopreg fi_< 16 then
			place3("mov", 3, rl0), 16 -> maxpopreg
		endif;
		if i == 1 or offs &&/=_0 4 then
			offs fi_- 4 -> offs;
			place3("st", rl0, {^SP ^offs});
			i fi_- 1 -> i
		else
			if maxpopreg fi_< 17 then
				place3("mov", 3, rl1), 17 -> maxpopreg
			endif;
			offs fi_- 8 -> offs;
			place3("std", rl0, {^SP ^offs});
			i fi_- 2 -> i
		endif
	endwhile
enddefine;

	;;; {M_UNWIND_SF}
	;;; generate code to unwind stack frame (musn't use CHAIN_REG = g1)
	;;; Uses lvar dlocal_labs set up by previous M_CREATE_SF
define M_UNWIND_SF();
	lvars offs, l, lab1, lab2;

	;;; restore dlocal identifiers (2 at a time where possible)
	0 -> offs;
	dlocal_labs -> l;
	until l == [] do
		f_dest(l) -> l -> lab1;
		if l == [] then
			offs fi_- 4 -> offs;
			do_move({^FP ^offs}, lab1)
		else
			f_dest(l) -> l -> lab2;
			offs fi_- 8 -> offs;
			place3("ldd", {^FP ^offs}, ro0);
			placel(store_dst(ro0, lab2) ->);
			placel(store_dst(ro1, lab1) ->)
		endif
	enduntil;

	;;; back to caller's register window
	place4("restore", USP, curr_stack_diff, USP);
	0 -> curr_stack_diff
enddefine;

endlblock;


	;;; return from procedure
define M_RETURN();
	lvars last;
	if (f_hd(last_ipair) ->> last)(1) == "restore" then
		{[ret]} -> f_hd(last_ipair);
		placei(last)
	else
		placei({[retl]});
		stack_adjust(true)
	endif;
	clear_lit_reg()
enddefine;

	;;; end of code
define M_END = identfn(%%) enddefine;

define lconstant do_condbr_delay(bri_pair);
	lvars bri_pair, nextpair, delayi;
	f_tl(bri_pair) -> nextpair;
	if f_subv(1, f_hd(nextpair)) == OP_NOP_CONDBR
	and (get_annul_delay_instr(f_hd(bri_pair)) ->> delayi) then
		delayi -> f_hd(nextpair)
	endif
enddefine;

	;;; translate M-code to SPARC assembler
define lconstant code_trans(m_clist) -> instr_list;
	lvars opcode, m_clist;
	dlocal m_codelist, m_instr, instr_list, last_ipair,
		curr_stack_diff		= 0,
		condbr_code_pairs	= [],
		Lreg_A_val, Lreg_B_val, Lreg_C_val,
		Lreg_1, Lreg_2, Lreg_3,
		;

	;;; start of code label
	[{%OP_LABEL, current_pdr_exec_label%}] ->> instr_list -> last_ipair;
	place3([set], current_pdr_label, OPB);
	clear_lit_reg();
	for m_codelist on m_clist do
		f_hd(m_codelist) -> m_instr;
		if isprocedure(f_subv(1, m_instr) ->> opcode) then
			opcode()
		else
			mishap(opcode, 1, 'UNKNOWN M-OPCODE')
		endif
	endfor;

	applist(condbr_code_pairs, do_condbr_delay)
enddefine;


;;; --- GENERATE OUTPUT CODE -----------------------------------------------

define lconstant outopnd(opnd, opcode);
	lvars opnd, reg, dis, opcode;
	if isintegral(opnd) or isstring(opnd) then
		opnd, '%p'
	elseif isref(opnd) then
		fast_cont(opnd), '%p'
	elseif isreg(opnd) then
		opnd, '%%%p'
	elseif isaccess(opnd) then
		;;; reg access (vector)
		f_subv(1, opnd) -> reg;
		f_subv(2, opnd) -> dis;
		if datalength(opnd) == 3 then
			if dis /== 0 then
				mishap(opnd, 1, 'INVALID OPERAND FOR outopnd')
			endif;
			"%" <> f_subv(3, opnd) -> dis
		endif;
		unless isinteger(dis) and dis fi_<= 0 then
			dis, reg, '%%%p+%p'
		elseif dis == 0 then
			reg, '%%%p'
		else
			0 fi_- dis, reg, '%%%p-%p'
		endunless;

		;;; it's inconsistent not to have these in brackets!
		if opcode /== "call" and opcode /== "jmp" then
			'[%s]'
		endif
	else
		opnd, '%p'
;;;		mishap(opnd, 1, 'INVALID OPERAND FOR outopnd')
	endif;
	asmf_printf()
enddefine;

define lconstant outinst(inst);
	lvars n, l, opcode, inst;
	f_subv(1, inst) -> opcode;
	if isref(opcode) then fast_cont(opcode) -> opcode endif;
	if ispair(opcode) then f_hd(opcode) -> opcode endif;
	if opcode == "label" then outlab(f_subv(2,inst)); return endif;
	asmf_printf(opcode, '\t%p\t');
	datalength(inst) -> l;
	fast_for n from 2 to l fi_- 1 do
		outopnd(f_subv(n, inst), opcode);
		asmf_charout(`,`)
	endfast_for;
	unless l == 1 then outopnd(f_subv(l, inst), opcode) endunless;
	asmf_charout(`\n`)
enddefine;


;;; --- GENERATING CODE ------------------------------------------------

	/*	Generate assembler code for a procedure -- called by m_trans
		The global variables
			current_pdr_label, current_pdr_exec_label
		contain the current procedure's label and start-of-code label
		-hdr_len- is the length in words preceding the code.
	*/
define mc_code_generator(codelist, hdr_len) -> pdr_len -> gencode;
	lvars codelist, endlab, hdr_len, pdr_len;
	lconstant procedure gencode;

	;;; process codelist
	code_trans(codelist) -> codelist;	;;; translate to assembler

	;;; expression for procedure length in words
	genlab() -> endlab;
	'((' <> endlab <> '-' <> current_pdr_exec_label <> ')>>2)+'
											sys_>< hdr_len -> pdr_len;

	;;; code generator
	define lconstant gencode();
		applist(codelist, outinst);			;;; produce output code
		outlab(endlab)						;;; end label
	enddefine
enddefine;


;;; --- OTHER DEFINITIONS NEEDED BY m_trans.p ---------------------------


	/*	M-code tables for machine-dependent in-line subroutines.
		These are added to the corresponding properties in m_trans.p
	*/
constant

	mc_inline_procs_list = [
	[ \^_ptr_to_offs	[{^M_ERASE ^USP_+}]]		;;; erases type, leaves ptr
	[ \^_offs_to_ptr	[{^M_ERASE ^USP_+}]]		;;; erases type, leaves ptr
	[ \^_int			[{^M_ASH -2 ^USP_+ ^ -_USP}]]
	[ \^_pint			[{^M_ASH  2 ^USP_+ ^ -_USP} {^M_ADD 3 ^USP_+ ^ -_USP}]]
	[ \^_por			[{^M_BIS ^USP_+ ^USP_+ ^ -_USP}]]
	[ \^_pand			[{^M_BIM ^USP_+ ^USP_+ ^ -_USP}]]
	[ \^_mksimple		[{^M_ADD 1 ^USP_+ ^ -_USP}]]
	[ \^_mkcompound		[{^M_SUB 1 ^USP_+ ^ -_USP}]]
	[ \^_mksimple2		[{^M_ADD 3 ^USP_+ ^ -_USP}]]
	[ \^_mkcompound2	[{^M_SUB 3 ^USP_+ ^ -_USP}]]
	[ \^_\%flush		% procedure();
						{% M_CALLSUB, perm_const_opnd([Sys \^_flush_regfile]) %}
						  endprocedure % ]
	[ \^_sp_flush			[\^_\%flush \^_sp]]
	[ \^_caller_sp_flush	[\^_\%flush \^_caller_sp]]
	],

	mc_inline_conditions_list = [
	[ \^_iscompound		{^M_BIT  2:01   ^USP_+ EQ  ?}	]
	[ \^_issimple		{^M_BIT  2:01   ^USP_+ NEQ ?}	]
	[ \^_issimple2		{^M_BIT	 2:10	^USP_+ NEQ ?}	]
	[ \^_isinteger		{^M_BIT  2:10   ^USP_+ NEQ ?}	]
	[ \^_isaddress		{^M_BIT  2:11   ^USP_+ EQ  ?}	]
	],
;


	/*	Procedure to convert a pop integer subscript to an appropriate offset
		for the data type being accessed, used by OP_SUBV in m_trans.p to
		compile code for fast_subscrv, vectorclass field accesses, etc.
			-scale- is the scale for the data type involved; the results are
		the M-code instructions (if any) necessary to convert the subscript
		on top of the stack to an offset, plus a constant correction to be
		added.
	*/
define cvt_pop_subscript(scale);
	lvars pow, scale;
	if is_power2(scale) ->> pow then
		;;; pow-2 accounts for popint being shifted left 2
		unless (pow-2 ->> pow) == 0 then
			{^M_ASH ^pow ^USP_+ ^ -_USP}
		endunless,
		-(popint(0) << pow)		;;; additive correction to remove popint bits
	else
		;;; just convert to sysint and multiply
		{^M_ASH -2 ^USP_+ ^ -_USP},		;;; _int()
		{^M_MULT ^scale ^USP_+ ^ -_USP},
		0 						;;; no correction necessary
	endif
enddefine;


endsection;		/* Genproc */

endsection;		/* $-Popas$-M_trans */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Oct  1 1997
		Userstack now in reg g4 instead of g*7
--- John Gibson, Oct 18 1996
		Changed M_BRANCH_ON(_INT) to work with BRANCH_ON_ALLOWS_BASE true.
--- John Gibson, Mar 24 1995
		Changed to use our own pop.Mul instead of C .mul (guaranteed not
		to change any g regs)
--- John Gibson, Oct  6 1994
		Changed to use new M-code operands (USE_NEW_M_OPERANDS true)
--- John Gibson, Aug 31 1994
		Removed M_AR*RAY_SUB (no longer necessary)
--- John Gibson, Jun 11 1993
		Changed WK_ADDR_REG_1/2 to be g2/g3 instead of o7/o5 (which get
		corrupted by the call to .mul in M_MULT)
--- John Gibson, Sep 28 1992
		Changed M_CLOSURE to call Exec_closure for more than 16 frozvals
--- John Gibson, Jan  8 1992
		Added _por and _pand to mc_inline_procs_list
--- John Gibson, Jan  6 1992
		Changed M_CMPKEY to allow key arg to be an integer specifying
		flag(s) to be tested in K_FLAGS field.
		Fixed bug in -call_sr_delay-
--- John Gibson, Dec  5 1991
		Added optimisation in -code_trans-
--- John Gibson, Jan 11 1990
		Added -hdr_len- arg to -mc_code_generator- and corrected
		procedure length expression for new pointers
--- John Gibson, Jun  7 1989
		Included common.ph
--- John Gibson, May 17 1989
		Changed all references to subroutine names to begin with \^_
		(Ctrl-_) instead of _.
		Replaced all uses of @ and @@ with calls to field_## on the
		name of the field (converted to word offset where necessary).
		-pdr_offset_opnd- replaced by -pdr_index_opnd-, which now takes
		a pop integer index instead of a sysint offset.
--- John Gibson, Apr 26 1989
		Added M_SETSTKLEN, M_PLOG_IFNOT_ATOM and M_PLOG_TERM_SWITCH.
		Changed M_CALLSUB to include any register arguments as part of the
		instruction; removed references to ARG_REG_0.
--- John Gibson, Mar 23 1989
		-addr_add_pop_subscr- replaced with -cvt_pop_subscript-
--- John Gibson, Feb 15 1989
		Added M_AR*RAY_SUB
--- John Gibson, Feb 13 1989
		Improved interface from m_trans.p:
			Now only one code-generating procedure -mc_code_generator-,
		closure code being dealt with by the M_CLOSURE instruction.
			Additional procedure -pdr_index_opnd- required by m_trans
		for references to words in procedure header data
--- John Gibson, Sep  2 1988
		Added SPECIAL_VAR_BLOCK_REG
 */
