/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 > File:            S.sun4r5/src/syscomp/sysdefs.p
 > Purpose:
 > Author:          John Gibson, Aug 19 1988 (see revisions)
 */

/* -------------------------------------------------------------------------

				DEFINITIONS FOR MACHINE/OPERATING SYSTEM

--------------------------------------------------------------------------*/

section;

global constant macro (

	POPC_SYSDEFS_LOADED = true,


;;; --- SYSTEM NAME -----------------------------------------------------

	MACHINE			= [[sun4]],
	SUN 			= true,
	SUN4			= true,


;;; --- MACHINE = SPARC -----------------------------------------------

	PROCESSOR		= [[sparc]],	;;; type of cpu
	SPARC			= true,

	;;; Values for machine and C data types are defined in mcdata.p,
	;;; and can be overidden here if necessary

	BIG_ENDIAN		= true,
	STACK_ALIGN_BITS= 64,			;;; alignment in bits for stack frames


;;; -- OPERATING SYSTEM = SUNOS (SVR4) ------------------------------------

	SUNOS			= 5.3,
	POSIX1			= 199309,
	OPERATING_SYSTEM = [[unix sunos ^SUNOS posix {^POSIX1}]],	;;; type of os
	UNIX			= true,
	SYSTEM_V		= 4.0,
	SHARED_LIBRARIES = true,		;;; dynamically linked against shared libraries
	BSD_MMAP		= true,			;;; has -mmap- and -mprotect- facilities
	BSD_MPROTECT	= true,

	VPAGE_OFFS		= 16:2000,		;;; word address offset of a virtual page
	SEGMENT_OFFS	= VPAGE_OFFS,	;;; word address offset of a segment
	LOWEST_ADDRESS	= 16:2000,		;;; lowest pop structure address
	UNIX_USRSTACK	= 16:F8000000,	;;; end of stack (as USRSTACK in <sys/vmparam.h> etc)

	;;; Procedures to get and set the memory break and return the REAL end of
	;;; memory. (We always need the real end to ensure that the end of the
	;;; user stack is always at the true end of memory, so that user stack
	;;; underflow produces a memory access violation.)

	GET_REAL_BREAK =
		[procedure(); _extern sbrk(_0)@(b.r->vpage) endprocedure],

	SET_REAL_BREAK =
		[procedure(_break) -> _break;
			lvars _break = _break@(w.r->vpage);
			if _extern brk(_break@(w->b)) == _-1 then
				_-1 -> _break
			endif
		endprocedure],


;;; --- OTHER ------------------------------------------------------------


	;;; ANSI C returns floats as single, not double
	C_FLOAT_RESULT_SINGLE = true,

	;;; list of procedures to be optimised as subroutine calls
	;;; format of entries is
	;;;		[<pdr name> <nargs> <nresults> <subroutine name>]

	SUBROUTINE_OPTIMISE_LIST =
		[[
			[prolog_newvar			0 1 _prolog_newvar]
			[datakey				1 1 _datakey]
			[prolog_deref			1 1 _prolog_deref]
			[conspair				2 1 _conspair]
		]],

);

define :inline CACHEFLUSH(_ptr, _nbytes);
	$-Sys$- _cache_flush(_ptr, _nbytes)
enddefine;

endsection;		/* $- */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Nov  4 1996
		Removed is* procedures from SUBROUTINE_OPTIMISE_LIST (no longer
		required).
--- Robert John Duncan, Aug 11 1995
		Changed CACHEFLUSH to use new, faster _cache_flush subroutine
--- Robert John Duncan, Aug  9 1995
		Added CACHEFLUSH definition to cure problems on SPARC 5
--- John Gibson, Mar 30 1995
		Added BIG_ENDIAN
--- John Gibson, Mar 21 1995
		Standard machine data type definitions are now in mcdata.p
--- John Gibson, Feb 28 1995
		Added POSIX1 and "posix" entry in OPERATING_SYSTEM
--- Robert John Duncan, Mar 22 1994
		Added STACK_ALIGN_BITS
--- Robert John Duncan, Jan 12 1994
		Changed SUNOS from 5.2 to 5.3 (enables new treatment of shared
		libraries)
--- John Williams, Jul 19 1993
		Changed SUNOS from 5.1 to 5.2
--- Simon Nichols, May 11 1993
		Added SHARED_LIBRARIES
--- Simon Nichols, Mar  2 1993
		Changed SUNOS to 5.1 (Solaris 2.1)
--- John Gibson, Oct 22 1992
		Changed P*OPC to POPC_SYSDEFS_LOADED
--- Robert John Duncan, Aug  7 1992
		Added C_FLOAT_RESULT_SINGLE and removed BSD*_VFORK
--- Robert John Duncan, Jul 21 1992
		Modified for SunOS 5.0
--- Robert John Duncan, Jun 23 1992
		Added BSD*_VFORK
--- John Gibson, Feb 18 1991
		Removed SPARC_N*WINDOWS (replaced where necessary with
		SPARC_MAX_WINDOWS defined in symdefs.p)
--- John Gibson, Dec 11 1990
		SUNOS 4.1
--- John Gibson, Aug 31 1989
		Added UNIX_USRSTACK
--- John Gibson, Aug 24 1989
		Removed S*IGNALS
--- Rob Duncan, Apr  3 1989
		Added MACHINE definition; changed OPERATING_SYSTEM to include
		"sunos" and renamed SUN_RELEASE as SUNOS
--- Rob Duncan, Oct  6 1988
		Added BSD_MPROTECT flag
--- Roger Evans, Sep 26 1988
		Added POPC definition
--- John Gibson, Apr 20 1988
		Changed BIGINT_SPEC to "int" (aarith.s for Sun3 now uses 68020
		instructions, so bigints can be ints rather than shorts).
 */
