/* --- Copyright University of Sussex 1989. All rights reserved. ----------
 * File:		S.vaxunix4.2/src/alisp.s
 * Purpose:
 * Author:		John Williams (see revisions)
 */

#_<

#_INCLUDE 'declare.ph'

constant	_setstklen_diff
	;

>_#

/********************* wrapping structures ***********************************/

	.text
	.long	Ltext_end-Ltext_start, C_LAB(Sys$-objmod_pad_key)
Ltext_start:
	.data
	.long	Ldata_end-Ldata_start, C_LAB(Sys$-objmod_pad_key)
Ldata_start:

/**************************************************************************/


	.text
	.align  2

DEF_C_LAB (_setstklen)
	addl3	(ap)+,(ap)+,r0		;;; add saved stklen and nresults
	subl2	$6,r0			;;; r0 = desired stacklength (bytes)
	subl3	r0,I_LAB(_userhi),r0	;;; r0 = desired ap = (_userhi - r0)
	cmpl	r0,ap			;;; compare
	bneq	C_LAB(_setstklen_diff)	;;; carry on with _setstklen1 if diff
	rsb				;;; otherwise return

	.align  2

DEF_C_LAB (_setstklen_diff)
	bgtru	L_ERAS			;;; erase if r0 > ap
L_PUSH:
	movl	$C_LAB(nil),-(ap)	;;; push NIL
	cmpl	r0,ap			;;; compare actual and desired ap
	bneq	L_PUSH			;;; loop again unless same
	rsb

L_ERAS:
	movl	r0,ap
	rsb


/*************** end labels for wrapping structures **************************/

	.text
Ltext_end:
	.data
Ldata_end:

/**************************************************************************/



/* --- Revision History ---------------------------------------------------
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- John Gibson, Aug 23 1988
	Wrapping structures now use -objmod_pad_key-
--- John Gibson, Jan 17 1988
	Added 'wrapping' strings to enable object files from .s files to
	be mixed in with those from .p source.
		Replaced all references to 'poplog' labels with macros
	C_LAB, I_LAB, etc applied to identifier names, and added appropriate
	declarations between #_< ... >_#, etc.
 */
