/* --- Copyright University of Sussex 1992. All rights reserved. ----------
 > File:            C.vax/src/closure_cons.p
 > Purpose:
 > Author:          John Gibson (see revisions)
 > Documentation:	REF *PROCEDURE
*/

;;; ----------------- CONSTRUCTING CLOSURES (VAX) ------------------------

#_INCLUDE 'declare.ph'

constant
		procedure Sys$-Exec_closure
	;

;;; ----------------------------------------------------------------------

section $-Sys;

	;;; macros for dropping longs, shorts and bytes at _drop_ptr
lconstant macro (
	LONG	= [_drop_ptr!(l)++ -> _drop_ptr],
	SHORT	= [_drop_ptr!(s)++ -> _drop_ptr],
	BYTE	= [_drop_ptr!(b)++ -> _drop_ptr],
	);

	/*	Construct a raw closure for _nfroz frozvals
	*/
define Cons_closure(_nfroz) -> _clos;
	lvars _drop_ptr, _clos, _size, _nfroz;
	;;; calculate length of code to be planted
	if _nfroz _gr _16 then
		_11 -> _size
	else
		_nfroz _mult _3 _add _10 -> _size
	endif;
	##(w){_size | b.r} -> _size;

	;;; add header size and frozval size to get total
	@@PD_CLOS_FROZVALS[_nfroz _add _size] _sub @@POPBASE -> _size;
	Get_store(_size) -> _clos;
	##(w){_size} ->> _size -> _clos!PD_LENGTH;
	unless _clos!PD_LENGTH == _size then
		_clos -> Get_store();		;;; junk it
		mishap(0, 'CLOSURE EXCEEDS MAXIMUM ALLOWABLE SIZE')
	endunless;

	;;; plant code
	_clos@PD_CLOS_FROZVALS[_nfroz] ->> _drop_ptr -> _clos!PD_EXECUTE;

	if _nfroz _gr _16 then
		;;; just give _clos address to Exec_closure (11 bytes)
		_16:CFDE -> SHORT;					;;; moval <short offset>(pc)
		@@(w){_clos, _drop_ptr@(s)++} -> SHORT;	;;; <offset>
		_16:7C -> BYTE;						;;; -(ap)
		_16:9F17 -> SHORT;					;;; jmp @#
		Exec_closure!PD_EXECUTE -> LONG		;;; Exec_closure
	else
		;;; plant code to move PD_EXECUTE field of pdpart to r0 (PD_EXECUTE
		;;; field has offset 0 so can use use pc rel deferred),
		;;; and address of first frozval to r1 (8 bytes)
		_16:BFD0 -> SHORT;					;;; movl @<byte offset>(pc)
		@@(w){_clos@PD_CLOS_PDPART, _drop_ptr@(b)++} -> BYTE;	;;; <offset>
		_16:50 -> BYTE;						;;; r0
		_16:AFDE -> SHORT;					;;; moval <byte offset>(pc)
		@@(w){_clos@PD_CLOS_FROZVALS, _drop_ptr@(b)++} -> BYTE;	;;; <offset>
		_16:51 -> BYTE;						;;; r1
		;;; now plant code to push them onto the stack (_nfroz*3 bytes)
		until _zero(_nfroz) do
			_16:81D0 -> SHORT;				;;; movl (r1)+
			_16:7C -> BYTE;					;;; -(ap)
			_nfroz _sub _1 -> _nfroz
		enduntil;
		;;; finally, enter pdpart (2 bytes)
		_16:6017 -> SHORT					;;; jmp (r0)
	endif
enddefine;

endsection;		/* $-Sys */


/* --- Revision History ---------------------------------------------------
--- John Gibson, Sep 23 1992
		Added check for size not being too large
--- John Gibson, May  1 1988
		Procedure that used to be -partapply- now reduced to -Cons_closure-
		(called from -consclosure- in consclosure.p), which just returns
		a raw closure for a given number of frozvals.
--- John Gibson, Apr  1 1988
		Moved Pdr_<> to pdr_compose.p
--- John Gibson, Mar 22 1988
		Rewrote to use macros to plant code rather than using ass.p
		procedures.
--- John Gibson, Mar 21 1988
		Pdr_<> and Exec_closure into section Sys
--- John Gibson, Mar  8 1988
		Moved array constructor to C.vax/src/array_cons.p
--- John Williams, Nov  1 1987 -Cons_array- now works on 0-dim arrays
 */
