/* --- Copyright University of Sussex 1995. All rights reserved. ----------
 > File:			C.vax/src/syscomp/genproc.p
 > Purpose:
 > Author:			John Gibson (see revisions)
 */

/* -------------------------------------------------------------------------

				GENERATE PROCEDURE CODE (VAX/VMS & VAX/UNIX)

--------------------------------------------------------------------------*/

#_INCLUDE 'common.ph'

section $-Popas$-M_trans;

global constant
		procedure (auto_operand, negate_test)
	;

global vars
		current_pdr_label, current_pdr_exec_label, false_immediate
	;

	/****************************************************************
	* This file is contained entirely in section Genproc, and must	*
	*	define all the exports to section M_trans listed below.		*
	****************************************************************/

section Genproc =>

		/*	M-opcode Procedures */
		M_ADD
		M_ASH
		M_BIC
		M_BIM
		M_BIS
		M_BIT
		M_BRANCH
		M_BRANCH_std
		M_BRANCH_ON
		M_BRANCH_ON_INT
		M_CALL
		M_CALL_WITH_RETURN
		M_CALLSUB
		M_CHAIN
		M_CHAINSUB
		M_CLOSURE
		M_CMP
		M_CMPKEY
		M_CREATE_SF
		M_END
		M_ERASE
		M_LABEL
		M_LOGCOM
		M_MOVE
		M_MOVEb
		M_MOVEbit
		M_MOVEs
		M_MOVEsb
		M_MOVEsbit
		M_MOVEss
		M_MULT
		M_NEG
		M_PADD
		M_PADD_TEST
		M_PCMP
		M_PLOG_IFNOT_ATOM
		M_PLOG_TERM_SWITCH
		M_PSUB
		M_PSUB_TEST
		M_PTR_ADD_OFFS
		M_PTR_CMP
		M_PTR_SUB
		M_PTR_SUB_OFFS
		M_RETURN
		M_SETSTKLEN
		M_SUB
		M_TEST
		M_UNWIND_SF
		M_UPDb
		M_UPDbit
		M_UPDs

		/*	Registers */
		SP
		USP
		USP_+
		-_USP
		i_USP
		i_USP_+
		ii_USP
		WK_ADDR_REG_1
		WK_ADDR_REG_2
		WK_REG
		CHAIN_REG

		/*	Register Lists */
		nonpop_registers
		pop_registers

		/*	Register Procedures */
		reglabel
		regnumber
		autoidreg

		/*	M-code Mapping of Subroutines */
		mc_inline_conditions_list
		mc_inline_procs_list

		/*	Procedures Needed by -m_optimise- */
		cvt_pop_subscript
		can_defer_opnd
		pdr_index_opnd

		/*	Procedure to Generate Code */
		mc_code_generator
	;


;;; --- REGISTERS ----------------------------------------------------------

/* Register Use
		r0		working				r8		non-pop lvar
		r1		working				r9		non-pop lvar
		r2		working				r10		non-pop lvar
		r3		working				r11		non-pop lvar
		r4		working				r12		user stack pointer
		r5		address of false	r13		frame pointer
		r6		pop lvar			r14		stack pointer
		r7		pop lvar			r15		pc
*/


constant
	RG0			= "r0",
	RG1			= "r1",
	RG2			= "r2",
	RG3			= "r3",
	RG4			= "r4",
	RG5			= "r5",
	R_FALSE		= RG5,					;;; address of false
	USP			= "ap",
	SP			= "sp",
	i_USP		= {^USP 0},				;;; top of user stack
	-_USP		= {^USP ^false},		;;; user stack autodecrement
	USP_+		= {^USP ^true},			;;; user stack autoincrement
	ii_USP		= conspair(i_USP, 0),	;;; top of user stack indirect
	i_USP_+		= conspair(USP_+, 0),	;;; user stack autoincrement indirect
	i_RG0		= {^RG0 0},
	RG0_+		= {^RG0 ^true},
	ii_RG0		= conspair(i_RG0, 0),
	i_RG0_+		= conspair(RG0_+, 0),
	SP_+		= {^SP ^true},
	;


;;; --- DEFINITIONS NEEDED BY m_trans.p ------------------------------------

	/* -m_optimise- requires the definition of

			SP, USP, USP_+, -_USP and i_USP

		(It can also use ii_USP and i_USP_+ if these are available.)
	*/

	/*	WK_REG is used by -m_optimise- for eliminating stack pushes and pops
		between successive instructions
	*/

constant
	WK_REG = RG0;


	/*	WK_ADDR_REG_1 and 2 are used by "m_optimise" for building field
		access operands (ie of the the form {^reg ^offset} ) when an existing
		operand cannot be deferred directly ("can_defer_opnd" having
		returned false for it). 1 is used for source operands, 2 for
		destination operands
	*/

constant
	WK_ADDR_REG_1	= RG1,
	WK_ADDR_REG_2	= RG2;


	/*	CHAIN_REG is the register used to save procedure operands for in-line
		chaining, and must not be corrupted by M_UNWIND_SF (ideally it should
		be an address register). It is also used to save return addresses for
		out-of-line chaining thru the subroutines _syschain and _sysncchain.
	*/
constant
	CHAIN_REG	= RG4;


	/*	-m_optimise- needs lists of pop and nonpop registers,
		in order of allocation; these lists start with a list of
		registers that should be local to every procedure.
		It also needs the properties -regnumber- and -reglabel-.
	*/
constant
	pop_registers		= [[] 7 6],
	nonpop_registers	= [[] 8 9 10 11];

define regnumber 	= newassoc([]) enddefine;
define reglabel		= newassoc([]) enddefine;

	/* set up -regnumber- and -reglabel- properties */
procedure();
	lvars n, l;
	for n from 0 to 11 do
		consword('r'><n) -> l;
		n -> regnumber(l);
		l -> reglabel(n);
	endfor;
endprocedure();
12 -> regnumber(USP);
14 -> regnumber(SP);


	/*	The procedure -autoidreg- is used by -m_optimise- in deciding
		whether a register can be used for autoincrement/decrement operands,
		ie of the form {^reg ^boolean}
	*/
identof("regnumber") -> identof("autoidreg");


	/*	-can_defer_opnd- is used by -m_optimise- to create a field access
		operand from an existing operand, ie accessing the datum at offset
		"dis" from the pointer held in the operand
	*/
define can_defer_opnd(opnd, dis, upd);
	lvars opnd, dis, op2, upd;
	if regnumber(opnd) then
		return({^opnd ^dis})
	elseif isref(opnd) then
		;;; immediate label
		return(fast_cont(opnd), if dis/==0 then <> '+' >< dis endif)
	elseif dis == 0 then
		if isvector(opnd) then
			opnd(2) -> op2;
			if not(isboolean(op2)) or (op2 == true and not(upd)) then
				if opnd == USP_+ then i_USP_+
				elseif opnd == i_USP then ii_USP
				else conspair(opnd, 0)
				endif;
				return
			endif
		elseif isstring(opnd) then
			;;; contents at label address
			return(conspair(opnd, 0))
		else
			;;; it must be a pair - deferred already
			if isref(front(opnd)) then
				;;; deferred immediate
				return(conspair(fast_cont(fast_front(opnd)), 0))
			endif
		endif;
	endif;
	false
enddefine;

define lconstant wof = nonop fi_*(% WORD_OFFS %) enddefine;

	/*	pdr_index_opnd is used by m_trans.p for creating operands to
		push/call values from procedure headers (not used in closures).
	*/
define pdr_index_opnd(fld_index);
	lvars fld_index;
	current_pdr_label label_+ fld_index.wof
enddefine;


;;; --- M-CODE TO VAX ASSEMBLER TRANSLATION --------------------------------


lvars		m_instr, ilist, lasti, m_codelist
	;

lconstant procedure
	test_opcode =
		newassoc([
				[EQ	  beql]	 [NEQ	bneq]
				[LT	  blss]	 [LEQ	bleq]  [GT	 bgtr]	[GEQ   bgeq]
				[ULT blssu]	 [ULEQ blequ]  [UGT bgtru]	[UGEQ bgequ]
				[NEG  blss]	 [POS	bgeq]
				[OVF   bvs]	 [NOVF	 bvc]
		]);

#_IF DEF VMS
lconstant @_c = `@`, #_c = `#`, @#_s = '@#';
#_ELSEIF DEF BERKELEY
lconstant @_c = `*`, #_c = `$`, @#_s = '*$';
#_ELSE ERROR
#_ENDIF



define lconstant c_placei() with_nargs 1;
	() :: [] ->> if lasti then f_tl(lasti) else ilist endif -> lasti;
enddefine;

define lconstant c_place();
	c_placei(consvector())
enddefine;

define lconstant c_place2();
	c_placei(consvector(2))
enddefine;

define lconstant c_place3();
	c_placei(consvector(3))
enddefine;

define lconstant c_place4();
	c_placei(consvector(4))
enddefine;

define lconstant c_label(lab);
	lvars lab;
	c_place2("label", lab)
enddefine;

define lconstant replant() with_nargs 1;
	() -> m_instr(1);
	c_placei(m_instr);
enddefine;

define lconstant c_move(x, y);
	lvars x, y;
	unless x = y then
		c_place3("movl", x, y)
	endunless
enddefine;

#_IF DEF VMS
define lconstant test_move_G_opnd(opnd, use_dst);
	lvars opnd, use_dst;
	if isref(opnd) and islabel(fast_cont(opnd)) &&/=_0 LAB_EXTERN then
		;;; using external routine address -- use moval with G^ addressing
		c_place3("moval", 'G^' <> fast_cont(opnd), use_dst);
		true
	else
		false
	endif
enddefine;
#_ENDIF

define lconstant c_arith(opcode, num, alt, src1, src2, dst);
	lvars src1, src2, dst, opcode, num, alt;
	if src2 = dst then
		if src1 == num then
			c_place2(alt, dst)
		else
			c_place3(opcode<>"\2", src1, dst)
		endif
	else
		c_place4(opcode<>"\3", src1, src2, dst)
	endif
enddefine;

define lconstant c_arith3();
	lvars src1, src2, dst;
	explode(m_instr) -> dst -> src2 -> src1 ->;
	c_arith(src1, src2, dst)
enddefine;

define M_ADD	= c_arith3(%"addl", 1, "incl"%) enddefine;
define M_SUB	= c_arith3(%"subl", 1, "decl"%) enddefine;
define M_MULT	= c_arith3(%"mull", false, false%) enddefine;
define M_BIS	= c_arith3(%"bisl", false, false%) enddefine;
define M_BIC	= c_arith3(%"bicl", false, false%) enddefine;

define lconstant c_ptr_arith(opcode, alt);
	lvars opcode, alt, offs_ptr, ptr, dst;
	explode(m_instr) -> dst -> ptr -> offs_ptr -> /* type */ ->;
	if opcode == "addl" and offs_ptr = dst then
		ptr, offs_ptr -> ptr -> offs_ptr	;;; commutes
	endif;
	c_arith(opcode, 1, alt, offs_ptr, ptr, dst)
enddefine;

define M_PTR_ADD_OFFS = c_ptr_arith(%"addl", "incl"%) enddefine;
define M_PTR_SUB_OFFS = c_ptr_arith(%"subl", "decl"%) enddefine;
define M_PTR_SUB	  = c_ptr_arith(%"subl", "decl"%) enddefine;


define lconstant c_parith(opcode);
	lvars src1, src2, dst, opcode;
	explode(m_instr) -> dst -> src2 -> src1 ->;
	if isintegral(src1) then
		src1 &&~~ 3 -> src1
	else
		c_place4("bicl3", 3, src1, RG3 ->> src1)
	endif;
	c_arith(opcode, false, false, src1, src2, dst);
enddefine;

define M_PADD	= c_parith(%"addl"%) enddefine;
define M_PSUB	= c_parith(%"subl"%) enddefine;

define lconstant c_parith_test(opcode);
	lvars opcode test lab;
	{%explode(m_instr) -> lab -> test, -_USP%} -> m_instr;
	c_parith(opcode);
	c_place2(test_opcode(test), lab);
enddefine;

define M_PADD_TEST = c_parith_test(%"addl"%) enddefine;
define M_PSUB_TEST = c_parith_test(%"subl"%) enddefine;


define M_BIM();
	lvars x;
	m_instr(2) -> x;
	if isintegral(x) then
		~~ x -> x
	else
		c_place3("mcoml", x, RG3 ->> x);
	endif;
	x -> m_instr(2);
	M_BIC();
enddefine;

define M_MOVE();
	lvars x = f_subv(2,m_instr), y = f_subv(3,m_instr), opcode;
	returnif(x = y);
	"movl" -> opcode;
	if isinteger(x) then
		if x == 0 then
			c_place2("clrl", y);
			return
		elseif -64 < x and x < 0 then
			-x -> x; "mnegl" -> opcode;
		elseif 63 < x and x < 128 then
			"movzbl" -> opcode
		endif
	elseif x = false_immediate then
		R_FALSE -> x
#_IF DEF VMS
	elseif test_move_G_opnd(x, y) then
		return
#_ENDIF
	endif;
	c_place3(opcode, x, y)
enddefine;

define M_MOVEb	= replant(%"movzbl"%) enddefine;
define M_MOVEs	= replant(%"movzwl"%) enddefine;
define M_MOVEsb	= replant(%"cvtbl"%) enddefine;
define M_MOVEss	= replant(%"cvtwl"%) enddefine;
define M_UPDb	= replant(%"cvtlb"%) enddefine;
define M_UPDs	= replant(%"cvtlw"%) enddefine;


	;;; {M_MOVE(s)bit <fieldsize> <bitoffs> <ptr> <dst>}
define lconstant bitfield(opcode);
	lvars fieldsize, x, src_dst, ptr, bitoffs, opcode, upd = opcode == "insv";

	define lconstant do_auto(opnd, reg) -> opnd;
		lvars opnd, reg;
		if auto_operand(opnd) then c_move(opnd, reg ->> opnd) endif
	enddefine;

	explode(m_instr) -> src_dst -> ptr -> bitoffs -> fieldsize -> ;
	do_auto(fieldsize, RG3) -> fieldsize;
	if upd and auto_operand(src_dst) then
		do_auto(bitoffs, RG5) -> bitoffs;		;;; = R_FALSE
		do_auto(ptr, RG4) -> ptr
	endif;
	if can_defer_opnd(ptr, 0, false) ->> x then
		x -> ptr
	else
		do_auto(bitoffs, RG5) -> bitoffs;
		c_move(ptr, RG4);
		{^RG4 0} -> ptr
	endif;
	c_place(opcode, if upd then src_dst endif, bitoffs, fieldsize, ptr,
			unless upd then src_dst endunless, 5);
	if bitoffs == RG5 then c_place3("movl", false_immediate, RG5) endif
enddefine;

define M_MOVEbit	= bitfield(%"extzv"%) enddefine;
define M_MOVEsbit	= bitfield(%"extv"%) enddefine;
define M_UPDbit		= bitfield(%"insv"%) enddefine;

define M_ASH		= replant(%"ashl"%) enddefine;
define M_NEG		= replant(%"mnegl"%) enddefine;
define M_LOGCOM		= replant(%"mcoml"%) enddefine;


define M_ERASE();
	lvars x = f_subv(2,m_instr);
	if auto_operand(x) then
		c_place2("tstl", x)
	endif;
enddefine;

define lconstant c_tst(x);
	lvars i, x;
	unless lasti and (f_hd(lasti) -> i, f_subv(datalength(i), i) = x)
	and not(auto_operand(x))
	then
		c_place2("tstl", x);
	;;; else last instruction has operand as destination, so flags already set
	endunless;
enddefine;

define M_TEST();
	c_tst(f_subv(2,m_instr));
	c_place2(test_opcode(f_subv(3,m_instr)), f_subv(4,m_instr));
enddefine;

define lconstant c_cmp(x, y, test, lab);
	lvars x, y, test, lab;
	if x == 0 and (test == "EQ" or test == "NEQ") then
		;;; turn it into a M_TEST
		c_tst(y)
	else
#_IF DEF VMS
		if test_move_G_opnd(x, RG3) then RG3 -> x endif;
#_ENDIF
		if x = false_immediate then R_FALSE -> x endif;
		c_place3("cmpl", x, y)
	endif;
	c_place2(test_opcode(test), lab);
enddefine;

define M_CMP();
	lvars x, y, test, lab;
	explode(m_instr) -> lab -> test -> y -> x ->;
	c_cmp(x, y, test, lab);
enddefine;

	;;; compare popints
constant procedure M_PCMP = M_CMP;

	;;; compare pointers -- same as integers for all types
define M_PTR_CMP();
	lvars x, y, test, lab;
	explode(m_instr) -> lab -> test -> y -> x -> /* type */ -> ;
	c_cmp(x, y, test, lab);
enddefine;

define c_bit_test(x, y, test, lab);
	lvars x, y, test, lab, bit;
	if x == 1 then
		c_place3(if test=="EQ" then "blbc" else "blbs" endif, y, lab);
	else
		if x = #_< 1 << (WORD_BITS-1) >_# then
			;;; testing on sign bit
			if test=="EQ" then "POS" else "NEG" endif -> test;
			c_tst(y);
		else
			c_place3("bitl", x, y);
		endif;
		c_place2(test_opcode(test), lab);
	endif
enddefine;

define M_BIT();
	c_bit_test(explode(m_instr)) -> ;
enddefine;

define M_CMPKEY();
	lvars x, test, lab, tlab, key, key_opnd;
	explode(m_instr) -> (, key, x, test, lab);
	unless regnumber(x) then
		c_move(x, RG0 ->> x)
	endunless;
	if test == "EQ" then genlab() else lab endif -> tlab;
	c_place3("blbs", x, tlab);
	{%x, field_##("KEY").wof%} -> key_opnd;
	if isintegral(key) then
		;;; testing flag(s) nonzero in K_FLAGS field
		c_move(key_opnd, RG0);
		c_bit_test(key, {%RG0, field_##("K_FLAGS").wof%}, negate_test(test),
																	lab)
	else
		;;; test for specific key
		c_cmp(key, key_opnd, test, lab)
	endif;
	if test == "EQ" then c_label(tlab) endif;
enddefine;

define M_BRANCH();
	lvars i;
	;;; see if redundant
	unless lasti and (f_hd(lasti) -> i; i(1) == "brw" or i(1) == "jmp") then
		c_place2("brw", f_subv(2, m_instr))
	endunless;
enddefine;

	;;; Branch instruction of standard size (3 bytes).
	;;; Using "brw\s" as the opcode prevents optimisation to "brb"
define M_BRANCH_std();
	c_place2("brw\s", f_subv(2, m_instr))
enddefine;

define M_BRANCH_ON();
	lvars opnd lab blab;
	m_instr(2) -> opnd;
	unless regnumber(opnd) then
		c_move(opnd, RG0 ->> opnd)
	endunless;
	c_place4("ashl", -2, opnd, RG1);
	c_place4("casel", RG1, 1, listlength(m_instr(3))-1);
	genlab() -> lab;
	c_label(lab);
	'-' <> lab -> lab;
	for blab in m_instr(3) do
		c_place2("\.word", blab<>lab);
	endfor;
	unless m_instr(4) then
		;;; if no "else" label, push arg back onto stack
		;;; (as argument to error procedure)
		c_move(opnd, -_USP);
	endunless;
enddefine;

define M_BRANCH_ON_INT();
	lvars lab blab;
	c_place4("casel", m_instr(2), 1, listlength(m_instr(3))-1);
	genlab() -> lab;
	c_label(lab);
	'-' <> lab -> lab;
	for blab in m_instr(3) do
		c_place2("\.word", blab<>lab);
	endfor;
enddefine;

define lconstant getexecop(opnd, is_subr) -> eopnd;
	lvars opnd, eopnd, is_subr;
	unless can_defer_opnd(opnd, 0, false) ->> eopnd then
		c_move(opnd, RG0);
		i_RG0 -> eopnd;
	endunless;
	unless is_subr then
		;;; pop procedure call (offset of PD_EXECUTE field is 0)
		getexecop(eopnd, true) -> eopnd
	endunless;
enddefine;

define lconstant pop_call_or_chain(opcode, alt);
	lvars opnd = f_subv(2,m_instr), lab, opcode, alt;
	if isref(opnd) then
		;;; constant
		fast_cont(opnd) -> opnd;
		execlabof(opnd, true) -> lab;
		if islabel(opnd) && LAB_OF_STRUCT /== 0
		and file_total_bytecount fi_< 16:4000 	;;; kludge for very big files
		then
			;;; defined in this file -- use "bsbw" or "brw"
			alt -> opcode
		endif
	else
		getexecop(opnd, false) -> lab
	endif;
	c_place2(opcode, lab)
enddefine;

	;;; {<op> <pdr_opnd>}
define M_CALL	= pop_call_or_chain(%"jsb", "bsbw"%) enddefine;
define M_CHAIN	= pop_call_or_chain(%"jmp", "brw"%) enddefine;

	;;; {M_CALL_WITH_RETURN <pdr_opnd> <return addr>}
define M_CALL_WITH_RETURN();
	c_place2("pushl", f_subv(3,m_instr));	;;; push return address
	M_CHAIN()								;;; chain to procedure
enddefine;

define lconstant subr_call_or_chain(opcode);
	lvars opcode;
	c_place2(opcode, getexecop(f_subv(2,m_instr), true))
enddefine;

	;;; {M_CALLSUB <subroutine_opnd> <upto 3 args to go in regs>}
	;;; (subroutine is always a constant when reg args present)
define M_CALLSUB();
	lvars l = datalength(m_instr);
	if l  ==   5 then c_move(f_subv(3,  m_instr), RG2) endif;	;;; arg_reg_2
	if l fi_>= 4 then c_move(f_subv(l-1,m_instr), RG1) endif;	;;; arg_reg_1
	if l fi_>= 3 then c_move(f_subv(l,  m_instr), RG0) endif;	;;; arg_reg_0
	subr_call_or_chain("jsb")
enddefine;

	;;; {M_CHAINSUB <subroutine_opnd>}
define M_CHAINSUB	= subr_call_or_chain(%"jmp"%) enddefine;

define M_LABEL();
	"label" -> f_subv(1,m_instr);
	c_placei(m_instr);
enddefine;

	;;; {M_CLOSURE <frozvals> <pdpart opnd>}
define M_CLOSURE();
	lvars nfroz, (, frozvals, pdpart_opnd) = explode(m_instr);
	;;; code to push frozvals
	listlength(frozvals) -> nfroz;

	if nfroz fi_> 16 then
		;;; just give clos to Exec_closure
		c_place3("moval", pdr_index_opnd(0), -_USP);
		;;; use absolute addressing mode so it can be copied
		c_place2("jmp", @#_s <> execlabof(perm_const_lab([Sys Exec_closure]),
												true));
		return
	elseif nfroz == 1 then
		c_move(pdr_index_opnd(field_##("PD_CLOS_FROZVALS")), -_USP)
	elseunless nfroz == 0 then
		c_place3("moval", pdr_index_opnd(field_##("PD_CLOS_FROZVALS")), RG0);
		repeat nfroz times
			c_move(RG0_+, -_USP);
		endrepeat;
	endif;

	;;; code to chain pdpart -- if closure is non-writeable, pdpart_opnd
	;;; is an immediate operand for the pdpart procedure
	{%M_CHAIN, if pdpart_opnd then pdpart_opnd
			   else pdr_index_opnd(field_##("PD_CLOS_PDPART"))
			   endif%} -> m_instr;
	M_CHAIN()
enddefine;

	;;; {M_SETSTKLEN <offset of stack increase> <popint saved stklen opnd>}
	;;; offset is always a constant integer
define M_SETSTKLEN();
	lvars sl_opnd, offs, lab;
	explode(m_instr) -> sl_opnd -> offs -> ;
	;;; userhi - popint stklen -> r0
	c_place4("subl3", sl_opnd, identlabel("\^_userhi"), RG0);
	;;; d0 - (offs-3) -> d0 = desired value of USP
	;;; (-3 accounts for the popint bits in sl_opnd)
	c_place3(if offs == 0 then "addl2", 3 else "subl2", offs-3 endif, RG0);
	c_place3("cmpl", RG0, USP);
	c_place2("beql", genlab()->>lab);
	c_place2("jsb", perm_const_lab([\^_setstklen_diff]));
	c_label(lab)
enddefine;


;;; --- PROLOG INSTRUCTIONS ----------------------------------------------

	;;; {M_PLOG_IFNOT_ATOM <ifnot_lab>}
	;;; (follows a call of _prolog_unify_atom)
define M_PLOG_IFNOT_ATOM();
	c_place2("bneq", f_subv(2,m_instr))
enddefine;

	;;; {M_PLOG_TERM_SWITCH <fail_lab> <var_lab> <dst for drop thru case>}
	;;; (follows a call of _prolog_pair_switch/_prolog_term_switch)
define M_PLOG_TERM_SWITCH();
	c_place2("bgtr", f_subv(3,m_instr));	;;; var_lab if greater than
	c_place2("blss", f_subv(2,m_instr));	;;; fail_lab if less than
	;;; else deref'ed pair/term in arg_reg_0 (r0)
	c_move(RG0, f_subv(4,m_instr))
enddefine;


;;; --- CREATE/UNWIND STACK FRAME ----------------------------------------

lblock

lvars	Ndlocals, Nstkvars, regmask,
	;

	;;; {M_CREATE_SF <reg_locals> <Npopreg> <Nstkvars> <Npopstkvars>
	;;;								<dlocal_labs> <ident reg_spec> }
	;;; Generate code to construct stack frame -- this sets up values
	;;; to be used by later M_UNWIND_SF.
define M_CREATE_SF();
	lvars n, l, bit, npstk, reg_spec_id, dlocal_labs, Npopstkvars, Npopregs,
		reg_locals;

	explode(m_instr) -> reg_spec_id -> dlocal_labs
					-> Npopstkvars -> Nstkvars -> Npopregs -> reg_locals -> ;

	listlength(dlocal_labs) -> Ndlocals;

	;;; create register mask from reg locals
	0 -> regmask;
	fast_for n in reg_locals do regmask || (1 << n) -> regmask endfast_for;

	;;; Reg spec to go in PD_REGMASK is switch offset to 20-byte register
	;;; save/restore code section (see aprocess.s).
	;;; This is returned in idval(reg_spec_id)
	( (listlength(reg_locals)-Npopregs) * listlength(pop_registers)
							+ Npopregs ) * 20 ->  idval(reg_spec_id);

	;;; registers
	11 -> n;
	1 << n -> bit;
	until n==5 do
		if regmask &&/=_0 bit then
			c_place2("pushl", reglabel(n));
		endif;
		bit >> 1 -> bit;
		n-1 -> n;
	enduntil;
	;;; dynamic locals
	if Ndlocals == 1 then
		c_place2("pushl", conspair(pdr_index_opnd(field_##("PD_TABLE")), 0));
	elseunless Ndlocals == 0 then
		c_place3("moval", pdr_index_opnd(field_##("PD_TABLE")), RG0);
		Ndlocals*4 -> l;					;;; stack locals
		for 0->n step n+4->n till n >= l then
			c_place2("pushl", i_RG0_+);
		endfor;
	endif;
	;;; stack-allocated locals
	repeat Npopstkvars times				;;; pop ones - have to be initialised
		c_place2("pushl", popint(0));
	endrepeat;
	if (Nstkvars - Npopstkvars ->> npstk) /== 0 then
		;;; some nonpop ones
		c_place3("subl2", npstk.wof, SP)
	endif;
	;;; owner address
	c_place2("pushal", current_pdr_label);
enddefine;

	;;; {M_UNWIND_SF}
	;;; generate code to unwind stack frame (musn't use CHAIN_REG = R4)
	;;; Uses lvar values set up by previous M_CREATE_SF
define M_UNWIND_SF();
	lvars n, l, bit;
	;;; remove owner and stack vars
	c_place3("addl2", (Nstkvars+1).wof, SP);

	;;; restore dynamic locals
	field_##("PD_TABLE") -> l;
	l + Ndlocals -> n;
	while n > l do
		n - 1 -> n;
		c_move(SP_+, conspair(pdr_index_opnd(n), 0))	;;; restore locals
	endwhile;

	;;; restore registers
	6 -> n;
	1 << n -> bit;
	until n == 12 do
		if regmask &&/=_0 bit then
			bit << 1 -> bit;
			if regmask && bit /== 0 then
				c_place3("movq", SP_+, reglabel(n));
				bit << 1 -> bit;
				n+1 -> n;
			else
				c_move(SP_+, reglabel(n));
			endif;
		else
			bit << 1 -> bit;
		endif;
		n+1 -> n;
	enduntil
enddefine;

endlblock;

	;;; return from procedure
define M_RETURN();
	c_place("rsb", 1);
enddefine;

	;;; end of codelist
define M_END = identfn(%%) enddefine;


	;;; translate M-code to VAX assembler
define lconstant c_translate(clist) -> ilist;
	lvars opcode, clist;
	dlocal m_codelist, m_instr, ilist, lasti = false;
	c_label(current_pdr_exec_label);				;;; execute label
	fast_for m_codelist on clist do
		f_hd(m_codelist) -> m_instr;
		if isprocedure(f_subv(1, m_instr) ->> opcode) then
			opcode()
		else
			mishap(opcode, 1, 'UNKNOWN M-OPCODE');
		endif;
	endfast_for;
enddefine;


;;; --- DEAL WITH CONDITIONAL BRANCH INSTRUCTIONS -----------------------------

lconstant procedure
	negate_test_opcode =
		newassoc([
			[beql	bneq]  [bneq   beql]
			[blss	bgeq]  [bleq   bgtr]  [bgtr	  bleq]	 [bgeq	 blss]
			[blssu bgequ]  [blequ bgtru]  [bgtru blequ]	 [bgequ blssu]
			[bvs	 bvc]  [bvc		bvs]
			[blbs	blbc]  [blbc   blbs]
		]);

lvars bytecount, forward_count = false;

	;;; compute the size of an instruction in bytes
	;;; (at least, an upper bound for it - which is all condbr needs)
define lconstant countinst(inst);
	lvars n, opcode, inst;

	define lconstant countop(opnd);
		lvars opnd, spec, deferred;
		if regnumber(opnd) then
			1
		elseif isintegral(opnd) then
			if isinteger(opnd) and -1 fi_< opnd and opnd fi_< 64 then
				1
			else
				5
			endif
		else
			false -> deferred;
			if ispair(opnd) then
				true -> deferred; fast_front(opnd) -> opnd;
			endif;
			if isref(opnd) or isstring(opnd) then
				;;; immediate/abs
				5
			else
				;;; must be a vector, i.e. register displacement
				opnd(2) -> spec;
				if isboolean(spec) or (spec == 0 and not(deferred)) then
					;;; auto inc/dec or reg indirect
					1
				else
					;;; reg displacement
					2
				endif
			endif
		endif fi_+ bytecount -> bytecount
	enddefine;

	lconstant
		byte_br_opcodes = [brb blbs blbc beql bneq blss bleq
								bgtr bgeq blssu blequ bgtru bgequ bvs bvc],
		word_br_opcodes = [bsbw brw brw\s];

	f_subv(1,inst) -> opcode;
	returnif(opcode == "label");
	if fast_lmember(opcode, byte_br_opcodes) then
		if forward_count then
			;;; allow for short branch around a brw
			bytecount fi_+ 5 -> bytecount
		else
			bytecount fi_+ 2 -> bytecount	;;; 1 + byte displacement
		endif;
		if opcode == "blbs" or opcode == "blbc" then
			countop(f_subv(2,inst))
		endif
	elseif fast_lmember(opcode, word_br_opcodes) then
		bytecount fi_+ 3 -> bytecount		;;; 1 + word displacement
	else
		bytecount fi_+ 1 -> bytecount;		;;; count opcode
		fast_for n from 2 to datalength(inst) do
			countop(f_subv(n,inst))
		endfast_for
	endif
enddefine;

define lconstant findlab(lab, clist, pdr);
	lvars x, clist, list, lab, procedure pdr;
	repeat
		f_dest(clist) -> list -> x;
		quitif(f_subv(1,x)=="label" and f_subv(2,x)==lab);
		pdr(x);
		list -> clist;
		if clist==[] then return(false) endif;
	endrepeat;
	clist;
enddefine;

define lconstant condbr(org_codelist);
	lvars l, inst, lab, lab2, info, opcode, org_codelist;
	dlocal bytecount, forward_count;
	f_hd(m_codelist) -> inst;
	f_subv(1, inst) -> opcode;
	inst(datalength(inst)) -> lab;				;;; the label to find
	islabel(lab) -> info;
	unless negate_test_opcode(opcode)
	or (opcode == "brw" and info && LAB_PROC_INNER /== 0) then
		return
	endunless;
	0 -> bytecount, true -> forward_count;
	if info && LAB_BACKWARD /== 0				;;; definitely backward
	or not(findlab(lab,f_tl(m_codelist),countinst))
	then
		returnunless(findlab(lab,org_codelist,erase) ->> l);
		f_tl(l) -> l;
		0 -> bytecount, false -> forward_count;
		until l == m_codelist do
			countinst(f_dest(l) -> l)
		enduntil;
		countinst(inst)
	endif;
	if opcode == "brw" then
		if bytecount <= 127 then "brb" -> f_subv(1, inst) endif;
	elseif bytecount > 127 then					;;; pity
		negate_test_opcode(opcode) -> f_subv(1, inst);		;;; reverse test
		;;; make it br round brw
		genlab() ->> lab2 -> f_subv(datalength(inst), inst);
		{brw ^lab} :: ({label ^lab2} :: f_tl(m_codelist))
									->> f_tl(m_codelist) -> m_codelist
	endif
enddefine;

define lconstant docondbr(m_codelist) -> org_codelist;
	lvars org_codelist = m_codelist;
	dlocal m_codelist;
	until m_codelist == [] do
		condbr(org_codelist);
		f_tl(m_codelist) -> m_codelist
	enduntil
enddefine;


;;; --- CODE OUTPUT ----------------------------------------------------------

define lconstant outopnd(opnd, opcode);
	lvars opnd, reg, dis, opcode;

	if ispair(opnd) then
		asmf_charout(@_c), fast_front(opnd) -> opnd
	endif;
	if isintegral(opnd) then
		opnd, #_c, '%c%p'
	elseif isref(opnd) then
		fast_cont(opnd), #_c, '%c%p'
	elseunless isvector(opnd) then
		opnd, '%p'
	else
		opnd(1) -> reg;
		opnd(2) -> dis;
		if isboolean(dis) then
			reg, if dis then '(%p)+' else '-(%p)' endif
		elseif dis == 0 then
			reg, '(%p)'
		else
			reg, dis, '%p(%p)'
		endif
	endif;
	asmf_printf()
enddefine;

define lconstant outinst(inst);
	lvars n, l, opcode, inst;
	f_subv(1, inst) -> opcode;
	if opcode=="label" then outlab(f_subv(2,inst)); return endif;
	asmf_printf(opcode, '\t%p\t');
	datalength(inst) -> l;
	for n from 2 to l-1 do
		outopnd(f_subv(n, inst), opcode);
		asmf_charout(`,`)
	endfor;
	unless l == 1 then outopnd(f_subv(l, inst), opcode) endunless;
	asmf_charout(`\n`);
	;;; accumulate in total code length
	countinst(inst)
enddefine;


;;; --- GENERATING CODE ----------------------------------------------------

	/*	Generate assembler code for a procedure -- called by m_trans
		The global variables
			current_pdr_label, current_pdr_exec_label
		contain the current procedure's label and start-of-code label
		-hdr_len- is the length in words preceding the code.
	*/
define mc_code_generator(codelist, hdr_len) -> pdr_len -> gencode;
	lvars codelist, endlab, hdr_len, pdr_len;
	lconstant procedure gencode;

	;;; process codelist
	c_translate(codelist) -> codelist;	;;; translate to VAX assembler
	docondbr(codelist) -> codelist;		;;; deal with relative branches

	genlab() -> endlab;
	;;; procedure length in (long)words
#_IF DEF VMS
	'<<' <> endlab <> '-' <> current_pdr_exec_label <> '>@-2>+'
#_ELSEIF DEF BERKELEY
	'((' <> endlab <> '-' <> current_pdr_exec_label <> ')>>2)+'
#_ENDIF
											sys_>< hdr_len -> pdr_len;

	;;; produce code generator
	define lconstant gencode();
		dlocal bytecount = 0;		;;; accumulates rough code length
		applist(codelist, outinst);					;;; produce output code
#_IF DEF VMS
		outcode('.align long');						;;; align end of procedure
#_ELSEIF DEF BERKELEY
		outcode('.align 2');						;;; align end of procedure
#_ENDIF
		outlab(endlab);								;;; end label

		file_total_bytecount + (hdr_len<<2) + bytecount -> file_total_bytecount
	enddefine
enddefine;



;;; --- OTHER DEFINITIONS NEEDED BY m_trans.p ---------------------------


	/*	M-code tables for machine-dependent in-line subroutines.
		These are added to the corresponding properties in m_trans.p
	*/
constant

	mc_inline_procs_list = [
	[ \^_ptr_to_offs	[{^M_ERASE ^USP_+}]]		;;; erases type, leaves ptr
	[ \^_offs_to_ptr	[{^M_ERASE ^USP_+}]]		;;; erases type, leaves ptr
	[ \^_int			[{^M_ASH -2 ^USP_+ ^ -_USP}]]
	[ \^_pint			[{^M_ASH  2 ^USP_+ ^ -_USP} {^M_ADD 3 ^USP_+ ^ -_USP}]]
	[ \^_por			[{^M_BIS ^USP_+ ^USP_+ ^ -_USP}]]
	[ \^_pand			[{^M_BIM ^USP_+ ^USP_+ ^ -_USP}]]
	[ \^_mksimple		[{^M_ADD 1 ^USP_+ ^ -_USP}]]
	[ \^_mkcompound		[{^M_SUB 1 ^USP_+ ^ -_USP}]]
	[ \^_mksimple2		[{^M_ADD 3 ^USP_+ ^ -_USP}]]
	[ \^_mkcompound2	[{^M_SUB 3 ^USP_+ ^ -_USP}]]
	],

	mc_inline_conditions_list = [
	[ \^_iscompound		{^M_BIT	 2:01	^USP_+ EQ  ?}	]
	[ \^_issimple		{^M_BIT	 2:01	^USP_+ NEQ ?}	]
	[ \^_issimple2		{^M_BIT	 2:10	^USP_+ NEQ ?}	]
	[ \^_isinteger		{^M_BIT	 2:10	^USP_+ NEQ ?}	]
	[ \^_isaddress		{^M_BIT	 2:11	^USP_+ EQ  ?}	]
	],
;


	/*	Procedure to convert a pop integer subscript to an appropriate offset
		for the data type being accessed, used by OP_SUBV in m_trans.p to
		compile code for fast_subscrv, vectorclass field accesses, etc.
			-scale- is the scale for the data type involved; the results are
		the M-code instructions (if any) necessary to convert the subscript
		on top of the stack to an offset, plus a constant correction to be
		added.
	*/
define cvt_pop_subscript(scale);
	lvars pow, scale;
	if is_power2(scale) ->> pow then
		;;; pow-2 accounts for popint being shifted left 2
		unless (pow-2 ->> pow) == 0 then
			{^M_ASH ^pow ^USP_+ ^ -_USP}
		endunless,
		-(popint(0) << pow)		;;; additive correction to remove popint bits
	else
		;;; just convert to sysint and multiply
		{^M_ASH -2 ^USP_+ ^ -_USP},		;;; _int()
		{^M_MULT ^scale ^USP_+ ^ -_USP},
		0 						;;; no correction necessary
	endif
enddefine;


endsection;		/* Genproc */

endsection;		/* $-Popas$-M_trans */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Aug  5 1995
		Fixed problem in M_UNWIND_SF brought about by the introduction of extra
		entries for dlocal active vars at the end of PD_TABLE (was assuming
		that the ordinary dlocal ids were always at the end of PD_TABLE)
--- John Gibson, Aug 31 1994
		Removed M_AR*RAY_SUB (no longer necessary)
--- John Gibson, Sep  1 1993
		Added dirty kludge to pop_call_or_chain to stop "bsbw" being used
		when branch offset may be bigger than 16 bits in very big files
--- John Gibson, Sep 28 1992
		Changed M_CLOSURE to call Exec_closure for more than 16 frozvals
--- John Gibson, Jan  8 1992
		Added _por and _pand to mc_inline_procs_list
--- John Gibson, Jan  2 1992
		Changed M_CMPKEY to allow key arg to be an integer specifying
		flag(s) to be tested in K_FLAGS field
--- John Gibson, Sep 29 1990
		Changed value for PD_REGMASK to be switch offset for code in aprocess.s
--- John Gibson, Jan 11 1990
		Added -hdr_len- arg to -mc_code_generator- and corrected
		procedure length expression for new pointers
--- John Gibson, Nov 28 1989
		Now assumes R_FALSE = r5 contains address of <false> instead of
		being zero.
--- John Gibson, Jun  7 1989
		Included common.ph
--- John Gibson, May 17 1989
		Changed all references to subroutine names to begin with \^_
		(Ctrl-_) instead of _.
		Replaced all uses of @ and @@ with calls to field_## on the
		name of the field (converted to word offset where necessary).
		-pdr_offset_opnd- replaced by -pdr_index_opnd-, which now takes
		a pop integer index instead of a sysint offset.
--- John Gibson, Apr 26 1989
		Added M_SETSTKLEN, M_PLOG_IFNOT_ATOM and M_PLOG_TERM_SWITCH.
		Changed M_CALLSUB to include any register arguments as part of the
		instruction; removed references to ARG_REG_0.
--- John Gibson, Mar 23 1989
		-addr_add_pop_subscr- replaced with -cvt_pop_subscript-
--- John Gibson, Feb 15 1989
		Added M_AR*RAY_SUB
--- John Gibson, Feb 13 1989
		Improved interface from m_trans.p:
			Now only one code-generating procedure -mc_code_generator-,
		closure code being dealt with by the M_CLOSURE instruction.
			Additional procedure -pdr_index_opnd- required by m_trans
		for references to words in procedure header data
--- John Gibson, Nov 23 1988
		Corrected problem in -docondbr- where forward byte-displacement
		branch instructions were not correctly turned into 'compound'
		branches (i.e. branch around a "brw"), where the destination is too
		far away for a byte displacement.
--- John Gibson, Aug  2 1988
		Changed bitfield procedures to cope with revised format
		bitfield M-instructions.
--- John Gibson, Feb 18 1988
		Got rid of -small_address_structs-
--- John Gibson, Feb  5 1988
		Replaced use of -syssynonym- with -identof-, etc
--- John Gibson, Oct 28 1987
		For VMS, added test for external routine address being used in M_CMP
		(necessitates use of G^ addressing mode)
--- John Gibson, Aug 27 1987
		Added M-code for _mksimple2, _mkcompound2, _issimple2 (needed for
		new non-copying garbage collector)
--- John Gibson, Aug 16 1987
		Substituted use of global vars with lvars
 */
