/* --- Copyright University of Sussex 1997. All rights reserved. ----------
 * File:	S.vaxunix4.2/src/amisc.s
 * Purpose:	Miscellaneous assembler routines
 * Author:	John Gibson (see revisions)
 */

#_<

#_INCLUDE 'declare.ph'

vars
	_call_stack_lim, _plog_trail_sp, _plog_trail_lim
	;

section $-Sys;

constant
	procedure (Call_overflow, User_overflow, Callstack_reset,
	Conspair, Plog$-Area_overflow, Async_raise_signal)
	;

endsection;

lconstant macro (
	_KEY		= @@KEY,
	_K_APPLY	= @@K_APPLY,
	_RF_CONT	= @@RF_CONT,
	_PD_EXECUTE	= @@PD_EXECUTE,
	_PD_EXIT	= @@PD_EXIT,
	_PD_FRAME_LEN	= @@PD_FRAME_LEN,
	_PD_UPDATER	= @@PD_UPDATER,
	_P_BACK		= @@P_BACK,
	_P_FRONT	= @@P_FRONT,
	_SF_OWNER	= @@SF_OWNER,
	_V_BYTES	= @@V_BYTES,
	);

>_#

/********************* wrapping structures ***********************************/

	.text
	.long	Ltext_end-Ltext_start, C_LAB(Sys$-objmod_pad_key)
Ltext_start:
	.data
	.long	Ldata_end-Ldata_start, C_LAB(Sys$-objmod_pad_key)
Ldata_start:

/**************************************************************************/

	.text

;;;----------------------------------------------------------------------------
	;;; executing a poplog object in ARG_REG_0 = r0

	;;; normal checking entry
	.align 2
DEF_C_LAB (_popenter)
	blbs	r0, 1f				;;; br if number
	cmpl	_KEY(r0), $C_LAB(procedure_key)	;;; is it a proc?
	bneq	3f				;;; br if not
	jmp	*_PD_EXECUTE(r0)		;;; go straight in to procedure

	;;; applying a number
1:	movl	r0, -(ap)
	movl	C_LAB(integer_key)+_K_APPLY, r1	;;; (in a ref)
	bbs	$1, r0, 2f		 	;;; br if integer
	movl	C_LAB(weakref decimal_key)+_K_APPLY, r1 ;;; (in a ref)
2:	movl	_RF_CONT(r1), r1		;;; the procedure
	jmp	*_PD_EXECUTE(r1)

	.align 2
	;;; applying a structure - run key apply procedure
3:	movl	r0, -(ap)
	movl	_KEY(r0), r1
	movl	_K_APPLY(r1), r1		;;; key apply proc (in a ref)
	movl	_RF_CONT(r1), r1		;;; the procedure
	jmp	*_PD_EXECUTE(r1)


;;; --- CHECKS ON PROCEDURE ENTRY -----------------------------------------

	.align 2
DEF_C_LAB (_checkplogall)
	moval	C_LAB(_special_var_block), r1
	cmpl	_SVB_OFFS(_plog_trail_sp)(r1), _SVB_OFFS(_plog_trail_lim)(r1)
	blssu	checkall_cmp
	jmp	XC_LAB(weakref[prologvar_key] Sys$-Plog$-Area_overflow)

	.align 2
DEF_C_LAB (_checkall)
	;;; do checks
	moval	C_LAB(_special_var_block), r1
checkall_cmp:
	cmpl	sp, _SVB_OFFS(_call_stack_lim)(r1)
	blssu	3f				;;; br if call stack too long
	cmpl	ap, _SVB_OFFS(_userlim)(r1)
	blssu	4f				;;; br if user stack too long
1:	blbs	_SVB_OFFS(_trap)(r1), 5f	;;; br if signals pending
2:	rsb					;;; return to pdr if not

3:	bbs	$1, I_LAB(_disable), 1b		;;; continue if stk checks disabled
	jmp	XC_LAB(Sys$-Call_overflow)	;;; if call stk overflow
4:	bbs	$1, I_LAB(_disable), 1b		;;; continue if stk checks disabled
	jmp	XC_LAB(Sys$-User_overflow)	;;; if user stk overflow
5:	blbs	I_LAB(_disable), 2b		;;; return if signals disabled
	jmp     XC_LAB(Sys$-Async_raise_signal) ;;; chain to raise async signal

	.align 2
DEF_C_LAB (_checkinterrupt)
	blbs	I_LAB(_trap), C_LAB(_checkall)	;;; br if signals pending
	rsb					;;; return if not



;;;---------------------------------------------------------------------------
	.align 2

	;;; Unwind the current stack frame, by jumping into the procedure's
	;;; exit code. This subroutine is called immediately after executing
	;;; an M_UNWIND operation, so that the (unwanted) return address into
	;;; the procedure being unwound is above this subroutine's return
	;;; address on the call stack.
	;;;	The procedure's exit code finishes with an "rsb", and we
	;;; replace the return address into the NEXT caller with the return from
	;;; this subroutine, but saving the former in CHAIN_REG (= r4) from
	;;; whence it can be restored with an M_CALL_WITH_RETURN operation.
DEF_C_LAB (_unwind_frame)
	movl	8(sp), r0		;;; caller procedure
	movzbl	_PD_FRAME_LEN(r0), r1	;;; stack frame length
	moval	4(sp)[r1], r2		;;; addr of return addr into NEXT caller
	movl	(r2), r4		;;; save in CHAIN_REG
	movl	(sp), (r2)		;;; replace with my return
	addl2	$8, sp			;;; erase my return and unwanted return
	jmp	*_PD_EXIT(r0)		;;; go into procedure exit code

;;;-------------------------------------------------------------------------

	.align 2
	;;; Routines to chain a procedure, either directly or out of the
	;;; current caller. These are executed as a result of displacing a stack
	;;; frame return address with their address and then returning with an
	;;; "rsb"; in the case of _syschain, the displaced return is saved in
	;;; CHAIN_REG.
DEF_C_LAB (_syschain_caller)
	subl2	$4, sp		;;; need dummy return address for _unwind_frame
	bsbb	C_LAB(_unwind_frame)	;;; pop frame for caller
DEF_C_LAB (_syschain)
	pushl	r4		;;; reinstate return address from CHAIN_REG
	movl	(ap)+, r0	;;; procedure to chain on user stack
	brw	C_LAB(_popenter) ;;; run it

	.align 2
	;;; The same, but with no check for procedure
DEF_C_LAB (_sysncchain_caller)
	subl2	$4, sp		;;; need dummy return address for _unwind_frame
	bsbb	C_LAB(_unwind_frame)	;;; pop frame for caller
DEF_C_LAB (_sysncchain)
	pushl	r4		;;; reinstate return address from CHAIN_REG
	movl	*(ap)+, r0	;;; get exec address (_PD_EXECUTE offset = 0)
	jmp	(r0)		;;; run it


;;;----------------------------------------------------------------------------
	.align 2

	;;; call updater of pop procedure in ARG_REG_0 = r0
DEF_C_LAB (_popuenter)
	blbs	r0, upnum		;;; br if not pointer
	cmpl	_KEY(r0), $C_LAB(procedure_key) ;;; procedure?
	bneq	upstr			;;; br if not

DEF_C_LAB (_popuncenter)
	;;; test updater
	movl	_PD_UPDATER(r0), r1	;;; get the updater
	cmpl	r5, r1
	beql	upexc			;;; br if updater false

	;;; ok, so call it
	jmp	*_PD_EXECUTE(r1)

	;;; updater false
upexc:	movl	r0, -(ap)		;;; give as argument
	jmp	XC_LAB(-> Sys$-Exec_nonpd) ;;; to updater exception proc

	;;; applying a number as updater
upnum:	movl	C_LAB(integer_key)+_K_APPLY, r1
	bbs	$1, r0, upkapp			;;; br if integer
	movl	C_LAB(weakref decimal_key)+_K_APPLY, r1
	brb	upkapp

	;;; applying non-procedure structure as updater
upstr:	movl	_KEY(r0), r1
	movl	_K_APPLY(r1), r1	;;; key apply proc (in a ref)
upkapp: movl	_RF_CONT(r1), r1	;;; the procedure
	movl	_PD_UPDATER(r1), r1	;;; get the updater
	cmpl	r5, r1
	beql	upexc			;;; br if false
	movl	r0, -(ap)
	jmp	*_PD_EXECUTE(r1)	;;; run the updater

;;;----------------------------------------------------------------------------

	;;; erase 1 longword from the call stack and chain Callstack_reset
	;;; (used by Callstack_reset in cleaning up)
DEF_C_LAB (_erase_sp_1)
	movl	(sp)+, (sp)			;;; push return address up one
	jmp	XC_LAB(Sys$-Callstack_reset)	;;; try again

;;;----------------------------------------------------------------------------

	.align 2
	;;; get next stack frame - pointer assumed to point at owner
DEF_C_LAB (_nextframe)
	movl	(ap), r0		;;; frame pointer
	movl	_SF_OWNER(r0), r1	;;; owner address
	movzbl	_PD_FRAME_LEN(r1), r2	;;; frame size
	moval	(r0)[r2], (ap)		;;; pointer to next owner
	rsb

;;;----------------------------------------------------------------------------

	.align 2
	;;; fast routines for subscrs and its updater

DEF_C_LAB (_subss)
	movl	(ap)+, r0			;;; string address
	ashl	$-2, (ap), r1			;;; pop integer subscript
	movzbl	_V_BYTES-1(r0)[r1], r1		;;; get the byte
	ashl	$2, r1, r1			;;; convert to popint
	bisl3	$3, r1, (ap)
	rsb

	.align 2
DEF_C_LAB (-> _subss)
DEF_C_LAB (_u_subss)
	movl	(ap)+, r0			;;; string address
	ashl	$-2, (ap)+, r1			;;; popint subscript
	ashl	$-2, (ap)+, r2			;;; convert byte to sysint
	movb	r2, _V_BYTES-1(r0)[r1]		;;; insert byte
	rsb

;;;----------------------------------------------------------------------------

	;;; boolean functions
	.align 2
DEF_C_LAB (_iscompound)
	blbc	(ap), true1
	brb	false1

	.align 2
DEF_C_LAB (_issimple)
	blbs	(ap), true1
	brb	false1

	.align 2
DEF_C_LAB (_isinteger)
	bbs	$1, (ap), true1
	brb	false1

	.align 2
DEF_C_LAB (_haskey)
	movl	(ap)+, r0	;;; the key
	movl	(ap), r1	;;; the object
	blbs	r1, false1	;;; br if popnum
	cmpl	r0, _KEY(r1)
	beql	true1
	brb	false1

	.align 2
DEF_C_LAB 4 (_bitst)
	bitl	(ap)+, (ap)
	bneq	true1
	brb	false1

	.align 2
false1:
	movl	r5, (ap)
	rsb

	.align 2
true1:
	moval	C_LAB(true), (ap)
	rsb

	.align 2
DEF_C_LAB 6 (_gr)
	cmpl	(ap)+, (ap)
	blssu	true1
	brb	false1

	.align 2
DEF_C_LAB 6 (_greq)
	cmpl	(ap)+, (ap)
	blequ	true1
	brb	false1

	.align 2
DEF_C_LAB 6 (_lt)
	cmpl	(ap)+, (ap)
	bgtru	true1
	brb	false1

	.align 2
DEF_C_LAB 6 (_lteq)
	cmpl	(ap)+, (ap)
	bgequ	true1
	brb	false1

	.align 2
DEF_C_LAB 6 (_sgr)
	cmpl	(ap)+, (ap)
	blss	true1
	brb	false1

	.align 2
DEF_C_LAB 6 (_sgreq)
	cmpl	(ap)+, (ap)
	bleq	true1
	brb	false1

	.align 2
DEF_C_LAB 6 (_slt)
	cmpl	(ap)+, (ap)
	bgtr	true1
	brb	false1

	.align 2
DEF_C_LAB 6 (_slteq)
	cmpl	(ap)+, (ap)
	bgeq	true1
	brb	false1

	.align 2
DEF_C_LAB (_not)
	cmpl	r5, (ap)
	beql	true1
	brb	false1

	.align 2
DEF_C_LAB 7 (_neq)
	cmpl	(ap)+, (ap)
	bneq	true1
	brb	false1

	.align 2
DEF_C_LAB 7 (_eq)
	cmpl	(ap)+, (ap)
	beql	true1
	brb	false1

	.align 2
DEF_C_LAB (_zero)
	tstl	(ap)
	beql	true1
	brb	false1

	.align 2
DEF_C_LAB (_neg)
	tstl	(ap)
	blss	true1
	brb	false1

;;;----------------------------------------------------------------------------

	.align 2
	;;; get the key of any pop object
DEF_C_LAB (_datakey)
	movl	(ap), r0		;;; the object
	blbs	r0, 1f			;;; br if not pointer
	movl	_KEY(r0), (ap)		;;; the key from the record
	rsb
1:	bbc	$1, r0, 2f		;;; br if decimal
	movl	$C_LAB(integer_key), (ap)		;;; integer
	rsb
2:	movl	$C_LAB(weakref decimal_key), (ap)	;;; decimal
	rsb

;;;----------------------------------------------------------------------------

	.align 2
	;;; optimise subroutine for "conspair"
DEF_C_LAB (_conspair)
	movl	I_LAB(Sys$- _free_pairs), r0	;;; get free pair list
	blbs	r0, 1f			;;; if simple, then none left
	movl	_P_BACK(r0), I_LAB(Sys$- _free_pairs) ;;; move the next back to _free_pairs
	movl	(ap)+, _P_BACK(r0)	;;; init back
	movl	(ap), _P_FRONT(r0)	;;; init front
	movl	r0, (ap)		;;; return the pair
	rsb
1:	jmp	XC_LAB(Sys$-Conspair)	;;; none left, chain to Conspair

;;;----------------------------------------------------------------------------

	.align 2
	;;; search/skip string for character
DEF_C_LAB (_locc)
	movq	(ap)+, r0	;;; r0=char, r1=string length
	locc	r0, r1, *(ap)
	bneq	1f		;;; br if found
	mnegl	$1, (ap)	;;; return -1 if not found
	rsb
1:	subl3	(ap), r1, (ap)	;;; return offset to char
	rsb

	.align 2
DEF_C_LAB (_skpc)
	movq	(ap)+, r0	;;; r0=char, r1=string length
	skpc	r0, r1, *(ap)
	bneq	1f		;;; br if something else found
	mnegl	$1, (ap)	;;; return -1 if nothing else found
	rsb
1:	subl3	(ap), r1, (ap)	;;; return offset to char
	rsb


;;;--------------------------------------------------------------------------

	;;; move the user stack up or down
DEF_C_LAB (_move_userstack)
	movl	(ap)+, r2		;;; amount to shift in bytes
	subl3	ap, I_LAB(_userhi), r0	;;; length of u/s to move
	movl	ap, r1			;;; u/s top - moving from here
	addl2	r2, I_LAB(_userhi)	;;; new userhi
	addl2	ap, r2			;;; where moving to
	movl	r2, ap			;;; correct ap
	jmp	movchars		;;; move the user stack and return

;;;-------------------------------------------------------------------------

	;;; Set registers for pop environment
.globl reset_pop_reg_environ
reset_pop_reg_environ:
	;;; set constant registers
	moval	C_LAB(false), r5	;;; r5 must always be false
	;;; set pop lvar registers to sensible values (false)
	movl	r5, r6
	movl	r5, r7
	rsb

/*************** end labels for wrapping structures **************************/

	.text
Ltext_end:
	.data
Ldata_end:

/**************************************************************************/



/* --- Revision History ---------------------------------------------------
--- John Gibson, Feb 10 1997
	Removed _mt*chc subroutine
--- John Gibson, Oct 18 1994
	free*pairs -> _free_pairs
--- John Gibson, Nov 10 1993
	Renamed amisc.s and moved the main routine to amain.s
--- John Gibson, Oct  2 1992
	Got rid of _c*mpc_order
--- John Gibson, Sep 26 1990
	Fixed bug in _unwind_frame where sp was being incremented over 2
	words on the stack and then relying on accessing the first of those
	at -ve offset. This failed if a signal interrupted, since signal
	handler stack frame overwrote anything below sp.
--- John Gibson, May 15 1990
	Changed _checkall so that -Async_raise_signal- not called
	when _disable interrupt bit set (also now doesn't clear _trap
	if it is called).
--- John Gibson, May  1 1990
	Removed saving of fp on startup (no longer required)
--- John Gibson, Dec  7 1989
	Changes for new pop pointers (explicit offsets for RF_CONT,P_FRONT)
--- John Gibson, Nov 29 1989
	Reg r5 now caches address of false -- made appropriate changes.
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- John Gibson, Jan 15 1989
	Replaced use of UC_LAB etc for updater with -> before pathname
--- John Gibson, Sep  4 1988
	Replaced _SVB macros with _SVB_OFFS(identifier name)
--- John Gibson, Aug 23 1988
	Wrapping structures now use -objmod_pad_key-
--- John Gibson, Jun  3 1988
	Added name Sys$-_entry_point to _main (used by poplink to force
	inclusion of this routine).
--- Roger Evans, Apr 18 1988
	moved Async_raise_signal into section Sys
--- Roger Evans, Apr 11 1988
	Installed signal handling code
--- John Gibson, Mar  4 1988
	Plog_overflow -> Sys$-Plog$-Area_overflow and weakref'ed
--- John Gibson, Feb 11 1988
	integer_key and decimal_key now in section Sys.
--- John Gibson, Jan 17 1988
	Added 'wrapping' strings to enable object files from .s files to
	be mixed in with those from .p source.
		Replaced all references to 'poplog' labels with macros
	C_LAB, I_LAB, etc applied to identifier names, and added appropriate
	declarations between #_< ... >_#, etc.
--- John Gibson, Oct 31 1987
	Made _main initialise _system_stack_base rather than _call_stack_hi,
	and removed pushing of <false> owner address to start (no longer
	needed).
--- John Gibson, Aug 14 1987
	For segmented system, changed _main to set up initial userstack
	in a temporary area.
 */
