/* --- Copyright University of Sussex 1994. All rights reserved. ----------
 * File:            S.vaxunix4.2/src/aprolog.s
 * Purpose:
 * Author:          John Gibson (see revisions)
 */

;;; ----------------- ROUTINES FOR PROLOG --------------------------------

#_<

#_INCLUDE 'declare.ph'

constant
	procedure (Sys$-Plog$-Assign_pair, Sys$-Plog$-New_var),
	_checkplogall
	;

vars
	_plog_trail_sp, _plog_next_var, _plog_contn_sp, _plog_contn_top,
	_plog_save_contn_sp, _plog_trail_barrier, _plog_trail_lim,
	_call_stack_lim
	;

lconstant macro (
	_KEY		= @@KEY,
	_PGV_CONT	= @@PGV_CONT,
	_PGV_SIZE	= @@(struct PLOGVAR)++,
	_PGT_FUNCTOR	= @@PGT_FUNCTOR,
	_PGT_LENGTH	= @@PGT_LENGTH,
	_P_FRONT	= @@P_FRONT,
	_P_BACK		= @@P_BACK,
	_SF_PLGSV_CONTN_TOP	= @@SF_PLGSV_CONTN_TOP,
	_SF_PLGSV_NEXT_VAR	= @@SF_PLGSV_NEXT_VAR,
	_SF_PLGSV_TRAIL_SP	= @@SF_PLGSV_TRAIL_SP,
	);

>_#

/********************* wrapping structures ***********************************/

	.text
	.long	Ltext_end-Ltext_start, C_LAB(Sys$-objmod_pad_key)
Ltext_start:
	.data
	.long	Ldata_end-Ldata_start, C_LAB(Sys$-objmod_pad_key)
Ldata_start:

/**************************************************************************/


	.text



;;; --- PROLOG SAVE AND RESTORE -------------------------------------------

	;;; Save the prolog continuation stack, trail and next free var
	;;; in the corresponding saved locations. The do stack overflow and
	;;; interrupt checks.
	.align 2
DEF_C_LAB (_prolog_save_check)
	moval	C_LAB(_special_var_block), r3
	;;; save next var
	movl	_SVB_OFFS(_plog_next_var)(r3), 4+_SF_PLGSV_NEXT_VAR(sp)
	;;; save trail end pointer, relative to trail barrier
	movl	_SVB_OFFS(_plog_trail_sp)(r3), r0	;;; save this for check
	subl3	_SVB_OFFS(_plog_trail_barrier)(r3), r0, 4+_SF_PLGSV_TRAIL_SP(sp)
	;;; save continuation stack top and pointer
	;;; save_contn_sp is a dynamic local (see plogcore.p)
	movl	_SVB_OFFS(_plog_contn_sp)(r3), _SVB_OFFS(_plog_save_contn_sp)(r3)
	movl	_SVB_OFFS(_plog_contn_top)(r3), 4+_SF_PLGSV_CONTN_TOP(sp)
	;;; now do stack/interrupt checks
	cmpl	r0, _SVB_OFFS(_plog_trail_lim)(r3)	;;; compare _plog_trail_sp
	bgequ	1f				;;; br if trail overflow
	cmpl	sp, _SVB_OFFS(_call_stack_lim)(r3)
	blssu	1f				;;; br if call stack too long
	cmpl	ap, _SVB_OFFS(_userlim)(r3)
	blssu	1f				;;; br if user stack too long
	blbs	_SVB_OFFS(_trap)(r3), 1f	;;; br if _trap set
	rsb					;;; return if ok
1:	jmp	C_LAB(_checkplogall)		;;; else redo checks


	;;; restore the contn stack and next free var from the current
	;;; saved values, and unwind the trail back to the saved position,
	;;; resetting vars to undef
	.align 2
DEF_C_LAB (_prolog_restore)
	moval	C_LAB(_special_var_block), r3
	;;; restore next var
	movl	4+_SF_PLGSV_NEXT_VAR(sp), _SVB_OFFS(_plog_next_var)(r3)

	;;; restore continuation top and pointer
	movl	_SVB_OFFS(_plog_save_contn_sp)(r3), _SVB_OFFS(_plog_contn_sp)(r3)
	movl	4+_SF_PLGSV_CONTN_TOP(sp), _SVB_OFFS(_plog_contn_top)(r3)

	;;; restore trail end pointer, setting plogvars back to undef
	addl3	_SVB_OFFS(_plog_trail_barrier)(r3), 4+_SF_PLGSV_TRAIL_SP(sp), r0
	movl	_SVB_OFFS(_plog_trail_sp)(r3), r1	;;; current end
	cmpl	r0, r1				;;; reached end?
	bgequ	2f				;;; br if so
	movl	r0, _SVB_OFFS(_plog_trail_sp)(r3)	;;; set new end
1:	movl	(r0)+, r4			;;; get address of plogvar
	movl	r4, _PGV_CONT(r4)		;;; put var into its own PGV_CONT
	cmpl	r0, r1				;;; reached end?
	blssu	1b				;;; br if not
2:	rsb


	;;; unify against atom. arg in r0, atom in r1
	.align 2
DEF_C_LAB (_prolog_unify_atom)
	movl	$C_LAB(prologvar_key), r3	;;; register for speed
1:	blbs	r0, 2f			;;; go if simple
	cmpl	_KEY(r0), r3		;;; isprologvar?
	bneq	2f			;;; go if not
	movl	r0, r2			;;; move round one
	movl	_PGV_CONT(r0), r0	;;; deref one link
	cmpl	r0, r2			;;; undefvar?
	bneq	1b			;;; go if not, loop for more
	movl	r1, _PGV_CONT(r0)	;;; move atom to cont of var
	movl	I_LAB(_plog_trail_sp), r3	;;; get trail pointer
	movl	r0, (r3)+		;;; push var to trail
	movl	r3, I_LAB(_plog_trail_sp)	;;; put trail pointer back
	tstb	$0			;;; leave flags set equal
	rsb
2:	cmpl	r0, r1			;;; leave flags set for equal/not eq
	rsb


	;;; prolog pair switch
	;;; arg is in r0
	.align 2
DEF_C_LAB (_prolog_pair_switch)
	movl	$C_LAB(prologvar_key), r2	;;; variable key in reg
1:	blbs	r0, 3f			;;; go if simple
	cmpl	_KEY(r0), r2		;;; isprologvar?
	bneq	2f			;;; go if not
	movl	r0, r1			;;; move round one
	movl	_PGV_CONT(r0), r0	;;; get cont
	cmpl	r0, r1			;;; see if end of chain
	bneq	1b			;;; go if more
	;;; undef var - push it and return flags set to greater than
	movl	r0, -(ap)		;;; sets flags (addr is > 0)
	rsb
	;;; compound item
2:	cmpl	_KEY(r0), $C_LAB(pair_key)	;;; ispair?
	bneq	3f			;;; go if not
	;;; pair - return flags set to equal (already are)
	rsb
	;;; anything else - return flags set to less than
3:	tstb	$-1
	rsb

	;;; just like pair_switch but checks functor and length (== arity + 1)
	;;; arg is in r0, functor in r1, popint length in r2
	.align 2
DEF_C_LAB (_prolog_term_switch)
	movl	$C_LAB(prologvar_key), r4	;;; get key into register
1:	blbs	r0, 3f			;;; go if simple
	cmpl	_KEY(r0), r4		;;; isprologvar?
	bneq	2f			;;; go if not
	movl	r0, r3			;;; move round one
	movl	_PGV_CONT(r0), r0	;;; get cont
	cmpl	r0, r3			;;; undefvar?
	bneq	1b			;;; go if not
	;;; undef var - push it and return flags set to greater than
	movl	r0, -(ap)		;;; sets flags (addr is > 0)
	rsb
	;;; compound item
2:	cmpl	_KEY(r0), $C_LAB(prologterm_key)	;;; isprologterm?
	bneq	3f			;;; go if not
	cmpl	_PGT_FUNCTOR(r0), r1	;;; same functor?
	bneq	3f			;;; go if not
	ashl	$-2, r2, r2
	cmpl	_PGT_LENGTH(r0), r2	;;; same length?
	bneq	3f			;;; go if not
	;;; prologterm - return flags set to equal (already are)
	rsb
	;;; anything else - return flags set to less than
3:	tstb	$-1
	rsb


DEF_C_LAB (_prolog_assign)
	movl	(ap)+, r0		;;; item into r0
	brb	plog_assign

DEF_C_LAB (_prolog_assign_pair)
	movl	I_LAB(Sys$- _free_pairs), r0	;;; get free pair list
	blbs	r0, nopair		;;; if simple, then none left
	movl	_P_BACK(r0), I_LAB(Sys$- _free_pairs)	;;; move the next back to _free_pairs
	movl	(ap)+, _P_BACK(r0)	;;; init back
	movl	(ap)+, _P_FRONT(r0)	;;; init front
	;;; assign item in r0 to var and push on trail
plog_assign:
	movl	(ap)+, r1		;;; prolog var into r1
	movl	r0, _PGV_CONT(r1)	;;; assign to var cont
	movl	I_LAB(_plog_trail_sp), r0
	movl	r1, (r0)+		;;; push on trail
	movl	r0, I_LAB(_plog_trail_sp)	;;; update global var
	rsb

	;;; none left, chain this for more
nopair:	jmp	XC_LAB(Sys$-Plog$-Assign_pair)


;;; --- OPTIONAL ASSEMBLER CODE ---------------------------------------------

;;; optional assembler optimised stuff, for code normally in pop.
;;; see bottom of syscomp/sysdefs.p for when this are used
;;; and plogcore.p, plogterms.p for equivalent pop code

	;;; dereference a chain of prolog variables
	;;; this code is twice as long as it has to be, but it saves
	;;; executing one instruction per link of chain
	;;; it's only a little bit faster
	.align 2
DEF_C_LAB (_prolog_deref)
	movl	(ap), r1
	movl	$C_LAB(prologvar_key), r2	;;; get the key into a reg
	;;; deref one link of r1
1:	blbs	r1, 2f			;;; item is simple? go if so
	cmpl	r2, _KEY(r1)		;;; item is plogvar?
	bneq	2f			;;; no: return item
	movl	_PGV_CONT(r1), r0	;;; deref one link of plogvar
	cmpl	r1, r0			;;; cont(item) == item? (end of chain)
	beql	3f			;;; no: do another on other side
	;;; deref one link of r0
	blbs	r0, 3f			;;; item is simple? go if so
	cmpl	r2, _KEY(r0)		;;; item is plogvar?
	bneq	3f			;;; no: return item
	movl	_PGV_CONT(r0), r1	;;; deref one link of plogvar
	cmpl	r0, r1			;;; cont(item) == item? (end of chain)
	bneq	1b			;;; no: do another on other side
2:	movl	r1, (ap)		;;; finish with result from r1
	rsb
3:	movl	r0, (ap)		;;; finish with result from r0
	rsb

	.align 2
DEF_C_LAB (_prolog_newvar)
	moval	I_LAB(_plog_next_var), r1
	movl	(r1), r0		;;; next var in block
	cmpl	$C_LAB(ref_key), _KEY(r0) ;;; end-of-block reference?
	beql	1f			;;; branch if so
	movl	r0, _PGV_CONT(r0)	;;; make this one undef
	movl	r0, -(ap)		;;; and return it
	moval	_PGV_SIZE(r0), (r1)	;;; move on to next
	rsb
1:	jmp	XC_LAB(Sys$-Plog$-New_var)	;;; call this for some more


/*************** end labels for wrapping structures **************************/

	.text
Ltext_end:
	.data
Ldata_end:

/**************************************************************************/



/* --- Revision History ---------------------------------------------------
--- John Gibson, Oct 18 1994
	free*pairs -> _free_pairs
--- John Gibson, Dec  7 1989
	Changes for new pop pointers (explicit use of PGV_CONT)
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- John Gibson, Apr  9 1989
	Prolog_newvar, Prolog_assign_pair renamed into section Sys$-Plog
--- John Gibson, Sep  4 1988
	Replaced _SVB macros with _SVB_OFFS(identifier name)
--- John Gibson, Aug 23 1988
	Wrapping structures now use -objmod_pad_key-
--- John Gibson, Jan 17 1988
	Added 'wrapping' strings to enable object files from .s files to
	be mixed in with those from .p source.
		Replaced all references to 'poplog' labels with macros
	C_LAB, I_LAB, etc applied to identifier names, and added appropriate
	declarations between #_< ... >_#, etc.
 */
