/* --- Copyright University of Sussex 1993. All rights reserved. ----------
 > File:            C.all/lib/proto/go/lib/go_ncremove.p
 > Purpose:         GO file
 > Author:          Ben Rabau, 1992-1993
 > Documentation:   HELP GO_CLASSES
 > Related Files:
 */
													   ;;; 28th April 1993
;;; File: go_ncremove.p
;;; Author: Jonathan Meyer

compile_mode :pop11 +strict;

define go_ncremove(n, list) -> newlist;
lvars n, list, newlist;
;;; REF: go_ncremove(N, LIST_1) -> LIST_2;
;;; REF:  Removes the N'th element from  the list, returning the new  list
;;; REF:  with the element removed. Tries to  reuse the pairs in the  list
;;; REF:  when possible - may destructively change the original list.
;;; REF:
;;; REF:        eg.
;;; REF:            go_ncremove(1, [cat dog rat]) =>
;;; REF:            ** dog rat
;;; REF:
;;; REF:            go_ncremove(2, [cat dog rat]) =>
;;; REF:            ** [cat rat]
;;; REF:
	if null(list) then
		mishap(list,1,'NON-EMPTY LIST NEEDED');
	elseif n <= 0 then
		mishap(n, 1, 'INTEGER >= 1 NEEDED');
	elseif n == 1 then
		;;; all but the first item of the list
		list.tl -> newlist;
	else
		list -> newlist;
		n - 2 -> n;
		;;; step down the list
		repeat n times dest(list) -> list -> ; endrepeat;
		;;; unlink the pair
		list.tl.tl -> list.tl;
	endif;
enddefine;

;;;----------------------------------------------------------------
;;; Variable for "uses"
;;; Is not necessary because the file name == the procedure name.

/* --- Revision History --------------------------------------------
 * BR 29/04/93
 *     Changed file-name from ncremove.p to go_ncremove.p
 *     Changed file-layout and comments.
 */
;;; eof
