/* --- Copyright University of Sussex 1989. All rights reserved. ----------
 * File:            S.vaxunix4.2/src/aarith.s
 * Purpose:
 * Author:          John Gibson (see revisions)
 */

;;; --------------------- ARITHMETIC ROUTINES ---------------------------------

#_<

#_INCLUDE 'declare.ph'

>_#

/********************* wrapping structures ***********************************/

	.text
	.long	Ltext_end-Ltext_start, C_LAB(Sys$-objmod_pad_key)
Ltext_start:
	.data
	.long	Ldata_end-Ldata_start, C_LAB(Sys$-objmod_pad_key)
Ldata_start:

/**************************************************************************/

	.text


;;; --- LOGICAL BIT ROUTINES ----------------------------------------------

	.align 2
DEF_C_LAB 4 (_biset)
	bisl2	(ap)+, (ap)
	rsb

	.align 2
DEF_C_LAB 4 (_biclear)
	bicl2	(ap)+, (ap)
	rsb

	.align 2
DEF_C_LAB 4 (_bimask)
	mcoml	(ap)+, r0
	bicl2	r0, (ap)
	rsb

	.align 2
DEF_C_LAB 4 (_bixor)
	xorl2	(ap)+, (ap)
	rsb

;;; ------------------------------------------------------------------------

	.align 2
	;;; integer divide
DEF_C_LAB 4 (_div)
	movl	4(ap), r2		;;; dividend above divisor on stack
	ashq    $-32, r1, r1		;;; sign extend dividend to r1/2
	ediv    (ap), r1, (ap), 4(ap)	;;; quot on tos, rem next
	rsb

	.align 2
	;;; integer divide, quotient only
DEF_C_LAB 2 (_divq)
	divl3	(ap)+, (ap), (ap)
	rsb


;;; ------------------------------------------------------------------------

	.align 2
	;;; pop integer multiply
DEF_C_LAB 4 (_pmult)
	ashl	$-2, (ap)+, r0		;;; make one a sysint, clr other, then
	bicl2	$3, (ap)		;;; after mul, result will be times 4
	mull2   r0, (ap)
	bisl2	$3, (ap)		;;; restore popint bits
	rsb

	;;; and with overflow test
	.align 2
DEF_C_LAB (_pmult_testovf)
	ashl	$-2, (ap)+, r0		;;; make one a sysint, clr other, then
	bicl2	$3, (ap)		;;; after mul, result will be times 4
	mull2   r0, (ap)
	bvs     1f
	bisl2	$3, (ap)		;;; restore popint bits
	movl	$C_LAB(true), -(ap)
	rsb
1:	bisl2	$3, (ap)		;;; restore popint bits
	movl	r5, -(ap)		;;; return false
	rsb

;;; ------------------------------------------------------------------------

	.align 2
return_false:
	movl	r5, (ap)
	rsb

;;; ------------------------------------------------------------------------

	.align 2
	;;; pop integer divide
DEF_C_LAB 4 (_pdiv)
	ashl	$-2, (ap)+, r0		;;; divisor
	beql	return_false		;;; error - zero divisor
	movl	(ap), r2		;;; dividend
	ashq    $-34, r1, r1		;;; cvt to sysint and sign extend
	ediv    r0, r1, r0, r1		;;; quot in r0, rem in r1
	ashl	$2, r1, (ap)		;;; convert back both results
	bisl2	$3, (ap)		;;; remainder
	ashl	$2, r0, -(ap)
	bisl2	$3, (ap)		;;; quotient
	rsb

;;; ------------------------------------------------------------------------

	.align 2
	;;; convert int to popint, with overflow test
DEF_C_LAB (_pint_testovf)
	ashl	$2, (ap), r0
	bvs	return_false		;;; false for overflow
	bisl3	$3, r0, (ap)
	movl	$C_LAB(true), -(ap)
	rsb

;;; ------------------------------------------------------------------------

	.align 2
	;;; shift popint left, with overflow test
DEF_C_LAB (_pshift_testovf)
	movl	(ap)+, r0		;;; r0 = positive shift
	bicl3	$3, (ap), r1		;;; r1 = popint with 0,1 cleared
	beql	1f			;;; no overflow if 0
	cmpl	r0, $30			;;; shift >= 30 bits?
	bgequ	return_false		;;; overflow if so
	ashl	r0, r1, r1		;;; else do the shift
	bvs	return_false		;;; return false for overflow
	bisl3	$3, r1, (ap)		;;; return result
1:	movl	$C_LAB(true), -(ap)	;;; and true
	rsb


;;; --- BIGINTEGER ARITHMETIC --------------------------------------------

	;;; multiply two longs to get double length result
	;;; _emul(multiplicand, multiplier) -> high -> low
	.align 2
DEF_C_LAB (_emul)
DEF_C_LAB (_posword_emul)
	emul 	(ap)+, (ap), $0, r0	;;; MN  -> r0, r1
	ashl	$1, r1, r1		;;; shift up high part of result
	tstl	r0			;;; bit 31 set in low part?
	bgeq	1f			;;; branch if not
	incl	r1			;;; else transfer to high part
	bicl2	$0x80000000, r0		;;; clear in low part
1:	movl	r0, (ap)		;;; low part
	movl	r1, -(ap)		;;; high part
	rsb

	;;; divide double dividend by single
	;;; _ediv(high, low, divisor) -> quotient -> remainder
	.align 2
DEF_C_LAB (_ediv)
	movl 	(ap)+, r2		;;; divisor
	movl 	(ap)+, r0		;;; dividend low
	movl 	(ap), r1		;;; dividend high
	blbc	r1, 1f
	bisl2	$0x80000000, r0
1:	ashl	$-1, r1, r1
	ediv 	r2, r0, r3, r4
	movl 	r4, (ap)		;;; return remainder
	movl	r3, -(ap)		;;; and quotient
	rsb


	;;; multiply a biginteger by a signed value into a destination bigint
	;;; _bgi_mult(multiplier, saddr, slim, daddr) -> nextdest -> carry
DEF_C_LAB (_bgi_mult)
	movq	(ap)+, r0		;;; r0 = dest addr, r1 = source lim
	movq	(ap)+, r2		;;; r2 = source addr, r3 = multiply value
	clrl	r5			;;; zero carry slice
1:	emul	r3, (r2)+, r5, r4	;;; product+carry in r4, r5
	ashl	$1, r5, r5		;;; shift up high part of result
	tstl	r4			;;; bit 31 set in low part?
	bgeq	2f			;;; branch if not
	incl	r5			;;; else transfer to high part
	bicl2	$0x80000000, r4		;;; clear in low part
2:	movl	r4, (r0)+		;;; move low part to destination
	cmpl	r2, r1			;;; reached end of source?
	blssu	1b			;;; loop if not
	movl	r5, -(ap)		;;; return carry
	movl	r0, -(ap)		;;; and next destination
	moval	C_LAB(false), r5	;;; restore r5 to false
	rsb

	;;; multiply a biginteger by a signed value
	;;; and add into a destination bigint
	;;; _bgi_mult_add(value, saddr, slim, sdaddr) -> nextdest -> carry
DEF_C_LAB (_bgi_mult_add)
	pushl	r6
	movq	(ap)+, r0		;;; r0 = source/dest addr, r1 = source lim
	movq	(ap)+, r2		;;; r2 = source addr, r3 = multiply value
	clrl	r5			;;; zero carry slice
1:	emul	r3, (r2)+, r5, r4	;;; product+carry in r4, r5
	movl	(r0), r6
	bgeq	2f
	addl2	r6, r4			;;; + dest into r4
	adwc	$-1, r5			;;; + carry to r5
	brb	3f
2:	addl2	r6, r4			;;; + dest into r4
	adwc	$0, r5			;;; + carry to r5
3:	ashl	$1, r5, r5		;;; shift up high part of result
	tstl	r4			;;; bit 31 set in low part?
	bgeq	4f			;;; branch if not
	incl	r5			;;; else transfer to high part
	bicl2	$0x80000000, r4		;;; clear in low part
4:	movl	r4, (r0)+		;;; move low part to update destination
	cmpl	r2, r1			;;; reached end of source?
	blssu	1b			;;; loop if not
	movl	r5, -(ap)		;;; return carry
	movl	r0, -(ap)		;;; and next destination
	movl	(sp)+, r6		;;; restore r6
	moval	C_LAB(false), r5	;;; restore r5 to false
	rsb

	;;; divide a biginteger by a signed value into a destination bigint
	;;; _bgi_div(divisor, saddr, slim, dlim) -> remainder
DEF_C_LAB (_bgi_div)
	movq	(ap)+, r0		;;; r0 = dest lim, r1 = source lim
	movq	(ap)+, r2		;;; r2 = source addr, r3 = signed divisor
	movl	-(r1), r4		;;; first slice is signed
	ashl	$-31, r4, r5		;;; sign extend into hi part in r5
	brb	2f

1:	clrl	r4			;;; clear out r4
	ashq	$-1, r4, r4		;;; bit 0 of r5 down to 31 of r4
	bisl2	-(r1), r4		;;; or in next (+ve) slice
2:	ediv 	r3, r4, -(r0), r5	;;; store quot in dest (can be negative)
	cmpl	r1, r2			;;; reached start of source?
	bgtru	1b			;;; loop if not
	movl	r5, -(ap)		;;; return remainder
	moval	C_LAB(false), r5	;;; restore r5 to false
	rsb


/*************** end labels for wrapping structures **************************/

	.text
Ltext_end:
	.data
Ldata_end:

/**************************************************************************/



/* --- Revision History ---------------------------------------------------
--- John Gibson, Nov 29 1989
	Reg r5 now caches address of false -- made appropriate changes.
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- John Gibson, Dec  2 1988
	Added _divq
--- John Gibson, Aug 23 1988
	Wrapping structures now use -objmod_pad_key-
--- John Gibson, Jan 17 1988
	Added 'wrapping' strings to enable object files from .s files to
	be mixed in with those from .p source.
		Replaced all references to 'poplog' labels with macros
	C_LAB, I_LAB, etc applied to identifier names, and added appropriate
	declarations between #_< ... >_#, etc.
 */
