/* --- Copyright University of Sussex 1995. All rights reserved. ----------
 * File:		S.vaxunix4.2/src/asignals.s
 * Purpose:
 * Author:		John Gibson (see revisions)
 */

;;; ------------------ SIGNAL HANDLER (4.2/3 BSD) -----------------------------

#_<

#_INCLUDE 'declare.ph'

section $-Sys;

constant
	procedure (Callstack_reset, Error_signal, Vfork_parent)
	;

vars
	Extern$- _saved_sp,
	;

endsection;

lconstant macro (
	_PD_ARRAY_BY_ROW	= @@PD_ARRAY_BY_ROW,
	_SAVED_SP		= [I_LAB(Sys$-Extern$- _saved_sp)],
	);

>_#

/********************* wrapping structures ***********************************/

	.text
	.long	Ltext_end-Ltext_start, C_LAB(Sys$-objmod_pad_key)
Ltext_start:
	.data
	.long	Ldata_end-Ldata_start, C_LAB(Sys$-objmod_pad_key)
Ldata_start:

/**************************************************************************/

	.text

;;; --- ROUTINES TO CLEAN UP AND CALL A POP ERROR HANDLER -----------------

reset_pop_environ:
	;;; unwind any VAX procedure stack frames until fp is at or above
	;;; the current _call_stack_seg_hi (n.b. restores registers)
	clrl	___pop_in_user_extern	;;; clear this just in case
	movl	(sp)+, save_return 	;;; save this
1:	cmpl	fp, I_LAB(_call_stack_seg_hi)
	bgequ	2f			;;; OK
	moval	1b, 16(fp)		;;; else frig return to loop
	ret				;;; unwind frame and return to 1b

2:	jsb	reset_pop_reg_environ	;;; set registers to proper pop state
	movl	I_LAB(_userhi), ap	;;; reset userstack
	tstl	_SAVED_SP
	beql	3f
	movl	_SAVED_SP, sp
	clrl	_SAVED_SP
3:	jmp	*save_return

	;;; Error signals (e.g. SEGV) set return to this
.globl ___pop_errsig
___pop_errsig:
	bsbw	reset_pop_environ		;;; clean up
	jsb	XC_LAB(Sys$-Error_signal)	;;; never returns


;;; --------------------------------------------------------------------------

#_IF not(DEF VAXULTRIX)

.set vfork, 66

DEF_C_LAB (Sys$- _do_vfork)
	chmk	$vfork
	bcc	1f
	movl	r0, EXTERN_NAME(errno)
	mnegl	$1, -(ap)
	rsb

1:	tstl	r1		;;; the child?
	beql	2f		;;; no, the parent
	clrl	-(ap)		;;; return 0 for child
	rsb

2:	clrl	_SAVED_SP	;;; in case in extern calls in child
	movl	r0, -(ap)	;;; child id
	moval	C_LAB(weakref Sys$-Vfork_parent), -(ap)
	jmp	XC_LAB(Sys$-Callstack_reset)

#_ENDIF


;;; --- SYSTEM CALLS --------------------------------------------------------

	;;; Make a system call, moving args from userstack
	;;; to system stack -- for internal use only (calls to this
	;;; are generated by the _extern syntax form).
	;;; (User external calls are done in aextern.s)

	.align 2
DEF_C_LAB (_call_sys)
	moval	4(sp), _SAVED_SP ;;; save for exceptions

	movl	(ap)+, r1	;;; system procedure wanted
	movl	(ap)+, r2	;;; number of args
	movl	r2, r0
	beql	2f		;;; no args

1:	pushl	(ap)+		;;; push args onto stack
	sobgtr	r0, 1b

2:	calls	r2, (r1)	;;; the system call
	moval	C_LAB(false), r5 ;;; ensure r5 is false
	movl	r0, -(ap)	;;; the result if any

	clrl	_SAVED_SP
	rsb


;;;-------------------------------------------------------------------------

	.data
	.align 2

save_return:	.long 0
save_val:	.long 0



/*************** end labels for wrapping structures **************************/

	.text
Ltext_end:
	.data
Ldata_end:

/**************************************************************************/



/* --- Revision History ---------------------------------------------------
--- John Gibson, Mar 14 1995
	Removed _pop_m*alloc_exhausted (no longer needed)
--- John Gibson, Oct 24 1994
	Removed the C pointers to pop vars (now set up in initial.p)
--- John Gibson, Oct 13 1994
	Removed __pop_sub*rng_trap (no longer needed since arrays don't
	use the "index" instruction any more)
--- John Gibson, May 24 1994
	errno now used directly for syscall error codes -- got rid of
	code transferring it to _sys*error.
--- John Gibson, Mar 14 1991
	Added __pop_in_X_call
--- John Gibson, Jan 20 1991
	Added clearing of ___pop_in_user_extern in reset_pop_environ
--- John Gibson, Jan  5 1991
	Actual signal handlers rewritten in C and moved to c_core.c (this
	file now contains only routines gone to on return from a signal).
--- John Gibson, Dec  3 1990
	Replaced _pop_a*dd_sig with _pop_add_ast taking ast type as 1st arg
--- Roger Evans, Nov 22 1990 added __pop_xt_dummy_fd
--- John Gibson, Nov 19 1990
	Grouped all C-accessible pointers and added
	__WEAK_pop_external_callback etc
--- John Gibson, Nov 15 1990
	Changed "jsb" to Callstack_reset in _do_vfork to "jmp", and made
	it clear _SAVED_SP.
--- John Gibson, Nov 13 1990
	Replaced _m*alloc_use_external by _external_flags and
	_pop_malloc_use_external by pop_external_flags, etc.
--- John Gibson, Aug 21 1990
	Signal queue routines rewritten in C and put into malloc.c.
	These access the pop variable _trap via the constant pointer
	_pop_signals_pending.
--- John Gibson, May 13 1990
	Added __pop_malloc_use_external to enable malloc to get at
	Sys$-_malloc_use_external.
	Changed name of routine called by malloc when internal dynamic
	memory exhausted to __pop_m*alloc_exhausted, and error pop procedure
	called to Sys$-M*alloc_exhausted.
--- John Gibson, Apr 30 1990
	Moved _call_sys to this file from aextern.s (so core routine
	_call_sys doesn't pull in 'optional' external stuff).
	Also now uses signals.ph for signal numbers.
--- John Gibson, Mar 23 1990
	Removed call of reset_pop_environ from do_vfork (mustn't be
	there now, because it resets the pop registers).
--- Ian Rogers, Jan 17 1990
	Made reset_pop_environ globally accessable. Added call to it
	in  _do_vfork
--- John Gibson, Nov 29 1989
	Reg r5 now caches address of false -- made appropriate changes.
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- John Gibson, Feb  5 1989
	Array by row now indicated by PD_ARRAY_BY_ROW field in procedure
	rather than a bit in PD_FLAGS
--- John Gibson, Aug 23 1988
	Wrapping structures now use -objmod_pad_key-
--- Roger Evans, Jun 17 1988
	added SIGILL and SIGEMT to immediately handled signals
--- John Gibson, Mar 16 1988
	Vfork_parent into section Sys and weakref'ed
--- Roger Evans, Jan 22 1988
	added declaration of _saved_startup_fp
--- John Gibson, Jan 17 1988
	Added 'wrapping' strings to enable object files from .s files to
	be mixed in with those from .p source.
	Replaced all references to 'poplog' labels with macros
	C_LAB, I_LAB, etc applied to identifier names, and added appropriate
	declarations between #_< ... >_#, etc.
 */
