/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 > File:            S.vaxunix4.3/src/syscomp/sysdefs.p
 > Purpose:
 > Author:          John Gibson (see revisions)
 */

/* -------------------------------------------------------------------------

				DEFINITIONS FOR MACHINE/OPERATING SYSTEM
						 John Gibson June 1987

--------------------------------------------------------------------------*/

section;

global constant macro (

	POPC_SYSDEFS_LOADED = true,


;;; --- SYSTEM NAME ---------------------------------------------------------

	MACHINE			= [[vax]],
	VAX_UNIX_4_3	= true,


;;; --- MACHINE = VAX ------------------------------------------------------

	PROCESSOR		= [[vax]],		;;; type of cpu
	VAX				= true,

	;;; Values for machine and C data types are defined in mcdata.p,
	;;; and can be overidden here if necessary

	SHORT_ALIGN_BITS= 8,			;;; alignment in bits for short access
	INT_ALIGN_BITS	= 8,			;;; alignment in bits for int access
	DOUBLE_ALIGN_BITS= 8,			;;; alignment in bits for double access

	STRUCT_SHORT_ALIGN_BITS	= 16,	;;; bit alignment for short
	STRUCT_INT_ALIGN_BITS	= 32,	;;; bit alignment for int
	STRUCT_DOUBLE_ALIGN_BITS= 32,	;;; bit alignment for double

	CODE_POINTER_TYPE = "byte",		;;; type of pointer to machine code
	BIT_POINTER_TYPE  = "byte",		;;; type of pointer for bitfield access


;;; --- OPERATING SYSTEM = BERKELEY UNIX bsd ---------------------------

	BERKELEY		= 4.3,
	OPERATING_SYSTEM = [[unix bsd ^BERKELEY]],		;;; type of os
	UNIX			= true,

	BSD_VFORK		= true,			;;; has working vfork

	VPAGE_OFFS		= 1024,			;;; word address offset of a virtual page
	LOWEST_ADDRESS	= 0,			;;; lowest pop structure address
	UNIX_USRSTACK	= 16:7FFFEC00,	;;; end of stack (as USRSTACK in <sys/vmparam.h> etc)
	HERTZ			= 60,			;;; time between clock ticks (in hundreths
									;;; of a sec)

	;;; Procedures to get and set the memory break and return the REAL end of
	;;; memory. (We always need the real end to ensure that the end of the
	;;; user stack is always at the true end of memory, so that user stack
	;;; underflow produces a memory access violation.)

	GET_REAL_BREAK =
		[procedure(); _extern sbrk(_0)@(b.r->vpage) endprocedure],

	SET_REAL_BREAK =
		[procedure(_break) -> _break;
			lvars _break = _break@(w.r->vpage);
			if _extern brk(_break@(w->b)) == _-1 then
				_-1 -> _break
			endif
		endprocedure],


;;; --- OTHER ------------------------------------------------------------


	/* This tells POPC to use local labels for references to
	   structures defined in the same file, rather than using the global
	   name of the structure. Necessary for Berkeley because of a number
	   of bugs to do with global labels in the Berkeley 4.1 and 4.2
	   assemblers (these assemblers are riddled with bugs...)
	*/

	USE_LOCAL_LABELS	= true,



	;;; list of procedures to be optimised as subroutine calls
	;;; format of entries is
	;;;		[<pdr name> <nargs> <nresults> <subroutine name>]

	SUBROUTINE_OPTIMISE_LIST =
		[[
			[prolog_newvar			0 1 _prolog_newvar]
			[datakey				1 1 _datakey]
			[prolog_deref			1 1 _prolog_deref]
			[conspair				2 1 _conspair]
		]],

	;;; Old-style I_PUSH/POP_FIELD(_ADDR) instructions in ass.p
	OLD_FIELD_INSTRUCTIONS = true,


);


endsection;		/* $- */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Nov  4 1996
		Added OLD_FIELD_INSTRUCTIONS. Removed is* procedures from
		SUBROUTINE_OPTIMISE_LIST (no longer required).
--- John Gibson, Mar 21 1995
		Standard machine data type definitions are now in mcdata.p
--- John Gibson, Oct 22 1992
		Changed P*OPC to POPC_SYSDEFS_LOADED
--- Robert John Duncan, Jun 22 1992
		Added BSD_VFORK
--- John Gibson, Jan 22 1990
		Added value for UNIX_USRSTACK
--- John Gibson, Nov 29 1989
		Removed F*ALSE_AT_0  (no longer assumed, r5 used to cache false).
--- John Gibson, Aug 31 1989
		Added comment for UNIX_USRSTACK, but have no way of finding value.
--- John Gibson, Aug 24 1989
		Removed S*IGNALS
--- Rob Duncan, Apr  3 1989
		Added MACHINE definition; changed VAX_UNIX_4_2 to VAX_UNIX_4_3
 */
