$! --- Copyright University of Sussex 1995. All rights reserved. ----------
$! File:            C.vms/com/linkshare.com
$! Purpose:         Easy way of linking a shareable image
$! Author:          John Gibson, Nov 28 1994 (see revisions)
$! Documentation:	REF * EXTERNAL

$! USAGE:
$!
$!		@popcom:linkshare __________image-name _____files...
$!
$! where each _____files argument can be
$!
$!		# an object file name (wildcards allowed)
$!		# a library name with /library or /include appended
$!		# a shareable image name with /share appended
$!		# a linker options file with /options appended (these will appear
$!			last in the link).
$!		# a "gsmatch=" parameter (defaults to "gsmatch=lequal,1,1000")
$!
$! All global symbols defined in the object files are made universal in the
$! output image.


$ ALPHA = 0
$ if f$getsyi("NODE_HWTYPE") .eqs. "ALPH" then ALPHA = 1

$ tmpname =  "linkshr$" + f$getjpi("","PID")
$ tmpfile =  "sys$scratch:" + tmpname
$ symlist = tmpname + "sym"
$ optfile = tmpname + "opt"
$ vecfile = tmpname + "vec"
$ on error then goto END
$ on control_y then goto END

$ libpop = 1
$ gsmatch = "gsmatch=lequal,1,1000"
$ files = tmpfile + ".opt/options"
$ close/nolog 'optfile'
$ open/write 'optfile' 'tmpfile'.opt
$ NEXTPARAM:
$	if p2 .eqs. "" then goto DOLINK
$	len = f$length(p2)
$	p2 = f$edit(p2,"UPCASE")
$	if p2 .eqs. "-NOLIBPOP"
$	then
$		libpop = 0
$		goto SHIFT
$	endif
$	if f$locate("GSMATCH=",p2) .eq. 0
$	then
$		gsmatch = p2
$		goto SHIFT
$	endif
$	slash = f$locate("/",p2)
$	if slash .ne. len
$	then
$		qual = f$extract(slash,len-slash,p2)
$		p2 = f$parse(f$extract(0,slash,p2)) + qual
$		if f$locate(qual,"/OPTIONS") .eq. 0
$		then
$			files = files + "," + p2
$		else
$			write 'optfile' p2
$		endif
$	else
$		last = ""
$		NEXTFILE:
$   		file = f$search(p2)
$   		if file .eqs. "" .or. file .eqs. last then goto SHIFT
$   		last = file
$			write 'optfile' file
$   		goto NEXTFILE
$	endif
$ SHIFT:
$ p2 = p3
$ p3 = p4
$ p4 = p5
$ p5 = p6
$ p6 = p7
$ p7 = p8
$ p8 = ""
$ goto NEXTPARAM


$ DOLINK:
$ close 'optfile'
$ if libpop then files = files + ",popexternlib:libpop.olb/library"
$

$! Dummy link to get the global symbol listing from a .stb file
$ link/notraceback/nomap/noexe/sym='tmpfile'.stb 'files'
$

$! Then use analyze/object to get the symbol names (and types on the Alpha)
$ assign/user nla: sys$output
$ assign/user nla: sys$error
$ analyze/object/gsd/output='tmpfile'.txt 'tmpfile'.stb
$
$ close/nolog 'symlist'
$ close/nolog 'vecfile'
$ open/read 'symlist' 'tmpfile'.txt
$ open/write 'vecfile' 'tmpfile'.vec
$
$ READLOOP:
$	read/end_of_file=ENDFILE 'symlist' line
$	linelen = f$length(line)
$	if f$locate("symbol: """,line) .eq. linelen
$	then
$		if .not. ALPHA then goto READLOOP
$		if f$locate("symbol vector entry",line) .eq. linelen then goto READLOOP
$		if f$locate("(procedure)",line) .ne. linelen
$		then
$			type = "procedure"
$		else
$			type = "data"
$		endif
$	else
$		sym = f$element(1,"""",line)
$		if sym .eqs. ".$$ABS$$." then goto READLOOP
$		if ALPHA
$		then
$			write 'vecfile' "symbol_vector=(''sym'=''type')"
$		else
$			write 'vecfile' "universal=''sym'"
$		endif
$ 	endif
$	goto READLOOP
$
$ ENDFILE:
$ write 'vecfile' gsmatch
$ close 'vecfile'
$

$! Do the real link
$ link/notraceback/nomap/share='p1' 'files', 'tmpfile'.vec/options
$

$ END:
$ close/nolog 'optfile'
$ close/nolog 'symlist'
$ close/nolog 'vecfile'
$ delete 'tmpfile'.*;*
$


$! --- Revision History ---------------------------------------------------
$! --- John Gibson, Jun 19 1995
$!		Changed to generate separate symbol_vector/universal statements
$!		for each symbol, rather than using continuation lines (which
$!		can overflow the linker's read buffer).
