$! --- Copyright University of Sussex 1994. All rights reserved. ----------
$! File:            C.vms/extern/lib/mklibpop.com
$! Purpose:         Make pop external library libpop.olb
$! Author:          John Gibson, May 21 1990 (see revisions)
$! Documentation:	Self explanatory

$ on error then exit

$ last := ""
$ NEXTFILE:
$	file := 'f$search("*.c")'
$	if file .eqs. "" .or. file .eqs. "''last'" then goto DOLIB
$	last := 'file
$	write sys$output "''file'"
$	cc 'file'
$	goto NEXTFILE
$

$ DOLIB:
$ libname = "libpop.olb"
$ if f$getsyi("NODE_HWTYPE") .eqs. "ALPH"
$ then
$	! libpop.olb is a shareable image library containing the c_callback
$	! shareable image, while libpop2.olb is an ordinary object
$	! library containing the remaining internal stuff
$	@popcom:linkshare pop$c_callback: c_callback.obj -nolibpop
$	library/create/share 'libname' pop$c_callback:
$	purge pop$c_callback:, 'libname'
$	delete c_callback.obj;*
$	libname = "libpop2.olb"
$ endif

$ library/create 'libname' *.obj
$ del *.obj;*
$ purge 'libname'
$

$! This is a C file containing a single dummy procedure which is put
$! last in the link command generated by poplink. Both source and object
$! files have different extensions so the stuff above ignores them.
$ cc/object=.object pop_shrim_start.cc
$ purge *.object
$

$! --- Revision History ---------------------------------------------------
$! --- John Gibson, Nov 28 1994
$!		For Alpha, put c_callback in shareable image c_callback.exe in
$!		shareable image library libpop.olb, with rest of stuff in object
$!		library libpop2.olb
$! --- John Gibson, Nov 13 1993 All .c files now go in libpop.olb
$! --- Robert John Duncan, Jun  2 1993 Changed to create two libraries
$! --- John Gibson, May  6 1993 Added cc command for pop_shrim_start.cc
