/* --- Copyright University of Sussex 1994. All rights reserved. ----------
 > File:			C.vms/lib/auto/dcl_subsystem.p
 > Purpose:			Subsystem for dcl
 > Author:			John Gibson, Jan 13 1993 (see revisions)
 > Documentation:
 > Related Files:
 */
compile_mode :pop11 +strict;

/* dcl_compile uses dcl_send to communicate with a dcl subprocess. It takes
   one argument - a character repeater and passes strings delimited by
   linefeeds to the dcl process. The results are printed out. Suitable for use
   as POPCOMPILER in VED etc.
*/

section $-dcl_compile => dcl_compile, dcl_subsystem;

include ved_declare.ph;

vars dclsysobeyproc;

lvars read_buffer = false;

lconstant macro (
	VED_LOADED = [testdef vedprocess],
	VED_WEAK = [weakref[vedprocess]],
);

define lconstant dclsysobey();
	lvars	in_mbx, in_mbxname, out_mbx, out_mbxname, pid, output, str, c,
			len;
	dlocal	VED_WEAK vedlmr_print_in_file;

	define lconstant putmbx(s);
		lvars s;
		syswrite(in_mbx, s, datalength(s))
	enddefine;

	define dlocal interrupt();
		syskill(pid) -> ;
		sysclose(in_mbx);
		sysclose(out_mbx);
		false -> dclsysobeyproc;
		exitto(runproc);
	enddefine;

	if VED_LOADED and VED_WEAK vedediting then
		VED_WEAK vedputmessage('PLEASE WAIT')
	endif;

	'MIN' >< poppid -> in_mbxname;
	sysmailbox(in_mbxname, 1, "line") -> in_mbx;
	'MOUT' >< poppid -> out_mbxname;
	sysmailbox(out_mbxname, 0, "line") -> out_mbx;
	unless isstring(read_buffer) then inits(512) -> read_buffer endunless;

	sys_spawn(false, device_full_name(in_mbx), device_full_name(out_mbx),
											false, false) -> pid;
	putmbx('$ define SUB$POP11 TRUE\n');
	putmbx('$ on severe_error then continue\n');

	/* suspend and wait for inputs from VED */
	suspend(false, 1);
	repeat;
		unless () ->> str then interrupt() endunless;
		putmbx(str);
		datalength(str) -> len;
		unless len /== 1 and str(len-1) == `-` then
			putmbx('$ on severe_error then continue\n');
			putmbx('$ write sys$output "***end-of-output****"\n');

			/* This bit (believe it or not!) forces output into the current
			   file (locally) if its been diverted globally to another file */
			if VED_LOADED and isstring(VED_WEAK vedlmr_print_in_file) then
				VED_WEAK vedcurrent -> VED_WEAK vedlmr_print_in_file;
			endif;

			/* now read any output produced and return it */

			repeat;
				sysread(out_mbx, read_buffer, 512) -> c;
				substring(1, c, read_buffer) -> output;
				quitif (isstartstring('***end-of-output****', output));
				pr(output);
			endrepeat
		endunless;
		suspend(0);
	endrepeat;

	sysclose(in_mbx);
	sysclose(out_mbx);
	false -> dclsysobeyproc;
enddefine;

	/* start pop/dcl process if necessary and send string to it */
define dcl_send(line);
	lvars line, mess;
	unless dclsysobeyproc.isliveprocess then
		consproc(0, dclsysobey) -> dclsysobeyproc;
		if (runproc(0, dclsysobeyproc) ->> mess) then
			false -> dclsysobeyproc;
			if VED_LOADED then
				VED_WEAK vederror('CAN\'T START PROCESS ' >< mess);
			endif
		endif;
	endunless;
	runproc(line, 1, dclsysobeyproc);
enddefine;

	/*	As a subsystem compiler, this must have cucharin dlocally
		set to its input repeater.
	*/
define dcl_compile(cucharin);
	lvars c, str, len;
	dlocal cucharin, popprompt, poplinewidth = false;
   /*
	* Get chars from repeater, and build string for each line
	* (terminated by linefeed); send lines to csh process.
	*/
	dcl_send('\n');
	if VED_LOADED and VED_WEAK vedediting then
		nullstring -> VED_WEAK vedmessage
	endif;
	'$ '-> popprompt;
	repeat
		consstring(#|
			 repeat
				 cucharin() -> c;
				 quitif(c == termin)(2);
				 c;
			 quitif(c == `\n`);
			 endrepeat
		|#) -> str;
		dcl_send(str);
		datalength(str) -> len;
		if len /== 1 and str(len-1) == `-` then '_$ ' else '$ ' endif
							-> popprompt
	endrepeat;
	dcl_send(%false%) <> popexit -> popexit;
enddefine;


subsystem_add_new(
		"dcl",
		dcl_compile,
		'.com',
		'$ ',
		[],
		'DCL'
);

constant dcl_subsystem = "dcl";

endsection;


/* --- Revision History ---------------------------------------------------
--- John Gibson, Dec  9 1994
		Made it deal with continuation lines
--- John Gibson, Apr 21 1994
		Changed to use new sys_spawn
--- John Gibson, Apr 26 1993
		Moved in stuff from dcl_compile; uses subsystem_add_new
 */
