/* --- Copyright University of Sussex 1995. All rights reserved. ----------
 * File:            S.vaxvms/src/aextern.s
 * Purpose:
 * Author:          John Gibson (see revisions)
 */

	.title	aextern.o	;;; must be the object file name

;;; ---------------- USER EXTERNAL CALLS / CALLBACK ----------------------

#_<

#_INCLUDE 'declare.ph'
#_INCLUDE 'external.ph'
#_INCLUDE 'numbers.ph'

lconstant macro (
	_SAVED_SP	= [I_LAB(Sys$-Extern$- _saved_sp)],
	_SAVED_USP	= [I_LAB(Sys$-Extern$- _saved_usp)],

	_KEY		= @@KEY,
	_K_EXTERN_TYPE	= @@K_EXTERN_TYPE,
	_XP_PTR  	= @@XP_PTR,
	_DD_1		= @@DD_1,
	_DD_2		= @@DD_2,
	_BGI_LENGTH	= @@BGI_LENGTH,
	_BGI_SLICES	= @@BGI_SLICES,
	_EFC_FUNC	= @@EFC_FUNC,
	_EFC_ARG	= @@EFC_ARG,
	_EFC_ARG_DEST	= @@EFC_ARG_DEST,
	);

>_#

/********************* wrapping structures ***********************************/

	.psect popcode,shr,exe,nowrt,long
	.long	Lcode_end-Lcode_start, C_LAB(Sys$-objmod_pad_key)
Lcode_start:
	.psect popdata,noshr,noexe,wrt,long
	.long	Ldata_end-Ldata_start,C_LAB(Sys$-objmod_pad_key)
Ldata_start:

/**************************************************************************/

	.psect popcode,shr,exe,nowrt,long

;;; --------------------------------------------------------------------

	;;;    _call_external(____arg1, ..., ____argN, _N, _______routine, _________fltsingle)
	;;;
	;;; Call an external procedure, moving args from userstack
	;;; to stack and converting -- for users. Must be capable of
	;;; dealing with callback.
	;;;    Bit N set in the _________fltsingle arg says pass the Nth arg as a
	;;; single float if it's a (d)decimal (otherwise pass (d)decimals
	;;; as doubles). Note that bit 31 governs all args from 32nd onwards.

	.align long
DEF_C_LAB (_call_external)
	moval	4(sp), _SAVED_SP	;;; save caller's stack frame for callback

	movl	(ap)+, r2		;;; _________fltsingle arg in r2
	movl	(ap)+, r5		;;; _______routine in r5
	movl	(ap)+, r4		;;; argument count _N in r4
	bneq	0$
	brw	do_call			;;; no args

0$:	movl	r4, r3			;;; count args down in r3
	subl3	r3, #1, r0		;;; 1 - _N
	cmpl	r3, #32
	bleq	1$
	mnegl	#31, r0			;;; r0 = -31 if _N > 32
1$:	rotl	r0, r2, r2		;;; get _________fltsingle bit for last arg
	brb	arg1			;;; into bit 0

arg_loop:
	cmpl	r3, #32			;;; still on or after 32nd arg?
	bgeq	arg1			;;; br if so, don't shift
	rotl	#1, r2, r2		;;; next _________fltsingle bit to bit 0

arg1:	movl	(ap)+, r0		;;; next arg
	blbc	r0, 4$			;;; br if structure

	;;; integer or decimal
	bbc	#1, r0, 2$		;;; br if decimal
	ashl	#-2, r0, -(sp)		;;; convert integer and push
	sobgtr	r3, arg_loop
	brb	do_call

	;;; decimal -- pass as double float unless _________fltsingle bit set
2$:	bicl2	#1, r0			;;; clear bottom bit of arg
	rotl	#16, r0, -(sp)		;;; convert to single float on stack
	blbs	r2, 3$			;;; leave single if _________fltsingle bit set
	cvtfd	(sp)+, -(sp)		;;; repush as double
	incl	r4			;;; incr number of arg words to pass
3$:	sobgtr	r3, arg_loop
	brb	do_call

	;;; structure
4$:     movl	_KEY(r0), r1		;;; get key
	movb	_K_EXTERN_TYPE(r1), r1	;;; type
	bneq	5$			;;; br if nonzero
	;;; EXTERN_TYPE_NORMAL (0) -- just pass pointer
	pushl	r0
	sobgtr	r3, arg_loop
	brb	do_call

5$:	cmpb	r1, #_:EXTERN_TYPE_DEREF ;;; deref type?
	bneq	6$			;;; br if not
	;;; pass word field at pointer (e.g. external pointer)
	pushl	(r0)			;;; dereference
	sobgtr	r3, arg_loop
	brb	do_call

6$:	cmpb	r1, #_:EXTERN_TYPE_DDEC	;;; ddecimal?
	bneq	8$			;;; br if not
	;;; ddecimal -- pass as double unless _________fltsingle bit set
	pushl	_DD_2(r0)
	pushl	_DD_1(r0)
	blbs	r2, 7$			;;; cvt to single if _________fltsingle bit set
	incl	r4			;;; incr number of args to pass
	sobgtr	r3, arg_loop
	brb	do_call
7$:	cvtdf	(sp)+, -(sp)		;;; repush as single
	sobgtr	r3, arg_loop
	brb	do_call

	;;; else must be biginteger (EXTERN_TYPE_BIGINT)
	;;; pass least significant 32 bits
8$:	pushl	_BGI_SLICES(r0)		;;; ls slice to stack
	cmpl	_BGI_LENGTH(r0), #1	;;; only 1 slice?
	beql	9$			;;; OK if so
	blbc	_BGI_SLICES+4(r0), 9$	;;; or if bottom bit of 2nd slice is 0
	bisb2	#^X80, 3(sp)		;;; else set top bit in top byte
9$:	sobgtr	r3, arg_loop

	;;; make the procedure call
do_call:
	movl	ap, _SAVED_USP		;;; save user sp for callback

	;;; NEXT INSTRUCTION ENABLES ASYNC CALLBACK
	movl	sp, __pop_in_user_extern ;;; any nonzero value will do
	calls   r4, (r5)		;;; over to the procedure
	;;; NEXT INSTRUCTION DISABLES ASYNC CALLBACK
	clrl	__pop_in_user_extern

	moval	C_LAB(false), r5	;;; ensure r5 is false
	movl	_SAVED_USP, ap		;;; regain user sp

	;;; set result_struct with possible float result from
	;;; r0,r1 in first 2 words and possible word result from r0 in last
	moval	C_LAB(Sys$-Extern$-result_struct), r2
	movq	r0, (r2)+		;;; float result
	movl	r0, (r2)		;;; word result

	clrl	_SAVED_SP		;;; says no longer in extern calls
	rsb


;;; --- EXTERNAL FUNCTION CLOSURES --------------------------------------

	;;; passed (exfunc_clos address)+8 on stack
	;;; assign EFC_ARG to EFC_ARG_DEST and chain EFC_FUNC

	.align long
DEF_C_LAB(Sys$- _exfunc_clos_action)

	movl	(sp)+, r0	;;; addr of after jsb (-8 gives addr of rec)
	movl	_EFC_ARG-8(r0), @_EFC_ARG_DEST-8(r0) ;;; store arg at dest
	movl	@_EFC_FUNC-8(r0), r0	;;; get func ptr from exptr
	callg	(ap), (r0)		;;; call it, passing on args
	ret


;;; --- INTERFACE ROUTINE FOR EXTERNAL CALLBACK ------------------------------

	;;; C Synopsis:
	;;;
	;;; 	int _pop_external_callback(argp)
	;;; 	unsigned argp[];
	;;;
	;;; (where argp[0] is the function code for -Callback-)

	.align long
	;;; for indirect weak reference (N.B. must come BEFORE .entry)
DEF_C_LAB(Sys$- _external_callback_func)

.entry _pop_external_callback, ^M<r2,r3,r4,r5,r6,r7,r8,r9,r10,r11>

	;;; enable pop condition handler
	moval	_pop_errsig_handler, (fp)

	;;; 3 word dummy stack frame to hold SF_NEXT_SEG_SP and SF_NEXT_SEG_HI
	subl2	#3*4, sp

	movl	__pop_in_user_extern, r8 ;;; save this and restore at end
	;;; NEXT INSTRUCTION DISABLES ASYNC CALLBACK
	clrl	__pop_in_user_extern

	;;; set registers
	moval	C_LAB(false), r5	;;; r5 always false
	movl	r5, r6			;;; set pop lvar regs to
	movl	r5, r7			;;; sensible values
	movl	4(ap), r0		;;; save argp
	movl	_SAVED_USP, ap		;;; regain saved user sp

	movl	r0, -(ap)		;;; push argp
	clrl	-(ap)			;;; push dummy break diff
	jsb	XC_LAB(Sys$-Extern$-Callback)

	movl	(ap)+, r0		;;; return status
	movl	ap, _SAVED_USP		;;; resave user sp for _call_external

	;;; NEXT INSTRUCTION ENABLES ASYNC CALLBACK
	movl	r8, __pop_in_user_extern ;;; set back to value on entry

	ret				;;; return into external code



/*************** end labels for wrapping structures **************************/

	.psect popcode,shr,exe,nowrt,long
Lcode_end:
	.psect popdata,noshr,noexe,wrt,long
Ldata_end:

/**************************************************************************/

	.end



/* --- Revision History ---------------------------------------------------
--- John Gibson, Feb 17 1995
	Moved definition of Extern$- _r*esult_struct to extern_ptr.p as
	Extern$-result_struct
--- John Gibson, Oct 20 1994
	No longer necessary for _call_external to save the pop registers
	(r6, r7), or for callback to do anything other than set them to
	false.
--- John Gibson, Dec  3 1993
	Added missing test for 0 args at beginning of _call_external.
	Made _pop_external_callback set __pop_in_user_extern back to the
	same value it had on entry.
--- John Gibson, Nov 30 1993
	Line 69, subl -> subl3
--- John Gibson, May 19 1993
	Template part of exfunc closures now generated by POPC, which
	jumps to the _exfunc_clos_action code in this file.
--- John Gibson, Dec 18 1992
	Moved pop_ex*func_arg to c_core.c (otherwise it's undefined if this
	file is not extracted)
--- John Gibson, Aug  8 1992
	Changed _call_external to take _________fltsingle arg whose Nth bit
	specifies the treatment of (d)decimals for the Nth arg
--- John Gibson, Jan 20 1991
	Added setting and clearing of ___pop_in_user_extern (tested nonzero
	by signal handler in c_core.c to determine whether asynchronous
	callback is allowed)
--- John Gibson, Jan 20 1991
	Added setting and clearing of ___pop_in_user_extern (tested nonzero
	by signal handler in c_core.c to determine whether asynchronous
	callback is allowed)
--- John Gibson, Nov 19 1990
	Added pop label for _pop_external_callback.
	Removed functions for getting interrupt/disable flag info
	(replaced by pointer constants in asignals.s)
--- John Gibson, Nov 13 1990
	_call_external now doesn't return the result structure on the
	stack, so the procedures calling it have to push
	Sys$-Extern$- _r*esult_struct explicitly (this is so the result isn't
	left on the stack when the return address from _call_external is
	changed for abnormal exit).
	_pop_external_callback now receives and passes on a status return
	from Callback.
--- John Gibson, Sep  5 1990
	Added exfunc closure stuff
--- Roger Evans, Jul  3 1990 added pop_interrupt_disabled
--- John Gibson, May 14 1990
	_call_external now returns pointer to 3-word array, first
	2 words of which are possible single/double float result, 3rd word
	is possible result of any other kind.
--- John Gibson, May  1 1990
	Added callback routine.
	Moved _call_sys to asignals.s (so this file is purely 'optional'
	external stuff).
--- John Gibson, Mar 15 1990
	_call_external rewritten to use K_EXTERN_TYPE field, including
	coping with biginteger args.
--- John Gibson, Jan 23 1990
	Made external call routines assign false to r5 after calling the
	routine.
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- John Gibson, Nov 23 1988
	Corrected typo in last change (E_DATA instead of _E_DATA on line 90).
--- Roger Evans, Oct 10 1988
	External data classes now dereference the E_PTR field, other
	structures pass E_DATA field (third longword).
--- John Gibson, Aug 23 1988
	Wrapping structures now use -objmod_pad_key-
--- John Gibson, Feb 11 1988
	ddecimal_key now in section Sys
--- John Gibson, Jan 17 1988
	Added 'wrapping' strings to enable object files from .s files to
	be mixed in with those from .p source.
		Replaced all references to 'poplog' labels with macros
	C_LAB, I_LAB, etc applied to identifier names, and added appropriate
	declarations between #_< ... >_#, etc.
 */
