/* --- Copyright University of Sussex 1995. All rights reserved. ----------
 * File:            S.vaxvms/src/afloat.s
 * Purpose:
 * Author:          John Gibson (see revisions)
 */

	.title	afloat.o	;;; must be the object file name

;;; ----------------- FLOATING POINT ROUTINES -----------------------------

#_<

#_INCLUDE 'declare.ph'

section $-Sys;

constant
	procedure Float_qrem
	;

vars
	_fpe_handler
	;

define_extern_name
	__pop_fpe_handler	= ident _fpe_handler,
	;

endsection;


lconstant macro (
	_DD_1		= @@DD_1,
	_DD_2		= @@DD_2,
	_FPHANDLER	= [I_LAB(Sys$- _fpe_handler)],
	);

>_#

/********************* wrapping structures ***********************************/

	.psect popcode,shr,exe,nowrt,long
	.long	Lcode_end-Lcode_start, C_LAB(Sys$-objmod_pad_key)
Lcode_start:
	.psect popdata,noshr,noexe,wrt,long
	.long	Ldata_end-Ldata_start,C_LAB(Sys$-objmod_pad_key)
Ldata_start:

/**************************************************************************/

	.psect  popcode,shr,nowrt,exe,long

;;; ------------------------------------------------------------------------

	.align long
	;;; copy a double float from one address to another
DEF_C_LAB (_pfcopy)
	movd	@(ap)+, @(ap)+
	rsb

;;; ------------------------------------------------------------------------

	;;; routines to float sysints, decimals and ddecimals
	.align long
DEF_C_LAB (_pf_dfloat_int)
	movl	(ap)+, r1		;;; address for result
	cvtld	(ap)+, (r1)		;;; convert to double floating
	rsb

	.align long
DEF_C_LAB (_pf_dfloat_dec)
	movl	(ap)+, r1		;;; address for result
	bicl3	#1, (ap)+, r0		;;; clear bit 0 on decimal
	rotl	#16, r0, (r1)+		;;; convert to single floating
	clrl	(r1)			;;; with zero low order bits
	rsb

	.align long
DEF_C_LAB (_pf_sfloat_dec)
	movl    (ap), r1		;;; fetch decimal, don't bother to move sp
	bicl2   #1, r1			;;; convert to float
	rotl	#16, r1, r1
	movl    r1, (ap)		;;; push result, sp already in right place
	rsb

	.align long
DEF_C_LAB (_pf_dfloat_ddec)
	movl	(ap)+, r1		;;; address for result
	movl	(ap)+, r0		;;; the ddecimal
	movl	_DD_1(r0), (r1)+	;;; move fields to result
	movl	_DD_2(r0), (r1)
	rsb

;;; --- DOUBLE FLOATING ARITHMETIC -----------------------------------------

	;;; (must ensure args removed from stack for add, sub, mult and div)

	.align long
DEF_C_LAB (_pfadd)
	moval	1$, _FPHANDLER	;;; in case overflow fault
	movq	(ap)+, r0	;;; source addr in r0, dest in r1
	addd2	(r0), (r1)
1$:	bvc	true1		;;; true result if ok
	brb	false1		;;; false if overflow

	.align long
DEF_C_LAB (_pfsub)
	moval	1$, _FPHANDLER	;;; in case overflow fault
	movq	(ap)+, r0	;;; source addr in r0, dest in r1
	subd2	(r0), (r1)
1$:	bvc	true1		;;; true result if ok
	brb	false1		;;; false if overflow

	.align long
DEF_C_LAB (_pfmult)
	moval	1$, _FPHANDLER	;;; in case overflow fault
	movq	(ap)+, r0	;;; source addr in r0, dest in r1
	muld2	(r0), (r1)
1$:	bvc	true1		;;; true result if ok
	brb	false1		;;; false if overflow

	.align long
DEF_C_LAB (_pfdiv)
	moval	1$, _FPHANDLER	;;; in case overflow fault
	movq	(ap)+, r0	;;; source addr in r0, dest in r1
	divd2	(r0), (r1)
1$:	bvc	true1		;;; true result if ok
	brb	false1		;;; false if overflow

	.align long
DEF_C_LAB (_pfqrem)
	jmp	XC_LAB(Sys$-Float_qrem)

	.align long
DEF_C_LAB (_pfabs)
	bicw2	#^X8000, @(ap)+	;;; clear sign bit
	rsb

	.align long
DEF_C_LAB (_pfnegate)
	mnegd	@(ap), @(ap)+
	rsb

;;; ------------------------------------------------------------------------

	.align long
true1:	moval	C_LAB(true), -(ap)
	rsb

	.align long
false1:	movl	r5, -(ap)
	rsb

	.align long
false1s:movl	r5, (ap)
	rsb

;;; ------------------------------------------------------------------------

	.align long
	;;; convert the given double float to a pop single decimal
	;;; or return false if too large
DEF_C_LAB (_pf_cvt_to_dec)
	movq	@(ap)+, r0		;;; result to be converted in r0,r1
	bisl2	#1@16, r0		;;; set lowest bit of high part
	movl	#1@15, r1		;;; and highest of low part
	moval	1$, _FPHANDLER		;;; in case overflow fault
	cvtdf	r0, r0			;;; then res rounded to pop float
1$:	bvs	false1			;;; return false if too big
	;;; ok for decimal result
	rotl	#16, r0, r0		;;; cvt to pop single float
	bicl2	#3, r0			;;; clr ls 2 bits of high part
	bisl3	#1, r0, -(ap)		;;; bit 0 marks as single float
	rsb

	.align long
	;;; convert double float to pop double decimal
DEF_C_LAB (_pf_cvt_to_ddec)
	movl	(ap)+, r1		;;; the result ddecimal
	movl    (ap)+, r0		;;; source double float address
	movl    (r0)+, _DD_1(r1)	;;; move fields to result
	movl    (r0), _DD_2(r1)
	rsb

;;; --- Routines to extract/update sfloat and dfloat field values ----

	;;; _pf_extend_s_to_d(_dfaddr) -> _dfaddr or <false>
	;;; extend single at _dfaddr into double
	.align long
DEF_C_LAB (_pf_extend_s_to_d)
	cvtfd	@(ap), @(ap)		;;; convert f to d
	rsb

	;;; _pf_check_d(_dfaddr) -> _dfaddr or <false>
	;;; check double at _dfaddr
	.align long
DEF_C_LAB (_pf_check_d)
	tstd	@(ap)
	rsb

	;;; _pf_round_d_to_s(_dfaddr) -> _dfaddr or <false>
	;;; round double to single back into _dfaddr
	.align long
DEF_C_LAB (_pf_round_d_to_s)
	moval	1$, _FPHANDLER		;;; in case overflow fault
	cvtdf	@(ap), @(ap)		;;; round from source addr
1$:	bvs	false1s			;;; return false if too big
	rsb				;;; else ok

;;; ------------------------------------------------------------------------

	;;; get and set exponent E of a double float, where E is
	;;; the number of bits needed for the integer part, e.g. 1 for 1.0,
	;;; 0 for 0.5, -1 for 0.05, etc.
	.align long
DEF_C_LAB (_pf_expof)
	movl	(ap)+, r0		;;; addr of dfloat
	extzv	#7, #8, (r0), r0	;;; vax exponent
	subl3	#128, r0, -(ap)		;;; get E
	rsb

	.align long
DEF_C_LAB (-> _pf_expof)
	movl	(ap)+, r0		;;; addr of dfloat
	addl3	#128, (ap)+, r1		;;; E to vax exponent
	bleq	false2			;;; false for negative/zero
	cmpl	r1, #255
	bgtr	false2			;;; and if too big
	insv	r1, #7, #8, (r0)	;;; insert it
	brb	true2			;;; true if OK


;;; --- DOUBLE FLOATING COMPARISON --------------------------------------

	.align long
DEF_C_LAB (_pfeq)
	cmpd	@(ap)+, @(ap)+
	beql	true2
	brb	false2

	.align long
DEF_C_LAB (_pfsgr)
	cmpd	@(ap)+, @(ap)+
	blss	true2
	brb	false2

	.align long
DEF_C_LAB (_pfsgreq)
	cmpd	@(ap)+, @(ap)+
	bleq	true2
	brb	false2

	.align long
DEF_C_LAB (_pfneg)
	tstd	@(ap)+
	blss	true2
	brb	false2

	.align long
DEF_C_LAB (_pfzero)
	tstd	@(ap)+
	beql	true2
	brb	false2

;;; ------------------------------------------------------------------------

	.align long
	;;; get integer and frac parts of double float
DEF_C_LAB (_pfmodf)
	movq	(ap)+, r0		;;; r0 = source & addr for int
					;;; r1 = addr for frac
	emodd	#1.0, #0, (r0), r2, (r1)
	subd2	(r1), (r0)		;;; int part back in source
	rsb

	.align long
	;;; get integer part of double floating as an integer
DEF_C_LAB (_pf_intof)
	cvtdl	@(ap)+, r0		;;; addr of arg on stack
	bvs	false2			;;; false if too big
	movl	r0, -(ap)		;;; else return int
	brb	true2			;;; and true

;;; ------------------------------------------------------------------------

	.align long
true2:
	moval	C_LAB(true), -(ap)
	rsb
	.align long
false2:
	movl	r5, -(ap)	;;; false
	rsb



/*************** end labels for wrapping structures **************************/

	.psect popcode,shr,exe,nowrt,long
Lcode_end:
	.psect popdata,noshr,noexe,wrt,long
Ldata_end:

/**************************************************************************/

	.end



/* --- Revision History ---------------------------------------------------
--- John Gibson, Feb 25 1995
	Removed _m*ath1/2 subroutines (library math functions now called
	via _extern)
--- John Gibson, Oct 17 1994
	Replaced external var ___pop*_fpe_continue with pop var
	Sys$- _fpe_handler, and __pop*_in_m*ath_lib with pop var
	Sys$- _in_m*ath_lib
--- John Gibson, Mar 26 1991
	Added _pf_check_d
--- John Gibson, Nov 29 1989
	Reg r5 now caches address of false -- made appropriate changes.
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- John Gibson, Jan 15 1989
	Replaced use of UC_LAB etc for updater with -> before pathname
--- John Gibson, Aug 23 1988
	Wrapping structures now use -objmod_pad_key-
--- John Gibson, Feb 11 1988
	-Ddec_qrem- now -Sys$-Float_qrem-
--- John Gibson, Jan 17 1988
	Added 'wrapping' strings to enable object files from .s files to
	be mixed in with those from .p source.
		Replaced all references to 'poplog' labels with macros
	C_LAB, I_LAB, etc applied to identifier names, and added appropriate
	declarations between #_< ... >_#, etc.
--- John Gibson, Sep 21 1987
	Added _pf_cvt_to_ddec (also renamed _pf_cvt_to_decimal as
	_pf_cvt_to_dec for compatibility).
	Deleted _pf_dfloat, an obsolete routine that had been accidentally
	left in.
 */
