/* --- Copyright University of Sussex 1989. All rights reserved. ----------
 * File:            S.vaxvms/src/alisp.s
 * Purpose:
 * Author:          John Williams (see revisions)
 */

	.title	alisp.o		;;; must be the object file name

#_<

#_INCLUDE 'declare.ph'

constant	_setstklen_diff
	;

>_#

/********************* wrapping structures ***********************************/

	.psect popcode,shr,exe,nowrt,long
	.long	Lcode_end-Lcode_start, C_LAB(Sys$-objmod_pad_key)
Lcode_start:
	.psect popdata,noshr,noexe,wrt,long
	.long	Ldata_end-Ldata_start,C_LAB(Sys$-objmod_pad_key)
Ldata_start:

/**************************************************************************/

	.psect popcode,shr,exe,nowrt,long

	.align long
DEF_C_LAB (_setstklen)
	addl3	(ap)+,(ap)+,r0		;;; add saved stklen and nresults
	subl2	#6,r0			;;; r0 = desired stacklength (bytes)
	subl3	r0,I_LAB(_userhi),r0	;;; r0 = desired ap = (_userhi - r0)
	cmpl	r0,ap			;;; compare
	bneq	C_LAB(_setstklen_diff)	;;; carry on with _setstklen1 if diff
	rsb				;;; otherwise return

	.align  long
DEF_C_LAB (_setstklen_diff)
	bgtru	2$		  	;;; erase if r0 > ap
1$:
	movl	#C_LAB(nil),-(ap)	;;; push NIL
	cmpl	r0,ap			;;; compare actual and desired ap
	bneq	1$		  	;;; loop again unless same
	rsb

2$:
	movl	r0,ap
	rsb


/*************** end labels for wrapping structures **************************/

	.psect popcode,shr,exe,nowrt,long
Lcode_end:
	.psect popdata,noshr,noexe,wrt,long
Ldata_end:

/**************************************************************************/

	.end



/* --- Revision History ---------------------------------------------------
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- John Gibson, Aug 23 1988
	Wrapping structures now use -objmod_pad_key-
--- John Gibson, Jan 17 1988
	Added 'wrapping' strings to enable object files from .s files to
	be mixed in with those from .p source.
		Replaced all references to 'poplog' labels with macros
	C_LAB, I_LAB, etc applied to identifier names, and added appropriate
	declarations between #_< ... >_#, etc.
 */
