/* --- Copyright University of Sussex 1997. All rights reserved. ----------
 * File:            S.vaxvms/src/amisc.s
 * Purpose:         Miscellaneous Assembler routines
 * Author:          John Gibson (see revisions)
 */

	.title  amisc.o         ;;; must be the object file name

#_<

#_INCLUDE 'declare.ph'

vars
	_call_stack_lim, _plog_trail_sp, _plog_trail_lim
	;

section $-Sys;

constant
	procedure (Call_overflow, User_overflow, Callstack_reset,
	Conspair, Plog$-Area_overflow, Async_raise_signal)
	;

endsection;

lconstant macro (
	_KEY		= @@KEY,
	_K_APPLY	= @@K_APPLY,
	_RF_CONT	= @@RF_CONT,
	_PD_EXECUTE	= @@PD_EXECUTE,
	_PD_EXIT	= @@PD_EXIT,
	_PD_FRAME_LEN	= @@PD_FRAME_LEN,
	_PD_UPDATER	= @@PD_UPDATER,
	_P_BACK		= @@P_BACK,
	_P_FRONT	= @@P_FRONT,
	_SF_OWNER	= @@SF_OWNER,
	_V_BYTES	= @@V_BYTES,
	);

>_#

/********************* wrapping structures ***********************************/

	.psect popcode,shr,exe,nowrt,long
	.long   Lcode_end-Lcode_start, C_LAB(Sys$-objmod_pad_key)
Lcode_start:
	.psect popdata,noshr,noexe,wrt,long
	.long   Ldata_end-Ldata_start,C_LAB(Sys$-objmod_pad_key)
Ldata_start:

/**************************************************************************/


	.psect popcode,shr,exe,nowrt,long

;;;---------------------------------------------------------------------------

	;;; applying a poplog object in ARG_REG_0 = r0

	;;; normal checking entry
	.align long
DEF_C_LAB (_popenter)
	blbs	r0, 1$				;;; br if number
	cmpl	_KEY(r0), #C_LAB(procedure_key)	;;; is it a proc?
	bneq	3$				;;; br if not
	jmp	@_PD_EXECUTE(r0)		;;; go straight in to procedure

	.align long
	;;; applying a number - run key apply proc
1$:	movl	r0, -(ap)
	movl	C_LAB(integer_key)+_K_APPLY, r1	;;; key apply (in a ref)
	bbs	#1, r0, 2$			;;; br if integer
	movl	C_LAB(weakref decimal_key)+_K_APPLY, r1 ;;; key apply (in a ref)
2$:	movl	_RF_CONT(r1), r1		;;; the procedure
	jmp	@_PD_EXECUTE(r1)

	.align long
	;;; applying a structure - run key apply proc
3$:	movl	r0, -(ap)
	movl	_KEY(r0), r1
	movl	_K_APPLY(r1), r1		;;; key apply proc (in a ref)
	movl	_RF_CONT(r1), r1		;;; the procedure
	jmp	@_PD_EXECUTE(r1)


;;;---------------------------------------------------------------------------
	.align long

	;;; do checks
DEF_C_LAB (_checkplogall)
	moval	C_LAB(_special_var_block), r1
	cmpl	_SVB_OFFS(_plog_trail_sp)(r1), _SVB_OFFS(_plog_trail_lim)(r1)
	blssu	checkall_cmp
	jmp	XC_LAB(weakref[prologvar_key] Sys$-Plog$-Area_overflow)

	.align long
DEF_C_LAB (_checkall)
	;;; do checks
	moval	C_LAB(_special_var_block), r1
checkall_cmp:
	cmpl	sp, _SVB_OFFS(_call_stack_lim)(r1)
	blssu	3$				;;; br if call stack too long
	cmpl	ap, _SVB_OFFS(_userlim)(r1)
	blssu	4$				;;; br if user stack too long
1$:	blbs	_SVB_OFFS(_trap)(r1), 5$	;;; br if signals pending
2$:	rsb					;;; enter/return proc if not

3$:	bbs	#1, I_LAB(_disable), 1$		;;; continue if stk checks disabled
	jmp	XC_LAB(Sys$-Call_overflow)	;;; if call stk overflow
4$:	bbs	#1, I_LAB(_disable), 1$		;;; continue if stk checks disabled
	jmp	XC_LAB(Sys$-User_overflow)	;;; if user stk overflow
5$:	blbs	I_LAB(_disable), 2$		;;; return if signals disabled
	jmp     XC_LAB(Sys$-Async_raise_signal) ;;; chain to raise async signal

	.align long
DEF_C_LAB (_checkinterrupt)
	blbs	I_LAB(_trap), C_LAB(_checkall)	;;; br if signals pending
	rsb					;;; return if not


;;;---------------------------------------------------------------------------
	.align long

	;;; Unwind the current stack frame, by jumping into the procedure's
	;;; exit code. This subroutine is called immediately after executing
	;;; an M_UNWIND operation, so that the (unwanted) return address into
	;;; the procedure being unwound is above this subroutine's return
	;;; address on the call stack.
	;;;	The procedure's exit code finishes with an "rsb", and we
	;;; replace the return address into the NEXT caller with the return from
	;;; this subroutine, but saving the former in CHAIN_REG (= r4) from
	;;; whence it can be restored with an M_CALL_WITH_RETURN operation.
DEF_C_LAB (_unwind_frame)
	movl	8(sp), r0		;;; caller procedure
	movzbl	_PD_FRAME_LEN(r0), r1	;;; stack frame length
	moval	4(sp)[r1], r2		;;; addr of return addr into NEXT caller
	movl	(r2), r4		;;; save in CHAIN_REG
	movl	(sp), (r2)		;;; replace with my return
	addl2	#8, sp			;;; erase my return and unwanted return
	jmp	@_PD_EXIT(r0)		;;; go into procedure exit code

;;;-------------------------------------------------------------------------

	.align long
	;;; leave a pop procedure and chain another
	;;; Routines to chain a procedure, either directly or out of the
	;;; current caller. These are executed as a result of displacing a stack
	;;; frame return address with their address and then returning with an
	;;; "rsb";;; in the case of _syschain, the displaced return is saved in
	;;; CHAIN_REG.
DEF_C_LAB (_syschain_caller)
	subl2	#4, sp		;;; need dummy return address for _unwind_frame
	bsbb	C_LAB(_unwind_frame)	;;; pop frame for caller
DEF_C_LAB (_syschain)
	pushl	r4		;;; reinstate return address from CHAIN_REG
	movl	(ap)+, r0	;;; procedure to chain on user stack
	brw	C_LAB(_popenter) ;;; run it

	.align long
	;;; The same, but with no check for procedure
DEF_C_LAB (_sysncchain_caller)
	subl2	#4, sp		;;; need dummy return address for _unwind_frame
	bsbb	C_LAB(_unwind_frame)	;;; pop frame for caller
DEF_C_LAB (_sysncchain)
	pushl	r4		;;; reinstate return address from CHAIN_REG
	movl	@(ap)+, r0	;;; get exec address (PD_EXECUTE offset = 0)
	jmp	(r0)		;;; run it

;;;---------------------------------------------------------------------------
	.align long

	;;; applying an object in ARG_REG_0 = r0 in update mode
DEF_C_LAB (_popuenter)
	blbs	r0, upnum		;;; br if number
	cmpl	_KEY(r0), #C_LAB(procedure_key) ;;; procedure?
	bneq	upstr			;;; br if not

DEF_C_LAB (_popuncenter)
	;;; test updater
	movl	_PD_UPDATER(r0), r1	;;; get the updater
	cmpl	r5, r1
	beql	upexc			;;; br if updater false

	;;; ok, so call it
	jmp	@_PD_EXECUTE(r1)

	;;; updater false
upexc:
	movl	r0, -(ap)		;;; give as argument
	jmp	XC_LAB(-> Sys$-Exec_nonpd) ;;; to updater exception proc

	.align long
	;;; applying a number as updater
upnum:	movl	C_LAB(integer_key)+_K_APPLY, r1	;;; key apply (in a ref)
	bbs	#1, r0, upkapp		 	;;; br if integer
	movl	C_LAB(weakref decimal_key)+_K_APPLY, r1 ;;; key apply (in a ref)
	brb	upkapp

	;;; not a procedure  - may be indexed access
upstr:	movl	_KEY(r0), r1
	movl	_K_APPLY(r1), r1	;;; key apply (in a ref)
upkapp: movl	_RF_CONT(r1), r1	;;; the procedure
	movl	_PD_UPDATER(r1), r1	;;; run the updater
	cmpl	r5, r1
	beql	upexc			;;; go there if no updater
	movl	r0, -(ap)		;;; give as arg to key apply proc
	jmp	@_PD_EXECUTE(r1)


;;;---------------------------------------------------------------------------

	;;; erase 1 longword from the call stack and chain Callstack_reset
	;;; (used by Callstack_reset in cleaning up)
DEF_C_LAB (_erase_sp_1)
	movl	(sp)+, (sp)			;;; push return address up one
	jmp	XC_LAB(Sys$-Callstack_reset)	;;; try again

;;;---------------------------------------------------------------------------

	.align long
	;;; get next stack frame - pointer assumed to point at owner
DEF_C_LAB (_nextframe)
	movl	(ap), r0		;;; frame pointer
	movl	_SF_OWNER(r0), r1	;;; owner address
	movzbl	_PD_FRAME_LEN(r1), r2	;;; frame size
	moval	(r0)[r2], (ap)		;;; pointer to next owner
	rsb

;;;---------------------------------------------------------------------------

	.align long
	;;; fast routines for subscrs and its updater

DEF_C_LAB (_subss)
	movl	(ap)+, r0		;;; string address
	ashl	#-2, (ap), r1		;;; pop integer subscript
	movzbl	_V_BYTES-1(r0)[r1], r1	;;; get the byte
	ashl	#2, r1, r1		;;; convert to popint
	bisl3	#3, r1, (ap)
	rsb

	.align long
DEF_C_LAB (-> _subss)
DEF_C_LAB (_u_subss)
	movl	(ap)+, r0		;;; string address
	ashl	#-2, (ap)+, r1		;;; popint subscript
	ashl	#-2, (ap)+, r2		;;; convert byte to sysint
	movb	r2, _V_BYTES-1(r0)[r1]	;;; insert byte
	rsb

;;;---------------------------------------------------------------------------

	;;; boolean functions
	.align long
DEF_C_LAB (_iscompound)
	blbc	(ap), true1
	brb	false1

	.align long
DEF_C_LAB (_issimple)
	blbs	(ap), true1
	brb	false1

	.align long
DEF_C_LAB (_isinteger)
	bbs	#1, (ap), true1
	brb	false1

	.align long
DEF_C_LAB (_haskey)
	movl	(ap)+, r0	;;; the key
	movl	(ap), r1	;;; the object
	blbs	r1, false1	;;; br if popnum
	cmpl	r0, _KEY(r1)
	beql	true1
	brb	false1

	.align long
DEF_C_LAB 4 (_bitst)
	bitl	(ap)+, (ap)
	bneq	true1
	brb	false1

	.align long
false1:
	movl	r5, (ap)
	rsb
	.align long
true1:
	moval	C_LAB(true), (ap)
	rsb

	.align long
DEF_C_LAB 6 (_gr)
	cmpl	(ap)+, (ap)
	blssu	true1
	brb	false1

	.align long
DEF_C_LAB 6 (_greq)
	cmpl	(ap)+, (ap)
	blequ	true1
	brb	false1

	.align long
DEF_C_LAB 6 (_lt)
	cmpl	(ap)+, (ap)
	bgtru	true1
	brb	false1

	.align long
DEF_C_LAB 6 (_lteq)
	cmpl	(ap)+, (ap)
	bgequ	true1
	brb	false1

	.align long
DEF_C_LAB 6 (_sgr)
	cmpl	(ap)+, (ap)
	blss	true1
	brb	false1

	.align long
DEF_C_LAB 6 (_sgreq)
	cmpl	(ap)+, (ap)
	bleq	true1
	brb	false1

	.align long
DEF_C_LAB 6 (_slt)
	cmpl	(ap)+, (ap)
	bgtr	true1
	brb	false1

	.align long
DEF_C_LAB 6 (_slteq)
	cmpl	(ap)+, (ap)
	bgeq	true1
	brb	false1

	.align long
DEF_C_LAB (_not)
	cmpl	r5, (ap)
	beql	true1
	brb	false1

	.align long
DEF_C_LAB 7 (_neq)
	cmpl	(ap)+, (ap)
	bneq	true1
	brb	false1

	.align long
DEF_C_LAB 7 (_eq)
	cmpl	(ap)+, (ap)
	beql	true1
	brb	false1

	.align long
DEF_C_LAB (_zero)
	tstl	(ap)
	beql	true1
	brb	false1

	.align long
DEF_C_LAB (_neg)
	tstl	(ap)
	blss	true1
	brb	false1

;;;---------------------------------------------------------------------------

	.align long
	;;; get the key of any pop object
DEF_C_LAB (_datakey)
	movl	(ap), r0		;;; the object
	blbs	r0, 1$			;;; br if not pointer
	movl	_KEY(r0), (ap)		;;; the key from the record
	rsb
1$:	bbc	#1, r0, 2$		;;; br if decimal
	movl	#C_LAB(integer_key), (ap)		;;; integer
	rsb
2$:	movl	#C_LAB(weakref decimal_key), (ap)	;;; decimal
	rsb

;;;---------------------------------------------------------------------------

	.align long
	;;; optimise subroutine for "conspair"
DEF_C_LAB (_conspair)
	movl	I_LAB(Sys$- _free_pairs), r0	;;; get free pair list
	blbs	r0, 1$			;;; if simple, then none left
	movl	_P_BACK(r0), I_LAB(Sys$- _free_pairs) ;;; move the next back to _free_pairs
	movl	(ap)+, _P_BACK(r0)	;;; init back
	movl	(ap), _P_FRONT(r0)	;;; init front
	movl	r0, (ap)		;;; return the pair
	rsb
1$:	jmp	XC_LAB(Sys$-Conspair)	;;; none left, chain to Conspair


;;;---------------------------------------------------------------------------

	.align long
false2:
	movl	r5, (ap)
	rsb
	.align long
true2:
	moval	C_LAB(true), (ap)
	rsb

;;;---------------------------------------------------------------------------

	.align long
	;;; search/skip string for character
DEF_C_LAB (_locc)
	movq	(ap)+, r0	;;; r0=char, r1=string length
	locc	r0, r1, @(ap)
	bneq	1$		;;; br if found
	movl	#-1, (ap)	;;; return -1 if not found
	rsb
1$:	subl3	(ap), r1, (ap)	;;; return offset to char
	rsb

	.align long
DEF_C_LAB (_skpc)
	movq	(ap)+, r0	;;; r0=char, r1=string length
	skpc	r0, r1, @(ap)
	bneq	1$		;;; br if something else found
	movl	#-1, (ap)	;;; return -1 if nothing else found
	rsb
1$:	subl3	(ap), r1, (ap)	;;; return offset to char
	rsb


;;;--------------------------------------------------------------------------

	;;; move the user stack up or down
DEF_C_LAB (_move_userstack)
	movl	(ap)+, r2		;;; amount to shift in bytes
	subl3	ap, I_LAB(_userhi), r0	;;; length of u/s to move
	movl	ap, r1			;;; u/s top - moving from here
	addl2	r2, I_LAB(_userhi)	;;; new userhi
	addl2	ap, r2			;;; where moving to
	movl	r2, ap			;;; correct ap
	jmp	movchars		;;; move the user stack and return


;;; -------------------------------------------------------------------------

	;;; Set registers for pop environment
reset_pop_reg_environ::
	;;; set constant registers
	moval	C_LAB(false), r5	;;; r5 must always be false
	;;; set pop lvar registers to sensible values (false)
	movl	r5, r6
	movl	r5, r7
	rsb


;;; --- RMS I/O CONTROL BLOCKS -------------------------------------------

	.psect  popcode,shr,exe,nowrt,long
	.align long
DEF_C_LAB (Sys$-Io$- _fab_template)
	$fab
DEF_C_LAB (Sys$-Io$- _rab_template)
	$rab
DEF_C_LAB (Sys$-Io$- _nam_template)
	$nam

	.psect  popnosrdata,noshr,noexe,wrt,long
	.align long
DEF_C_LAB (Sys$-Io$- _work_fhcxab)
	$xabfhc
DEF_C_LAB (Sys$-Io$- _work_datxab)
	$xabdat
DEF_C_LAB (Sys$-Io$- _work_proxab)
	$xabpro
DEF_C_LAB (Sys$-Io$- _work_nam)
	$nam
DEF_C_LAB (Sys$-Io$- _work_ufofab)
	$fab fop = <ufo>, nam = ufonam

ufonam:
	$nam


/*************** end labels for wrapping structures **************************/

	.psect popcode,shr,exe,nowrt,long
Lcode_end:
	.psect popdata,noshr,noexe,wrt,long
Ldata_end:

/**************************************************************************/

	.end



/* --- Revision History ---------------------------------------------------
--- John Gibson, Feb 10 1997
	Removed _mt*chc subroutine
--- John Gibson, Oct 18 1994
	free*pairs -> _free_pairs
--- John Gibson, Sep 28 1994
	Removed the timeval_to/from_quadtime routines -- rewritten in
	C in c_core.c
--- John Gibson, Sep 12 1994
	Removed _fi*ndc subroutine
--- John Gibson, Nov 10 1993
	Moved in all the code from amain.s, except the entry procedure
--- John Gibson, Jan  5 1991
	Replaced quadtime subroutines with timeval<->quadtime conversion
	procedures.
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- John Gibson, Jan 15 1989
	Replaced use of UC_LAB etc for updater with -> before pathname
--- Roger Evans, Sep 26 1988
	Timer and spawn ast code moved to asignals.s
--- John Gibson, Aug 23 1988
	Wrapping structures now use -objmod_pad_key-
--- John Gibson, Jan 17 1988
	Added 'wrapping' strings to enable object files from .s files to
	be mixed in with those from .p source.
		Replaced all references to 'poplog' labels with macros
	C_LAB, I_LAB, etc applied to identifier names, and added appropriate
	declarations between #_< ... >_#, etc.
--- John Gibson, Aug 14 1987
	Changed for segmented system
 */
