/* --- Copyright University of Sussex 1995. All rights reserved. ----------
 * File:	    S.vaxvms/src/amove.s
 * Purpose:	    Move subroutines
 * Author:	    John Gibson (see revisions)
 */

	.title	amove.o		;;; must be the object file name

#_<

#_INCLUDE 'declare.ph'

>_#

/********************* wrapping structures ***********************************/

	.psect popcode,shr,exe,nowrt,long
	.long	Lcode_end-Lcode_start, C_LAB(Sys$-objmod_pad_key)
Lcode_start:
	.psect popdata,noshr,noexe,wrt,long
	.long	Ldata_end-Ldata_start,C_LAB(Sys$-objmod_pad_key)
Ldata_start:

/**************************************************************************/


	.psect popcode,shr,exe,nowrt,long

;;; ------------------------------------------------------------------------

	.align long
	;;; compare two byte/word/longword regions of the same length
DEF_C_LAB (_bcmp)
DEF_C_LAB (_scmp)
DEF_C_LAB (_icmp)
DEF_C_LAB (_cmp)
	movq	(ap)+, r1		;;; r1 = region2 addr, r2 = region1 addr
	cmpc3	(ap), (r1), (r2)	;;; compare them
	beql	1$
	movl	r5, (ap)		;;; false for not equal
	rsb
1$:	moval	C_LAB(true), (ap)	;;; true for equal
	rsb

;;; ------------------------------------------------------------------------

	.align long
	;;; move a region of longwords
	;;; this (quick) routine only handles more than 64k bytes when
	;;; source/dest overlap if moving DOWN
DEF_C_LAB (_moveq)
	movl	(ap)+, r3		;;; destination
	movl	(ap)+, r1		;;; source
	brb	2$

1$:	movb	(r1)+, (r3)+		;;; move a single byte after sobgeq
2$:	movc3	(ap), (r1), (r3)	;;; move the low-word count (uses r5)
	clrw	(ap)			;;; then zero it
	sobgeq	(ap), 1$		;;; reduce total by 1 and if finished
	movl	r3, (ap)		;;; return next destination
	moval	C_LAB(false), r5	;;; restore r5 to false
	rsb

	;;; move a region of bytes/longwords
	;;; this one handles any move whatever
	.align long
DEF_C_LAB (_bmove)
DEF_C_LAB (_smove)
DEF_C_LAB (_imove)
DEF_C_LAB (_dmove)
DEF_C_LAB (_move)
	movl	(ap)+, r2		;;; destination
	movl	(ap)+, r1		;;; source
	movl	(ap), r0		;;; size in bytes
	addl3	r0, r2, (ap)		;;; return next destination
	brb	movchars

;;;-------------------------------------------------------------------------

	.align long
	;;; another routine to move store - this is called with num in
	;;; r0, source in r1 and dest in r2. this handles any size of move
	;;; regardless of direction
movchars::
	bitl	#^XFFFF0000, r0		;;; move more than 64K bytes?
	bneq	11$			;;; br if so
	movc3	r0, (r1), (r2)		;;; else just one move (uses r5)
	moval	C_LAB(false), r5	;;; restore r5 to false
	rsb
11$:	cmpl	r1, r2			;;; source less than dest?
	blssu	3$			;;; br if so
	bneq	0$			;;; br if not equal
	rsb
	;;; moving down
0$:	movl	r6, @#saveregs		;;; save r6
	movl	r0, r6
	movl	r2, r3
	brb	2$
1$:	movb	(r1)+, (r3)+		;;; move a single byte after sobgeq
2$:	movc3	r6, (r1), (r3)		;;; move the low-word count (uses r5)
	clrw	r6
	sobgeq	r6, 1$			;;; reduce total by 1
	movl	@#saveregs, r6		;;; restore r6
	moval	C_LAB(false), r5	;;; restore r5 to false
	rsb
	;;; moving up
3$:	movq	r6, @#saveregs		;;; save r6, r7, r8
	movl	r8, @#saveregs+8
	movl	r0, r6
	addl3	r0, r1, r7		;;; after end of source
	subl3	r1, r2, r8		;;; offset to move
	brb	5$
4$:	movb	-(r7), (r7)[r8]		;;; move a single byte after sobgeq
5$:	movzwl	r6, r2
	clrw	r6
	subl	r2, r7
	movc3	r2, (r7), (r7)[r8]	;;; move the low-word count (uses r5)
	sobgeq	r6, 4$			;;; reduce total by 1
	movq	@#saveregs, r6		;;; restore r6, r7, r8
	movl	@#saveregs+8, r8
	moval	C_LAB(false), r5	;;; restore r5 to false
	rsb

;;; ------------------------------------------------------------------------

	;;; fill a region of bytes with a given byte
	.align long
DEF_C_LAB (_bfill)
	movl	(ap)+, r3		;;; destination
	brb	2$			;;; use length and byte from the stack

1$:	movb	4(ap), (r3)+		;;; move a single byte after sobgeq
2$:	movc5	#0, 0, 4(ap) , (ap), (r3) ;;; do the low-word count (uses r5)
	clrw	(ap)			;;; then zero it
	sobgeq	(ap), 1$		;;; reduce total by 1
	addl2	#8, ap			;;; remove the length and byte operands
	moval	C_LAB(false), r5	;;; restore r5 to false
	rsb

	;;; fill a region of longwords with a given longword
	.align long
DEF_C_LAB (_ifill)
DEF_C_LAB (_fill)
	tstl	8(ap)			;;; filling with 0?
	beql	C_LAB(_bfill)		;;; do byte fill if so
	movq	(ap)+, r1		;;; r1=destination, r2=length in bytes
	movl	(ap)+, r0		;;; fill operand
	addl2	r1, r2			;;; limit address
	brb	2$
1$:	movl	r0, (r1)+		;;; fill one
2$:	cmpl	r1, r2
	blssu	1$			;;; continue if not reached limit
	rsb				;;; else return

;;;-------------------------------------------------------------------------

	;;; _move_callstack(_woffs, _limaddr)
	;;; Move the callstack area from _sp() to _limaddr up by _woffs

	.align long
DEF_C_LAB(_move_callstack)
	subl3	sp, (ap)+, r0	;;; limaddr - sp = no. of bytes to move in r0
	addl3	sp, (ap)+, r2	;;; sp + no. of bytes to shift UP by = dest

	;;; this bit is to reset the value of the frame pointer reg fp
	;;; when Extern$-Callback erases a block of external calls (on
	;;; abnormal exit thru them)
	addl3	r0, r2, r3	;;; r3 = lim address of dest area
1$:	cmpl	r3, fp		;;; fp at or above that address?
	blequ	2$		;;; OK if so
	movl	12(fp), fp	;;; else erase a frame (12 = next fp)
	brb	1$		;;; then test next

2$:	movl	sp, r1		;;; source address in r1
	movl	r2, sp		;;; new sp after move
	brw	movchars	;;; sp points to return address after



	.psect popnosrdata, noshr, wrt, noexe, long
saveregs:
	.blkl 3


/*************** end labels for wrapping structures **************************/

	.psect popcode,shr,exe,nowrt,long
Lcode_end:
	.psect popdata,noshr,noexe,wrt,long
Ldata_end:

/**************************************************************************/

	.end



/* --- Revision History ---------------------------------------------------
--- John Gibson, Apr  6 1995
	Added _icmp, _imove, _dmove, _ifill as equivalent to word versions
--- John Gibson, Apr 30 1990
	Added code to _move_callstack to deal with ensuring fp has the
	right value on abnormal exit from callback through external calls
--- John Gibson, Jan 19 1990
	Last change had overlooked that movc3/5 instructions use r5 --
	made routines using these restore r5 afterwards.
--- John Gibson, Nov 29 1989
	Reg r5 now caches address of false -- made appropriate changes.
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- John Gibson, Aug 23 1988
	Wrapping structures now use -objmod_pad_key-
--- John Gibson, Aug  2 1988
	_movebits removed (replaced by Sys$-Move_bits in movebits.p)
--- John Gibson, Mar  4 1988
	Replaced _move_restore_frame and _expand_plog_area with
	_move_callstack
--- John Gibson, Feb 14 1988
	Subroutines _movetabtrans_in/out no longer needed (replaced with
	sysPOP procedures in vdfileio.p).
--- John Gibson, Jan 17 1988
	Added 'wrapping' strings to enable object files from .s files to
	be mixed in with those from .p source.
		Replaced all references to 'poplog' labels with macros
	C_LAB, I_LAB, etc applied to identifier names, and added appropriate
	declarations between #_< ... >_#, etc.
--- John Gibson, Jul 26 1987
	Removed _vedscanline (-vedrefreshtail- rewritten to do without it).
 */
