/* --- Copyright University of Sussex 1994. All rights reserved. ----------
 * File:            S.vaxvms/src/aprocess.s
 * Purpose:
 * Author:          John Gibson (see revisions)
 */

	.title	aprocess.o	;;; must be the object file name

;;; --- ROUTINES TO HANDLE PROCESS CALL STACK SWAPPING -----------------------

#_<

#_INCLUDE 'declare.ph'
#_INCLUDE 'process.ph'

lconstant macro (
	_ID_VALOF		= @@ID_VALOF,
	_PD_EXIT		= @@PD_EXIT,
	_PD_FLAGS		= @@PD_FLAGS,
	_PD_FRAME_LEN		= @@PD_FRAME_LEN,
	_PD_NLOCALS		= @@PD_NLOCALS,
	_PD_NUM_STK_VARS	= @@PD_NUM_STK_VARS,
	_PD_REGMASK		= @@PD_REGMASK,
	_PD_TABLE		= @@PD_TABLE,
	_PS_CALLSTACK_LIM	= @@PS_CALLSTACK_LIM,
	_PS_CALLSTACK_PARTIAL	= @@PS_CALLSTACK_PARTIAL,
	_PS_FLAGS		= @@PS_FLAGS,
	_PS_PARTIAL_RETURN 	= @@PS_PARTIAL_RETURN,
	_PS_STATE		= @@PS_STATE,
	);

>_#

/********************* wrapping structures ***********************************/

	.psect popcode,shr,exe,nowrt,long
	.long	Lcode_end-Lcode_start, C_LAB(Sys$-objmod_pad_key)
Lcode_start:
	.psect popdata,noshr,noexe,wrt,long
	.long	Ldata_end-Ldata_start, C_LAB(Sys$-objmod_pad_key)
Ldata_start:

/**************************************************************************/

	/***************************************************
	*  N.B. Because signals can interrupt on any       *
	*  instruction, -sp- must never be `out of phase', *
	*  i.e. pointing above data that's still wanted.   *
	****************************************************/

	.psect  popcode,shr,nowrt,exe,long


	;;; size of an I_BRANCH_std instruction, i.e. a "brw"
BRANCH_std = 3


	;;; swap out the callstack for a process
	.align long
DEF_C_LAB (_swap_out_callstack)
	movl	(ap)+, r0		;;; the process
	movl	r0, process		;;; save it here
	movl	_PS_CALLSTACK_LIM(r0), r5	;;; limit of saved callstack
	movl	_PS_STATE(r0), r3	;;; start of saved callstack
	movl	ap, sav_ap		;;; save ap
	brw	sotest

soloop:	movq	(sp)+, r0		;;; r0 = return addr, r1 = owner
	subl2	r1, r0			;;; make return address relative

	;;; test if has dlocal expression code to run
	bitb	_PD_FLAGS(r1), #_:M_PD_PROC_DLEXPR_CODE
	beql	socont			;;; no -- continue
	brw	sobrk			;;; yes -- break out to run code

	;;; (continue here after break)
socont:
	movzbl	_PD_FRAME_LEN(r1), r2	;;; frame length in longwords
	mnegl	r2, r2
	moval	(r5)[r2], r5		;;; start of frame in process
	movl	r5, r2			;;; use r2 to work up frame
	movq	r0, (r2)+		;;; copy in rel ret addr and owner

	movzbl	_PD_NUM_STK_VARS(r1), r0 ;;; number of on-stack vars
	beql	2$			;;; branch if none
1$:	movl	(sp)+, (r2)+		;;; copy stack lvars into process
	sobgtr	r0, 1$

2$:	movzbl	_PD_NLOCALS(r1), r0	;;; any dlocals to save/restore?
	beql	4$			;;; br if not
	moval	_PD_TABLE(r1)[r0], r4	;;; end of local identifier table
3$:	movl	-(r4), ap		;;; next identifier ptr
	movl	_ID_VALOF(ap), (r2)+	;;; save current idval in process
	movl	(sp)+, _ID_VALOF(ap)	;;; restore value from stack
	sobgtr	r0, 3$

4$:	movzwl	_PD_REGMASK(r1), r0	;;; switch value for local registers
	jmp	5$[r0]

	;;; 20 byte code sections
5$:	brw	sotest			;;;
	.byte	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

	movl	r7, (r2)+		;;;   7
	movl	(sp)+, r7
	brw	sotest
	.byte	0,0,0,0,0,0,0,0,0,0,0

	movq	r6, (r2)+		;;; 6,7
	movq	(sp)+, r6
	brw	sotest
	.byte	0,0,0,0,0,0,0,0,0,0,0

	movl	r8, (r2)+		;;;      8
	movl	(sp)+, r8
	brw	sotest
	.byte	0,0,0,0,0,0,0,0,0,0,0

	movq	r7, (r2)+		;;;   7  8
	movq	(sp)+, r7
	brw	sotest
	.byte	0,0,0,0,0,0,0,0,0,0,0

	movl	r6, (r2)+		;;; 6,7  8
	movq	r7, (r2)+
	movl	(sp)+, r6
	movq	(sp)+, r7
	brw	sotest
	.byte	0,0,0,0,0

	movq	r8, (r2)+		;;;      8,9
	movq	(sp)+, r8
	brw	sotest
	.byte	0,0,0,0,0,0,0,0,0,0,0

	movl	r7, (r2)+		;;;   7  8,9
	movq	r8, (r2)+
	movl	(sp)+, r7
	movq	(sp)+, r8
	brw	sotest
	.byte	0,0,0,0,0

	movq	r6, (r2)+		;;; 6,7  8,9
	movq	r8, (r2)+
	movq	(sp)+, r6
	movq	(sp)+, r8
	brb	sotest
	.byte	0,0,0,0,0,0

	movl	r8, (r2)+		;;;      8,9,10
	movq	r9, (r2)+
	movl	(sp)+, r8
	movq	(sp)+, r9
	brb	sotest
	.byte	0,0,0,0,0,0

	movq	r7, (r2)+		;;;   7  8,9,10
	movq	r9, (r2)+
	movq	(sp)+, r7
	movq	(sp)+, r9
	brb	sotest
	.byte	0,0,0,0,0,0

	movl	r6, (r2)+		;;; 6,7  8,9,10
	movq	r7, (r2)+
	movq	r9, (r2)+
	movl	(sp)+, r6
	movq	(sp)+, r7
	movq	(sp)+, r9
	brb	sotest

	movq	r8, (r2)+		;;;      8,9,10,11
	movq	r10, (r2)+
	movq	(sp)+, r8
	movq	(sp)+, r10
	brb	sotest
	.byte	0,0,0,0,0,0

	movl	r7, (r2)+		;;;   7  8,9,10,11
	movq	r8, (r2)+
	movq	r10, (r2)+
	movl	(sp)+, r7
	movq	(sp)+, r8
	movq	(sp)+, r10
	brb	sotest

	movq	r6, (r2)+		;;; 6,7  8,9,10,11
	movq	r8, (r2)+
	movq	r10, (r2)+
	movq	(sp)+, r6
	movq	(sp)+, r8
	movq	(sp)+, r10

sotest:	cmpl	r5, r3			;;; reached the beginning?
	blequ	1$			;;; yes
	brw	soloop			;;; next frame if not

	;;; finished -- chain procedure on stack
1$:	movl	process, r0
	clrl	_PS_CALLSTACK_PARTIAL(r0) ;;; ensure PARTIAL reset to NULL
	clrw	_PS_FLAGS(r0)		;;; 0 process flags = suspended
	moval	C_LAB(false), r5	;;; restore r5 to false
	movl	sav_ap, ap		;;; restore ap
	movl	@(ap)+, r0		;;; exec address
	jmp	(r0)			;;; chain it

	;;; come here to run dlocal expression code, by jumping into the
	;;; owner procedure. owner is in r1 and relative return address in r0
sobrk:	pushl	r1			;;; owner back on stack
	movl	process, r4		;;; pass process in CHAIN_REG
	movl	r0, _PS_PARTIAL_RETURN(r4)	;;; save relative return in PARTIAL_RETURN
	movl	r5, _PS_CALLSTACK_PARTIAL(r4)	;;; save r5 in CALLSTACK_PARTIAL
	moval	C_LAB(false), r5	;;; restore r5 to false
	movl	sav_ap, ap		;;; restore ap
	movl	_PD_EXIT(r1), r1	;;; exit code base address
	jmp	-BRANCH_std*2(r1)	;;; go into procedure's suspend code

	;;; then return from procedure's suspend code is to here
	;;; (process in CHAIN_REG = r4)
DEF_C_LAB (_swap_out_continue)
	movl	_PS_CALLSTACK_PARTIAL(r4), r5	;;; restore r5
	movl	_PS_STATE(r4), r3		;;; restore limit
	movl	_PS_PARTIAL_RETURN(r4), r0 ;;; relative return back in r0
	movl	(sp)+, r1		;;; restore owner to r1
	movl	r4, process		;;; re-save process
	movl	ap, sav_ap		;;; save ap
	brw	socont			;;; continue swap-out



	;;; swap in the callstack for a process
	.align long
DEF_C_LAB (_swap_in_callstack)
	movl	(ap)+, r0		;;; the process
	movl	r0, process		;;; save it here
	movl	ap, sav_ap		;;; save ap
	movl	_PS_CALLSTACK_LIM(r0), r3	;;; limit of saved callstack
	movl	_PS_STATE(r0), r5	;;; start of saved callstack
	brw	sitest

siloop:	movq	(r5)+, r0		;;; rel return addr in r0, owner in r1
	addl2	r1, r0			;;; make return absolute

	movzbl	_PD_FRAME_LEN(r1), r2	;;; frame length in longwords
	mnegl	r2, r2
	moval	(sp)[r2], sp		;;; start of frame on stack
	movl	sp, r2			;;; use r2 to work up frame
	movq	r0, (r2)+		;;; copy in abs ret addr and owner

	movzbl	_PD_NUM_STK_VARS(r1), r0 ;;; number of on-stack vars
	beql	2$			;;; branch if none
1$:	movl	(r5)+, (r2)+		;;; copy process lvars onto stack
	sobgtr	r0, 1$

2$:	movzbl	_PD_NLOCALS(r1), r0	;;; any dlocals to save/restore?
	beql	4$			;;; br if not
	moval	_PD_TABLE(r1)[r0], r4	;;; end of local identifier table
3$:	movl	-(r4), ap		;;; next identifier ptr
	movl	_ID_VALOF(ap), (r2)+	;;; save current idval on stack
	movl	(r5)+, _ID_VALOF(ap)	;;; restore value from process
	sobgtr	r0, 3$

4$:	movzwl	_PD_REGMASK(r1), r0	;;; switch value for local registers
	jmp	5$[r0]

	;;; 20 byte code sections
5$:	brw	6$			;;;
	.byte	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

	movl	r7, (r2)+		;;;   7
	movl	(r5)+, r7
	brw	6$
	.byte	0,0,0,0,0,0,0,0,0,0,0

	movq	r6, (r2)+		;;; 6,7
	movq	(r5)+, r6
	brw	6$
	.byte	0,0,0,0,0,0,0,0,0,0,0

	movl	r8, (r2)+		;;;      8
	movl	(r5)+, r8
	brw	6$
	.byte	0,0,0,0,0,0,0,0,0,0,0

	movq	r7, (r2)+		;;;   7  8
	movq	(r5)+, r7
	brw	6$
	.byte	0,0,0,0,0,0,0,0,0,0,0

	movl	r6, (r2)+		;;; 6,7  8
	movq	r7, (r2)+
	movl	(r5)+, r6
	movq	(r5)+, r7
	brw	6$
	.byte	0,0,0,0,0

	movq	r8, (r2)+		;;;      8,9
	movq	(r5)+, r8
	brw	6$
	.byte	0,0,0,0,0,0,0,0,0,0,0

	movl	r7, (r2)+		;;;   7  8,9
	movq	r8, (r2)+
	movl	(r5)+, r7
	movq	(r5)+, r8
	brw	6$
	.byte	0,0,0,0,0

	movq	r6, (r2)+		;;; 6,7  8,9
	movq	r8, (r2)+
	movq	(r5)+, r6
	movq	(r5)+, r8
	brb	6$
	.byte	0,0,0,0,0,0

	movl	r8, (r2)+		;;;      8,9,10
	movq	r9, (r2)+
	movl	(r5)+, r8
	movq	(r5)+, r9
	brb	6$
	.byte	0,0,0,0,0,0

	movq	r7, (r2)+		;;;   7  8,9,10
	movq	r9, (r2)+
	movq	(r5)+, r7
	movq	(r5)+, r9
	brb	6$
	.byte	0,0,0,0,0,0

	movl	r6, (r2)+		;;; 6,7  8,9,10
	movq	r7, (r2)+
	movq	r9, (r2)+
	movl	(r5)+, r6
	movq	(r5)+, r7
	movq	(r5)+, r9
	brb	6$

	movq	r8, (r2)+		;;;      8,9,10,11
	movq	r10, (r2)+
	movq	(r5)+, r8
	movq	(r5)+, r10
	brb	6$
	.byte	0,0,0,0,0,0

	movl	r7, (r2)+		;;;   7  8,9,10,11
	movq	r8, (r2)+
	movq	r10, (r2)+
	movl	(r5)+, r7
	movq	(r5)+, r8
	movq	(r5)+, r10
	brb	6$

	movq	r6, (r2)+		;;; 6,7  8,9,10,11
	movq	r8, (r2)+
	movq	r10, (r2)+
	movq	(r5)+, r6
	movq	(r5)+, r8
	movq	(r5)+, r10

	;;; test if has dlocal expression code to run
6$:	bitb	_PD_FLAGS(r1), #_:M_PD_PROC_DLEXPR_CODE
	bneq	sibrk			;;; yes -- break out to run code

	;;; (continue here after break)
sitest:	cmpl	r5, r3			;;; reached the end?
	bgequ	1$			;;; yes
	brw	siloop			;;; next frame if not

	;;; finished -- call procedure off stack
1$:	moval	C_LAB(false), r5	;;; restore r5 to false
	movl	sav_ap, ap		;;; restore ap
	movl	process, r0
	clrl	_PS_CALLSTACK_PARTIAL(r0) ;;; ensure PARTIAL reset to NULL
	movl	@(ap)+, r0		;;; exec address of procedure
	jmp	(r0)			;;; call it with existing return

	;;; come here to run dlocal expression code, by jumping into the
	;;; owner procedure. owner is in r1.
sibrk:	movl	process, r4		;;; process into CHAIN_REG
	subl3	r1, (sp)+, _PS_PARTIAL_RETURN(r4) ;;; save rel return in proc
	movl	r5, _PS_CALLSTACK_PARTIAL(r4)	;;; save r5 in process
	moval	C_LAB(false), r5	;;; restore r5 to false
	movl	sav_ap, ap		;;; restore ap
	movl	_PD_EXIT(r1), r1	;;; exit code base address
	jmp	-BRANCH_std(r1)		;;; go into procedure's resume code

	;;; then return from procedure's resume code is to here
	;;; (process in CHAIN_REG = r4)
DEF_C_LAB (_swap_in_continue)
	movl	_PS_CALLSTACK_PARTIAL(r4), r5	;;; restore r5
	movl	_PS_CALLSTACK_LIM(r4), r3	;;; restore limit
	addl3	(sp), _PS_PARTIAL_RETURN(r4), -(sp) ;;; abs return back on stack
	movl	r4, process		;;; re-save process
	movl	ap, sav_ap		;;; save ap
	brb	sitest			;;; continue swap-in



;;; --- ROUTINES TO HANDLE USERSTACK SWAPPING -------------------------------

	.align long
DEF_C_LAB (_ussave)
	pushl   r6			;;; save r6
	movl    (ap)+, r2		;;; address to store saved part
	movl    (ap)+, r0		;;; length to save
	subl3   r0, I_LAB(_userhi), r1	;;; where it starts
	movl    r1, r6			;;; save that
	jsb     movchars		;;; save the part underneath
	;;; now reposition the top part
	subl3   ap, r6, r0		;;; length of remainder
	movl    ap, r1			;;; start of u/s
	subl3   r0, I_LAB(_userhi), ap	;;; where it will start
	movl    ap, r2
	jsb     movchars
	popl    r6			;;; restore r6
	rsb

	.align long
DEF_C_LAB (_usrestore)
	pushl	r7			;;; save r6 & 7
	pushl	r6
	movl    (ap)+, r7		;;; address of part to restore
	movl    (ap)+, r6		;;; length of it
	subl3   ap, I_LAB(_userhi), r0	;;; length of current u/s
	movl    ap, r1			;;; start of it
	subl    r6, ap			;;; where it will start
	movl    ap, r2
	jsb     movchars		;;; move current u/s to make room
	movq    r6, r0			;;; length of saved area and start of it
	subl3   r6, I_LAB(_userhi), r2	;;; where to put it
	jsb     movchars		;;; restore it under rest
	movq	(sp)+, r6		;;; restore r6 & 7
	rsb

DEF_C_LAB (_userasund)
	addl3   (ap)+, ap, r2		;;; where stack will start
	subl3   r2, I_LAB(_userhi), r0	;;; length of remainder
	movl    ap, r1
	movl    r2, ap
	jsb     movchars
	rsb


;;; -----------------------------------------------------------------------

	.psect  popnosrdata,noshr,noexe,wrt,long

process:	.long	0
sav_ap: 	.long   0


/*************** end labels for wrapping structures **************************/

	.psect popcode,shr,exe,nowrt,long
Lcode_end:
	.psect popdata,noshr,noexe,wrt,long
Ldata_end:

/**************************************************************************/

	.end



/* --- Revision History ---------------------------------------------------
--- John Gibson, Sep 23 1994
	Removed _us*eras
--- John Gibson, Jun 15 1991
	Made _swap_in_callstack call a procedure off the stack when
	finished
--- John Gibson, Sep 29 1990
	Process swap routines rewritten so that -sp- is always in a kosher
	state for an interrupt on any instruction.
--- John Gibson, Dec  6 1989
	Changes for new pop pointers (use explicit ID_VALOF offset)
--- John Gibson, Nov 29 1989
	Reg r5 now caches address of false -- made process code that uses it
	restore it afterwards.
--- John Gibson, Oct  5 1989
	_swap_out_callstack now clears the process' flags and chains the
	procedure on the stack when finished; the SWAP_BACK_IN flag is
	therefore unnecessary.
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- John Gibson, Aug 23 1988
	Wrapping structures now use -objmod_pad_key-
--- John Gibson, Jul  5 1988
	Made all return addresses stored in process records relative.
--- John Gibson, Jul  3 1988
	Replaced double word field PS_PARTIAL_SAVE with single word field
	PS_PARTIAL_RETURN holding the relative return address (i.e.
	return address minus owner procedure).
--- John Gibson, Jan 17 1988
	Added 'wrapping' strings to enable object files from .s files to
	be mixed in with those from .p source.
		Replaced all references to 'poplog' labels with macros
	C_LAB, I_LAB, etc applied to identifier names, and added appropriate
	declarations between #_< ... >_#, etc.
 */
