/* --- Copyright University of Sussex 1994. All rights reserved. ----------
 > File:            C.vax/src/array_cons.p
 > Purpose:			Constructing array procedures (VAX version)
 > Author:          John Gibson (see revisions)
 > Related Files:   C.vax/src/ass.p, C.all/src/arrays.p
*/

#_INCLUDE 'declare.ph'

constant
		_array_sub
	;


;;; -----------------------------------------------------------------------

section $-Sys;

	;;; macros for dropping longs, shorts, bytes and immediates at _drop_ptr
lconstant macro (
	LONG	= [_drop_ptr!(l)++ -> _drop_ptr],
	SHORT	= [_drop_ptr!(s)++ -> _drop_ptr],
	BYTE	= [_drop_ptr!(b)++ -> _drop_ptr],
	);

	/*	Construct a raw array procedure. _________tabsize is the word offset size of
		the array params starting at PD_ARRAY_TABLE.
	*/
define $-Sys$-Array$-Cons(_tabsize) -> _arrayp;
	lvars _tabsize, _arrayp, _drop_ptr, _size;

	;;; get procedure record -- 4 words of code
	@@PD_ARRAY_TABLE{_tabsize} _add @@(w)[_4] _sub @@POPBASE -> _size;
	Get_store(_size) -> _arrayp;

	;;; initialise some of procedure header
	##(w){_size} -> _arrayp!PD_LENGTH;
	_0		->> _arrayp!PD_REGMASK
			->> _arrayp!PD_NUM_STK_VARS
			->> _arrayp!PD_NUM_PSTK_VARS
			->> _arrayp!PD_NLOCALS
			->  _arrayp!PD_GC_SCAN_LEN;
	##SF_LOCALS -> _arrayp!PD_GC_OFFSET_LEN;
	##SF_LOCALS _sub ##SF_RETURN_ADDR -> _arrayp!PD_FRAME_LEN;

	;;; start of code
	_arrayp@PD_ARRAY_TABLE{_tabsize} ->> _drop_ptr -> _arrayp!PD_EXECUTE;

	;;; owner address for stack frame
	_16:CFDF						-> SHORT;	;;; pushal pc rel short offset
	@@(b){_arrayp, _drop_ptr@(s)++} -> SHORT;	;;; proc addr

	;;; call the array subscript routine
	;;; (picks up parameters from PD_ARRAY_TABLE, stacks computed
	;;; subscript and PD_ARRAY_VECTOR, and then chains PD_ARRAY_SUBSCR_PDR)
	_16:9F16						-> SHORT;	;;; jsb @#
	_array_sub						-> LONG;	;;; routine address

	_drop_ptr -> _arrayp!PD_EXIT;	;;; pointer to exit code
	_16:8ED5						-> SHORT;	;;; tstl (sp)+
	_16:05							-> BYTE;	;;; rsb
enddefine;

endsection;		/* $-Sys */


/* --- Revision History ---------------------------------------------------
--- John Gibson, Aug 30 1994
		Simplified so that this machine-specific file now only has to
		construct a procedure with a stack frame and a call to _array_sub
		(_array_sub  picks up the parameters from PD_ARRAY_TABLE; these are
		planted by the machine-independent Get in arrays.p. The VAX "index"
		instruction is no longer used.)
--- Robert John Duncan, Mar 21 1994
		Changed not to depend on popa*rray_by_row
--- John Gibson, Feb  5 1989
		Initialisation of some procedure headrer fields moved to
		-newanyarray-
--- John Gibson, Mar 22 1988
		Rewrote to use macros to plant code rather than using ass.p
		procedures.
--- John Gibson, Mar  8 1988
		Moved this out of partapply.p
 */
