/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 * File:            S.vaxvms/src/asignals.s
 * Purpose:
 * Author:          John Gibson (see revisions)
 */

	.title  asignals.o      ;;; must be the object file name

;;;------------------ POP CONDITION HANDLER ------------------------------

#_<

#_INCLUDE 'declare.ph'

section $-Sys;

constant
	procedure (Error_signal)
	;

vars
	_syserror, _rmserror
	;

endsection;

lconstant macro (
	_SAVED_SP		= [I_LAB(Sys$-Extern$- _saved_sp)],
	);

>_#

/********************* wrapping structures ***********************************/

	.psect popcode,shr,exe,nowrt,long
	.long   Lcode_end-Lcode_start, C_LAB(Sys$-objmod_pad_key)
Lcode_start:
	.psect popdata,noshr,noexe,wrt,long
	.long   Ldata_end-Ldata_start,C_LAB(Sys$-objmod_pad_key)
Ldata_start:

/**************************************************************************/

	.psect popcode,shr,exe,nowrt,long


;;; --- ROUTINES TO CLEAN UP AND CALL A POP ERROR HANDLER -----------------

reset_pop_environ:
	;;; unwind any VAX procedure stack frames until fp is at or above
	;;; the current _call_stack_seg_hi (n.b. restores registers)
	clrl	__pop_in_user_extern	;;; clear this just in case
	movl    (sp)+, save_return      ;;; save this
1$:	cmpl	fp, I_LAB(_call_stack_seg_hi)
	bgequ	2$			;;; OK
	moval	1$, 16(fp)		;;; else frig return to loop
	ret				;;; unwind frame and return to 1b

2$:	jsb	reset_pop_reg_environ	;;; set registers to proper pop state
	movl    I_LAB(_userhi), ap      ;;; reset user stack
	tstl	_SAVED_SP
	beql	3$
	movl	_SAVED_SP, sp
	clrl	_SAVED_SP
3$:	jmp     @save_return

	;;; Conditions (i.e. error signals) set return to this
__pop_errsig::
	bsbw	reset_pop_environ		;;; clean up
	jsb	XC_LAB(Sys$-Error_signal)	;;; never returns


;;; --- SYSTEM CALLS --------------------------------------------------------

	;;; Make a VMS system call, moving args from userstack
	;;; to system stack -- for internal use only (calls to this
	;;; are generated by the _extern syntax form).
	;;; (User external calls are done in aextern.s)

	.align long
DEF_C_LAB (_call_sys)
	moval	4(sp), _SAVED_SP ;;; save for exceptions

	movl	(ap)+, r1	;;; procedure wanted
	movl	(ap)+, r2	;;; no of args
	movl	r2, r0
	beql	2$		;;; no args

1$:	pushl   (ap)+		;;; push args onto stack
	sobgtr  r0, 1$

2$:	calls   r2, (r1)	;;; the system call
	moval	C_LAB(false), r5 	;;; ensure r5 is false
	blbs	r0, 3$			;;; br if OK
	movl	r0, I_LAB(Sys$- _syserror)	;;; put error code in here
	clrl	I_LAB(Sys$- _rmserror)		;;; init this to 0
3$:	movl	r0, -(ap)		;;; return value

	clrl	_SAVED_SP
	rsb


;;; -------------------------------------------------------------------------

	.psect popnosrdata,noshr,noexe,wrt,long
	.align long

save_return:
	.long   0

	;;; process table
DEF_C_LAB (Sys$- _vmsproc_tab)
	.blkl	32*3      ;;; space for 32 PROC_ENTRY
DEF_C_LAB (Sys$- _vmsproc_tab_lim)



/*************** end labels for wrapping structures **************************/

	.psect popcode,shr,exe,nowrt,long
Lcode_end:
	.psect popdata,noshr,noexe,wrt,long
Ldata_end:

/**************************************************************************/

	.end



/* --- Revision History ---------------------------------------------------
--- John Gibson, Oct 25 1996
	Fixed references to _syserror/_rmserror to be in section Sys.
--- John Gibson, Apr 12 1996
	_rmserror set zero when _syserror set.
--- John Gibson, Oct 24 1994
	Removed the C pointers to pop vars (now set up in initial.p)
--- John Gibson, Oct 17 1994
	Made extern vars __pop*_fpe_continue and __pop*_in_math_lib with
	pointers __pop_fpe_handler and __pop_in_math_lib to pop vars
	Sys$- _fpe_handler, Sys$- _in_math_lib
--- John Gibson, Oct 13 1994
	Removed __pop_sub*rng_trap (no longer needed since arrays don't
	use the "index" instruction any more)
--- John Gibson, Feb  9 1991
	Condition handler moved to c_core.c
--- John Gibson, Jan 20 1991
	Added clearing of ___pop_in_user_extern in reset_pop_environ
--- John Gibson, Nov 22 1990
	Signals stuff and ASTs rewritten in C and moved to core.c
--- John Gibson, Nov 19 1990
	Grouped all C-accessible pointers and added
	__WEAK_pop_external_callback etc
--- John Gibson, Oct 10 1990
	_call_sys changed so that proper result is always returned
	(instead of -1 if bit 0 set).
--- John Gibson, Aug 21 1990
	Renamed signal add and remove routines.
--- John Gibson, May  1 1990
	Moved _call_sys to this file from aextern.s (so core routine
	_call_sys doesn't pull in 'optional' external stuff).
	Also now uses signals.ph for signal numbers.
--- John Gibson, Nov 29 1989
	Reg r5 now caches address of false -- made appropriate changes.
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- John Gibson, Apr 10 1989
	Removed code self-reenabling code from _pwm_signal_ast
	(doesn't work to reenable ast until mailbox has been read)
--- John Gibson, Feb 21 1989
	Added AST For write attention on a mailbox (Sys$- _pwm_signal_ast),
	used by PWM.
--- Roger Evans, Sep 26 1988
	Moved timer and spawn ast's here from amisc.s
	Added signal queue code
--- John Gibson, Aug 23 1988
	Wrapping structures now use -objmod_pad_key-
--- John Gibson, Jan 17 1988
	Added 'wrapping' strings to enable object files from .s files to
	be mixed in with those from .p source.
		Replaced all references to 'poplog' labels with macros
	C_LAB, I_LAB, etc applied to identifier names, and added appropriate
	declarations between #_< ... >_#, etc.
 */
