/* --- Copyright University of Sussex 1994. All rights reserved. ----------
 > File:            C.vms/src/sys_async_input.p
 > Purpose:
 > Author:          John Gibson, Dec  5 1990 (see revisions)
 > Documentation:	REF *SYSIO
 > Related Files:	C.unix/src/sys_async_input.p
 */

;;; ----------- CONTROL ASYNCHRONOUS INPUT ON A DEVICE --------------------

#_INCLUDE 'declare.ph'
#_INCLUDE 'io.ph'
#_INCLUDE 'signals.ph'
#_INCLUDE 'vmsdefs.ph'

global constant
		procedure (sys_raise_ast, Sys$-Vms_set_chan_AST,
		Sys$-Io$-New_mailbox)
	;


;;; ---------------------------------------------------------------------

section $-Sys$-Io => sys_async_io;

	/*	For device-associated mailbox
	*/
vars
	_devmbx_channel = _0;
lvars
	devmbx_name_desc = false;


define lconstant Raise_Sigio = sys_raise_ast(% SIG_IO %) enddefine;

define sys_async_io(dev, ioset) -> trap_p;
	lvars dev, ioset, trap_p = false;
	Check_integer_range(ioset, RD_SET, EX_SET);
	Check_device(dev, if ioset == WR_SET then 2:101 else 2:11 endif);
	returnif(ioset /== RD_SET);
	if (dev!D_UNIT_P!UNT_INPUT_TRAP ->> trap_p) == Raise_Sigio then
		true -> trap_p
	endif
enddefine;
;;;
define updaterof sys_async_io(trap_p, dev, ioset);
	lvars unit_p, unit_n, dev, trap_p, ioset, _mbx, _mbxnam;
	Check_integer_range(ioset, RD_SET, EX_SET);
	Check_device(dev, if ioset == WR_SET then 2:101 else 2:11 endif);
	if trap_p == true then
		Raise_Sigio -> trap_p
	elseif trap_p then
		Check_procedure(trap_p)
	endif;
	if ioset /== RD_SET then
		mishap(dev, ioset, 2, 'sys_async_io: ASYNC INPUT ONLY SUPPORTED')
	endif;

	dev!D_UNIT_P -> unit_p;
	dev!D_UNIT_N -> unit_n;

	if trap_p and not(unit_p!UNT_INPUT_TRAP) then

		;;; disabled -> enabled
		if unit_n!UNT_DEVCHAR _bitst _:'DEV$M_FOD' then
			;;; disk/tape
			mishap(dev, 1, 'sys_async_io: INVALID DEVICE FOR ASYNC INPUT')
		endif;

		_0 -> _mbxnam;
		unit_n!UNT_DEVCHAR _bitst _:'DEV$M_MBX' -> _mbx;		;;; is a mailbox
		unless _mbx then
			;;; assign alt channel with associated mailbox
			;;; set up associated-mailbox if not already done
			if _zero(_devmbx_channel) then
				consdescriptor(New_mailbox(false) -> _devmbx_channel)
														-> devmbx_name_desc;
				;;; set write attention AST on the mailbox which generates an
				;;; AST_DEV_INPUT with the unit number of the associated
				;;; device (got from the mailbox message)
				Vms_set_chan_AST(_devmbx_channel, _:'IO$M_WRTATTN',
									_extern _pop_devmbx_ast, _devmbx_channel)
			endif;
			devmbx_name_desc@DSC_SPEC -> _mbxnam
		endunless;

		;;; now assign channel with mailbox associated unless dev is mailbox
		unless _extern sys\$assign(
				/* devnam */	Temp_Desc(dev!D_FULL_NAME),
				/* chan   */	unit_n@UNT_MBX_CHANNEL,
				/* acmode */	,
				/* mbxnam */	_mbxnam )
		_bitst _1 then
			Syserr_mishap(dev, 1, 'sys_async_io: CAN\'T OPEN CHANNEL FOR DEVICE')
		endunless;

		if _mbx then
			;;; mailbox -- enable write attention AST taking unit num
			;;; as parameter
			Vms_set_chan_AST(unit_n!UNT_MBX_CHANNEL, _:'IO$M_WRTATTN',
								_extern _pop_wrtattn_ast, unit_n!UNT_UNIT_NUM)
		endif;

	elseif not(trap_p) and unit_p!UNT_INPUT_TRAP then

		;;; enabled -> disabled
		;;; deassign mailbox / associated mailbox channel
		_extern sys\$dassgn(unit_n!UNT_MBX_CHANNEL) -> ;
		_0 -> unit_n!UNT_MBX_CHANNEL

	endif;

	trap_p -> unit_p!UNT_INPUT_TRAP
enddefine;

endsection;		/* $-Sys$-Io */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Jul  8 1994
		Now sys_async_io taking 2nd arg 0,1,2 to mean read,write,except,
		(but input only supported for now).
 */
