/* --- Copyright University of Sussex 1990. All rights reserved. ----------
 > File:            C.vms/src/sys_file_move.p
 > Purpose:
 > Author:          John Gibson, May 23 1988 (see revisions)
 > Documentation:	REF *SYSUTIL
 */

;;; --------------------- MOVE A FILE (VMS) -------------------------------

#_INCLUDE 'declare.ph'
#_INCLUDE 'io.ph'
#_INCLUDE 'vmsdefs.ph'

global constant
		procedure sysdelete
	;

section $-Sys;

global constant
		procedure (Io$-Rms_fabnam_init, Io$-Delete_old_version)
	;

endsection;


;;; --------------------------------------------------------------------

section $-Sys$-Io => sys_file_copy sys_file_move;

define sys_file_copy(from_name, to_name);
	lvars f_dev, t_dev, from_name, to_name, buff, arg3, _fab, _n;
	sysopen(from_name, 0, "record", `N`) -> f_dev;
	f_dev!D_CTRL_BLK@ICB_FAB -> _fab;
	if _fab!FAB$B_RFM == _:'FAB$C_FIX' then
		;;; assume block I/O
		true
	elseif _fab!FAB$B_RAT _bitst _:'FAB$M_CR!FAB$M_PRN!FAB$M_FTN' then
		"line"
	else
		"record"
	endif -> arg3;
	sysclose(f_dev);
	sysopen(from_name, 0, arg3, `N`) -> f_dev;

	;;; create the new file and do the copy
	syscreate(to_name, 1, arg3) -> t_dev;
	inits(513) -> buff;
	while (fast_sysread(f_dev, 1, buff, 513) ->> _n) /== 0 do
		fast_syswrite(t_dev, 1, buff, _n)
	endwhile;
	sysclose(f_dev);
	sysclose(t_dev)
enddefine;

define sys_file_move(from_name, to_name);
	lvars from_name, to_name, f_ctrl_blk, t_ctrl_blk, _f_fab, _t_fab, _nam;
	sysfileok(from_name) -> from_name;
	sysfileok(to_name) -> to_name;
	inits(NAM_ICB_LEN) -> f_ctrl_blk;
	inits(NAM_ICB_LEN) -> t_ctrl_blk;
	Rms_fabnam_init(from_name, '', f_ctrl_blk) -> _f_fab;
	Rms_fabnam_init(to_name, '', t_ctrl_blk) -> _t_fab;
	if _extern sys\$rename(_f_fab, , , _t_fab) _bitst _1 then
		t_ctrl_blk@ICB_NAM -> _nam;
		_nam!NAM$B_RSL -> _sysstring_len;
		_bmove(_sysstring_len, _nam!NAM$L_RSA, sysstring@V_BYTES) -> ;
		Delete_old_version(to_name, Copy_sysstring())
	else
		if _syserror == _:'RMS$_DEV' then
			;;; assume to_name on another device (will fail if not)
			sys_file_copy(from_name, to_name);
			returnif(sysdelete(from_name));
			sysdelete(to_name) ->
		else
			_f_fab!FAB$L_STV -> _rmserror
		endif;
		Syserr_mishap(from_name, to_name, 2, 'CAN\'T MOVE FILE')
	endif
enddefine;

endsection;



/* --- Revision History ---------------------------------------------------
--- John Gibson, Oct 10 1990
		VMS _extern changed to return proper system call result (thus test
		for success is now result _bitst _1).
--- John Gibson, Aug  1 1989
		Made -sys_file_move- deal with deleting old versions
--- John Gibson, Feb 19 1989
		Included io.ph
 */
