/* --- Copyright University of Sussex 1994. All rights reserved. ----------
 > File:            C.vms/src/sys_file_stat.p
 > Purpose:			sys_file_stat (Vax/Vms)
 > Author:          John Gibson (see revisions)
 > Documentation:	REF *SYSUTIL
 */


#_INCLUDE 'declare.ph'
#_INCLUDE 'io.ph'
#_INCLUDE 'vmsdefs.ph'

global constant
		procedure (Sys$-Pint_unix_time, Sys$-Check_vector)
	;

section $-Sys$-Io;

global constant
		procedure (Opencreate, Rms_display, Rms_displayopen),
		work_ctrl_blk, _work_datxab, _work_proxab
	;

endsection;

;;; --------------------------------------------------------------------

section $-Sys$-Io => sys_file_stat;

define File_stat(ctrl_blk, statbuff) -> statbuff;
	lvars statbuff, ctrl_blk, _len, _group, _member, _prot;
	Check_vector(statbuff);
	if ctrl_blk!ICB_DEVCHAR _bitst _:'DEV$M_REC!DEV$M_RTM' then
		;;; record orientated/real-time -- not valid device for stat
		return(false -> statbuff)
	endif;
	datalength(statbuff) -> _len;
	returnif(_len == 0);

	go_on _len to ONE TWO THREE FOUR FIVE else FIVE;
FIVE:
	_pint(_work_proxab!XAB$W_PRO) -> statbuff(5);	;;; protections
FOUR:
	_pint(_work_proxab!XAB$W_MBM) -> statbuff(4);	;;; member number
THREE:
	_pint(_work_proxab!XAB$W_GRP) -> statbuff(3);	;;; group number
TWO:
	Pint_unix_time(_work_datxab@XAB$Q_RDT) -> statbuff(2);	;;; revision date
ONE:
	_pint(ctrl_blk!ICB_EOF_BYTE) -> statbuff(1);	;;; file size
enddefine;


define sys_file_stat(file, statbuff);
	lvars file, statbuff, ctrl_blk, _fab;
	if isboolean(statbuff) then		;;; for compatibility with Unix version
		((), file) -> (file, statbuff)
	endif;
	if isstring(file) or isword(file) then
		sysfileok(file) -> file;
		work_ctrl_blk -> ctrl_blk;
		returnunless(Opencreate(file, 0, false, ctrl_blk, Rms_displayopen))
															(false)
	else
		Check_device(file, 2:1001);		;;; flush if open for writing
		Rms_display(file!D_CTRL_BLK ->> ctrl_blk)
	endif;
	File_stat(ctrl_blk, statbuff)
enddefine;

endsection;		/* $-Sys$-Io */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Nov 22 1994
		Changed to use Rms_display on an open file
--- John Williams, Mar 18 1991
		Now allows words as well as strings (fixes BR isl-er.151)
		Calls -sysfileok- on string or word (like the Unix version)
--- John Gibson, Aug  8 1989
		Some code from rmsio.p onlyused in -sys_file_stat- moved into
		latter.
--- John Gibson, Feb 19 1989
		Included io.ph
--- John Williams, Dec  5 1988
		Allows zero length vector. -File_stat- rewritten using -go_on-
--- John Williams, Oct  6 1988
		Fixed for VED devices
--- John Gibson, Apr 26 1988
		Name changed from sysfstat.p to sys_file_stat.p
--- John Gibson, Feb 21 1988
		Replaced -Check_subscr- with -Sys$-Check_vsubscr-
 */
