/* --- Copyright University of Sussex 1995. All rights reserved. ----------
 > File:            C.vms/src/sys_real_time.p
 > Purpose:
 > Author:          John Gibson (see revisions)
 > Documentation:	REF *TIMES
 */

;;; ----------------------- REAL TIME -----------------------------------

#_INCLUDE 'declare.ph'
#_INCLUDE 'vmsdefs.ph'

uses (biginteger_key);

;;; --------------------------------------------------------------------

section $-Sys => sys_real_time;

	/*	Convert VMS (abs) quadword time to/from Unix secs as a pop integer.
		(note that this is always local time, since VMS knows nothing
		about time-zones).
	*/
define Pint_unix_time(_quadp);
	lvars _quadp;
	lstackmem struct TIMEVAL _tvp;
	_extern pop\$timeval_from_quadtime(_tvp, _quadp, _1) -> ;
	Sint_->_pint(_tvp!TIM_SEC)
enddefine;
;;;
define updaterof Pint_unix_time(secs, _quadp);
	lvars secs, _quadp;
	lstackmem struct TIMEVAL _tvp;
	Pint_->_sint(secs, _MOST_POSITIVE_SIGNED(int)) -> _tvp!TIM_SEC;
	_0 -> _tvp!TIM_USEC;
	_extern pop\$timeval_to_quadtime(_tvp, _quadp, _1) -> ;
enddefine;

	;;; Return current time in Unix format
define sys_real_time();
	lstackmem long[2] _quadp;
	_extern sys\$gettim(_quadp) -> ;		;;; get VMS time in _quadp
	Pint_unix_time(_quadp)
enddefine;

endsection;		/* $-Sys */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Jun 30 1995
		Pint_unix_time now correctly allows secs to be signed (i.e. a
		negative value indicating a time before the Unix base date).
--- John Gibson, Jul  7 1994
		Changed to use lstackmem
--- John Gibson, Jan  5 1991
		Rewritten to use timeval<->quadtime conversion routines
 */
