/* --- Copyright University of Sussex 1991. All rights reserved. ----------
 > File:            C.vms/src/sys_symbol_value.p
 > Purpose:
 > Author:          John Gibson, May 31 1991
 > Documentation:	REF *SYSUTIL
 */

;;; ------------------- DCL SYMBOL VALUES --------------------------------

#_INCLUDE 'declare.ph'
#_INCLUDE 'vmsdefs.ph'


;;; ----------------------------------------------------------------------

section $-Sys => sys_symbol_value;

define sys_symbol_value(symname);
	lvars symname;
	;;; ignore a boolean for compatibility with updater, but can't
	;;; select local/global value (local overrides global)
	if isboolean(symname) then () -> symname endif;
	Check_string(symname);
	if _extern lib\$get_symbol(
					Temp_Desc(symname),
					_sysstring_desc,
					ident _sysstring_len)
	_bitst _1 then
		Copy_sysstring()
	else
		false
	endif
enddefine;
;;;
define updaterof sys_symbol_value(valstring, symname);
	lvars valstring, symname, desc;
	dlvars _tabtype = false;	;;; local by default
	if isboolean(symname) then
		((), valstring, symname) -> (valstring, symname, _tabtype)
	endif;
	;;; 2 = global, 1 = local
	if _tabtype then _2 else _1 endif -> _tabtype;
	Check_string(symname);
	if valstring then
		Check_string(valstring);
		consdescriptor(valstring) -> desc;
		_extern lib\$set_symbol(
						Temp_Desc(symname),
						desc@DSC_SPEC,
						ident _tabtype)
	else
		_extern lib\$delete_symbol(
						Temp_Desc(symname),
						ident _tabtype)
	endif;

	unless () _bitst _1 then
		Syserr_mishap(valstring, symname, 2, 'ERROR (DE)ASSIGNING SYMBOL VALUE')
	endunless
enddefine;

endsection;		/* $-Sys */
