/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 > File:            S.vaxvms/src/syscomp/sysdefs.p
 > Purpose:
 > Author:          John Gibson (see revisions)
 */

/* -------------------------------------------------------------------------

				DEFINITIONS FOR MACHINE/OPERATING SYSTEM

--------------------------------------------------------------------------*/

section;


global constant macro (

	POPC_SYSDEFS_LOADED = true,


;;; --- SYSTEM NAME ---------------------------------------------------------

	MACHINE			= [[vax]],
	VAX_VMS			= true,


;;; --- MACHINE = VAX ------------------------------------------------------

	PROCESSOR		= [[vax]],		;;; type of cpu
	VAX				= true,

	;;; Values for machine and C data types are defined in mcdata.p,
	;;; and can be overidden here if necessary

	SHORT_ALIGN_BITS= 8,			;;; alignment in bits for short access
	INT_ALIGN_BITS	= 8,			;;; alignment in bits for int access
	DOUBLE_ALIGN_BITS= 8,			;;; alignment in bits for double access

	CODE_POINTER_TYPE = "byte",		;;; type of pointer to machine code
	BIT_POINTER_TYPE  = "byte",		;;; type of pointer for bitfield access


;;; --- OPERATING SYSTEM = VMS --------------------------------------------

	VMS					= 5.5,
	OPERATING_SYSTEM	= [[vms ^VMS]],		;;; type of os

	VPAGE_OFFS			= 512,		;;; word address offset of a virtual page
	LOWEST_ADDRESS		= 0,		;;; lowest pop structure address


;;; --- OTHER ------------------------------------------------------------

	;;; Says single float results from C functions are returned as
	;;; singles not doubles.
	C_FLOAT_RESULT_SINGLE = true,


	;;; list of procedures to be optimised as subroutine calls
	;;; format of entries is
	;;;		[<pdr name> <nargs> <nresults> <subroutine name>]

	SUBROUTINE_OPTIMISE_LIST =
		[[
			[prolog_newvar			0 1 _prolog_newvar]
			[datakey				1 1 _datakey]
			[prolog_deref			1 1 _prolog_deref]
			[conspair				2 1 _conspair]
		]],

	;;; Old-style I_PUSH/POP_FIELD(_ADDR) instructions in ass.p
	OLD_FIELD_INSTRUCTIONS = true,

);


endsection;		/* $- */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Nov  4 1996
		Added OLD_FIELD_INSTRUCTIONS. Removed is* procedures from
		SUBROUTINE_OPTIMISE_LIST (no longer required).
--- John Gibson, Mar 21 1995
		Standard machine data type definitions are now in mcdata.p
--- John Gibson, Oct 22 1992
		Changed P*OPC to POPC_SYSDEFS_LOADED
--- John Gibson, Apr  3 1991
		Added C_FLOAT_RESULT_SINGLE.
--- John Gibson, Dec 11 1990
		VMS 5.3
--- John Gibson, Nov 29 1989
		Removed F*ALSE_AT_0  (no longer assumed, r5 used to cache false).
--- John Gibson, Aug 24 1989
		Removed S*IGNALS
--- John Gibson, Jul 24 1989
		Changed VMS to 5.0
--- John Gibson, May 17 1989
		Removed VAX_FLOAT, DFLOAT_SIG_BITS, SFLOAT_SIG_BITS (first one
		not used, other two defined in genfloat.p).
--- Rob Duncan, Apr  3 1989
		Added MACHINE definition; changed VMS flag to have a numeric
		(version number) value and deleted the VMS_V4_OR_LATER flag
--- Roger Evans, Sep 26 1988
		Added POPC and S*IGNALS definitions
--- John Gibson, Aug  5 1988
		Added DOUBLE definitions
 */
