/* --- Copyright University of Sussex 1991. All rights reserved. ----------
 > File:			C.vms/src/sysfileok.p
 > Purpose:
 > Author:			John Gibson, John Williams et al (see revisions)
 > Related Files:	Unix versions
 */

;;; -------------- FILENAME CHECKING AND CONVERSION (VMS) -----------------

#_INCLUDE 'declare.ph'

constant
		procedure (isuppercode, uppertolower, Sys$-Explode_substring)
	;

;;; -------------------------------------------------------------------

section $-Sys => pop_max_filename_len sysfileok dir_>< ;

lconstant macro (
	MAX_FILENAME_LEN	= 39,
	MAX_EXTENSION_LEN	= 39,
	);

protected vars
	pop_max_filename_len = MAX_FILENAME_LEN
	;

lvars
	_parse_disk,
	_parse_dir,
	_parse_name,
	_parse_extn,
	_parse_vers,
	;


;;; --- CONVERTING UNIX FILENAMES TO VMS FORMAT --------------------------
;;; e.g. /a/b/c/d -> a:[b.c]d etc

define Unix_convert(fname, isdir);
	lvars fname, disk, dir, path, filename, isdir, _pos, _c, _ndirs;

	define lconstant Extract_component(_pos, string);
		lvars next, string, _pos, _lim;
		if locchar(`/`, _pos, string) ->> next then
			next -> _lim
		else
			datalength(string) fi_+ 1 -> _lim
		endif;
		substring(_pos, _lim fi_- _pos, string);
		if next then next fi_+ 1 else false endif
	enddefine;

	if isword(fname) then fname!W_STRING -> fname endif;
	Check_string(fname);
	returnif(fname = nullstring) (nullstring);
	fast_subscrs(1,fname) -> _c;
	unless locchar(`/`, 1, fname)
	or (_c == `.` and isdir and (fname = '.' or fname = '..')) then
		return(fname)
	endunless;
	if _c == `$` or _c == `/` then
		Extract_component(2, fname) -> _pos -> disk
	else
		1 -> _pos,	false -> disk
	endif;
	if fast_subscrs(datalength(fname),fname) == `/` then
		true -> isdir
	endif;
	nullstring -> filename;
	0 -> _ndirs;
	lconstant MINUS = '-', ELIPS = '...';
	[%	while _pos do
			Extract_component(_pos, fname) -> _pos -> dir;
			;;; _pos is false if this is the last component
			if _pos or isdir then
				nextif(dir == nullstring);
				if fast_subscrs(1,dir) /== `.` then
					dir
				elseif dir = '..' then
					MINUS
				elseif dir = ELIPS then
					ELIPS
				elseif dir /= '.' then
					dir
				else
					nextloop
				endif;
				_ndirs fi_+ 1 -> _ndirs
			elseif dir = '.' then
				if _ndirs fi_> 0 then
					() sys_>< '.dir' -> filename
				else
					mishap(fname, 1, 'CAN\'T CONVERT AS FILENAME')
				endif
			elseif dir = '..' then
				if _ndirs fi_> 1 then
					->, () sys_>< '.dir' -> filename
				else
					mishap(fname, 1, 'CAN\'T CONVERT AS FILENAME')
				endif
			else
				;;; last one is filename
				dir -> filename
			endif
		endwhile
	%] -> path;
	cons_with consstring {%
		if disk then
			if disk = nullstring then
				'sys$disk' -> disk
			elseif disk = 'tmp' then
				'sys$scratch' -> disk
			elseif disk = 'dev' then
				if path == [] then
					filename -> disk, nullstring -> filename;
					if disk = 'null' then '_nla0' -> disk endif
				else
					mishap(fname, 1, 'INVALID DEVICE NAME')
				endif
			endif;
			deststring(disk) -> ;
			unless dup() == `:` then `:` endunless
		endif;
		if path == [] then
			if not(disk) and isdir then `[`, `]` endif
		else
			`[`;
			fast_for dir in path do
				if dir == MINUS then
					dup() -> _c;
					unless _c == `.` or _c == `[` or _c == `-` then
						`.`
					endunless;
					`-`
				elseif dir == ELIPS then
					unless dup() == `.` then `.`,`.`,`.` endunless
				else
					unless disk or dup() == `.` then `.` endunless;
					deststring(dir) ->
				endif;
				false -> disk
			endfast_for;
			`]`
		endif;
		deststring(filename) ->
	%}
enddefine;

;;; -----------------------------------------------------------------------

define lconstant Parse_filename(string);
	lvars string, _p, _s, _fin, _c, _start;
	string@V_BYTES[_0] -> _start;
	_start@(b)[string!V_LENGTH] -> _fin;

	;;; disk and dir
	_start ->> _p -> _s;
	1 -> _parse_disk;
	while _p <@(b) _fin do
		nextunless((_p!(b)++ -> _p) == _:`:`);
		if _p <@(b) _fin and _p!(b) == _:`:` then
			_p@(b)++ ->> _p -> _s;
			_pint(##(b){_p,_start} _add _1) -> _parse_disk;
			while _p <@(b) _fin do
				if (_p!(b)++ -> _p) == _:`:` then _p -> _s, quitloop endif
			endwhile
		else
			_p -> _s
		endif;
		quitloop
	endwhile;
	_pint(##(b){_s,_start} _add _1) -> _parse_dir;

	;;; name
	if _s <@(b) _fin and _s!(b) == _:`[` then
		_s@(b)++ -> _s;
		repeat
			if _s <@(b) _fin then
				quitif((_s!(b)++ -> _s) == _:`]`)
			else
				mishap(string, 1, 'MISSING ] IN FILENAME')
			endif
		endrepeat
	endif;
	_pint(##(b){_s,_start} _add _1) -> _parse_name;

	;;; extension and version
	_NULL -> _p;
	while _s <@(b) _fin do
		_s!(b)++ -> _s -> _c;
		if _c == _:`.` and _p == _NULL then
			_s--@(b) -> _p
		elseif _c == _:`;` or _c == _:`.` then
			_s--@(b) -> _s, quitloop
		endif
	endwhile;
	if _p == _NULL then _s -> _p endif;
	_pint(##(b){_p,_start} _add _1) -> _parse_extn;
	_pint(##(b){_s,_start} _add _1) -> _parse_vers
enddefine;

define No_filename_chars(string);
	lvars string, _p, _c, _fin;
	string@V_BYTES[_0] -> _p;
	_p@(b)[string!V_LENGTH] -> _fin;
	while _p <@(b) _fin do
		_p!(b)++ -> _p -> _c;
		returnif( _c == _:`:` or _c == _:`[` or _c == _:`.` or _c == _:`;` )
												(false)
	endwhile;
	true
enddefine;

	/*	Get rid of occurences of ][
		(e.g [foo.][baz.grum] -> [foo.baz.grum])
	*/
define lconstant Remove_brackets(string) -> string;
	lvars string, _n = 1, _m, _len = datalength(string);
	while (locchar(`]`, _n, string) ->> _n) and _n fi_< _len
	and fast_subscrs(_n fi_+ 1, string) == `[` do
		consstring(#|
			Explode_substring(1, _n fi_- 1, string);
			_n fi_+ 2 -> _m;
			if _m fi_> 3 and dup() /== `.`
			and _m fi_<= _len and fast_subscrs(_m, string) /== `.` then
				`.`
			endif;
			Explode_substring(_m, _len fi_- _m fi_+ 1, string)
		|#) -> string;
		datalength(string) -> _len
	endwhile
enddefine;

define sysfileok(string);
	lvars	string, trans, org_string, _n, _len, _want_parse = false;
	_CLAWBACK_SAVE;

	if isboolean(string) then string -> _want_parse -> string endif;
	if isword(string) then
		string!W_STRING -> string
	else
		Check_string(string)
	endif;
	string -> org_string;

	;;; convert Unix filename formats
	Unix_convert(string, false) -> string;

	;;; translate logical names

	define lconstant Trans(string, _lim) -> string;
		lvars string, trans, _n, _lim;
		returnunless((locchar(`:`, 1, string) ->> _n) and _n fi_<= _lim);
		if _n fi_< _lim and fast_subscrs(_n fi_+ 1, string) == `:` then
			_n fi_+ 1 -> _n
		endif;
		returnunless(systranslate(substring(1, _n, string)) ->> trans);
		datalength(trans) -> _lim;
		while _lim fi_> 0 do
			quitif(fast_subscrs(_lim,trans) /== `:`);
			_lim fi_- 1 -> _lim
		endwhile;
		Trans(trans, _lim) sys_>< Str_allbutfirst(_n, string) -> string
	enddefine;

	if No_filename_chars(string) and (systranslate(string) ->> trans) then
		trans -> string
	endif;
	Trans(string, datalength(string)) -> string;

	;;; get rid of occurences of ][ (e.g [foo.][baz.grum] -> [foo.baz.grum])
	Remove_brackets(string) -> string;

	datalength(string) -> _len;
	returnif(_len == 0) (nullstring, if _want_parse then 1,1,1,1,1 endif);

	;;; translate file name to lower case
	uppertolower(string) -> string;

	;;; parse filename
	Parse_filename(string);

	;;; translate `.` for version to `;`
	_parse_vers -> _n;
	if _n fi_<= _len and fast_subscrs(_n,string) == `.` then
		if string == org_string then copy(string) -> string endif;
		`;` -> fast_subscrs(_n,string)
	endif;

	;;; truncate name if too long
	_parse_extn fi_- _parse_name fi_- pop_max_filename_len -> _n;
	if _n fi_> 0 then
		cons_with consstring {%
			Explode_substring(1, _parse_name fi_- 1, string);
			Explode_substring(_parse_name, pop_max_filename_len, string);
			Explode_substring(_parse_extn, _len fi_- _parse_extn fi_+ 1,
																string);
			_parse_extn fi_- _n -> _parse_extn;
			_parse_vers fi_- _n -> _parse_vers
			%}
	else
		string
	endif;
	Clawback();
	if _want_parse then
		_parse_disk, _parse_dir, _parse_name, _parse_extn, _parse_vers
	endif
enddefine;

define 4 dir dir_>< name;
	lvars dir, name;
	_CLAWBACK_SAVE;
	Unix_convert(dir, true) -> dir;
	Unix_convert(name, false) -> name;
	Clawback(Remove_brackets(dir sys_>< name))
enddefine;

endsection;		/* $-Sys */


/* --- Revision History ---------------------------------------------------
--- John Gibson, Oct 30 1991
		Made dir_>< remove occurences of ][ in result
--- John Gibson, Sep 11 1989
		Improved handling of logical name translation in -sysfileok-
--- John Gibson, Aug  8 1989
		Improved -Unix_convert-
--- John Gibson, Jul 31 1989
		Rewrote -sysfileok-. Changed it to return string plus 5 subscripts
		of fields within string when given extra 2nd arg of true.
--- Rob Duncan, Apr  4 1989
		Replaced DEF VMS_V4_OR_LATER with DEFV VMS >= 4.0
--- John Gibson, May  9 1988
		Added -pop_max_filename_len-
--- John Gibson, Feb 22 1988
		Check_string into section Sys
 */
