/* --- Copyright University of Sussex 1991. All rights reserved. ----------
 > File:            C.vms/src/sysmailbox.p
 > Purpose:
 > Author:          John Gibson (see revisions)
 > Documentation:	REF *SYSIO
 */

;;;--------------------- VAX/VMS MAILBOXES  -------------------------------

#_INCLUDE 'declare.ph'
#_INCLUDE 'vmsdefs.ph'

global vars
		poppid
	;


;;; ----------------------------------------------------------------------

section $-Sys$-Io => sysmailbox;

lvars
	tmpnum = 0;

define New_mailbox(mbxname) /* -> (mbxname, _mbxchan) */;
	lvars mbxname;
	lstackmem short _chan;

	unless mbxname then
		'POPTMPMBX' sys_>< tmpnum sys_>< '_' sys_>< poppid -> mbxname;
		tmpnum fi_+ 1 -> tmpnum
	endunless;
	lowertoupper(mbxname) -> mbxname;

	unless _extern sys\$crembx(
						/* prmflag */ 	_0,			;;; temporary mbx
						/* chan */ 		_chan,
						/* maxmsg */ 	,
						/* bufquo */ 	,
						/* promsk */ 	,
						/* acmode */ 	,
						/* lognam */	Temp_Desc(mbxname) )
	_bitst _1 then
		Sysgarbage(true, 'fopn');
		unless _extern sys\$crembx(_0,_chan,,,,,Temp_Desc(mbxname)) _bitst _1
		then
			Syserr_mishap(mbxname, 1, 'CAN\'T CREATE/OPEN MAILBOX')
		endunless
	endunless;
	mbxname, _chan!(s)
enddefine;

define sysmailbox(mbxname, mode, arg3);
	lvars mbxname, mode, arg3, _mbxchan;
	Check_string(mbxname);
	Check_integer(mode, 0);
	New_mailbox(mbxname) -> (mbxname, _mbxchan);
	sysopen(mbxname, mode, arg3, `N`);	;;; open and return device
	_extern sys\$dassgn(_mbxchan) -> 	;;; deassign channel crembx allocated
enddefine;


endsection;		/* $-Sys$-Io */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Jan 25 1991
		Added -New_mailbox-
--- John Gibson, Oct 10 1990
		VMS _extern changed to return proper system call result (thus test
		for success is now result _bitst _1).
--- John Gibson, Mar 31 1988
		Moved out of sysio.p
 */
