/* --- Copyright University of Sussex 1991. All rights reserved. ----------
 > File:            C.vms/src/vms_dir.p
 > Purpose:
 > Author:          John Gibson (see revisions)
 > Documentation:	REF *SYSUTIL
 */

;;; ----------------- CURRENT DIRECTORY (VMS) ---------------------------

#_INCLUDE 'declare.ph'
#_INCLUDE 'vmsdefs.ph'

section $-Sys;

global constant
		procedure (Uptolow_sysstring, Unix_convert, Io$-Rms_displayopen),
		Io$-work_ctrl_blk
	;

endsection;


;;; --------------------------------------------------------------------

section $-Sys => current_directory;

define Dir_exists(dir);
	lvars dir;
	;;; Use an unlikely filename in dir and see if it gives File Not Found
	Io$-Rms_displayopen(false, false, 0, dir sys_>< '.$$$$$$$$$$$$',
													Io$-work_ctrl_blk)
	or _syserror == _:'RMS$_FNF'
enddefine;

define active current_directory;
	lvars dir;
	_CLAWBACK_SAVE;
	;;; get the current directory into sysstring
	_extern sys\$setddir(
						/* new desc   */	,
						/* old length */	ident _sysstring_len,
						/* old buf    */	_sysstring_desc )
		-> ;
	Uptolow_sysstring();		;;; convert sysstring chars to lower
	Copy_sysstring() -> dir;
	Clawback(systranslate('sys$disk:') sys_>< dir)
enddefine;

define updaterof active current_directory new_dir;
	lvars dir, disk, new_dir, exists, _n, _d;
	lconstant invdir_ms = 'INVALID DIRECTORY';
	_CLAWBACK_SAVE;

	if isword(new_dir) then new_dir!W_STRING -> new_dir endif;
	sysfileok(if new_dir = nullstring then
				'sys$login:'
			  else
				Unix_convert(new_dir, true)
			  endif, true) -> (new_dir, , _d, _n, , );

	new_dir -> dir;
	false -> exists;
	if _n == 1 then
		;;; no path -- see if it's a subdirectory of current directory
		'[.' sys_>< new_dir sys_>< ']' -> dir;
		unless Dir_exists(dir) ->> exists then
			;;; assume top level on disk
			'[' sys_>< new_dir sys_>< ']' -> dir
		endunless
	endif;
	unless exists or Dir_exists(dir) then
		Syserr_mishap(new_dir, 1, invdir_ms)
	endunless;

	if dir /== new_dir then
		sysfileok(dir, true) -> (dir, , _d, , , )
	endif;
	if _d == 1 then
		;;; no host/disk
		false -> disk
	else
		substring(1, _d fi_- 1, dir) -> disk;
		substring(_d, datalength(dir) fi_- _d fi_+ 1, dir) -> dir
	endif;

	unless _extern sys\$setddir(
							/* new desc   */	Temp_Desc(dir),
							/* old length */	,
							/* old buf    */	)
	_bitst _1 then
		;;; must have been a file name ....
		Syserr_mishap(new_dir, 1, invdir_ms)
	endunless;
	if disk then
		;;; optional table=2 arg to systranslate means
		;;; process table in supervisor mode, so changing
		;;; the disk outside Poplog too
		disk -> systranslate('sys$disk', 2)
	endif;

	Clawback(0) ->
enddefine;

endsection;		/* $-Sys */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Nov 25 1991
		Improved way of testing whether dir exists
--- John Gibson, Oct 10 1990
		VMS _extern changed to return proper system call result (thus test
		for success is now result _bitst _1).
--- John Gibson, Aug  8 1989
		Rewrote updater of -current_directory- to use new -sysfileok-.
--- John Gibson, Apr 25 1988
		Moved out of sysio.p
 */
