
	  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	  ;;                                              ;;
	  ;;  Initialisation for using Poplog with Emacs  ;;
	  ;;                                              ;;
	  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;; search for Lisp files in $popcontrib/emacs/lisp

(setq load-path
      (cons (substitute-in-file-name "$popcontrib/emacs/lisp")
	    load-path))

;; make all .p files use Pop11 mode

(setq auto-mode-alist
      (cons '("\\.p$" . pop-mode)
	    auto-mode-alist))

;; don't use short commands

(setq pop-short-help-commands nil)

;; don't use /* ... */ comments in procedures

(setq pop-use-pl1-comments nil)

;; where to find pop functions

(autoload 'pop-mode "pop-mode" "Major mode for editing Pop11 programs" t)

(autoload 'run-pop "inferior-pop-mode" "Run a Poplog process" t)

(autoload 'pop-help  "pop-sys-file-mode" "Get Poplog HELP file"  t)
(autoload 'pop-ref   "pop-sys-file-mode" "Get Poplog REF file"   t)
(autoload 'pop-teach "pop-sys-file-mode" "Get Poplog TEACH file" t)
(autoload 'pop-doc   "pop-sys-file-mode" "Get Poplog DOC file"   t)

(autoload 'pop-showlib "pop-sys-file-mode" "Get Poplog LIB file" t)

(autoload 'pop-apropos "pop-sys-file-mode" 
	  "Get summary help for everything matching PATTERN" t)