
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;                                                                  ;;
 ;; Inferior pop mode - run poplog processes under gnu-emacs.        ;;
 ;;                                                                  ;;
 ;;         Hacked from prolog-mode bsl 17.07.89                     ;;
 ;;         Variously mutilated by RJC.                              ;;
 ;;                                                                  ;;
 ;; Problems, gripes, bribes etc should be sent to                   ;;
 ;; rjc@cstr.ed.ac.uk.                                               ;;
 ;;                                                                  ;;
 ;; This mode can also be used as the basis of modes which run       ;;
 ;; poplog as an aplication under emacs.  Thus there are variables   ;;
 ;; to control what is meant by compilation and what is compiled.    ;;
 ;; We run a text to speech system this way.                         ;;
 ;;                                                                  ;;
 ;; This code is based on emacs prolog-mode and so is distributed    ;;
 ;; under the terms of the gnu general public licence.  Basically    ;;
 ;; this means you can do whatever you want with it except ship a    ;;
 ;; compiled version without this source code. You should have       ;;
 ;; received a copy of the gnus general public lisence with this     ;;
 ;; code in the file COPYING.                                        ;;
 ;;                                                                  ;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;                                                                  ;;
 ;; THINGS TO DO:                                                    ;;
 ;;         Add epoch support.                                       ;;
 ;;                                                                  ;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; 24th Feb 1991 rjc
;;; Split off from pop-mode.el
;;; Changed to use comint rather than shell-mode.
;;; Removed the pop-mode bindings from inferior-pop-mode, they
;;;			clash with comint.

(require 'comint)
(require 'cmushell)			; for cd comands
(require 'pop-mode)

(autoload 'pop-get-help "pop-sys-file-mode" 
	  "Read the help file for this word" t)
(autoload 'pop-closeit "pop-mode" "close off a pop structure" t)

(provide 'inferior-pop-mode)

(defvar pop-path 
	(if (getenv "usepop")
	    (concat (getenv "usepop") "/pop/pop/pop11")
	    "pop11")
	"*Shell command for running POP-11")

(defvar pop-prompt-regexp
	"^\\(: \\|\\*\\* *\\)*"
	"*Regexp matching pop11 prompts.")

(defvar pop-cd-regexp
	"cd"
	"*Regexp to match pop11 commands equivalent to cd.")

(defvar inferior-pop-mode-map nil
  "Keymap used in inferior pop mode.")

(if (not inferior-pop-mode-map)
    (progn
     (setq inferior-pop-mode-map (full-copy-sparse-keymap comint-mode-map))
;     (pop-mode-commands inferior-pop-mode-map)
;     (define-key inferior-pop-mode-map ";" 'self-insert-command)
     (define-key inferior-pop-mode-map "\eh" 'pop-get-help)
     (define-key inferior-pop-mode-map "\e]" 'pop-closeit)     )
    )

(defvar inferior-pop-name "pop-11"
	"Name of the buffer which runs pop" )

(defvar inferior-pop-process nil
	"The current poplog process")

(defvar inferior-pop-process-variable 'inferior-pop-process
	"The variable which holds the current poplog process")

(defun inferior-pop-mode ()
    "Major mode for interacting with an inferior Pop process.

The following commands are available:
\\{inferior-pop-mode-map}

Entry to this mode calls the value of pop-mode-hook with no arguments,
if that value is non-nil.  Likewise with the value of comint-mode-hook.
pop-mode-hook is called after comint-mode-hook.

Comments:
Delete converts tabs to spaces as it moves back.
Tab indents for Pop."

  (interactive)
  (comint-mode)
  (setq comint-prompt-regexp pop-prompt-regexp)
  (use-local-map inferior-pop-mode-map)
  (setq major-mode 'inferior-pop-mode)
  (setq mode-name "Inferior Pop-11")
  (setq mode-line-format 
	"--%1*%1*-Emacs: %17b   %M   %[(%m: %s)%]----%3p--%-")
  (setq local-abbrev-table pop-mode-abbrev-table)
  (pop-syntax-table)
  (setq comint-input-sentinel 'pop-directory-tracker)  
  (pop-mode-variables)
  (run-hooks 'shell-mode-hook 'pop-mode-hook)
  )

;; The following procedure is a cut down version of the cmushell 
;; equivalent which does not bother with pushd and popd

(defun pop-directory-tracker (str)
  "Tracks cd commands issued to pop11.
This function is called on each input passed to pop11.
It watches for cd commands and sets the buffer's
default directory to track these commands."

	 (string-match "^\\s *" str) ; skip whitespace
	 (let ((bos (match-end 0))
	       (x nil))
	   (cond ((setq x (cmushell-match-cmd-w/optional-arg 
			   pop-cd-regexp
			   str bos))
		  (cmushell-process-cd x)))))


(defun break-up-words (line)
       "Break up into a list of words by splitting at whitespace"

       (let ((last nil)
	     (current 0)
	     (words nil)
	     (space '(?  ?\t))
	     (l (length line)))
	    
	    ( while (< current l)
		    (while (and (< current l) (memq (elt line current) space))
			   (setq current (1+ current))
			   )
		    (if (< current l)
			(progn
			 (setq last current)
			 (while (and (< current l) 
				     (not (memq (elt line current) space)))
				(setq current (1+ current))
				)
			 (setq words (cons (substring line last current) words))
			 )
			)
		    )
	    (nreverse words)
	    )
       )
	    
(defun run-pop (arg)
       "Run an inferior pop11 process, input and output via a buffer.
ARG is a string giving the command to be run"

       (interactive "P")

       (let* ((program (if arg 
			   (break-up-words
			    (if (stringp arg)
				arg
				(read-from-minibuffer "poplog command? ")))
			   pop-path))
	      (name    (if arg 
			   (if (stringp arg)
			       inferior-pop-name
			       (file-name-nondirectory (car program)))
			   inferior-pop-name))
	      )
	    (switch-to-buffer 
	     (apply 'make-comint
		    (cons name
			  (if (listp program)
			      (cons (car program) (cons nil (cdr program)))
			      (list program)))))
	    (set inferior-pop-process-variable (get-process name))
	    (setq inferior-pop-process (get-process name))
	    (inferior-pop-mode)
	    )
       )

 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;                                                                  ;;
 ;; Function for sending pop code to an inferior pop process         ;;
 ;;                                                                  ;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defvar pop-compiling-what "region from" "Name of entity being compiled")
(defvar pop-compile-command 'pop-make-compile 
	"name of a function returning the pop11 command to compile a file")

(defun pop-make-compile(filename)

       "Return a string which is the pop11 command to compile FILENAME"

       (concat "compile('" filename "');\n")
       )

(defun pop-compile-region (start end)
       "Send a region to an inferior pop process."

       (interactive "r" )

;       (if (not (eq major-mode 'pop-mode)) (pop-mode))
       (let* ((file (make-temp-name "/tmp/emacs"))
	      (program-buffer-name (buffer-name))
	      (compile-command (apply pop-compile-command (list file)))
	      (program-buffer (current-buffer))
	      (pop-process
	       (or (eval inferior-pop-process-variable) 
		   (error (concat "No " inferior-pop-name " process"))))
	      (foo (if (not (eq (process-status pop-process) 'run))
		 (error (concat inferior-pop-name " process not runing"))
		 ))
	      (pop-buffer (process-buffer pop-process))
	      (pop-window (get-buffer-window pop-buffer))
	      size)

	     ;; check pop is at top-level prompt
	     (switch-to-buffer-other-window pop-buffer)
	     (switch-to-buffer-other-window program-buffer)
	     (save-excursion
	      (set-buffer pop-buffer)
	      (goto-char (point-max))
	      (if (not (pop-top-level-p)) (error "Not at pop-11 top-level")))
	     ;; everything should be ok, so write pop to temp file
	     (write-region start end file)
	     ;; put a message in the pop buffer
	     (switch-to-buffer-other-window pop-buffer)
	     (goto-char (point-max))
	     (insert comment-start " compiling "
		     pop-compiling-what " "
		     program-buffer-name "\n")
	     ;; send the consult command and delete the temp file when ready
	     (move-marker (process-mark pop-process) (point))
	     (setq size (buffer-size))
	     (send-string pop-process compile-command)

	     (while (= size (buffer-size)) (sit-for 1)) ;wait for pop.  cf shell.c
	     (delete-file file)
	     ))

(defun pop-compile-buffer ()

       "Send the entire buffer to the inferior pop process"

       (interactive)
       (let ( ( pop-compiling-what "buffer" ))
	    (pop-compile-region (point-min) (point-max))
	    )
       )

(defun pop-compile-procedure ()

       "Send the current procedure to the inferior poplog"
       (interactive)


       (let (( pop-compiling-what "procedure from" )
	     (proc (pop-procedure-ends)))
	    (pop-compile-region (car proc) (cdr proc))
	    )
       )

(defun pop-top-level-p ()
       "Returns t if point appears to be after a pop top-level prompt"
       (let ((p (point)))
	    (save-excursion
	     (if (re-search-backward ":" nil t)
		 (save-restriction
		  (narrow-to-region (point) p)
		  (looking-at "[:* \n\t]*\\'"))
		 nil))))




