 /********************************************************************\
 *                                                                    *
 * Code to set up poplog under emacs. This simply tweaks the          *
 * terminal modes to make sure that there is not an extra carrage     *
 * return at the end of each line.                                    *
 *                                                                    *
 * This is based on LIB *vediocontrol.                                *
 *                                                                    *
 * Hacked by RJC June '89.                                            *
 *                                                                    *
 \********************************************************************/

define _IOR(x,y,s);
    vars popdprecision;
    lvars x y s;
    true -> popdprecision;
    16:40000000 + (s<<16) + (x<<8) + y
enddefine;

define _IOW(x,y,s);
    vars popdprecision;
    lvars x y s;
    true -> popdprecision;
    16:80000000 + (s<<16) + (x<<8) + y
enddefine;

constant TIOCGETP = _IOR(`t`,8,6);
constant TIOCSETP = _IOW(`t`,9,6);

recordclass sgttyb
     sg_dummy : 32
     sg_ispeed : 8
     sg_ospeed : 8
     sg_erase : 8
     sg_kill : 8
     sg_flags :16
     ;

vars b;
conssgttyb(0,0,0,0,0,0)->b;

unless sys_io_control(popdevout,TIOCGETP,b) then
    mishap('can\'t get terminal modes',[]);
endunless;

(b.sg_flags &&~~ 16) &&~~ 8 -> b.sg_flags;

unless sys_io_control(popdevout,TIOCSETP,b) then
    mishap('can\'t set terminal modes',[]);
endunless;



