/* --- Copyright University of Sussex 1994. All rights reserved. ----------
 > File:            $popvision/lib/arrayshift.p
 > Purpose:         Shift coordinates of array by specified vector
 > Author:          David S Young, Nov 16 1994
 > Documentation:   HELP * ARRAYSHIFT
 */

compile_mode:pop11 +strict;

section;

define arrayshift(arr, shift /* [, shiftcrds]*/) /* -> newarr */;
    lvars arr, shift, shiftcrds = false;

    if shift.isboolean then
        (arr, shift) -> (arr, shift, shiftcrds)
    endif;

    lvars s, b1, b2, newb,
        5 op = shiftcrds and nonop fi_- or nonop fi_+,
        b = arr.isarray and boundslist(arr) or arr;

    [%
        if shift.islist then
            for s in shift do
                dest(dest(b)) -> (b1, b2, b);
                b1 op s, b2 op s
            endfor
        elseif shift.isvector then
            for s in_vector shift do
                dest(dest(b)) -> (b1, b2, b);
                b1 op s, b2 op s
            endfor
        elseif shift.isinteger then
            until b == [] do
                dest(dest(b)) -> (b1, b2, b);
                b1 op shift, b2 op shift
            enduntil
        else
            mishap(shift, 1, 'List, vector or integer needed')
        endif
    %] -> newb;
    unless b == [] then
        mishap(shift, 1, 'Shift list or vector too short')
    endunless;

    if arr.isarray then
        lvars ( , off) = arrayvector_bounds(arr);
        newanyarray(newb, arr, off-1, arr.isarray_by_row)
    else
        newb
    endif
enddefine;

endsection;
