/* --- Copyright University of Sussex 1995. All rights reserved. ----------
 > File:            $popvision/lib/ellipse_hough.p
 > Purpose:         Simple Hough transform for ellipses
 > Author:          David S Young, Mar  3 1995
 > Documentation:   HELP * ELLIPSE_HOUGH
 > Related Files:   See "uses" list
 */

compile_mode:pop11 +strict;

section;

uses popvision
uses appellipse
uses newsfloatarray
uses array_peaks

define ellipse_hough(image, a, b, alpha) -> (xc, yc);
    lvars image, a, b, alpha, xc, yc;
    lconstant refpk = 1;
    lvars x, y, crds, v,
        bounds = boundslist(image),
        accum = oldsfloatarray(ellipse_hough, bounds, 0);

    define lconstant accumulate(xc, yc); lvars xc, yc;
        accum(xc, yc) + v -> accum(xc, yc)
    enddefine;

    for v with_index crds in_array image do
        if v /= 0 then
            explode(crds) -> (x, y);
            appellipse_rim(x, y, a, b, alpha, bounds, accumulate);
        endif
    endfor;

    explode(refine_peaks(accum, array_peak(accum, false), refpk, refpk))
        -> ( , xc, yc)
enddefine;

define circle_hough(image, r) /* -> (xc, yc) */;
    lvars image, r, xc, yc;
    ellipse_hough(image, r, r, 0)
enddefine;

endsection;
