/* --- Copyright University of Sussex 1993. All rights reserved. ----------
 > File:            $popvision/lib/filesequence.p
 > Purpose:         Write and read sequences of files
 > Author:          David S Young, Nov 10 1993 (see revisions)
 > Documentation:   HELP *FILESEQUENCE
 */

compile_mode:pop11 +strict;

section;

define lconstant ncintstr(int, pos, wid, str) -> str;
    ;;; Puts an integer into an existing string, starting at pos,
    ;;; with width wid, padded on left with zeroes
    lvars int pos wid str;
    define dlocal cucharout(c);
        lvars c;
        c -> str(pos);
        pos + 1 -> pos
    enddefine;

    pr_field(int, wid, `0`, false, syspr);
enddefine;

define lconstant intlen(int) -> len;
    ;;; This should give the length needed by syspr to print the integer,
    ;;; without having to create a string each time. (Could use
    ;;; logs except rounding errors make for problems.)
    lvars int, len = 1;
    fi_check(int, false, false) -> ;
    if int fi_< 0 then
        2 -> len;
        -int -> int
    endif;
    until int fi_< 10 do
        len fi_+ 1 -> len;
        int fi_div 10 -> int
    enduntil
enddefine;

define lconstant getname(base_name, nwid, suffix, n0) -> (filename, npos);
    lvars base_name, nwid, suffix, n0, filename, npos;
    ;;; set up the file name in fixed-width case
    if intlen(n0) > nwid then
        mishap(n0, nwid, 2, 'Sequence number too large for width')
    endif;
    length(base_name) + 1 -> npos;
    base_name sys_>< inits(nwid) sys_>< suffix -> filename
enddefine;

define lconstant makename(int, npos, nwid, filename, suffix) /* -> filename */;
    lvars int, npos, nwid, filename, suffix;
    if nwid then
        if intlen(int) > nwid then
            mishap(int, nwid, 2, 'Sequence number too large for width')
        endif;
        ncintstr(int, npos, nwid, filename)
    else
        filename sys_>< int sys_>< suffix
    endif
enddefine;

define global filesout(writer, base_name, nwid, suffix, n0, ninc) -> consumer;
    lvars base_name, nwid, suffix, n0, ninc, n1 = false, writer,
        procedure consumer;
    if suffix.isinteger then            ;;; optional n1 argument
        (writer, base_name, nwid, suffix, n0, ninc)
            -> (writer, base_name, nwid, suffix, n0, ninc, n1)
    endif;
    checkinteger(n0, false, false);
    checkinteger(ninc, 1, false);
    lvars npos, n = n0;
    if nwid then
        getname(base_name, nwid, suffix, n0) -> (base_name, npos)
    endif;

    define lvars procedure consumer(arr) /* -> finished - optionally */;
        ;;; Only returns a result if n1 is given.  Result is false until
        ;;; last file is written, when it becomes true.
        ;;; If the argument is <false>, just increments the index.
        lvars arr;
        lvars filename = makename(n, npos, nwid, base_name, suffix);
        if arr and (not(n1) or n <= n1) then
            arr -> writer(filename)
        endif;
        n + ninc -> n;
        if n1 then
            n > n1  /* -> finished */
        endif;
    enddefine;

enddefine;

define global filesin(reader, base_name, nwid, suffix, n0, ninc) -> rep;
    lvars base_name, nwid, suffix, n0, n1 = false, ninc, reader,
        procedure rep;
    if suffix.isinteger then            ;;; optional n1 argument
        (reader, base_name, nwid, suffix, n0, ninc)
            -> (reader, base_name, nwid, suffix, n0, ninc, n1)
    endif;
    checkinteger(n0, false, false);
    checkinteger(ninc, 1, false);
    lvars npos, n = n0;
    if nwid then
        getname(base_name, nwid, suffix, n0) -> (base_name, npos)
    endif;

    define lvars procedure rep() /* -> arr */;
        lvars arr;
        if n1 and n > n1 then
            termin /* -> arr */
        else
            lvars dev,
                filename = makename(n, npos, nwid, base_name, suffix);
            if readable(filename) ->> dev then
                sysclose(dev);
                reader(filename) /* -> arr */;
            else
                false /* -> arr */
            endif;
            n + ninc -> n
        endif
    enddefine;

    define updaterof rep;
        n0 -> n
    enddefine;
enddefine;

vars filesequence = true;

endsection;

/* --- Revision History ---------------------------------------------------
--- David S Young, Nov 12 1993
        N1 optional argument added to filesout, and data consumer allowed
        to skip a file if given <false> as argument.
 */
