/* --- Copyright University of Sussex 1995. All rights reserved. ----------
 > File:            $popvision/lib/objectfile.p
 > Purpose:         Find an object file
 > Author:          David S Young, Jun  3 1992 (see revisions)
 > Documentation:   HELP OBJECTFILE
 */

compile_mode:pop11 +strict;

section;

#_IF sys_os_type(2) == "sunos" and sys_os_type(3) >= 5.0
    lconstant ARCH = "sun4r5", SUFFIX = '.so';
#_ELSEIF hd(sys_machine_type) == "alpha"
    lconstant ARCH = hd(sys_machine_type);  SUFFIX = '.so';
#_ELSE
    lconstant ARCH = hd(sys_machine_type), SUFFIX = '.o';
#_ENDIF

define procedure objectfile(name) -> obfilename;
    lvars name, obfilename;
    unless popfilename then
        mishap(name, 1, 'Need to be compiling named file')
    endunless;
    sys_fname_path(popfilename)
        dir_>< 'bin' dir_>< ARCH dir_>< (name sys_>< SUFFIX)
        -> obfilename;
    unless readable(obfilename) then false -> obfilename endunless
enddefine;


endsection;


/* --- Revision History ---------------------------------------------------
--- David S Young, Sep 19 1995
        Made SUFFIX .so if machine type is alpha
--- David S Young, Jan 31 1994
        Made to use popfilename instead of pdprops(cucharin).
--- John Williams, Nov  5 1993
        Fixed for Solaris 2.x
--- David S Young, Nov 26 1992
        Changed to use -sys_machine_type-
 */
