/* --- Copyright University of Sussex 1994. All rights reserved. ----------
 > File:            $popvision/lib/oldarray.p
 > Purpose:         Avoid garbage collection when getting temporary arrays
 > Author:          David S Young, Nov 15 1994
 > Documentation:   HELP * OLDARRAY
 */

compile_mode:pop11 +strict;

section;

define /*lconstant*/ boundsize(bounds) -> n;
    lvars bounds, n = 1;
    lvars x0, x1;
    until bounds == [] do
        dest(dest(bounds)) -> (x0, x1, bounds);
        n * (x1 - x0 + 1) -> n
    enduntil
enddefine;

define oldanyarray(tag, bounds, key) -> arr;
    lvars tag, bounds, init = false, key, arr;
    lconstant
        propsize1 = 5,
        propsize2 = 20,
        typestore = newproperty([], propsize1, false, "perm");

    ;;; See if an initialiser given
    unless bounds.islist and bounds /== [] and back(bounds) /== [] then
        (tag, bounds) -> (tag, bounds, init)
    endunless;

    ;;; Get property for this type of array
    lvars arraystore;
    unless typestore(key) ->> arraystore then
        newproperty([], propsize2, false, "tmpval") ->> arraystore
            -> typestore(key)
    endunless;

    ;;; Get array for this tag
    arraystore(tag) -> arr;
    if arr and boundslist(arr) = bounds then
        ;;; array is OK, but use newanyarray to do initialisation if needed
        if init then
            newanyarray(bounds, init, arr) -> arr
        endif
    else
        if arr and length(arrayvector(arr)) >= boundsize(bounds) then
            ;;; Create an array on top of the existing arrayvector.
            ;;; Note - this new array is not stored in the property, so that
            ;;; the entry can be garbage collected. This is desirable when
            ;;; a reduction in size has occurred and memory is short.
            newanyarray(bounds, if init then init endif, arr) -> arr
        else
            ;;; create a completely new array
            newanyarray(bounds, if init then init endif, key)
                ->> arr -> arraystore(tag)
        endif
    endif
enddefine;

define oldarray with_nargs 1;
    oldanyarray(vector_key)
enddefine;

endsection;
